/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Multimap;
import com.regnosys.ingest.test.framework.ingestor.ExpectationDefaults;
import com.regnosys.ingest.test.framework.ingestor.IngestionReport;
import com.regnosys.ingest.test.framework.ingestor.IngestionTestExpectation;
import com.regnosys.ingest.test.framework.ingestor.testing.Expectation;
import com.regnosys.ingest.test.framework.ingestor.testing.QualificationExpectation;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationReport;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.qualify.QualifyResult;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpectationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpectationUtil.class);
    public static ExpectationDefaults EXPECTATION_DEFAULTS = new ExpectationDefaults();
    public static boolean WRITE_EXPECTATIONS = EXPECTATION_DEFAULTS.writeExpectationsFlag();
    public static boolean CREATE_EXPECTATION_FILES = EXPECTATION_DEFAULTS.createExpectationFilesFlag();
    public static Optional<Path> TEST_WRITE_BASE_PATH = EXPECTATION_DEFAULTS.testWriteBasePath();

    public static Expectation actualExpectation(IngestionReport<? extends RosettaModelObject> ingestionReport, String string, String string2, int n2) {
        Optional<QualificationReport> optional = Optional.ofNullable(ingestionReport).map(IngestionReport::getQualificationReport);
        List<QualificationExpectation.Result> list = optional.map(QualificationReport::getResults).orElseGet(ArrayList::new).stream().filter(qualificationResult -> qualificationResult.getUniqueSuccessQualifyResult().isPresent()).map(qualificationResult -> new QualificationExpectation.Result(((QualifyResult)qualificationResult.getUniqueSuccessQualifyResult().get()).getName(), qualificationResult.getQualifiedRosettaObjectType().getName())).sorted().collect(Collectors.toList());
        Optional<Integer> optional2 = optional.map(QualificationReport::getQualifiableObjectsCount);
        Optional<Integer> optional3 = optional.map(QualificationReport::getUniquelyQualifiedObjectsCount);
        boolean bl = optional2.flatMap(n -> optional3.map(n2 -> n2 == n)).orElse(false);
        return ExpectationUtil.createExpectation(string, string2, n2, ingestionReport.getMappingReport().getExternalPaths(), ingestionReport.getMappingReport().getFailures().size(), ingestionReport.getValidationReport().validationFailures().size(), ExpectationUtil.createQualificationExpectation(bl, optional2.orElse(0), list));
    }

    private static Expectation createExpectation(String string, String string2, int n, int n2, int n3, int n4, QualificationExpectation qualificationExpectation) {
        try {
            Constructor constructor = Expectation.class.getDeclaredConstructor(String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, QualificationExpectation.class);
            constructor.setAccessible(true);
            return (Expectation)constructor.newInstance(string, string2, n, n2, n3, n4, qualificationExpectation);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static QualificationExpectation createQualificationExpectation(boolean bl, int n, List<QualificationExpectation.Result> list) {
        try {
            Constructor constructor = QualificationExpectation.class.getDeclaredConstructor(Boolean.TYPE, List.class, Integer.TYPE);
            constructor.setAccessible(true);
            return (QualificationExpectation)constructor.newInstance(bl, list, n);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void printExpectations(Multimap<String, IngestionTestExpectation> multimap, boolean bl) throws JsonProcessingException {
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            String string = (String)entry.getKey();
            ArrayList arrayList = new ArrayList((Collection)entry.getValue());
            List list = arrayList.stream().map(IngestionTestExpectation::getExpectation).collect(Collectors.toList());
            Collections.sort(list);
            String string2 = new ObjectMapper().writer().writeValueAsString(list).replaceAll("\\{\"category\":null,", "\n\\{");
            LOGGER.debug("--------------------  EXPECTED RESULTS FOR " + string + "  --------------------");
            LOGGER.debug(string2);
            LOGGER.debug("-----------------------------------------------------------------------------------");
            if (!bl) continue;
            TEST_WRITE_BASE_PATH.filter(path -> Files.exists(path, new LinkOption[0])).ifPresent(path -> {
                Path path2 = path.resolve(string.substring(string.indexOf("cdm-sample-files")));
                ExpectationUtil.writeFile(path2, string2, CREATE_EXPECTATION_FILES);
                arrayList.stream().forEach(ingestionTestExpectation -> {
                    Path path2 = Paths.get(ingestionTestExpectation.getExpectation().getFileName().replace("cdm-sample-files", "result-json-files").replace(".json", "_cdm.json").replace(".xml", ".json"), new String[0]);
                    Path path3 = path.resolve(path2);
                    ExpectationUtil.writeFile(path3, ingestionTestExpectation.getJson(), CREATE_EXPECTATION_FILES);
                });
            });
        }
    }

    private static void writeFile(Path path, String string, boolean bl) {
        try {
            if (bl) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            if (bl || Files.exists(path, new LinkOption[0])) {
                Files.write(path, string.getBytes(), new OpenOption[0]);
                LOGGER.info("Wrote output to {}", (Object)path);
            }
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to write output to {}", (Object)path, (Object)iOException);
        }
    }
}

