/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.valueadd.common.VaNode;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.Service;
import com.refinitiv.eta.valueadd.reactor.WlInteger;
import com.refinitiv.eta.valueadd.reactor.WlItemGroup;
import com.refinitiv.eta.valueadd.reactor.WlRequest;
import com.refinitiv.eta.valueadd.reactor.WlStream;
import java.util.HashMap;
import java.util.LinkedList;

class WlService
extends VaNode {
    Service _rdmService = DirectoryMsgFactory.createService();
    long _numOutstandingRequests;
    LinkedList<WlRequest> _waitingRequestList = new LinkedList();
    LinkedList<WlStream> _streamList = new LinkedList();
    HashMap<Buffer, WlItemGroup> _itemGroupTable = new HashMap();
    LinkedList<Buffer> _itemGroupList = new LinkedList();
    WlInteger _tableKey;

    WlService() {
    }

    Service rdmService() {
        return this._rdmService;
    }

    long numOutstandingRequests() {
        return this._numOutstandingRequests;
    }

    void numOutstandingRequests(long numOutstandingRequests) {
        this._numOutstandingRequests = numOutstandingRequests;
    }

    LinkedList<WlRequest> waitingRequestList() {
        return this._waitingRequestList;
    }

    LinkedList<WlStream> streamList() {
        return this._streamList;
    }

    void itemGroupTablePut(Buffer key, WlItemGroup wlItemGroup) {
        this._itemGroupList.add(key);
        this._itemGroupTable.put(key, wlItemGroup);
    }

    WlItemGroup itemGroupTableGet(Buffer key) {
        return this._itemGroupTable.get(key);
    }

    WlItemGroup itemGroupTableRemove(Buffer key) {
        this._itemGroupList.remove(key);
        return this._itemGroupTable.remove(key);
    }

    void tableKey(WlInteger tableKey) {
        this._tableKey = tableKey;
    }

    WlInteger tableKey() {
        return this._tableKey;
    }

    void clear() {
        this._numOutstandingRequests = 0L;
        this._waitingRequestList.clear();
        this._streamList.clear();
        this._itemGroupTable.clear();
        this._itemGroupList.clear();
        this._tableKey = null;
    }

    @Override
    public void returnToPool() {
        WlRequest wlRequest = null;
        while ((wlRequest = this._waitingRequestList.poll()) != null) {
            wlRequest.state(WlRequest.State.RETURN_TO_POOL);
            wlRequest.returnToPool();
        }
        for (int i = 0; i < this._itemGroupList.size(); ++i) {
            this._itemGroupTable.get(this._itemGroupList.get(i)).returnToPool();
        }
        this._itemGroupTable.clear();
        this._itemGroupList.clear();
        super.returnToPool();
    }
}

