/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.transport.Error;
import com.refinitiv.eta.transport.TransportBuffer;
import com.refinitiv.eta.valueadd.common.VaDoubleLinkList;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamBuffer;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamPersistenceBuffer;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamUtil;
import com.refinitiv.eta.valueadd.reactor.TunnelSubstream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

abstract class TunnelStreamPersistenceFile {
    static int _defaultPersistenceVerion = 0x2000000;
    protected VaDoubleLinkList<TunnelStreamPersistenceBuffer> _persistentBufferPool;
    protected VaDoubleLinkList<TunnelStreamBuffer> _localQueueAckList;
    protected RandomAccessFile _file;
    protected MappedByteBuffer _fileByteBuf;
    protected FileChannel _fileChannel;
    protected FileLock _fileLock;
    protected TunnelSubstream _tunnelSubstream;
    ByteBuffer _tmpByteBuf;

    abstract int saveMsg(TunnelStreamBuffer var1, Error var2);

    abstract void releasePersistenceBuffers(int var1);

    abstract void releasePersistenceBuffer(TunnelStreamPersistenceBuffer var1);

    abstract int retransmitBuffers(int var1, Msg var2, EncodeIterator var3, DecodeIterator var4, Error var5);

    abstract void setBufferAsTransmitted(TunnelStreamPersistenceBuffer var1);

    abstract void lastInSeqNum(int var1);

    abstract void lastOutSeqNum(int var1);

    abstract int persistBufferMsgOffset();

    abstract long persistBufferTimeoutNsec(TunnelStreamPersistenceBuffer var1);

    TunnelStreamPersistenceFile(TunnelSubstream tunnelSubstream, RandomAccessFile file, FileChannel fileChannel, FileLock fileLock) {
        this._tunnelSubstream = tunnelSubstream;
        this._file = file;
        this._fileChannel = fileChannel;
        this._fileLock = fileLock;
        this._persistentBufferPool = new VaDoubleLinkList();
        this._localQueueAckList = new VaDoubleLinkList();
    }

    int close(Error error) {
        if (this._fileByteBuf != null) {
            try {
                this._fileLock.release();
                this._fileChannel.close();
                this._file.close();
            }
            catch (IOException e) {
                error.errorId(-1);
                error.text("Failed to close persistence file.");
                return -1;
            }
        }
        this.clear(error);
        return 0;
    }

    void clear(Error tmpError) {
        TunnelStreamBuffer tunnelStreamBuffer;
        while ((tunnelStreamBuffer = this._localQueueAckList.pop(TunnelStreamBuffer.RETRANS_LINK)) != null) {
            this._tunnelSubstream._tunnelStream.releaseBuffer(tunnelStreamBuffer, tmpError);
        }
        this._persistentBufferPool.clear();
        this._tunnelSubstream = null;
        this._fileByteBuf = null;
        this._tmpByteBuf = null;
        this._fileChannel = null;
        this._fileChannel = null;
        this._fileLock = null;
    }

    protected void peristenceBufferListMove(VaDoubleLinkList<TunnelStreamPersistenceBuffer> oldList, int oldListHeadPosition, VaDoubleLinkList<TunnelStreamPersistenceBuffer> newList, int newListHeadPosition, int nextMsgPosOffset, TunnelStreamPersistenceBuffer persistBuffer) {
        assert (newList != null);
        assert (oldList != null);
        TunnelStreamPersistenceBuffer next = TunnelStreamPersistenceBuffer.SUBSTREAM_LINK.getNext(persistBuffer);
        TunnelStreamPersistenceBuffer prev = TunnelStreamPersistenceBuffer.SUBSTREAM_LINK.getPrev(persistBuffer);
        if (prev != null) {
            if (next != null) {
                this._fileByteBuf.putInt(prev.filePosition() + nextMsgPosOffset, next.filePosition());
            } else {
                this._fileByteBuf.putInt(prev.filePosition() + nextMsgPosOffset, 0);
            }
        } else if (next != null) {
            this._fileByteBuf.putInt(oldListHeadPosition, next.filePosition());
        } else {
            this._fileByteBuf.putInt(oldListHeadPosition, 0);
        }
        oldList.remove(persistBuffer, TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
        newList.push(persistBuffer, TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
        next = TunnelStreamPersistenceBuffer.SUBSTREAM_LINK.getNext(persistBuffer);
        prev = TunnelStreamPersistenceBuffer.SUBSTREAM_LINK.getPrev(persistBuffer);
        if (next != null) {
            this._fileByteBuf.putInt(persistBuffer.filePosition() + nextMsgPosOffset, next.filePosition());
        } else {
            this._fileByteBuf.putInt(persistBuffer.filePosition() + nextMsgPosOffset, 0);
        }
        if (prev != null) {
            this._fileByteBuf.putInt(prev.filePosition() + nextMsgPosOffset, persistBuffer.filePosition());
        } else {
            this._fileByteBuf.putInt(newListHeadPosition, persistBuffer.filePosition());
        }
    }

    protected void copyToTunnelStreamBuffer(TunnelStreamPersistenceBuffer persistBuffer, TunnelStreamBuffer tunnelStreamBuffer) {
        int tmpLimit = this._fileByteBuf.limit();
        int startPos = persistBuffer.filePosition() + this.persistBufferMsgOffset() + persistBuffer.tunnelStreamHeaderLen();
        int length = persistBuffer.length() - persistBuffer.tunnelStreamHeaderLen();
        this._fileByteBuf.limit(startPos + length);
        this._fileByteBuf.position(startPos);
        tunnelStreamBuffer.data().put(this._fileByteBuf);
        this._fileByteBuf.limit(tmpLimit);
        tunnelStreamBuffer.setCurrentPositionAsEndOfEncoding();
        tunnelStreamBuffer.persistenceBuffer(this._tunnelSubstream, persistBuffer);
    }

    protected int retransmitBuffer(TunnelStreamPersistenceBuffer persistBuffer, int seqNum, long currentTime, Msg tmpMsg, EncodeIterator tmpEncodeIter, DecodeIterator tmpDecodeIter, Error error) {
        TunnelStreamBuffer tunnelStreamBuffer;
        if (persistBuffer.length() - persistBuffer.tunnelStreamHeaderLen() > this._tunnelSubstream._tunnelStream._classOfService.common().maxMsgSize()) {
            tunnelStreamBuffer = this._tunnelSubstream._tunnelStream._tunnelStreamBufferPool.pop(TunnelStreamBuffer.RETRANS_LINK);
            if (tunnelStreamBuffer == null) {
                tunnelStreamBuffer = new TunnelStreamBuffer();
            }
            tunnelStreamBuffer.clear(persistBuffer.length());
            tunnelStreamBuffer.persistenceBuffer(this._tunnelSubstream, persistBuffer);
        } else {
            tunnelStreamBuffer = this._tunnelSubstream._tunnelStream.getBuffer(persistBuffer.length() - persistBuffer.tunnelStreamHeaderLen(), false, true, error);
            if (tunnelStreamBuffer == null) {
                error.text("Failed to get TunnelStream buffer while retransmitting QueueData message: " + error.text());
                return -1;
            }
            this.copyToTunnelStreamBuffer(persistBuffer, tunnelStreamBuffer);
        }
        if (seqNum == 0) {
            if (tunnelStreamBuffer.data() == null) {
                this._localQueueAckList.push(tunnelStreamBuffer, TunnelStreamBuffer.RETRANS_LINK);
                return 0;
            }
            tunnelStreamBuffer.setAsInnerReadBuffer();
            TunnelStreamUtil.replaceQueueDataFlags(tunnelStreamBuffer.data(), 1);
            tunnelStreamBuffer.setAsFullReadBuffer();
        } else {
            if (TunnelStreamUtil.seqNumCompare(persistBuffer.seqNum(), seqNum) <= 0) {
                tunnelStreamBuffer.isForLocalAck(true);
                this._localQueueAckList.push(tunnelStreamBuffer, TunnelStreamBuffer.RETRANS_LINK);
                return 0;
            }
            if (tunnelStreamBuffer.data() == null) {
                this._localQueueAckList.push(tunnelStreamBuffer, TunnelStreamBuffer.RETRANS_LINK);
                return 0;
            }
        }
        tunnelStreamBuffer.setAsInnerReadBuffer();
        tmpDecodeIter.clear();
        tmpDecodeIter.setBufferAndRWFVersion((TransportBuffer)tunnelStreamBuffer, this._tunnelSubstream._tunnelStream.classOfService().common().protocolMajorVersion(), this._tunnelSubstream._tunnelStream.classOfService().common().protocolMinorVersion());
        if (tmpDecodeIter.extractStreamId() != this._tunnelSubstream._streamId) {
            tmpEncodeIter.clear();
            tmpEncodeIter.setBufferAndRWFVersion((TransportBuffer)tunnelStreamBuffer, this._tunnelSubstream._tunnelStream.classOfService().common().protocolMajorVersion(), this._tunnelSubstream._tunnelStream.classOfService().common().protocolMinorVersion());
            int ret = tmpEncodeIter.replaceStreamId(this._tunnelSubstream._streamId);
            if (ret != 0) {
                error.errorId(ret);
                error.text("Failed to update stream id from " + tmpDecodeIter.extractStreamId() + " to " + this._tunnelSubstream._streamId + " on QueueData message.");
                return -1;
            }
        }
        tunnelStreamBuffer.timeoutNsec(this.persistBufferTimeoutNsec(persistBuffer));
        if (tunnelStreamBuffer.timeoutNsec() > 0L) {
            tunnelStreamBuffer.timeoutIsCode(false);
            if (!persistBuffer.isTransmitted()) {
                this._tunnelSubstream._tunnelStream.insertTimeoutBuffer(tunnelStreamBuffer, currentTime);
            }
        } else {
            tunnelStreamBuffer.timeoutIsCode(true);
        }
        tunnelStreamBuffer.isQueueData(true);
        this._tunnelSubstream._tunnelStream._outboundTransmitList.push(tunnelStreamBuffer, TunnelStreamBuffer.RETRANS_LINK);
        return 0;
    }

    protected int sendLocalQueueAcks(EncodeIterator tmpEncodeIter, DecodeIterator tmpDecodeIter, Error error) {
        TunnelStreamBuffer tunnelStreamBuffer;
        while ((tunnelStreamBuffer = this._localQueueAckList.pop(TunnelStreamBuffer.RETRANS_LINK)) != null) {
            TunnelStreamPersistenceBuffer persistBuffer = tunnelStreamBuffer.persistenceBuffer();
            if (tunnelStreamBuffer.data() == null) {
                if (this._tmpByteBuf == null || this._tmpByteBuf.capacity() < persistBuffer.length()) {
                    this._tmpByteBuf = ByteBuffer.allocateDirect(persistBuffer.length());
                }
                this._tmpByteBuf.position(0);
                this._tmpByteBuf.limit(persistBuffer.length());
                tunnelStreamBuffer.data(this._tmpByteBuf);
                this.copyToTunnelStreamBuffer(persistBuffer, tunnelStreamBuffer);
            }
            tunnelStreamBuffer.setAsInnerReadBuffer();
            tmpDecodeIter.clear();
            tmpDecodeIter.setBufferAndRWFVersion((TransportBuffer)tunnelStreamBuffer, this._tunnelSubstream._tunnelStream.classOfService().common().protocolMajorVersion(), this._tunnelSubstream._tunnelStream.classOfService().common().protocolMinorVersion());
            if (tmpDecodeIter.extractStreamId() != this._tunnelSubstream._streamId) {
                tmpEncodeIter.clear();
                tmpEncodeIter.setBufferAndRWFVersion((TransportBuffer)tunnelStreamBuffer, this._tunnelSubstream._tunnelStream.classOfService().common().protocolMajorVersion(), this._tunnelSubstream._tunnelStream.classOfService().common().protocolMinorVersion());
                int ret = tmpEncodeIter.replaceStreamId(this._tunnelSubstream._streamId);
                if (ret != 0) {
                    error.errorId(ret);
                    error.text("Failed to update stream id from " + tmpDecodeIter.extractStreamId() + " to " + this._tunnelSubstream._streamId + " on QueueData message.");
                    return -1;
                }
            }
            if (tunnelStreamBuffer.isForLocalAck()) {
                this._tunnelSubstream.sendQueueAckToListener(tunnelStreamBuffer);
                this.releasePersistenceBuffer(persistBuffer);
                this._tunnelSubstream._tunnelStream.releaseBuffer(tunnelStreamBuffer, error);
            } else {
                this._tunnelSubstream._tunnelStream.queueMsgExpired(tunnelStreamBuffer, null, 6);
                this.releasePersistenceBuffer(persistBuffer);
                tunnelStreamBuffer.clear(0);
                this._tunnelSubstream._tunnelStream._tunnelStreamBufferPool.push(tunnelStreamBuffer, TunnelStreamBuffer.RETRANS_LINK);
            }
            if (this._tunnelSubstream._state == TunnelSubstream.TunnelSubstreamState.OPEN) continue;
            return 0;
        }
        return 0;
    }

    static void defaultPersistenceVersion(int defaultPersistenceVersion) {
        _defaultPersistenceVerion = defaultPersistenceVersion;
    }

    static int defaultPersistenceVersion() {
        return _defaultPersistenceVerion;
    }

    class FileVersion {
        static final int V1 = 1;
        static final int V2 = 0x2000000;
        static final int V2L = 2;

        FileVersion() {
        }
    }
}

