/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.valueadd.reactor.Reactor;
import com.refinitiv.eta.valueadd.reactor.ReactorAuthTokenInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import com.refinitiv.eta.valueadd.reactor.ReactorConnectInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorOAuthCredential;
import com.refinitiv.eta.valueadd.reactor.ReactorOAuthCredentialRenewal;
import com.refinitiv.eta.valueadd.reactor.ReactorRestProxyOptions;
import com.refinitiv.eta.valueadd.reactor.RestAuthOptions;
import com.refinitiv.eta.valueadd.reactor.RestCallback;
import com.refinitiv.eta.valueadd.reactor.RestClient;
import com.refinitiv.eta.valueadd.reactor.RestConnectOptions;
import com.refinitiv.eta.valueadd.reactor.RestEvent;
import com.refinitiv.eta.valueadd.reactor.RestReactor;
import com.refinitiv.eta.valueadd.reactor.RestRequest;
import com.refinitiv.eta.valueadd.reactor.RestResponse;
import com.refinitiv.eta.valueadd.reactor.RestResultClosure;
import com.refinitiv.eta.valueadd.reactor.WorkerEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONObject;

class ReactorTokenSession
implements RestCallback {
    private Reactor _reactor;
    private ReactorAuthTokenInfo _authTokenInfo = new ReactorAuthTokenInfo();
    private SessionState _sessionState = SessionState.UNKNOWN;
    private ReactorOAuthCredential _reactorOAuthCredential = new ReactorOAuthCredential();
    private ReactorOAuthCredentialRenewal _reactorOAuthCredentialRenewal = new ReactorOAuthCredentialRenewal();
    private boolean _initialized = false;
    private List<ReactorChannel> _reactorChannelList = new LinkedList<ReactorChannel>();
    private Lock _accessTokenLock = new ReentrantLock();
    private Lock _reactorChannelListLock = new ReentrantLock();
    private RestAuthOptions _restAuthRequest;
    private RestConnectOptions _restConnectOptions;
    private RestResultClosure _resultClosure;
    private long _nextAuthTokenRequestTime;
    private long _authTokenExpiresIn;
    private int _tokenReissueAttempts;
    private int _originalExpiresIn;
    private RestReactor _restReactor;
    private ReactorErrorInfo _errorInfo = ReactorFactory.createReactorErrorInfo();
    private boolean _setProxyInfo = false;
    private String _defaultTokenURLV1String = "https://api.refinitiv.com/auth/oauth2/v1/token";
    private Buffer _tokenURLV1Buffer = CodecFactory.createBuffer();
    private String _defaultTokenURLV2String = "https://api.refinitiv.com/auth/oauth2/v2/token";
    private Buffer _tokenURLV2Buffer = CodecFactory.createBuffer();
    private WorkerEvent _reissueWorkerTimerEvent;

    ReactorTokenSession(Reactor reactor, ReactorOAuthCredential reactorOAuthCredential) {
        this._reactor = reactor;
        this._restReactor = reactor._restClient._restReactor;
        reactorOAuthCredential.copy(this._reactorOAuthCredential);
        if (reactor._reactorOptions.tokenServiceURL_V1() != null && reactor._reactorOptions.tokenServiceURL_V1().length() > 0) {
            this._tokenURLV1Buffer = reactor._reactorOptions.tokenServiceURL_V1();
        } else {
            this._tokenURLV1Buffer.data(this._defaultTokenURLV1String);
        }
        if (reactor._reactorOptions.tokenServiceURL_V2() != null && reactor._reactorOptions.tokenServiceURL_V2().length() > 0) {
            this._tokenURLV2Buffer = reactor._reactorOptions.tokenServiceURL_V2();
        } else {
            this._tokenURLV2Buffer.data(this._defaultTokenURLV2String);
        }
        this._restConnectOptions = new RestConnectOptions(this._reactor.reactorOptions());
        this._restAuthRequest = new RestAuthOptions(this);
        this._restAuthRequest.username(this._reactorOAuthCredential.userName().toString());
        this._restAuthRequest.password(this._reactorOAuthCredential.password().toString());
        this._restAuthRequest.clientId(this._reactorOAuthCredential.clientId().toString());
        this._restAuthRequest.clientSecret(this._reactorOAuthCredential.clientSecret().toString());
        this._restAuthRequest.audience(this._reactorOAuthCredential.audience().toString());
        this._restAuthRequest.clientJwk(this._reactorOAuthCredential.clientJwk().toString());
        this._restAuthRequest.tokenScope(this._reactorOAuthCredential.tokenScope().toString());
        this._resultClosure = new RestResultClosure(this, this);
        this._restConnectOptions.restResultClosure(this._resultClosure);
        this._nextAuthTokenRequestTime = 0L;
        this._tokenReissueAttempts = 0;
        this._originalExpiresIn = 0;
        if (this._restAuthRequest.username().length() == 0) {
            this._authTokenInfo.tokenVersion(ReactorAuthTokenInfo.TokenVersion.V2);
            this._restConnectOptions.tokenServiceURLV2(this._tokenURLV2Buffer);
        } else {
            this._authTokenInfo.tokenVersion(ReactorAuthTokenInfo.TokenVersion.V1);
            this._restConnectOptions.tokenServiceURLV1(this._tokenURLV1Buffer);
        }
    }

    void setProxyInfo(ReactorConnectInfo connectInfo, ReactorRestProxyOptions proxyOpts) {
        if (!this._setProxyInfo) {
            this._restConnectOptions.applyProxyInfo(connectInfo.connectOptions(), proxyOpts);
            this._setProxyInfo = true;
        }
    }

    void calculateNextAuthTokenRequestTime(int expiresIn) {
        if (expiresIn > 0) {
            this._authTokenExpiresIn = (long)((double)expiresIn * this._reactor._reactorOptions.tokenReissueRatio() * 1.0E9);
        }
        this._nextAuthTokenRequestTime = System.nanoTime() + this._authTokenExpiresIn;
    }

    long nextAuthTokenRequestTime() {
        return this._nextAuthTokenRequestTime;
    }

    boolean checkMiniumTimeForReissue(ReactorErrorInfo errorInfo) {
        long remainingTimeForReissueNs;
        if (this._nextAuthTokenRequestTime != 0L && (remainingTimeForReissueNs = this._nextAuthTokenRequestTime - System.nanoTime()) < (long)(this._reactor._reactorOptions.tokenReissueRatio() * 1.0E9)) {
            this._reactor.populateErrorInfo(errorInfo, -1, "ReactorTokenSession.checkMiniumTimeForReissue()", "Couldn't add the channel to the token session as the token reissue interval is too small for this channel.");
            return false;
        }
        return true;
    }

    long nextTokenReissueAttemptReqTime() {
        long nextReqTime = (long)this._reactor._reactorOptions.reissueTokenAttemptInterval() * 1000000L;
        return System.nanoTime() + nextReqTime;
    }

    boolean handlesTokenReissueFailed() {
        if (this._reactor._reactorOptions.reissueTokenAttemptLimit() == 0) {
            return false;
        }
        if (this._reactor._reactorOptions.reissueTokenAttemptLimit() == -1) {
            return true;
        }
        ++this._tokenReissueAttempts;
        return this._tokenReissueAttempts <= this._reactor._reactorOptions.reissueTokenAttemptLimit();
    }

    void addReactorChannel(ReactorChannel reactorChannel) {
        this._reactorChannelListLock.lock();
        if (!this._reactorChannelList.contains(reactorChannel)) {
            this._reactorChannelList.add(reactorChannel);
        }
        this._reactorChannelListLock.unlock();
    }

    int removeReactorChannel(ReactorChannel reactorChannel) {
        int numberOfChannels = 0;
        this._reactorChannelListLock.lock();
        if (this._reactorChannelList.contains(reactorChannel)) {
            reactorChannel.tokenSession(null);
            this._reactorChannelList.remove(reactorChannel);
        }
        if ((numberOfChannels = this._reactorChannelList.size()) == 0) {
            this._initialized = false;
            this._setProxyInfo = false;
        }
        this._reactorChannelListLock.unlock();
        return numberOfChannels;
    }

    void removeAllReactorChannel() {
        this._reactorChannelListLock.lock();
        this._reactorChannelList.clear();
        this._reactorChannelListLock.unlock();
    }

    void resetTokenReissueAttempts() {
        this._tokenReissueAttempts = 0;
    }

    void originalExpiresIn(int expiresIn) {
        this._originalExpiresIn = expiresIn;
    }

    int originalExpiresIn() {
        return this._originalExpiresIn;
    }

    ReactorOAuthCredential oAuthCredential() {
        return this._reactorOAuthCredential;
    }

    ReactorOAuthCredentialRenewal oAuthCredentialRenewal() {
        return this._reactorOAuthCredentialRenewal;
    }

    ReactorAuthTokenInfo authTokenInfo() {
        return this._authTokenInfo;
    }

    RestAuthOptions authOptoins() {
        return this._restAuthRequest;
    }

    RestConnectOptions restConnectOptions() {
        return this._restConnectOptions;
    }

    RestResultClosure resultClosure() {
        return this._resultClosure;
    }

    void lock() {
        this._accessTokenLock.lock();
    }

    void unlock() {
        this._accessTokenLock.unlock();
    }

    SessionState sessionMgntState() {
        return this._sessionState;
    }

    void receivedAuthToken() {
        this._sessionState = SessionState.RECEIVED_AUTH_TOKEN;
    }

    void resetSessionMgntState() {
        this._sessionState = SessionState.REQ_INIT_AUTH_TOKEN;
    }

    void tokenReissueEvent(WorkerEvent tokenReissueEvent) {
        this._reissueWorkerTimerEvent = tokenReissueEvent;
    }

    WorkerEvent tokenReissueEvent() {
        return this._reissueWorkerTimerEvent;
    }

    boolean isInitialized() {
        return this._initialized;
    }

    void isInitialized(boolean initialized) {
        this._initialized = initialized;
    }

    static final void parseTokenInfomation(RestResponse response, ReactorAuthTokenInfo authTokenInfo) {
        if (response.statusCode() == 200 && response.jsonObject() != null) {
            JSONObject body = response.jsonObject();
            authTokenInfo.clear();
            if (body.has("access_token")) {
                authTokenInfo.accessToken(body.getString("access_token"));
            }
            if (body.has("refresh_token")) {
                authTokenInfo.refreshToken(body.getString("refresh_token"));
            }
            if (body.has("expires_in")) {
                if (authTokenInfo.tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V2) {
                    int expiresIn = 0;
                    expiresIn = body.getInt("expires_in") < 600 ? (int)(0.95 * (double)body.getInt("expires_in")) : body.getInt("expires_in") - 300;
                    authTokenInfo.expiresIn(expiresIn);
                } else {
                    authTokenInfo.expiresIn(body.getInt("expires_in"));
                }
            }
            if (body.has("scope")) {
                authTokenInfo.scope(body.getString("scope"));
            }
            if (body.has("token_type")) {
                authTokenInfo.tokenType(body.getString("token_type"));
            }
        }
    }

    int sendAuthRequestWithSensitiveInfo(String password, String newPassword, String clientSecret, String clientJwk) {
        int ret = 0;
        if (clientSecret != null && !clientSecret.isEmpty() || clientJwk != null && !clientJwk.isEmpty()) {
            this._sessionState = SessionState.REQ_AUTH_TOKEN_USING_V2_CREDENTIAL;
            this._restAuthRequest.grantType("client_credentials");
        } else {
            this._sessionState = SessionState.REQ_AUTH_TOKEN_USING_PASSWORD;
            this._restAuthRequest.grantType("password");
        }
        this._restAuthRequest.password(password);
        this._restAuthRequest.newPassword(newPassword);
        this._restAuthRequest.clientSecret(clientSecret);
        this._restAuthRequest.clientJwk(clientJwk);
        ret = this._restReactor.submitAuthRequest(this._restAuthRequest, this._restConnectOptions, this._authTokenInfo, this._errorInfo);
        this._restAuthRequest.clearSensitiveInfo();
        return ret;
    }

    void handleTokenReissue() {
        this._reactorChannelListLock.lock();
        try {
            if (this._reactorChannelList.size() == 0 || this._reactor.isShutdown()) {
                return;
            }
        }
        finally {
            this._reactorChannelListLock.unlock();
        }
        if (this._reissueWorkerTimerEvent != null) {
            this._reissueWorkerTimerEvent._tokenSession = null;
            this._reissueWorkerTimerEvent.timeout(System.nanoTime());
            this._reissueWorkerTimerEvent = null;
        }
        if (this._sessionState == SessionState.REQ_AUTH_TOKEN_USING_PASSWORD) {
            this._sessionState = SessionState.AUTHENTICATE_USING_PASSWD_GRANT;
        }
        if (this._sessionState == SessionState.REQUEST_TOKEN_FAILURE || this._sessionState == SessionState.AUTHENTICATE_USING_PASSWD_GRANT) {
            if (this._reactorOAuthCredential.reactorOAuthCredentialEventCallback() == null) {
                this._sessionState = SessionState.REQ_AUTH_TOKEN_USING_PASSWORD;
                this._restAuthRequest.grantType("password");
                this._restReactor.submitAuthRequest(this._restAuthRequest, this._restConnectOptions, this._authTokenInfo, this._errorInfo);
            } else {
                this._reactorOAuthCredentialRenewal.clear();
                this._reactorOAuthCredentialRenewal.userName().data(this._reactorOAuthCredential.userName().toString());
                this._reactorOAuthCredentialRenewal.clientId().data(this._reactorOAuthCredential.clientId().toString());
                this._reactorOAuthCredentialRenewal.tokenScope().data(this._reactorOAuthCredential.tokenScope().toString());
                this._reactor.sendCredentialRenewalEvent(this, this._errorInfo);
            }
        } else {
            this._sessionState = SessionState.REQ_AUTH_TOKEN_USING_REFRESH_TOKEN;
            this._restAuthRequest.grantType("refresh_token");
            this._restReactor.submitAuthRequest(this._restAuthRequest, this._restConnectOptions, this._authTokenInfo, this._errorInfo);
        }
    }

    void HandleTokenRenewalCallbackForOAuthV2() {
        this._reactorChannelListLock.lock();
        try {
            if (this._reactorChannelList.size() == 0 || this._reactor.isShutdown()) {
                this._sessionState = SessionState.STOP_TOKEN_REQUEST;
                return;
            }
        }
        finally {
            this._reactorChannelListLock.unlock();
        }
        if (this._reactorOAuthCredential.reactorOAuthCredentialEventCallback() != null) {
            this._reactorOAuthCredentialRenewal.clear();
            this._reactorOAuthCredentialRenewal.clientId().data(this._reactorOAuthCredential.clientId().toString());
            this._reactorOAuthCredentialRenewal.tokenScope().data(this._reactorOAuthCredential.tokenScope().toString());
            this._reactor.sendCredentialRenewalEvent(this, this._errorInfo);
            this._sessionState = SessionState.REQ_AUTH_TOKEN_USING_V2_CREDENTIAL;
        }
    }

    boolean hasAccessToken() {
        boolean hasAccessToken = false;
        this._accessTokenLock.lock();
        try {
            if (this._authTokenInfo.accessToken() != null && !this._authTokenInfo.accessToken().isEmpty()) {
                hasAccessToken = true;
            }
        }
        finally {
            this._accessTokenLock.unlock();
        }
        return hasAccessToken;
    }

    void onNewAuthToken(ReactorChannel reactorChannel, ReactorAuthTokenInfo authTokenInfo, ReactorErrorInfo errorInfo) {
        if (reactorChannel.state() == ReactorChannel.State.UP || reactorChannel.state() == ReactorChannel.State.READY || reactorChannel.state() == ReactorChannel.State.EDP_RT) {
            if (reactorChannel.watchlist() != null) {
                reactorChannel.reactor().loginReissue(reactorChannel, authTokenInfo.accessToken(), errorInfo);
            }
            this._reactor.sendAuthTokenEvent(reactorChannel, this, errorInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int RestResponseCallback(RestResponse response, RestEvent event) {
        if (this._reactor.isShutdown()) {
            return 0;
        }
        try {
            this.lock();
            ReactorTokenSession.parseTokenInfomation(response, this._authTokenInfo);
        }
        finally {
            this.unlock();
        }
        switch (event.eventType()) {
            case 0: {
                this._sessionState = SessionState.RECEIVED_AUTH_TOKEN;
                if (this.originalExpiresIn() != 0 && this._authTokenInfo.tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V1) {
                    if (this.originalExpiresIn() != this._authTokenInfo.expiresIn()) {
                        this._sessionState = SessionState.AUTHENTICATE_USING_PASSWD_GRANT;
                        this.originalExpiresIn(0);
                        this._reactor.sendAuthTokenWorkerEvent(this);
                        return 0;
                    }
                } else {
                    this.originalExpiresIn(this._authTokenInfo.expiresIn());
                }
                this._reactorChannelListLock.lock();
                try {
                    for (int i = 0; i < this._reactorChannelList.size(); ++i) {
                        ReactorChannel reactorChannel = this._reactorChannelList.get(i);
                        this.onNewAuthToken(reactorChannel, this._authTokenInfo, event.errorInfo());
                        if (reactorChannel.state() != ReactorChannel.State.EDP_RT) continue;
                        ReactorConnectInfo reactorConnectInfo = reactorChannel.getCurrentReactorConnectInfo();
                        if (Reactor.requestServiceDiscovery(reactorConnectInfo)) {
                            RestRequest restRequest = RestClient.createRestRequestForServiceDiscovery(reactorChannel.restConnectOptions().transport(), reactorChannel.restConnectOptions().dataFormat());
                            reactorChannel.sessionMgntState(ReactorChannel.SessionMgntState.QUERYING_SERVICE_DISCOVERY);
                            this._restReactor.submitRequestForServiceDiscovery(restRequest, reactorChannel.restConnectOptions(), this._authTokenInfo, reactorChannel.reactorServiceEndpointInfoList(), event.errorInfo());
                            continue;
                        }
                        reactorChannel.state(ReactorChannel.State.EDP_RT_DONE);
                    }
                }
                finally {
                    this._reactorChannelListLock.unlock();
                }
                if (this._authTokenInfo.tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V2) {
                    ReactorChannel reactorChannel = this._reactorChannelList.get(0);
                    this._reactor.sendAuthTokenWorkerEvent(reactorChannel, this);
                    break;
                }
                this._reactor.sendAuthTokenWorkerEvent(this);
                break;
            }
            case 1: 
            case 3: {
                String errorText = "failed to get an access token from the token service";
                if (response.jsonObject() != null) {
                    errorText = response.jsonObject().toString();
                }
                ReactorErrorInfo errorInfo = ReactorFactory.createReactorErrorInfo();
                this._reactor.populateErrorInfo(errorInfo, -1, "ReactorTokenSession.RestResponseCallback", "Failed REST request for the token service from HTTP status code " + response.statusCode() + " for user: " + this._reactorOAuthCredential.userName().toString() + ". Text: " + errorText);
                this._reactorChannelListLock.lock();
                this._sessionState = SessionState.REQUEST_TOKEN_FAILURE;
                if (event.eventType() != 3) {
                    if (this.handlesTokenReissueFailed()) {
                        this._reactor.sendAuthTokenWorkerEvent(this);
                    } else {
                        this._sessionState = SessionState.STOP_TOKEN_REQUEST;
                    }
                } else {
                    this._sessionState = SessionState.STOP_TOKEN_REQUEST;
                }
                try {
                    for (int i = 0; i < this._reactorChannelList.size(); ++i) {
                        ReactorChannel reactorChannel = this._reactorChannelList.get(i);
                        reactorChannel.copyEDPErrorInfo(errorInfo);
                        if ((reactorChannel.state() == ReactorChannel.State.READY || reactorChannel.state() == ReactorChannel.State.UP) && reactorChannel.enableSessionManagement()) {
                            reactorChannel.reactor().sendChannelWarningEvent(reactorChannel, errorInfo);
                        }
                        this._reactor.sendAuthTokenEvent(reactorChannel, this, errorInfo);
                        reactorChannel.sessionMgntState(ReactorChannel.SessionMgntState.REQ_FAILURE_FOR_TOKEN_SERVICE);
                        reactorChannel._loginRequestForEDP.userName().data("");
                        if (reactorChannel.state() != ReactorChannel.State.EDP_RT) continue;
                        reactorChannel.state(ReactorChannel.State.EDP_RT_FAILED);
                    }
                    break;
                }
                finally {
                    this._reactorChannelListLock.unlock();
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int RestErrorCallback(RestEvent event, String errorText) {
        if (this._reactor.isShutdown()) {
            return 0;
        }
        this._reactorChannelListLock.lock();
        RestReactor.populateErrorInfo(event.errorInfo(), -1, "RestHandler.failed", "Failed REST request for the token service. Text: " + errorText);
        try {
            for (int i = 0; i < this._reactorChannelList.size(); ++i) {
                ReactorChannel reactorChannel = this._reactorChannelList.get(i);
                reactorChannel.copyEDPErrorInfo(event.errorInfo());
                if ((reactorChannel.state() == ReactorChannel.State.READY || reactorChannel.state() == ReactorChannel.State.UP) && reactorChannel.enableSessionManagement()) {
                    reactorChannel.reactor().sendChannelWarningEvent(reactorChannel, event.errorInfo());
                }
                this._reactor.sendAuthTokenEvent(reactorChannel, this, event.errorInfo());
                reactorChannel.sessionMgntState(ReactorChannel.SessionMgntState.REQ_FAILURE_FOR_TOKEN_SERVICE);
                reactorChannel._loginRequestForEDP.userName().data("");
                if (reactorChannel.state() != ReactorChannel.State.EDP_RT) continue;
                reactorChannel.state(ReactorChannel.State.EDP_RT_FAILED);
            }
        }
        finally {
            this._reactorChannelListLock.unlock();
        }
        this._sessionState = SessionState.REQUEST_TOKEN_FAILURE;
        if (this.handlesTokenReissueFailed()) {
            this._reactor.sendAuthTokenWorkerEvent(this);
        }
        return 0;
    }

    static enum SessionState {
        UNKNOWN,
        STOP_REQUESTING,
        PARSE_RESP_FAILURE,
        REQUEST_TOKEN_FAILURE,
        REQ_INIT_AUTH_TOKEN,
        REQ_AUTH_TOKEN_USING_PASSWORD,
        REQ_AUTH_TOKEN_USING_REFRESH_TOKEN,
        RECEIVED_AUTH_TOKEN,
        AUTHENTICATE_USING_PASSWD_GRANT,
        AUTHENTICATE_USING_PASSWD_REFRESH_TOKEN,
        STOP_TOKEN_REQUEST,
        REQ_AUTH_TOKEN_USING_V2_CREDENTIAL;

    }
}

