/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.transport.TransportBuffer;
import com.refinitiv.eta.valueadd.common.VaNode;
import java.nio.ByteBuffer;
import java.util.Objects;

class ReactorPackedBuffer
extends VaNode {
    int totalSize;
    int remainingSize;
    private Buffer decodeBuffer = CodecFactory.createBuffer();
    private Buffer jsonBuffer = CodecFactory.createBuffer();
    private int nextRWFPosition;
    private static final int ADDITIONAL_BUFFER_SPACE = 300;

    ReactorPackedBuffer() {
        this.clear();
    }

    void clear() {
        this.totalSize = 0;
        this.remainingSize = 0;
        this.nextRWFPosition = 0;
    }

    Buffer decodeBuffer(TransportBuffer transportBuffer) {
        ByteBuffer byteBuffer = transportBuffer.data();
        if (this.nextRWFPosition == 0) {
            this.decodeBuffer.data(byteBuffer, transportBuffer.dataStartPosition(), transportBuffer.length());
        } else {
            this.decodeBuffer.data(transportBuffer.data(), this.nextRWFPosition, transportBuffer.data().position() - this.nextRWFPosition);
        }
        return this.decodeBuffer;
    }

    Buffer jsonBuffer(int bufferLength) {
        if (Objects.isNull(this.jsonBuffer.data()) || this.jsonBuffer.data().capacity() < (bufferLength += 300)) {
            this.jsonBuffer.clear();
            this.jsonBuffer.data(ByteBuffer.allocate(bufferLength));
        } else {
            ByteBuffer byteBuffer = this.jsonBuffer.data();
            byteBuffer.clear();
            this.jsonBuffer.clear();
            this.jsonBuffer.data(byteBuffer);
        }
        return this.jsonBuffer;
    }

    void nextRWFBufferPosition(int nextBufferPosition) {
        this.nextRWFPosition = nextBufferPosition;
    }

    int nextRWFBufferPosition() {
        return this.nextRWFPosition;
    }
}

