/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.directory;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.MsgKey;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.codec.StatusMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBaseImpl;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryStatus;
import java.nio.ByteBuffer;

class DirectoryStatusImpl
extends MsgBaseImpl {
    private final State state;
    private long filter;
    private int serviceId;
    private int flags;
    private static final String eol = System.getProperty("line.separator");
    private static final String tab = "\t";
    private StatusMsg statusMsg = (StatusMsg)CodecFactory.createMsg();

    DirectoryStatusImpl() {
        this.state = CodecFactory.createState();
    }

    public void applyHasFilter() {
        this.flags |= 1;
    }

    public boolean checkHasFilter() {
        return (this.flags & 1) != 0;
    }

    public void applyHasServiceId() {
        this.flags |= 2;
    }

    public boolean checkHasServiceId() {
        return (this.flags & 2) != 0;
    }

    public int copy(DirectoryStatus destStatusMsg) {
        assert (destStatusMsg != null) : "destStatusMsg must be non-null";
        destStatusMsg.streamId(this.streamId());
        if (this.checkHasFilter()) {
            destStatusMsg.applyHasFilter();
            destStatusMsg.filter(this.filter);
        }
        if (this.checkHasServiceId()) {
            destStatusMsg.applyHasServiceId();
            destStatusMsg.serviceId(this.serviceId);
        }
        if (this.checkClearCache()) {
            destStatusMsg.applyClearCache();
        }
        if (this.checkHasState()) {
            destStatusMsg.applyHasState();
            destStatusMsg.state().streamState(this.state.streamState());
            destStatusMsg.state().dataState(this.state.dataState());
            destStatusMsg.state().code(this.state.code());
            if (this.state.text().length() > 0) {
                Buffer stateText = CodecFactory.createBuffer();
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.state.text().length());
                this.state.text().copy(byteBuffer);
                stateText.data(byteBuffer);
                destStatusMsg.state().text(stateText);
            }
        }
        return 0;
    }

    public void flags(int flags) {
        this.flags = flags;
    }

    public int flags() {
        return this.flags;
    }

    @Override
    public void clear() {
        super.clear();
        this.serviceId = 0;
        this.filter = 0L;
        this.flags = 0;
        this.state.clear();
        this.state.streamState(1);
        this.state.dataState(1);
        this.state.code(0);
    }

    @Override
    public int encode(EncodeIterator encodeIter) {
        this.statusMsg.clear();
        this.statusMsg.streamId(this.streamId());
        this.statusMsg.containerType(128);
        this.statusMsg.msgClass(3);
        this.statusMsg.domainType(4);
        if (this.checkHasFilter()) {
            this.statusMsg.applyHasMsgKey();
            this.statusMsg.msgKey().applyHasFilter();
            this.statusMsg.msgKey().filter(this.filter);
        }
        if (this.checkClearCache()) {
            this.statusMsg.applyClearCache();
        }
        if (this.checkHasServiceId()) {
            this.statusMsg.applyHasMsgKey();
            this.statusMsg.msgKey().applyHasServiceId();
            this.statusMsg.msgKey().serviceId(this.serviceId);
        }
        if (this.checkHasState()) {
            this.statusMsg.applyHasState();
            this.statusMsg.state().dataState(this.state().dataState());
            this.statusMsg.state().streamState(this.state().streamState());
            this.statusMsg.state().code(this.state().code());
            this.statusMsg.state().text(this.state().text());
        }
        return this.statusMsg.encode(encodeIter);
    }

    @Override
    public int decode(DecodeIterator dIter, Msg msg) {
        MsgKey key;
        this.clear();
        if (msg.msgClass() != 3) {
            return -1;
        }
        StatusMsg statusMsg = (StatusMsg)msg;
        this.streamId(msg.streamId());
        if (statusMsg.checkHasState()) {
            this.state.code(statusMsg.state().code());
            this.state.streamState(statusMsg.state().streamState());
            this.state.dataState(statusMsg.state().dataState());
            if (statusMsg.state().text().length() > 0) {
                Buffer buf = statusMsg.state().text();
                this.state.text().data(buf.data(), buf.position(), buf.length());
            }
            this.applyHasState();
        }
        if (statusMsg.checkClearCache()) {
            this.applyClearCache();
        }
        if ((key = msg.msgKey()) != null) {
            if (key.checkHasFilter()) {
                this.applyHasFilter();
                this.filter(key.filter());
            }
            if (key.checkHasServiceId()) {
                this.applyHasServiceId();
                this.serviceId(key.serviceId());
            }
        }
        return 0;
    }

    public boolean checkHasState() {
        return (this.flags & 4) != 0;
    }

    public void applyHasState() {
        this.flags |= 4;
    }

    public void applyClearCache() {
        this.flags |= 8;
    }

    public boolean checkClearCache() {
        return (this.flags & 8) != 0;
    }

    public long filter() {
        return this.filter;
    }

    public void filter(long filter) {
        assert (this.checkHasFilter());
        this.filter = filter;
    }

    public void serviceId(int serviceId) {
        assert (this.checkHasServiceId());
        this.serviceId = serviceId;
    }

    public int serviceId() {
        return this.serviceId;
    }

    public State state() {
        return this.state;
    }

    public void state(State state) {
        this.state().streamState(state.streamState());
        this.state().dataState(state.dataState());
        this.state().code(state.code());
        this.state().text(state.text());
    }

    @Override
    public String toString() {
        StringBuilder stringBuf = super.buildStringBuffer();
        stringBuf.insert(0, "DirectoryStatus: \n");
        if (this.checkHasServiceId()) {
            stringBuf.append(tab);
            stringBuf.append("serviceId: ");
            stringBuf.append(this.serviceId());
            stringBuf.append(eol);
        }
        if (this.checkHasFilter()) {
            stringBuf.append(tab);
            stringBuf.append("filter: ");
            stringBuf.append(this.filter());
            stringBuf.append(eol);
        }
        if (this.checkHasState()) {
            stringBuf.append(tab);
            stringBuf.append("state: ");
            stringBuf.append(this.state());
            stringBuf.append(eol);
        }
        return stringBuf.toString();
    }

    @Override
    public int domainType() {
        return 4;
    }
}

