/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Array;
import com.refinitiv.eta.codec.ArrayEntry;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.ElementEntry;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Int;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.rdm.ElementNames;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorFactory;
import com.refinitiv.eta.valueadd.reactor.Watchlist;
import com.refinitiv.eta.valueadd.reactor.WlRequest;
import com.refinitiv.eta.valueadd.reactor.WlStream;
import com.refinitiv.eta.valueadd.reactor.WlView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;

public class WlViewHandler {
    private ElementList elementList = CodecFactory.createElementList();
    private ElementEntry elementEntry = CodecFactory.createElementEntry();
    private Array viewArray = CodecFactory.createArray();
    private ArrayEntry arrayEntry = CodecFactory.createArrayEntry();
    private Int tempInt = CodecFactory.createInt();
    private UInt tempUInt = CodecFactory.createUInt();
    private Buffer elementNameBuf = CodecFactory.createBuffer();
    Watchlist _watchlist;
    private boolean _resorted;
    LinkedList<ArrayList<Integer>> _viewFieldIdListPool = new LinkedList();
    LinkedList<ArrayList<String>> _viewElementNameListPool = new LinkedList();
    LinkedList<LinkedList<WlView>> _mergedViewsPool = new LinkedList();
    LinkedList<LinkedList<WlView>> _committedViewsPool = new LinkedList();
    LinkedList<LinkedList<WlView>> _newViewsPool = new LinkedList();
    LinkedList<HashMap<Integer, Integer>> _viewFieldIdCountMapPool = new LinkedList();
    LinkedList<HashMap<String, Integer>> _viewElementNameCountMapPool = new LinkedList();
    ArrayList<Integer> fidsToRemove = new ArrayList();

    WlViewHandler(Watchlist watchlist) {
        this._watchlist = watchlist;
        this._resorted = false;
    }

    WlView viewCreate(ArrayList<Integer> fieldIdList, ArrayList<String> elementNameList, int elemCount, int viewType, ReactorErrorInfo errorInfo) {
        switch (viewType) {
            case 1: {
                WlView wlView = ReactorFactory.createWlView();
                wlView.viewHandler(this);
                wlView.viewType(viewType);
                wlView.elemCount(0);
                wlView.state(WlView.State.NEW);
                wlView._fieldIdList = this._viewFieldIdListPool.poll();
                if (wlView._fieldIdList == null) {
                    wlView._fieldIdList = new ArrayList();
                } else {
                    wlView._fieldIdList.clear();
                }
                for (Integer I : fieldIdList) {
                    wlView._fieldIdList.add(I);
                    ++wlView._elemCount;
                }
                if (wlView._fieldIdList != null && wlView.elemCount() > 0) {
                    int startingCount;
                    Collections.sort(wlView._fieldIdList);
                    int newCount = startingCount = wlView.elemCount();
                    int nextValidPos = 1;
                    for (int i = 1; i < startingCount; ++i) {
                        if (wlView._fieldIdList.get(i).equals(wlView._fieldIdList.get(nextValidPos - 1))) {
                            --newCount;
                            continue;
                        }
                        if (i > nextValidPos) {
                            wlView._fieldIdList.set(nextValidPos, wlView._fieldIdList.get(i));
                        }
                        ++nextValidPos;
                    }
                    wlView._elemCount = newCount;
                } else {
                    wlView.elemCount(0);
                }
                return wlView;
            }
            case 2: {
                WlView wlView = ReactorFactory.createWlView();
                wlView.viewHandler(this);
                wlView.viewType(viewType);
                wlView.elemCount(0);
                wlView.state(WlView.State.NEW);
                wlView._elementNameList = this._viewElementNameListPool.poll();
                if (wlView._elementNameList == null) {
                    wlView._elementNameList = new ArrayList();
                } else {
                    wlView._elementNameList.clear();
                }
                for (String S : elementNameList) {
                    wlView._elementNameList.add(S);
                    ++wlView._elemCount;
                }
                if (wlView._elementNameList != null && wlView.elemCount() > 0) {
                    int startingCount;
                    Collections.sort(wlView._elementNameList);
                    int newCount = startingCount = wlView.elemCount();
                    int nextValidPos = 1;
                    for (int i = 1; i < startingCount; ++i) {
                        if (wlView._elementNameList.get(i).equals(wlView._elementNameList.get(nextValidPos - 1))) {
                            --newCount;
                            continue;
                        }
                        if (i > nextValidPos) {
                            wlView._elementNameList.set(nextValidPos, wlView._elementNameList.get(i));
                        }
                        ++nextValidPos;
                    }
                    wlView._elemCount = newCount;
                } else {
                    wlView.elemCount(0);
                }
                return wlView;
            }
        }
        this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ViewHandder", "Invalid ViewType  <" + viewType + ">");
        return null;
    }

    WlView aggregateViewCreate(WlView view, ReactorErrorInfo errorInfo) {
        WlView aggView = ReactorFactory.createWlView();
        aggView.aggregated(true);
        aggView.viewHandler(this);
        aggView._newViews = this._newViewsPool.poll();
        if (aggView._newViews == null) {
            aggView._newViews = new LinkedList();
        }
        aggView._newViews.clear();
        aggView._mergedViews = this._mergedViewsPool.poll();
        if (aggView._mergedViews == null) {
            aggView._mergedViews = new LinkedList();
        }
        aggView._mergedViews.clear();
        aggView._committedViews = this._committedViewsPool.poll();
        if (aggView._committedViews == null) {
            aggView._committedViews = new LinkedList();
        }
        aggView._committedViews.clear();
        aggView._viewFieldIdCountMap = null;
        aggView._viewElementNameCountMap = null;
        if (view.viewType() == 1) {
            aggView._viewFieldIdCountMap = this._viewFieldIdCountMapPool.poll();
            if (aggView._viewFieldIdCountMap == null) {
                aggView._viewFieldIdCountMap = new HashMap();
            }
            aggView._viewFieldIdCountMap.clear();
            for (Integer fieldId : view.fieldIdList().subList(0, view.elemCount())) {
                aggView._viewFieldIdCountMap.put(fieldId, 1);
            }
        } else if (view.viewType() == 2) {
            aggView._viewElementNameCountMap = this._viewElementNameCountMapPool.poll();
            if (aggView._viewElementNameCountMap == null) {
                aggView._viewElementNameCountMap = new HashMap();
            }
            aggView._viewElementNameCountMap.clear();
            for (String elementName : view.elementNameList().subList(0, view.elemCount())) {
                aggView._viewElementNameCountMap.put(elementName, 1);
            }
        }
        aggView.mergedViews().add(view);
        view.state(WlView.State.MERGED);
        aggView._fieldIdList = null;
        aggView._elementNameList = null;
        switch (view.viewType()) {
            case 1: {
                aggView.viewHandler(this);
                aggView.viewType(view.viewType());
                aggView.elemCount(view.elemCount());
                aggView._fieldIdList = this._viewFieldIdListPool.poll();
                if (aggView._fieldIdList == null) {
                    aggView._fieldIdList = new ArrayList();
                }
                aggView._fieldIdList.clear();
                aggView._fieldIdList.addAll(view.fieldIdList());
                break;
            }
            case 2: {
                aggView.viewHandler(this);
                aggView.viewType(view.viewType());
                aggView.elemCount(view.elemCount());
                aggView._elementNameList = this._viewElementNameListPool.poll();
                if (aggView._elementNameList == null) {
                    aggView._elementNameList = new ArrayList();
                }
                aggView._elementNameList.clear();
                aggView._elementNameList.addAll(view.elementNameList());
                break;
            }
            default: {
                this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ViewHandder", "Invalid ViewType, cannot create aggregate view  <" + view.viewType() + ">");
                return null;
            }
        }
        return aggView;
    }

    int aggregateViewAdd(WlView aggView, WlView view, ReactorErrorInfo errorInfo) {
        if (view.viewType() != aggView.viewType()) {
            this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandder", "ViewType mismatch, cannot add to aggregated view");
            return -1;
        }
        aggView._newViews.add(view);
        return 0;
    }

    int aggregateViewMerge(WlView aggView) {
        WlView view = aggView.newViews().poll();
        while (view != null) {
            switch (view.viewType()) {
                case 1: {
                    int j;
                    Integer count;
                    int index;
                    int i;
                    ArrayList<Integer> aggViewFieldIdList = aggView.fieldIdList();
                    if (aggViewFieldIdList == null) {
                        aggViewFieldIdList = this._viewFieldIdListPool.poll();
                        if (aggViewFieldIdList == null) {
                            aggViewFieldIdList = new ArrayList();
                        } else {
                            aggViewFieldIdList.clear();
                        }
                        aggView.fieldIdList(aggViewFieldIdList);
                        aggView._elemCount = 0;
                    }
                    ArrayList<Integer> newFids = new ArrayList<Integer>();
                    for (i = 0; i < view.fieldIdList().subList(0, view.elemCount()).size(); ++i) {
                        Integer fid = view.fieldIdList().get(i);
                        index = Collections.binarySearch(aggViewFieldIdList.subList(0, aggView._elemCount), fid);
                        if (index >= 0) {
                            count = aggView._viewFieldIdCountMap.get(fid);
                            count = count + 1;
                            aggView._viewFieldIdCountMap.put(fid, count);
                            continue;
                        }
                        newFids.add(fid);
                    }
                    for (j = 0; j < newFids.size(); ++j) {
                        if (aggView.elemCount() < aggViewFieldIdList.size()) {
                            aggViewFieldIdList.set(aggView._elemCount, (Integer)newFids.get(j));
                        } else {
                            aggViewFieldIdList.add((Integer)newFids.get(j));
                        }
                        aggView._viewFieldIdCountMap.put((Integer)newFids.get(j), 1);
                        ++aggView._elemCount;
                    }
                    Collections.sort(aggViewFieldIdList.subList(0, aggView._elemCount));
                    break;
                }
                case 2: {
                    int j;
                    Integer count;
                    int index;
                    int i;
                    ArrayList<String> aggViewElementNameList = aggView.elementNameList();
                    if (aggViewElementNameList == null) {
                        aggViewElementNameList = this._viewElementNameListPool.poll();
                        if (aggViewElementNameList == null) {
                            aggViewElementNameList = new ArrayList();
                        } else {
                            aggViewElementNameList.clear();
                        }
                        aggView.elementNameList(aggViewElementNameList);
                        aggView._elemCount = 0;
                    }
                    ArrayList<String> newElements = new ArrayList<String>();
                    for (i = 0; i < view.elementNameList().subList(0, view.elemCount()).size(); ++i) {
                        String elementName = view.elementNameList().get(i);
                        index = Collections.binarySearch(aggViewElementNameList.subList(0, aggView._elemCount), elementName);
                        if (index >= 0) {
                            count = aggView._viewElementNameCountMap.get(elementName);
                            count = count + 1;
                            aggView._viewElementNameCountMap.put(elementName, count);
                            continue;
                        }
                        newElements.add(elementName);
                    }
                    for (j = 0; j < newElements.size(); ++j) {
                        if (aggView.elemCount() < aggViewElementNameList.size()) {
                            aggViewElementNameList.set(aggView._elemCount, (String)newElements.get(j));
                        } else {
                            aggViewElementNameList.add((String)newElements.get(j));
                        }
                        aggView._viewElementNameCountMap.put((String)newElements.get(j), 1);
                        ++aggView._elemCount;
                    }
                    Collections.sort(aggViewElementNameList.subList(0, aggView._elemCount));
                    break;
                }
            }
            aggView.mergedViews().add(view);
            view.state(WlView.State.MERGED);
            view = aggView.newViews().poll();
        }
        return 0;
    }

    int removeRequestView(WlStream wlStream, WlRequest wlRequest, ReactorErrorInfo errorInfo) {
        block22: {
            if (!wlRequest.requestMsg().checkHasView()) {
                wlStream._pendingViewChange = true;
                return 0;
            }
            WlView view = wlRequest.view();
            --wlStream._requestsWithViewCount;
            WlView aggView = wlStream.aggregateView();
            if (view.state() == WlView.State.NEW) {
                wlStream.aggregateView().newViews().remove(view);
                return 0;
            }
            if (view.state() == WlView.State.MERGED) {
                wlStream.aggregateView().mergedViews().remove(view);
            } else if (view.state() == WlView.State.COMMITTED) {
                wlStream.aggregateView().committedViews().remove(view);
            }
            if (view.state() != WlView.State.MERGED && view.state() != WlView.State.COMMITTED) break block22;
            if (view.viewType() == 1) {
                ArrayList<Integer> aggViewFieldIdList = aggView.fieldIdList();
                this.fidsToRemove.clear();
                for (int i = 0; i < view.fieldIdList().subList(0, view.elemCount()).size(); ++i) {
                    Integer fid = view.fieldIdList().get(i);
                    int index = Collections.binarySearch(aggViewFieldIdList.subList(0, aggView._elemCount), fid);
                    if (index >= 0) {
                        Integer count = aggView._viewFieldIdCountMap.get(fid);
                        count = count - 1;
                        aggView._viewFieldIdCountMap.put(fid, count);
                        if (count != 0) continue;
                        this.fidsToRemove.add(fid);
                        continue;
                    }
                    this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ViewHandder", "Aggregate View cannot remove a non-existent field id  <" + fid + ">");
                }
                int writePos = 0;
                int currentPos = 0;
                int originalSize = aggView.elemCount();
                this._resorted = !this.fidsToRemove.isEmpty();
                for (int k = 0; k < this.fidsToRemove.size(); ++k) {
                    if (currentPos >= originalSize) continue;
                    if (aggViewFieldIdList.get(currentPos) == this.fidsToRemove.get(k)) {
                        ++currentPos;
                        --aggView._elemCount;
                        continue;
                    }
                    if (aggViewFieldIdList.get(currentPos) < this.fidsToRemove.get(k)) {
                        if (writePos != currentPos) {
                            aggViewFieldIdList.set(writePos, aggViewFieldIdList.get(currentPos));
                        }
                        ++currentPos;
                        ++writePos;
                        continue;
                    }
                    return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ViewHandler", "Aggregate View cannot remove a non-existent field id  <" + this.fidsToRemove.get(k) + ">");
                }
                while (currentPos < originalSize) {
                    aggViewFieldIdList.set(writePos++, aggViewFieldIdList.get(currentPos++));
                }
            } else {
                ArrayList<String> aggViewElementNameList = aggView.elementNameList();
                ArrayList<String> elementNamesToRemove = new ArrayList<String>();
                for (int i = 0; i < view.elemCount(); ++i) {
                    String elementName = view.elementNameList().get(i);
                    int index = Collections.binarySearch(aggViewElementNameList.subList(0, aggView._elemCount), elementName);
                    if (index >= 0) {
                        Integer count = aggView._viewElementNameCountMap.get(elementName);
                        count = count - 1;
                        aggView._viewElementNameCountMap.put(elementName, count);
                        if (count != 0) continue;
                        elementNamesToRemove.add(elementName);
                        continue;
                    }
                    this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ViewHandder", "Aggregate View cannot remove a non-existent elementName  <" + elementName + ">");
                }
                int writePos = 0;
                int currentPos = 0;
                int originalSize = aggView.elemCount();
                this._resorted = !elementNamesToRemove.isEmpty();
                block4: for (int k = 0; k < elementNamesToRemove.size(); ++k) {
                    while (currentPos < originalSize) {
                        int comparisonResult = aggViewElementNameList.get(currentPos).compareTo((String)elementNamesToRemove.get(k));
                        if (comparisonResult == 0) {
                            ++currentPos;
                            --aggView._elemCount;
                            continue block4;
                        }
                        if (comparisonResult < 0) {
                            if (currentPos > writePos) {
                                aggViewElementNameList.set(writePos, aggViewElementNameList.get(currentPos));
                            }
                            ++currentPos;
                            ++writePos;
                            continue;
                        }
                        return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ViewHandler", "Aggregate View cannot remove a non-existent field id  <" + (String)elementNamesToRemove.get(k) + ">");
                    }
                }
                while (currentPos < originalSize) {
                    aggViewElementNameList.set(writePos++, aggViewElementNameList.get(currentPos++));
                }
            }
        }
        return 0;
    }

    void aggregateViewCommit(WlView aggView) {
        WlView view = aggView.mergedViews().poll();
        while (view != null) {
            aggView.committedViews().add(view);
            view.state(WlView.State.COMMITTED);
            view = aggView.mergedViews().poll();
        }
    }

    void aggregateViewUncommit(WlView aggView) {
        WlView view = aggView.committedViews().poll();
        while (view != null) {
            aggView.mergedViews().add(view);
            view.state(WlView.State.MERGED);
            view = aggView.committedViews().poll();
        }
    }

    int encodeViewRequest(EncodeIterator encodeIter, WlView aggView) {
        this.elementList.clear();
        this.elementList.applyHasStandardData();
        int ret = this.elementList.encodeInit(encodeIter, null, 0);
        switch (aggView.viewType()) {
            case 1: {
                this.elementEntry.clear();
                this.elementEntry.name(ElementNames.VIEW_TYPE);
                this.elementEntry.dataType(4);
                this.tempUInt.value(1);
                ret = this.elementEntry.encode(encodeIter, this.tempUInt);
                if (ret < 0) {
                    return ret;
                }
                this.elementEntry.clear();
                this.elementEntry.name(ElementNames.VIEW_DATA);
                this.elementEntry.dataType(15);
                ret = this.elementEntry.encodeInit(encodeIter, 0);
                if (ret < 0) {
                    return ret;
                }
                this.viewArray.primitiveType(3);
                this.viewArray.itemLength(2);
                ret = this.viewArray.encodeInit(encodeIter);
                if (ret < 0) {
                    return ret;
                }
                for (Integer viewField : aggView.fieldIdList().subList(0, aggView.elemCount())) {
                    if (aggView._viewFieldIdCountMap.get(viewField) == null || aggView._viewFieldIdCountMap.get(viewField) == 0) continue;
                    this.arrayEntry.clear();
                    this.tempInt.value(viewField.intValue());
                    ret = this.arrayEntry.encode(encodeIter, this.tempInt);
                    if (ret >= 0) continue;
                    return ret;
                }
                ret = this.viewArray.encodeComplete(encodeIter, true);
                if (ret < 0) {
                    return ret;
                }
                ret = this.elementEntry.encodeComplete(encodeIter, true);
                if (ret < 0) {
                    return ret;
                }
                ret = this.elementList.encodeComplete(encodeIter, true);
                if (ret >= 0) break;
                return ret;
            }
            case 2: {
                this.elementEntry.clear();
                this.elementEntry.name(ElementNames.VIEW_TYPE);
                this.elementEntry.dataType(4);
                this.tempUInt.value(2);
                ret = this.elementEntry.encode(encodeIter, this.tempUInt);
                if (ret < 0) {
                    return ret;
                }
                this.elementEntry.clear();
                this.elementEntry.name(ElementNames.VIEW_DATA);
                this.elementEntry.dataType(15);
                ret = this.elementEntry.encodeInit(encodeIter, 0);
                if (ret < 0) {
                    return ret;
                }
                this.viewArray.primitiveType(17);
                ret = this.viewArray.encodeInit(encodeIter);
                if (ret < 0) {
                    return ret;
                }
                for (String elementName : aggView.elementNameList().subList(0, aggView.elemCount())) {
                    if (aggView._viewElementNameCountMap.get(elementName) == null || aggView._viewElementNameCountMap.get(elementName) == 0) continue;
                    this.arrayEntry.clear();
                    this.elementNameBuf.data(elementName);
                    ret = this.arrayEntry.encode(encodeIter, this.elementNameBuf);
                    if (ret >= 0) continue;
                    return ret;
                }
                ret = this.viewArray.encodeComplete(encodeIter, true);
                if (ret < 0) {
                    return ret;
                }
                ret = this.elementEntry.encodeComplete(encodeIter, true);
                if (ret < 0) {
                    return ret;
                }
                ret = this.elementList.encodeComplete(encodeIter, true);
                if (ret >= 0) break;
                return ret;
            }
        }
        return 0;
    }

    void aggregateViewDestroy(WlView aggView) {
        this._viewFieldIdCountMapPool.add(aggView._viewFieldIdCountMap);
        this._viewElementNameCountMapPool.add(aggView._viewElementNameCountMap);
        this._newViewsPool.add(aggView._newViews);
        this._mergedViewsPool.add(aggView._mergedViews);
        this._committedViewsPool.add(aggView._committedViews);
        this._viewFieldIdListPool.add(aggView._fieldIdList);
        this._viewElementNameListPool.add(aggView._elementNameList);
        aggView.returnToPool();
    }

    boolean aggregateViewContainsNewViews(WlView aggView) {
        int mergedCount = aggView.mergedViews().size() + aggView.committedViews().size();
        if (mergedCount == 0) {
            return false;
        }
        for (WlView view : aggView.newViews()) {
            switch (aggView.viewType()) {
                case 1: {
                    ArrayList<Integer> aggViewFieldIdList = aggView.fieldIdList();
                    ArrayList<Integer> viewFieldIdList = view.fieldIdList();
                    if (view.elemCount() > aggView.elemCount()) {
                        return false;
                    }
                    for (int i = 0; i < viewFieldIdList.subList(0, view.elemCount()).size(); ++i) {
                        Integer fid = view.fieldIdList().get(i);
                        int index = Collections.binarySearch(aggViewFieldIdList.subList(0, aggView._elemCount), fid);
                        if (index >= 0) continue;
                        return false;
                    }
                    return true;
                }
                case 2: {
                    ArrayList<String> aggViewElementNameList = aggView.elementNameList();
                    ArrayList<String> viewElementNameList = view.elementNameList();
                    if (view.elemCount() > aggView.elemCount()) {
                        return false;
                    }
                    for (int i = 0; i < viewElementNameList.subList(0, view.elemCount()).size(); ++i) {
                        String elementName = view.elementNameList().get(i);
                        int index = Collections.binarySearch(aggViewElementNameList.subList(0, aggView._elemCount), elementName);
                        if (index >= 0) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    boolean aggregateViewContainsView(WlView aggView, WlRequest wlRequest) {
        int mergedCount = aggView.mergedViews().size() + aggView.committedViews().size();
        if (mergedCount == 0) {
            return false;
        }
        switch (aggView.viewType()) {
            case 1: {
                ArrayList<Integer> aggViewFieldIdList = aggView.fieldIdList();
                ArrayList<Integer> viewFieldIdList = wlRequest.viewFieldIdList();
                if (wlRequest.viewElemCount() > aggView.elemCount()) {
                    return false;
                }
                for (int i = 0; i < viewFieldIdList.subList(0, wlRequest.viewElemCount()).size(); ++i) {
                    Integer fid = viewFieldIdList.get(i);
                    int index = Collections.binarySearch(aggViewFieldIdList.subList(0, aggView._elemCount), fid);
                    if (index >= 0) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                ArrayList<String> aggViewElementNameList = aggView.elementNameList();
                ArrayList<String> viewElementNameList = wlRequest.viewElementNameList();
                if (wlRequest.viewElemCount() > aggView.elemCount()) {
                    return false;
                }
                for (int i = 0; i < viewElementNameList.subList(0, wlRequest.viewElemCount()).size(); ++i) {
                    String elementName = viewElementNameList.get(i);
                    int index = Collections.binarySearch(aggViewElementNameList.subList(0, aggView._elemCount), elementName);
                    if (index >= 0) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    boolean commitedViewsContainsAggregateView(WlView aggView) {
        if (aggView.committedViews().size() == 0) {
            return false;
        }
        switch (aggView.viewType()) {
            case 1: {
                ArrayList<Integer> aggViewFieldIdList = aggView.fieldIdList();
                for (int kk = 0; kk < aggViewFieldIdList.subList(0, aggView.elemCount()).size(); ++kk) {
                    Integer aggFid = aggViewFieldIdList.get(kk);
                    boolean found = false;
                    for (WlView view : aggView.committedViews()) {
                        ArrayList<Integer> viewFieldIdList = view.fieldIdList();
                        int index = Collections.binarySearch(viewFieldIdList.subList(0, view._elemCount), aggFid);
                        if (index < 0) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return found;
                }
                break;
            }
            case 2: {
                ArrayList<String> aggViewElementNameList = aggView.elementNameList();
                for (int kk = 0; kk < aggViewElementNameList.subList(0, aggView.elemCount()).size(); ++kk) {
                    String aggName = aggViewElementNameList.get(kk);
                    boolean found = false;
                    for (WlView view : aggView.committedViews()) {
                        ArrayList<String> viewElementNameList = view.elementNameList();
                        int index = Collections.binarySearch(viewElementNameList.subList(0, view._elemCount), aggName);
                        if (index < 0) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return found;
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    boolean sameViews(WlView view1, WlRequest wlRequest) {
        if (view1 == null) {
            return false;
        }
        if (view1.viewType() != wlRequest.viewType()) {
            return false;
        }
        if (view1.elemCount() != wlRequest.viewElemCount()) {
            return false;
        }
        switch (view1.viewType()) {
            case 1: {
                return Arrays.equals(view1.fieldIdList().subList(0, view1._elemCount).toArray(), wlRequest._viewFieldIdList.subList(0, wlRequest.viewElemCount()).toArray());
            }
            case 2: {
                return Arrays.equals(view1.elementNameList().subList(0, view1._elemCount).toArray(), wlRequest._viewElementNameList.subList(0, wlRequest.viewElemCount()).toArray());
            }
        }
        return false;
    }

    void destroyView(WlView view) {
        if (view != null) {
            if (view._fieldIdList != null) {
                this._viewFieldIdListPool.add(view._fieldIdList);
            }
            if (view._elementNameList != null) {
                this._viewElementNameListPool.add(view._elementNameList);
            }
            view.returnToPool();
        }
    }

    boolean resorted() {
        return this._resorted;
    }

    void resorted(boolean resorted) {
        this._resorted = resorted;
    }
}

