/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.transport.Error;
import com.refinitiv.eta.valueadd.common.VaDoubleLinkList;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamBuffer;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamPersistenceBuffer;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamPersistenceFile;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamUtil;
import com.refinitiv.eta.valueadd.reactor.TunnelSubstream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

class TunnelStreamPersistenceFileV1
extends TunnelStreamPersistenceFile {
    private int _maxMsgs;
    private int _maxMsgLength;
    private VaDoubleLinkList<TunnelStreamPersistenceBuffer> _waitingTransmitList;
    private VaDoubleLinkList<TunnelStreamPersistenceBuffer> _waitingQueueAckList;
    Buffer _tmpBuf = CodecFactory.createBuffer();

    TunnelStreamPersistenceFileV1(TunnelSubstream tunnelSubstream, RandomAccessFile file, FileChannel fileChannel, FileLock fileLock, Msg tmpMsg, EncodeIterator tmpEncodeIter, DecodeIterator tmpDecodeIter, boolean reset, Error error) {
        super(tunnelSubstream, file, fileChannel, fileLock);
        this._waitingTransmitList = new VaDoubleLinkList();
        this._waitingQueueAckList = new VaDoubleLinkList();
        try {
            long fileSize = reset ? (long)(76 + (30 + this._tunnelSubstream._tunnelStream._classOfService.common().maxMsgSize() + 128) * 1024) : fileChannel.size();
            this._fileByteBuf = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, fileSize);
        }
        catch (IOException e) {
            error.errorId(-1);
            error.text("Failed to map persistence file to ByteBuffer");
        }
        if (!reset) {
            this._maxMsgs = this._fileByteBuf.getInt(4);
            this._maxMsgLength = this._fileByteBuf.getInt(12);
            this._tunnelSubstream._lastOutSeqNum = this._fileByteBuf.getInt(28);
            this._tunnelSubstream._lastInSeqNum = this._fileByteBuf.getInt(32);
            int position = this._fileByteBuf.getInt(36);
            while (position != 0) {
                TunnelStreamPersistenceBuffer persistBuffer = new TunnelStreamPersistenceBuffer();
                persistBuffer.filePosition(position);
                this._persistentBufferPool.push(persistBuffer, TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
                position = this._fileByteBuf.getInt(position + 0);
            }
            position = this._fileByteBuf.getInt(40);
            while (position != 0) {
                int tmpPosition = position;
                position = this._fileByteBuf.getInt(position + 0);
                if (this.loadMsg(tmpPosition, false, tmpMsg, tmpEncodeIter, tmpDecodeIter, error) == 0) continue;
                return;
            }
            position = this._fileByteBuf.getInt(44);
            while (position != 0) {
                int tmpPosition = position;
                position = this._fileByteBuf.getInt(position + 0);
                if (this.loadMsg(tmpPosition, true, tmpMsg, tmpEncodeIter, tmpDecodeIter, error) == 0) continue;
                return;
            }
        } else {
            this._maxMsgs = 1024;
            this._maxMsgLength = this._tunnelSubstream._tunnelStream.classOfService().common().maxMsgSize();
            this._tunnelSubstream._lastOutSeqNum = 0;
            this._tunnelSubstream._lastInSeqNum = 0;
            this._fileByteBuf.putInt(0, 1);
            this._fileByteBuf.putInt(4, this._maxMsgs);
            this._fileByteBuf.putInt(12, this._maxMsgLength);
            this._fileByteBuf.putInt(20, 0);
            this._fileByteBuf.putInt(28, 0);
            this._fileByteBuf.putInt(32, 0);
            TunnelStreamPersistenceBuffer prevPersistBuffer = null;
            TunnelStreamPersistenceBuffer persistBuffer = null;
            for (int i = 0; i < 1024; ++i) {
                persistBuffer = new TunnelStreamPersistenceBuffer();
                persistBuffer.filePosition(76 + i * (30 + this._maxMsgLength + 128));
                this._persistentBufferPool.push(persistBuffer, TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
                if (prevPersistBuffer != null) {
                    this._fileByteBuf.putInt(prevPersistBuffer.filePosition() + 0, persistBuffer.filePosition());
                }
                prevPersistBuffer = persistBuffer;
            }
            this._fileByteBuf.putInt(persistBuffer.filePosition() + 0, 0);
            this._fileByteBuf.putInt(36, ((TunnelStreamPersistenceBuffer)this._persistentBufferPool.peek()).filePosition());
            this._fileByteBuf.putInt(40, 0);
            this._fileByteBuf.putInt(44, 0);
        }
        error.errorId(0);
    }

    @Override
    void lastOutSeqNum(int lastOutSeqNum) {
        this._fileByteBuf.putInt(28, lastOutSeqNum);
    }

    @Override
    void lastInSeqNum(int lastInSeqNum) {
        this._fileByteBuf.putInt(32, lastInSeqNum);
    }

    @Override
    int saveMsg(TunnelStreamBuffer buffer, Error error) {
        int seqNum = this._tunnelSubstream._lastOutSeqNum + 1;
        assert (buffer.length() <= this._tunnelSubstream._tunnelStream._classOfService.common().maxMsgSize());
        TunnelStreamPersistenceBuffer persistenceBuffer = (TunnelStreamPersistenceBuffer)this._persistentBufferPool.peek();
        if (persistenceBuffer == null) {
            error.errorId(-9);
            error.text("Local persistence file is full. Space may become available later as delivered messages are acknowledged.");
            return -9;
        }
        int entryPosition = persistenceBuffer.filePosition();
        buffer.setToFullWritebuffer();
        this._fileByteBuf.putInt(entryPosition + 4, buffer.length());
        this._fileByteBuf.putInt(entryPosition + 8, seqNum);
        this._fileByteBuf.putShort(entryPosition + 12, (short)1);
        if (!buffer.timeoutIsCode()) {
            assert (buffer.timeoutNsec() - buffer.timeQueuedNsec() > 0L);
            this._fileByteBuf.putLong(entryPosition + 22, buffer.timeoutNsec() - buffer.timeQueuedNsec());
            this._fileByteBuf.putLong(entryPosition + 14, buffer.timeQueuedNsec());
        } else {
            this._fileByteBuf.putLong(entryPosition + 22, buffer.timeoutNsec());
        }
        this._fileByteBuf.position(entryPosition + 30);
        buffer.copyFullBuffer(this._fileByteBuf);
        this.persistenceBufferListMove(this._persistentBufferPool, 36, this._waitingTransmitList, 40, persistenceBuffer);
        buffer.persistenceBuffer(this._tunnelSubstream, persistenceBuffer);
        persistenceBuffer.tunnelStreamHeaderLen(buffer.tunnelStreamHeaderLen());
        return 0;
    }

    private int loadMsg(int entryPosition, boolean isTransmitted, Msg tmpMsg, EncodeIterator tmpEncodeIter, DecodeIterator tmpDecodeIter, Error error) {
        TunnelStreamPersistenceBuffer persistBuffer = new TunnelStreamPersistenceBuffer();
        int length = this._fileByteBuf.getInt(entryPosition + 4);
        persistBuffer.length(length);
        persistBuffer.filePosition(entryPosition);
        persistBuffer.seqNum(this._fileByteBuf.getInt(entryPosition + 8));
        persistBuffer.isTransmitted(isTransmitted);
        this._tmpBuf.clear();
        this._tmpBuf.data((ByteBuffer)this._fileByteBuf, entryPosition + 30, persistBuffer.length());
        tmpDecodeIter.clear();
        tmpDecodeIter.setBufferAndRWFVersion(this._tmpBuf, this._tunnelSubstream._tunnelStream.classOfService().common().protocolMajorVersion(), this._tunnelSubstream._tunnelStream.classOfService().common().protocolMinorVersion());
        int ret = tmpMsg.decode(tmpDecodeIter);
        if (ret != 0) {
            error.errorId(ret);
            error.text("Failed to decode message while loading message from file.");
            return -1;
        }
        persistBuffer.tunnelStreamHeaderLen(tmpMsg.encodedDataBody().position() - (entryPosition + 30));
        if (isTransmitted) {
            this._waitingQueueAckList.push(persistBuffer, TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
        } else {
            this._waitingTransmitList.push(persistBuffer, TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
        }
        return 0;
    }

    @Override
    void releasePersistenceBuffers(int seqNum) {
        TunnelStreamPersistenceBuffer persistBuffer;
        while ((persistBuffer = this._waitingQueueAckList.peek()) != null && TunnelStreamUtil.seqNumCompare(persistBuffer.seqNum(), seqNum) <= 0) {
            this.releasePersistenceBuffer(persistBuffer);
        }
    }

    @Override
    void releasePersistenceBuffer(TunnelStreamPersistenceBuffer persistBuffer) {
        if (persistBuffer.isTransmitted()) {
            this.persistenceBufferListMove(this._waitingQueueAckList, 44, this._persistentBufferPool, 36, persistBuffer);
        } else {
            this.persistenceBufferListMove(this._waitingTransmitList, 40, this._persistentBufferPool, 36, persistBuffer);
        }
        persistBuffer.reset();
    }

    @Override
    void setBufferAsTransmitted(TunnelStreamPersistenceBuffer persistenceBuffer) {
        if (persistenceBuffer.isTransmitted()) {
            return;
        }
        int seqNum = this._tunnelSubstream._lastOutSeqNum + 1;
        this._fileByteBuf.putInt(persistenceBuffer.filePosition() + 8, seqNum);
        persistenceBuffer.isTransmitted(true);
        persistenceBuffer.seqNum(seqNum);
        this.persistenceBufferListMove(this._waitingTransmitList, 40, this._waitingQueueAckList, 44, persistenceBuffer);
        this.lastOutSeqNum(seqNum);
    }

    @Override
    int retransmitBuffers(int seqNum, Msg tmpMsg, EncodeIterator tmpEncodeIter, DecodeIterator tmpDecodeIter, Error error) {
        int ret;
        long currentTime = System.nanoTime();
        TunnelStreamPersistenceBuffer persistBuffer = this._waitingQueueAckList.start(TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
        while (persistBuffer != null) {
            ret = this.retransmitBuffer(persistBuffer, seqNum, currentTime, tmpMsg, tmpEncodeIter, tmpDecodeIter, error);
            if (ret != 0) {
                return ret;
            }
            persistBuffer = this._waitingQueueAckList.forth(TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
        }
        persistBuffer = this._waitingTransmitList.start(TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
        while (persistBuffer != null) {
            ret = this.retransmitBuffer(persistBuffer, seqNum, currentTime, tmpMsg, tmpEncodeIter, tmpDecodeIter, error);
            if (ret != 0) {
                return ret;
            }
            persistBuffer = this._waitingTransmitList.forth(TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
        }
        return 0;
    }

    private void persistenceBufferListMove(VaDoubleLinkList<TunnelStreamPersistenceBuffer> oldList, int oldListHeadPosition, VaDoubleLinkList<TunnelStreamPersistenceBuffer> newList, int newListHeadPosition, TunnelStreamPersistenceBuffer persistBuffer) {
        super.peristenceBufferListMove(oldList, oldListHeadPosition, newList, newListHeadPosition, 0, persistBuffer);
        this._fileByteBuf.putInt(20, this._waitingTransmitList.count() + this._waitingQueueAckList.count());
        this._fileByteBuf.force();
    }

    @Override
    void clear(Error tmpError) {
        super.clear(tmpError);
        while (this._waitingTransmitList.pop(TunnelStreamPersistenceBuffer.SUBSTREAM_LINK) != null) {
        }
        while (this._waitingQueueAckList.pop(TunnelStreamPersistenceBuffer.SUBSTREAM_LINK) != null) {
        }
        this._maxMsgs = 0;
        this._tmpBuf.clear();
    }

    @Override
    int persistBufferMsgOffset() {
        return 30;
    }

    @Override
    long persistBufferTimeoutNsec(TunnelStreamPersistenceBuffer persistBuffer) {
        return this._fileByteBuf.getLong(persistBuffer.filePosition() + 22);
    }

    private class MsgHeader {
        private static final int LENGTH = 30;
        static final int NEXT_MSG_POS = 0;
        static final int MSG_LENGTH_POS = 4;
        static final int MSG_SEQNUM_POS = 8;
        static final int MSG_OPCODE_POS = 12;
        static final int TIME_QUEUED_POS = 14;
        static final int TIME_TO_LIVE_POS = 22;
        static final int MSG_BUFFER_POS = 30;

        private MsgHeader() {
        }
    }

    private class Header {
        private static final int LENGTH = 76;
        private static final int FILE_VERSION_POS = 0;
        private static final int MAX_MSGS_POS = 4;
        private static final int MAX_MSG_LENGTH_POS = 12;
        private static final int CURRENT_MSG_COUNT_POS = 20;
        private static final int LAST_OUT_SEQ_NUM_POS = 28;
        private static final int LAST_IN_SEQ_NUM_POS = 32;
        private static final int POOL_HEAD_POS = 36;
        private static final int WAIT_TRANSMIT_HEAD_POS = 40;
        private static final int WAITACK_LIST_HEAD_POS = 44;
        private static final int MAX_MSGS = 1024;

        private Header() {
        }
    }
}

