/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.transport.Error;
import com.refinitiv.eta.valueadd.common.VaDoubleLinkList;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsg;
import com.refinitiv.eta.valueadd.reactor.Reactor;
import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorFactory;
import com.refinitiv.eta.valueadd.reactor.TunnelStream;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamAcceptOptions;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamOpenOptions;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamRequestEvent;
import java.nio.ByteBuffer;

class TunnelStreamManager {
    long _nextDispatchTime;
    VaDoubleLinkList<TunnelStream> _tunnelStreamList;
    VaDoubleLinkList<TunnelStream> _tunnelStreamDispatchList;
    VaDoubleLinkList<TunnelStream> _tunnelStreamTimeoutList;
    Buffer _tunnelStreamTempBuffer = CodecFactory.createBuffer();
    ByteBuffer _tunnelStreamTempByteBuffer = ByteBuffer.allocateDirect(8192);
    ReactorErrorInfo _errorInfo = ReactorFactory.createReactorErrorInfo();
    private State _tmpState = CodecFactory.createState();
    ReactorChannel _reactorChannel;
    boolean _needsFlush;

    TunnelStreamManager() {
        this._tunnelStreamList = new VaDoubleLinkList();
        this._tunnelStreamDispatchList = new VaDoubleLinkList();
        this._tunnelStreamTimeoutList = new VaDoubleLinkList();
    }

    void clear() {
        this._nextDispatchTime = 0L;
        this._tunnelStreamList.clear();
        this._tunnelStreamDispatchList.clear();
        this._tunnelStreamTimeoutList.clear();
    }

    int dispatch(Error error) {
        int ret = 0;
        long nextMsgTimeoutNsec = 0L;
        TunnelStream tunnelStream = this._tunnelStreamDispatchList.start(TunnelStream.DISPATCH_LINK);
        while (tunnelStream != null) {
            ret = tunnelStream.dispatch(error);
            if (ret != 0) {
                if (ret == -1) {
                    tunnelStream.sendCloseMsg(error);
                    ret = 0;
                }
                this.sendTunnelStreamStatusCloseRecover(tunnelStream, error);
                break;
            }
            tunnelStream = this._tunnelStreamDispatchList.forth(TunnelStream.DISPATCH_LINK);
        }
        switch (ret) {
            case 0: {
                break;
            }
            case -3: {
                ret = 0;
                break;
            }
            default: {
                return ret;
            }
        }
        tunnelStream = this._tunnelStreamTimeoutList.start(TunnelStream.TIMEOUT_LINK);
        if (tunnelStream != null) {
            long currentTimeNsec = System.nanoTime();
            while (tunnelStream != null) {
                assert (tunnelStream.hasNextTimeout());
                ret = tunnelStream.handleTimer(currentTimeNsec, error);
                if (ret == 0 && tunnelStream.hasNextTimeout() && tunnelStream.nextTimeoutNsec() - nextMsgTimeoutNsec < 0L) {
                    this._nextDispatchTime = tunnelStream.nextTimeoutNsec();
                }
                tunnelStream = this._tunnelStreamTimeoutList.forth(TunnelStream.TIMEOUT_LINK);
            }
        }
        return ret == 0 ? this._tunnelStreamDispatchList.count() : ret;
    }

    int readMsg(TunnelStream tunnelStream, Msg deliveredMsg, Error error) {
        int ret = tunnelStream.readMsg(deliveredMsg, error);
        if (ret == -1) {
            tunnelStream.sendCloseMsg(error);
            this.sendTunnelStreamStatusCloseRecover(tunnelStream, error);
            ret = 0;
        }
        return ret;
    }

    boolean hasNextDispatchTime() {
        return this._tunnelStreamTimeoutList.count() > 0;
    }

    long nextDispatchTime() {
        return this._nextDispatchTime;
    }

    void addTunnelStreamToDispatchList(TunnelStream tunnelStream) {
        if (!tunnelStream.notifying()) {
            this._tunnelStreamDispatchList.push(tunnelStream, TunnelStream.DISPATCH_LINK);
            tunnelStream.notifying(true);
        }
    }

    void removeTunnelStreamFromDispatchList(TunnelStream tunnelStream) {
        if (tunnelStream.notifying()) {
            this._tunnelStreamDispatchList.remove(tunnelStream, TunnelStream.DISPATCH_LINK);
            tunnelStream.notifying(false);
        }
    }

    void addTunnelStreamToTimeoutList(TunnelStream tunnelStream, long nextDispatchTime) {
        boolean hasNextDispatchTime;
        boolean bl = hasNextDispatchTime = this._tunnelStreamTimeoutList.count() > 0;
        if (!tunnelStream.hasNextTimeout()) {
            tunnelStream.hasNextTimeout(true);
            this._tunnelStreamTimeoutList.push(tunnelStream, TunnelStream.TIMEOUT_LINK);
        }
        if (!hasNextDispatchTime || tunnelStream.nextTimeoutNsec() < this._nextDispatchTime) {
            this._nextDispatchTime = tunnelStream.nextTimeoutNsec();
        }
    }

    void removeTunnelStreamFromTimeoutList(TunnelStream tunnelStream) {
        if (tunnelStream.hasNextTimeout()) {
            tunnelStream.hasNextTimeout(false);
            this._tunnelStreamTimeoutList.remove(tunnelStream, TunnelStream.TIMEOUT_LINK);
        }
    }

    int setChannel(ReactorChannel reactorChannel, Error error) {
        this._reactorChannel = reactorChannel;
        TunnelStream tunnelStream = this._tunnelStreamList.start(TunnelStream.MANAGER_LINK);
        while (tunnelStream != null) {
            this.addTunnelStreamToDispatchList(tunnelStream);
            tunnelStream = this._tunnelStreamList.forth(TunnelStream.MANAGER_LINK);
        }
        return 0;
    }

    TunnelStream createTunnelStream(TunnelStreamOpenOptions options) {
        TunnelStream tunnelStream = new TunnelStream(this._reactorChannel, options);
        this._tunnelStreamList.push(tunnelStream, TunnelStream.MANAGER_LINK);
        return tunnelStream;
    }

    TunnelStream createTunnelStream(TunnelStreamRequestEvent event, TunnelStreamAcceptOptions options) {
        TunnelStream tunnelStream = new TunnelStream(this._reactorChannel, event, options);
        this._tunnelStreamList.push(tunnelStream, TunnelStream.MANAGER_LINK);
        return tunnelStream;
    }

    void removeTunnelStream(TunnelStream tunnelStream) {
        this._tunnelStreamList.remove(tunnelStream, TunnelStream.MANAGER_LINK);
        this.removeTunnelStreamFromDispatchList(tunnelStream);
        this.removeTunnelStreamFromTimeoutList(tunnelStream);
        tunnelStream.streamClosed(this._errorInfo.error());
    }

    boolean needsFlush() {
        boolean needsFlush = this._needsFlush;
        this._needsFlush = false;
        return needsFlush;
    }

    boolean needsDispatchNow() {
        return this._tunnelStreamDispatchList.count() > 0;
    }

    ReactorChannel reactorChannel() {
        return this._reactorChannel;
    }

    void setNeedsFlush() {
        this._needsFlush = true;
    }

    void close() {
        TunnelStream tunnelStream = this._tunnelStreamList.start(TunnelStream.MANAGER_LINK);
        while (tunnelStream != null) {
            this.removeTunnelStream(tunnelStream);
            tunnelStream = this._tunnelStreamList.forth(TunnelStream.MANAGER_LINK);
        }
    }

    void sendTunnelStreamStatusCloseRecover(TunnelStream tunnelStream, Error error) {
        this._tmpState.clear();
        this._tmpState.streamState(3);
        this._tmpState.dataState(2);
        this._tmpState.text().data(error.text());
        Reactor reactor = tunnelStream.reactorChannel().reactor();
        reactor.sendTunnelStreamStatusEventCallback(tunnelStream.reactorChannel(), tunnelStream, null, null, this._tmpState, null, this._errorInfo);
    }

    void sendTunnelStreamStatusClose(TunnelStream tunnelStream, Error error) {
        this._tmpState.clear();
        this._tmpState.streamState(4);
        this._tmpState.dataState(2);
        this._tmpState.text().data(error.text());
        TunnelStream reactorTunnelStream = tunnelStream;
        Reactor reactor = reactorTunnelStream.reactorChannel().reactor();
        reactor.sendTunnelStreamStatusEventCallback(reactorTunnelStream.reactorChannel(), reactorTunnelStream, null, null, this._tmpState, null, this._errorInfo);
    }

    void sendTunnelStreamStatusPendingClose(TunnelStream tunnelStream, Error error) {
        this._tmpState.clear();
        this._tmpState.streamState(1);
        this._tmpState.dataState(2);
        this._tmpState.text().data(error.text());
        Reactor reactor = tunnelStream.reactorChannel().reactor();
        reactor.sendTunnelStreamStatusEventCallback(tunnelStream.reactorChannel(), tunnelStream, null, null, this._tmpState, null, this._errorInfo);
    }

    void sendTunnelStreamStatus(TunnelStream tunnelStream, State state, Msg msg, LoginMsg loginMsg) {
        this._tmpState.clear();
        state.copy(this._tmpState);
        if (state != null) {
            state.copy(tunnelStream.state());
        }
        Reactor reactor = tunnelStream.reactorChannel().reactor();
        reactor.sendTunnelStreamStatusEventCallback(tunnelStream.reactorChannel(), tunnelStream, null, msg, this._tmpState, loginMsg, this._errorInfo);
    }
}

