/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.transport.TransportBuffer;
import com.refinitiv.eta.valueadd.common.VaDoubleLinkList;
import com.refinitiv.eta.valueadd.reactor.SlicedBufferPool;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamPersistenceBuffer;
import com.refinitiv.eta.valueadd.reactor.TunnelSubstream;
import java.nio.ByteBuffer;

class TunnelStreamBuffer
implements TransportBuffer {
    boolean _isBigBuffer;
    protected ByteBuffer _data;
    protected int _startPos;
    protected int _encodedPosition;
    private int _innerCapacity;
    private int _seqNum;
    int _containerType;
    SlicedBufferPool.SliceableBuffer _parentBuffer;
    SlicedBufferPool.DuplicateBuffer _duplicateBuffer;
    boolean _isUserBuffer;
    boolean _isForLocalAck;
    private int _tunnelStreamHeaderLen;
    TunnelStreamPersistenceBuffer _persistenceBuffer;
    TunnelSubstream _tunnelSubstream;
    Mode _mode;
    static final int MAX_SUBSTREAM_HEADER_LENGTH = 512;
    private long _timeQueued;
    private long _timeout;
    private boolean _timeoutIsCode;
    private boolean _isApplicationBuffer;
    private boolean _isRetransmit;
    private boolean _isWaitingAck;
    private boolean _isQueueData;
    private boolean _isQueueClose;
    private boolean _isTransmitted;
    private TunnelStreamBuffer _retransNext;
    private TunnelStreamBuffer _retransPrev;
    static final BufferRetransmitLink RETRANS_LINK = new BufferRetransmitLink();
    private TunnelStreamBuffer _timeoutNext;
    private TunnelStreamBuffer _timeoutPrev;
    static final TimeoutLink TIMEOUT_LINK = new TimeoutLink();

    TunnelStreamBuffer() {
    }

    TunnelStreamPersistenceBuffer persistenceBuffer() {
        return this._persistenceBuffer;
    }

    TunnelSubstream tunnelSubstream() {
        return this._tunnelSubstream;
    }

    void persistenceBuffer(TunnelSubstream tunnelSubstream, TunnelStreamPersistenceBuffer persistenceBuffer) {
        this._tunnelSubstream = tunnelSubstream;
        this._persistenceBuffer = persistenceBuffer;
    }

    int seqNum() {
        return this._seqNum;
    }

    void seqNum(int seqNum) {
        this._seqNum = seqNum;
    }

    public ByteBuffer data() {
        return this._data;
    }

    void data(ByteBuffer buffer) {
        this._data = buffer;
    }

    void data(ByteBuffer buffer, int position, int length) {
        this._data = buffer;
        this._startPos = position;
        this._data.position(position);
        this._data.limit(position + length);
    }

    void setToFullWritebuffer() {
        this._data.limit(this._startPos + this._tunnelStreamHeaderLen + this._innerCapacity);
        this._data.position(this._encodedPosition);
        this._mode = Mode.FULL_WRITE_BUFFER;
    }

    void setToInnerWriteBuffer() {
        this._data.limit(this._startPos + this._tunnelStreamHeaderLen + this._innerCapacity);
        this._data.position(this._encodedPosition);
        this._mode = Mode.INNER_WRITE_BUFFER;
    }

    int innerWriteBufferLength() {
        return this._encodedPosition - (this._startPos + this._tunnelStreamHeaderLen);
    }

    void setAsFullReadBuffer() {
        this._mode = Mode.FULL_READ_BUFFER;
        this._data.limit(this._encodedPosition);
        this._data.position(this._startPos);
    }

    void setAsInnerReadBuffer() {
        this._mode = Mode.INNER_READ_BUFFER;
        this._data.limit(this._encodedPosition);
        this._data.position(this._startPos + this._tunnelStreamHeaderLen);
    }

    void setCurrentPositionAsEndOfEncoding() {
        this._encodedPosition = this._data.position();
    }

    public int capacity() {
        switch (this._mode) {
            case INNER_WRITE_BUFFER: {
                return this._innerCapacity;
            }
            case INNER_READ_BUFFER: {
                return this._encodedPosition - (this._startPos + this._tunnelStreamHeaderLen);
            }
            case FULL_READ_BUFFER: {
                return this._encodedPosition - this._startPos;
            }
        }
        return this._innerCapacity + this._tunnelStreamHeaderLen;
    }

    public int copy(ByteBuffer destBuffer) {
        int length = this.length();
        int startPos = this._startPos + this._tunnelStreamHeaderLen;
        if (destBuffer == null) {
            return -6;
        }
        if (destBuffer.limit() - destBuffer.position() < length) {
            return -6;
        }
        int tmpPos = this._data.position();
        int tmpLimit = this._data.limit();
        this._data.position(startPos);
        this._data.limit(startPos + length);
        int tmpDestPos = destBuffer.position();
        destBuffer.put(this._data);
        destBuffer.position(tmpDestPos);
        this._data.limit(tmpLimit);
        this._data.position(tmpPos);
        return 0;
    }

    void containerType(int containerType) {
        this._containerType = containerType;
    }

    public int dataStartPosition() {
        switch (this._mode) {
            case INNER_WRITE_BUFFER: 
            case INNER_READ_BUFFER: {
                return this._startPos + this._tunnelStreamHeaderLen;
            }
        }
        return this._startPos;
    }

    int tunnelBufferStartPosition() {
        return this._startPos;
    }

    boolean isForLocalAck() {
        return this._isForLocalAck;
    }

    void isForLocalAck(boolean isForLocalAck) {
        this._isForLocalAck = isForLocalAck;
    }

    int tunnelStreamHeaderLen() {
        return this._tunnelStreamHeaderLen;
    }

    void tunnelStreamHeaderLen(int length) {
        this._tunnelStreamHeaderLen = length;
    }

    public int length() {
        if (this.data() == null) {
            return 0;
        }
        switch (this._mode) {
            case INNER_WRITE_BUFFER: {
                if (this.data().position() > this._startPos + this._tunnelStreamHeaderLen) {
                    return this.data().position() - (this._startPos + this._tunnelStreamHeaderLen);
                }
                return this._innerCapacity;
            }
            case INNER_READ_BUFFER: {
                return this.data().limit() - (this._startPos + this._tunnelStreamHeaderLen);
            }
            case FULL_READ_BUFFER: {
                return this.data().limit() - this._startPos;
            }
        }
        if (this.data().position() > this._startPos) {
            return this.data().position() - this._startPos;
        }
        return this._innerCapacity + this._tunnelStreamHeaderLen;
    }

    void clear(int length) {
        this._innerCapacity = length;
        this._data = null;
        this._tunnelStreamHeaderLen = 0;
        this._encodedPosition = 0;
        this._mode = Mode.FULL_WRITE_BUFFER;
        this._timeout = 0L;
        this._timeoutIsCode = false;
        this._isTransmitted = false;
        this._isApplicationBuffer = true;
        this._isRetransmit = false;
        this._isWaitingAck = false;
        this._isQueueData = false;
        this._isForLocalAck = false;
        this._persistenceBuffer = null;
        this._tunnelSubstream = null;
    }

    long timeQueuedNsec() {
        return this._timeQueued;
    }

    void timeQueuedNsec(long timeQueued) {
        this._timeQueued = timeQueued;
    }

    long timeoutNsec() {
        return this._timeout;
    }

    void timeoutNsec(long timeout) {
        this._timeout = timeout;
    }

    boolean timeoutIsCode() {
        return this._timeoutIsCode;
    }

    void timeoutIsCode(boolean timeoutIsCode) {
        this._timeoutIsCode = timeoutIsCode;
    }

    boolean isTransmitted() {
        return this._isTransmitted;
    }

    void isTransmitted(boolean isTransmitted) {
        this._isTransmitted = isTransmitted;
    }

    boolean isRetransmit() {
        return this._isRetransmit;
    }

    void isRetransmit(boolean isRetransmit) {
        this._isRetransmit = isRetransmit;
    }

    boolean isWaitingAck() {
        return this._isWaitingAck;
    }

    void isWaitingAck(boolean isWaitingAck) {
        this._isWaitingAck = isWaitingAck;
    }

    void isApplicationBuffer(boolean isApplicationBuffer) {
        this._isApplicationBuffer = isApplicationBuffer;
    }

    boolean isApplicationBuffer() {
        return this._isApplicationBuffer;
    }

    void isQueueData(boolean isQueueData) {
        this._isQueueData = isQueueData;
    }

    boolean isQueueData() {
        return this._isQueueData;
    }

    void isQueueClose(boolean isQueueClose) {
        this._isQueueClose = isQueueClose;
    }

    boolean isQueueClose() {
        return this._isQueueClose;
    }

    void copyFullBuffer(ByteBuffer destBuffer) {
        int tmpPos = this.data().position();
        int tmpLimit = this.data().limit();
        this.data().position(this._startPos);
        this.data().limit(this._encodedPosition);
        destBuffer.put(this.data());
        this.data().limit(tmpLimit);
        this.data().position(tmpPos);
    }

    boolean isBigBuffer() {
        return this._isBigBuffer;
    }

    static class TimeoutLink
    implements VaDoubleLinkList.Link<TunnelStreamBuffer> {
        TimeoutLink() {
        }

        @Override
        public TunnelStreamBuffer getPrev(TunnelStreamBuffer thisPrev) {
            return thisPrev._timeoutPrev;
        }

        @Override
        public void setPrev(TunnelStreamBuffer thisPrev, TunnelStreamBuffer thatPrev) {
            thisPrev._timeoutPrev = thatPrev;
        }

        @Override
        public TunnelStreamBuffer getNext(TunnelStreamBuffer thisNext) {
            return thisNext._timeoutNext;
        }

        @Override
        public void setNext(TunnelStreamBuffer thisNext, TunnelStreamBuffer thatNext) {
            thisNext._timeoutNext = thatNext;
        }
    }

    static class BufferRetransmitLink
    implements VaDoubleLinkList.Link<TunnelStreamBuffer> {
        BufferRetransmitLink() {
        }

        @Override
        public TunnelStreamBuffer getPrev(TunnelStreamBuffer thisPrev) {
            return thisPrev._retransPrev;
        }

        @Override
        public void setPrev(TunnelStreamBuffer thisPrev, TunnelStreamBuffer thatPrev) {
            thisPrev._retransPrev = thatPrev;
        }

        @Override
        public TunnelStreamBuffer getNext(TunnelStreamBuffer thisNext) {
            return thisNext._retransNext;
        }

        @Override
        public void setNext(TunnelStreamBuffer thisNext, TunnelStreamBuffer thatNext) {
            thisNext._retransNext = thatNext;
        }
    }

    private static enum Mode {
        INNER_WRITE_BUFFER,
        FULL_WRITE_BUFFER,
        FULL_READ_BUFFER,
        INNER_READ_BUFFER;

    }
}

