/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.valueadd.common.VaDoubleLinkList;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamBuffer;
import java.nio.ByteBuffer;

class TunnelStreamBigBuffer
extends TunnelStreamBuffer {
    private TunnelStreamBigBuffer _reactorChannelNext;
    private TunnelStreamBigBuffer _reactorChannelPrev;
    static final TunnelStreamBigBufferLink BIG_BUFFER_LINK = new TunnelStreamBigBufferLink();
    VaDoubleLinkList<TunnelStreamBigBuffer> _pool;
    int _size;
    boolean _inProgress;
    int _totalMsgLength;
    int _bytesRemainingToSend;
    int _bytesAlreadyCopied;
    int _lastFragmentId;
    int _messageId;
    int _containerType;

    TunnelStreamBigBuffer(VaDoubleLinkList<TunnelStreamBigBuffer> pool, int bufferSize, int userSize) {
        this._isBigBuffer = true;
        this._pool = pool;
        this._size = userSize;
        this._data = ByteBuffer.allocate(bufferSize);
        this._data.limit(userSize);
    }

    VaDoubleLinkList<TunnelStreamBigBuffer> pool() {
        return this._pool;
    }

    @Override
    public int length() {
        int length = this._encodedPosition > 0 ? this._encodedPosition : this._size;
        int position = this._data.position();
        if (position > 0) {
            length = position;
        }
        return length;
    }

    @Override
    public int capacity() {
        return this._size;
    }

    @Override
    public int dataStartPosition() {
        return this._startPos;
    }

    @Override
    void clear(int userSize) {
        this._size = userSize;
        this._data.clear();
        this._data.limit(userSize);
        this._inProgress = false;
        this._totalMsgLength = 0;
        this._bytesRemainingToSend = 0;
        this._bytesAlreadyCopied = 0;
        this._lastFragmentId = 0;
        this._messageId = 0;
        this._containerType = 0;
    }

    void saveWriteProgress(int totalMsgLength, int bytesRemaining, int lastFragmentId, int messageId, int containerType) {
        this._inProgress = true;
        this._totalMsgLength = totalMsgLength;
        this._bytesRemainingToSend = bytesRemaining;
        this._lastFragmentId = lastFragmentId;
        this._messageId = messageId;
        this._containerType = containerType;
    }

    boolean fragmentationInProgress() {
        return this._inProgress;
    }

    int bytesRemainingToSend() {
        return this._bytesRemainingToSend;
    }

    int bytesAlreadyCopied() {
        return this._bytesAlreadyCopied;
    }

    int lastFragmentId() {
        return this._lastFragmentId;
    }

    int messageId() {
        return this._messageId;
    }

    int containerType() {
        return this._containerType;
    }

    static class TunnelStreamBigBufferLink
    implements VaDoubleLinkList.Link<TunnelStreamBigBuffer> {
        TunnelStreamBigBufferLink() {
        }

        @Override
        public TunnelStreamBigBuffer getPrev(TunnelStreamBigBuffer thisPrev) {
            return thisPrev._reactorChannelPrev;
        }

        @Override
        public void setPrev(TunnelStreamBigBuffer thisPrev, TunnelStreamBigBuffer thatPrev) {
            thisPrev._reactorChannelPrev = thatPrev;
        }

        @Override
        public TunnelStreamBigBuffer getNext(TunnelStreamBigBuffer thisNext) {
            return thisNext._reactorChannelNext;
        }

        @Override
        public void setNext(TunnelStreamBigBuffer thisNext, TunnelStreamBigBuffer thatNext) {
            thisNext._reactorChannelNext = thatNext;
        }
    }
}

