/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.valueadd.common.VaDoubleLinkList;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyEvent;

class ReactorWarmStandbyEventPool {
    final int NUM_POOLS = 32;
    VaDoubleLinkList<ReactorWarmStandbyEvent>[] _pools = new VaDoubleLinkList[32];
    int _maxPool;
    int _maxNumEvents;
    int _currentNumEvents;

    ReactorWarmStandbyEventPool(int numBuffers) {
        this._maxNumEvents = numBuffers;
    }

    ReactorWarmStandbyEvent getEvent(ReactorErrorInfo errorInfo) {
        ReactorWarmStandbyEvent event = null;
        if (this._currentNumEvents < this._maxNumEvents) {
            int poolIndex;
            ++this._currentNumEvents;
            for (int i = poolIndex = 0; i <= this._maxPool; ++i) {
                if (this._pools[i] == null || (event = this._pools[i].pop(ReactorWarmStandbyEvent.BIG_BUFFER_LINK)) == null) continue;
                event.clear();
                return event;
            }
            if (this._pools[poolIndex] == null) {
                VaDoubleLinkList pool = new VaDoubleLinkList();
                this._pools[poolIndex] = pool;
            }
            return new ReactorWarmStandbyEvent(this._pools[poolIndex]);
        }
        if (errorInfo != null) {
            errorInfo.clear();
            errorInfo.code(-1).location("ReactorWarmStandbyEventPool.getEvent");
            errorInfo.error().errorId(-1);
            errorInfo.error().text("Max number of event limit reached");
        }
        return event;
    }

    void releaseEvent(ReactorWarmStandbyEvent event) {
        --this._currentNumEvents;
        event.pool().pushBack(event, ReactorWarmStandbyEvent.BIG_BUFFER_LINK);
    }

    int getBuffersUsed() {
        return this._currentNumEvents;
    }
}

