/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.RefreshMsg;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.valueadd.domainrep.rdm.queue.QueueMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.queue.QueueRefresh;
import com.refinitiv.eta.valueadd.reactor.QueueMsgImpl;
import java.nio.ByteBuffer;

class QueueRefreshImpl
extends QueueMsgImpl
implements QueueRefresh {
    Msg _msg = CodecFactory.createMsg();
    RefreshMsg _refreshMsg = (RefreshMsg)CodecFactory.createMsg();
    DecodeIterator _decIter = CodecFactory.createDecodeIterator();
    Buffer _sourceName = CodecFactory.createBuffer();
    Buffer _destName = CodecFactory.createBuffer();
    Buffer _tmpBuffer = CodecFactory.createBuffer();
    int _queueDepth = 0;

    QueueRefreshImpl() {
    }

    @Override
    public QueueMsgType rdmMsgType() {
        return QueueMsgType.REFRESH;
    }

    @Override
    public int encode(EncodeIterator eIter) {
        int ret = 0;
        this._refreshMsg.clear();
        this._refreshMsg.msgClass(2);
        this._refreshMsg.streamId(this.streamId());
        this._refreshMsg.domainType(this.domainType());
        this._refreshMsg.containerType(128);
        this._refreshMsg.applyDoNotCache();
        this._refreshMsg.applyRefreshComplete();
        this._refreshMsg.applySolicited();
        this._refreshMsg.applyHasMsgKey();
        this._refreshMsg.applyHasExtendedHdr();
        this._refreshMsg.msgKey().applyHasName();
        this._refreshMsg.msgKey().name(this._sourceName);
        this._refreshMsg.state().dataState(1);
        this._refreshMsg.state().streamState(1);
        this._refreshMsg.state().code(0);
        ret = this._refreshMsg.encodeInit(eIter, 0);
        if (ret < 0) {
            return ret;
        }
        ret = eIter.encodeNonRWFInit(this._tmpBuffer);
        if (ret != 0) {
            return ret;
        }
        if (this._tmpBuffer.length() < 11) {
            return -21;
        }
        this._tmpBuffer.data().putInt(this._lastOutSeqNum);
        this._tmpBuffer.data().putInt(this._lastInSeqNum);
        this._tmpBuffer.data().putShort((short)this._queueDepth);
        ret = eIter.encodeNonRWFComplete(this._tmpBuffer, true);
        if (ret != 0) {
            return ret;
        }
        ret = this._refreshMsg.encodeExtendedHeaderComplete(eIter, true);
        if (ret < 0) {
            return ret;
        }
        ret = this._refreshMsg.encodeComplete(eIter, true);
        if (ret < 0) {
            return ret;
        }
        return ret;
    }

    @Override
    public int decode(DecodeIterator dIter, Msg msg) {
        this._opCode = -1;
        this.streamId(msg.streamId());
        this.domainType(msg.domainType());
        RefreshMsg refreshMsg = (RefreshMsg)msg;
        if (!refreshMsg.checkHasExtendedHdr() || refreshMsg.extendedHeader().length() < 8) {
            this._lastInSeqNum = 0;
            this._lastOutSeqNum = 0;
            this._queueDepth = 0;
        } else {
            ByteBuffer extHdrByteBuf = refreshMsg.extendedHeader().data();
            int startPos = refreshMsg.extendedHeader().position();
            this._lastOutSeqNum = extHdrByteBuf.getInt(startPos);
            this._lastInSeqNum = extHdrByteBuf.getInt(startPos + 4);
            this._queueDepth = refreshMsg.extendedHeader().length() == 10 ? (int)extHdrByteBuf.getShort(startPos + 8) : 0;
        }
        this._sourceName.data(refreshMsg.msgKey().name().toString());
        refreshMsg.state().copy(this._state);
        return 0;
    }

    @Override
    public State state() {
        return this._state;
    }

    void queueDepth(int queueDepth) {
        this._queueDepth = queueDepth;
    }

    @Override
    public int queueDepth() {
        return this._queueDepth;
    }

    @Override
    public Buffer sourceName() {
        return this._sourceName;
    }

    void sourceName(Buffer sourceName) {
        this._sourceName.data(sourceName.data(), sourceName.position(), sourceName.length());
    }

    @Override
    public void clear() {
        this._opCode = -1;
        this._queueDepth = 0;
    }
}

