/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.Qos;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryClose;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryRequest;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryClose;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryRefresh;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.Service;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginClose;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginRequest;
import com.refinitiv.eta.valueadd.reactor.RDMDictionaryMsgCallback;
import com.refinitiv.eta.valueadd.reactor.RDMLoginMsgCallback;
import com.refinitiv.eta.valueadd.reactor.ReactorRole;

public class NIProviderRole
extends ReactorRole {
    static final int LOGIN_STREAM_ID = 1;
    static final int DIRECTORY_STREAM_ID = -1;
    static final int FIELD_DICTIONARY_STREAM_ID = -2;
    static final int ENUM_DICTIONARY_STREAM_ID = -3;
    static final int OPEN_LIMIT = 5;
    static final String VENDOR = "LSEG";
    static final String LINK_NAME = "NI_PUB";
    static final String FIELD_DICTIONARY_NAME = "RWFFld";
    static final String ENUM_TYPE_DICTIONARY_NAME = "RWFEnum";
    static final long FILTER_TO_REFRESH = 43L;
    LoginRequest _loginRequest = null;
    LoginClose _loginClose = null;
    DirectoryRefresh _directoryRefresh = null;
    DirectoryClose _directoryClose = null;
    RDMLoginMsgCallback _loginMsgCallback = null;
    Buffer _stateText = CodecFactory.createBuffer();
    RDMDictionaryMsgCallback _dictionaryMsgCallback = null;
    DictionaryRequest _fieldDictionaryRequest = null;
    DictionaryClose _fieldDictionaryClose = null;
    DictionaryRequest _enumDictionaryRequest = null;
    DictionaryClose _enumDictionaryClose = null;
    int _dictionaryDownloadMode = 0;
    final Buffer _fieldDictionaryName = CodecFactory.createBuffer();
    final Buffer _enumTypeDictionaryName = CodecFactory.createBuffer();
    boolean _receivedFieldDictionaryResp = false;
    boolean _receivedEnumDictionaryResp = false;
    private Service _service = DirectoryMsgFactory.createService();

    public NIProviderRole() {
        this._type = 3;
        this._stateText.data("Source Directory Refresh Completed");
        this._fieldDictionaryName.data(FIELD_DICTIONARY_NAME);
        this._enumTypeDictionaryName.data(ENUM_TYPE_DICTIONARY_NAME);
    }

    public void rdmLoginRequest(LoginRequest loginRequest) {
        this.copyLoginRequest(loginRequest);
    }

    public LoginRequest rdmLoginRequest() {
        return this._loginRequest;
    }

    public void initDefaultRDMLoginRequest() {
        int streamId;
        String userName = "";
        if (this._loginRequest == null) {
            streamId = 1;
            this._loginRequest = (LoginRequest)LoginMsgFactory.createMsg();
        } else {
            streamId = this._loginRequest.streamId() == 0 ? 1 : this._loginRequest.streamId();
            userName = this._loginRequest.userName().toString();
            this._loginRequest.clear();
        }
        this._loginRequest.rdmMsgType(LoginMsgType.REQUEST);
        this._loginRequest.initDefaultRequest(streamId);
        this._loginRequest.applyHasAttrib();
        if (!userName.equals("")) {
            this._loginRequest.userName().data(userName);
        }
        this._loginRequest.applyHasRole();
        this._loginRequest.role(1L);
    }

    LoginClose rdmLoginClose() {
        if (this._loginRequest == null) {
            return null;
        }
        if (this._loginClose == null) {
            this._loginClose = (LoginClose)LoginMsgFactory.createMsg();
            this._loginClose.rdmMsgType(LoginMsgType.CLOSE);
        }
        this._loginClose.streamId(this._loginRequest.streamId());
        return this._loginClose;
    }

    public void rdmDirectoryRefresh(DirectoryRefresh directoryRefresh) {
        this.copyDirectoryRefresh(directoryRefresh);
    }

    public DirectoryRefresh rdmDirectoryRefresh() {
        return this._directoryRefresh;
    }

    public void initDefaultRDMDirectoryRefresh(String serviceName, int serviceId) {
        int streamId;
        if (this._directoryRefresh == null) {
            streamId = -1;
            this._directoryRefresh = (DirectoryRefresh)DirectoryMsgFactory.createMsg();
        } else {
            streamId = this._directoryRefresh.streamId() == 0 ? -1 : this._directoryRefresh.streamId();
            this._directoryRefresh.clear();
        }
        this._directoryRefresh.rdmMsgType(DirectoryMsgType.REFRESH);
        this._directoryRefresh.streamId(streamId);
        this._directoryRefresh.state().streamState(1);
        this._directoryRefresh.state().dataState(1);
        this._directoryRefresh.state().code(0);
        this._directoryRefresh.state().text(this._stateText);
        this._directoryRefresh.applyClearCache();
        this._directoryRefresh.filter(43L);
        this._service.clear();
        this._service.action(2);
        this._service.serviceId(serviceId);
        this._service.applyHasInfo();
        this._service.info().action(2);
        this._service.info().applyHasVendor();
        this._service.info().vendor().data(VENDOR);
        this._service.info().serviceName().data(serviceName);
        this._service.info().applyHasSupportsQosRange();
        this._service.info().supportsQosRange(0L);
        this._service.info().capabilitiesList().add(6L);
        this._service.info().capabilitiesList().add(7L);
        this._service.info().applyHasQos();
        Qos qos = CodecFactory.createQos();
        qos.rate(1);
        qos.timeliness(1);
        this._service.info().qosList().add(qos);
        this._service.info().applyHasDictionariesUsed();
        this._service.info().dictionariesUsedList().add(FIELD_DICTIONARY_NAME);
        this._service.info().dictionariesUsedList().add(ENUM_TYPE_DICTIONARY_NAME);
        this._service.info().applyHasIsSource();
        this._service.info().isSource(1L);
        this._service.info().applyHasItemList();
        this._service.info().itemList().data("");
        this._service.info().applyHasAcceptingConsumerStatus();
        this._service.info().acceptingConsumerStatus(0L);
        this._service.info().applyHasSupportsOutOfBandSnapshots();
        this._service.info().supportsOutOfBandSnapshots(0L);
        this._service.applyHasState();
        this._service.state().action(2);
        this._service.state().serviceState(1L);
        this._service.state().applyHasAcceptingRequests();
        this._service.state().acceptingRequests(1L);
        this._service.state().applyHasStatus();
        this._service.state().status().dataState(1);
        this._service.state().status().streamState(1);
        this._service.state().status().code(0);
        this._service.state().status().text().data("OK");
        this._service.applyHasLoad();
        this._service.load().action(2);
        this._service.load().applyHasOpenLimit();
        this._service.load().openLimit(5L);
        this._service.load().applyHasLoadFactor();
        this._service.load().loadFactor(1L);
        this._service.applyHasLink();
        this._service.link().action(2);
        Service.ServiceLink serviceLink = new Service.ServiceLink();
        serviceLink.name().data(LINK_NAME);
        serviceLink.applyHasType();
        serviceLink.type(1L);
        serviceLink.linkState(1L);
        serviceLink.applyHasCode();
        serviceLink.linkCode(1L);
        serviceLink.applyHasText();
        serviceLink.text().data("Link state is up");
        this._service.link().linkList().add(serviceLink);
        this._directoryRefresh.serviceList().add(this._service);
    }

    DirectoryClose rdmDirectoryClose() {
        if (this._directoryRefresh == null) {
            return null;
        }
        if (this._directoryClose == null) {
            this._directoryClose = (DirectoryClose)DirectoryMsgFactory.createMsg();
            this._directoryClose.rdmMsgType(DirectoryMsgType.CLOSE);
        }
        this._directoryClose.streamId(this._directoryRefresh.streamId());
        return this._directoryClose;
    }

    void rdmFieldDictionaryRequest(DictionaryRequest fieldDictionaryRequest) {
        this._fieldDictionaryRequest = fieldDictionaryRequest;
    }

    DictionaryRequest rdmFieldDictionaryRequest() {
        return this._fieldDictionaryRequest;
    }

    void initDefaultRDMFieldDictionaryRequest() {
        int streamId;
        if (this._fieldDictionaryRequest == null) {
            streamId = -2;
            this._fieldDictionaryRequest = (DictionaryRequest)DictionaryMsgFactory.createMsg();
        } else {
            streamId = this._fieldDictionaryRequest.streamId() == 0 ? -2 : this._fieldDictionaryRequest.streamId();
            this._fieldDictionaryRequest.clear();
        }
        while (streamId == this._loginRequest.streamId() || streamId == this._directoryRefresh.streamId()) {
            --streamId;
        }
        this._fieldDictionaryRequest.rdmMsgType(DictionaryMsgType.REQUEST);
        this._fieldDictionaryRequest.streamId(streamId);
        this._fieldDictionaryRequest.applyStreaming();
        this._fieldDictionaryRequest.verbosity(7);
        this._fieldDictionaryRequest.dictionaryName(this._fieldDictionaryName);
    }

    DictionaryClose rdmFieldDictionaryClose() {
        if (this._fieldDictionaryRequest == null) {
            return null;
        }
        if (this._fieldDictionaryClose == null) {
            this._fieldDictionaryClose = (DictionaryClose)DictionaryMsgFactory.createMsg();
            this._fieldDictionaryClose.rdmMsgType(DictionaryMsgType.CLOSE);
        }
        this._fieldDictionaryClose.streamId(this._fieldDictionaryRequest.streamId());
        return this._fieldDictionaryClose;
    }

    void rdmEnumDictionaryRequest(DictionaryRequest enumDictionaryRequest) {
        this._enumDictionaryRequest = enumDictionaryRequest;
    }

    DictionaryRequest rdmEnumDictionaryRequest() {
        return this._enumDictionaryRequest;
    }

    void initDefaultRDMEnumDictionaryRequest() {
        int streamId;
        if (this._enumDictionaryRequest == null) {
            streamId = -3;
            this._enumDictionaryRequest = (DictionaryRequest)DictionaryMsgFactory.createMsg();
        } else {
            streamId = this._enumDictionaryRequest.streamId() == 0 ? -3 : this._enumDictionaryRequest.streamId();
            this._enumDictionaryRequest.clear();
        }
        while (streamId == this._loginRequest.streamId() || streamId == this._directoryRefresh.streamId() || streamId == this._fieldDictionaryRequest.streamId()) {
            --streamId;
        }
        this._enumDictionaryRequest.rdmMsgType(DictionaryMsgType.REQUEST);
        this._enumDictionaryRequest.streamId(streamId);
        this._enumDictionaryRequest.applyStreaming();
        this._enumDictionaryRequest.verbosity(7);
        this._enumDictionaryRequest.dictionaryName(this._enumTypeDictionaryName);
    }

    DictionaryClose rdmEnumDictionaryClose() {
        if (this._enumDictionaryRequest == null) {
            return null;
        }
        if (this._enumDictionaryClose == null) {
            this._enumDictionaryClose = (DictionaryClose)DictionaryMsgFactory.createMsg();
            this._enumDictionaryClose.rdmMsgType(DictionaryMsgType.CLOSE);
        }
        this._enumDictionaryClose.streamId(this._enumDictionaryRequest.streamId());
        return this._enumDictionaryClose;
    }

    public void loginMsgCallback(RDMLoginMsgCallback callback) {
        this._loginMsgCallback = callback;
    }

    public RDMLoginMsgCallback loginMsgCallback() {
        return this._loginMsgCallback;
    }

    public void dictionaryMsgCallback(RDMDictionaryMsgCallback dictionaryMsgCallback) {
        this._dictionaryMsgCallback = dictionaryMsgCallback;
    }

    public RDMDictionaryMsgCallback dictionaryMsgCallback() {
        return this._dictionaryMsgCallback;
    }

    public int dictionaryDownloadMode() {
        return this._dictionaryDownloadMode;
    }

    public void dictionaryDownloadMode(int dictionaryDownloadMode) {
        this._dictionaryDownloadMode = dictionaryDownloadMode;
    }

    public Buffer fieldDictionaryName() {
        return this._fieldDictionaryName;
    }

    public Buffer enumTypeDictionaryName() {
        return this._enumTypeDictionaryName;
    }

    public boolean receivedFieldDictionaryResp() {
        return this._receivedFieldDictionaryResp;
    }

    public void receivedFieldDictionaryResp(boolean receivedFieldDictionaryResp) {
        this._receivedFieldDictionaryResp = receivedFieldDictionaryResp;
    }

    public boolean receivedEnumDictionaryResp() {
        return this._receivedEnumDictionaryResp;
    }

    public void receivedEnumDictionaryResp(boolean receivedEnumDictionaryResp) {
        this._receivedEnumDictionaryResp = receivedEnumDictionaryResp;
    }

    void copy(NIProviderRole role) {
        super.copy(role);
        this._loginMsgCallback = role.loginMsgCallback();
        this._dictionaryMsgCallback = role.dictionaryMsgCallback();
        this.copyLoginRequest(role.rdmLoginRequest());
        this.copyDirectoryRefresh(role.rdmDirectoryRefresh());
        this._dictionaryDownloadMode = role.dictionaryDownloadMode();
    }

    void copyLoginRequest(LoginRequest loginRequest) {
        if (loginRequest != null) {
            if (this._loginRequest == null) {
                this._loginRequest = (LoginRequest)LoginMsgFactory.createMsg();
                this._loginRequest.rdmMsgType(LoginMsgType.REQUEST);
            }
            loginRequest.copy(this._loginRequest);
        }
    }

    void copyDirectoryRefresh(DirectoryRefresh directoryRefresh) {
        if (directoryRefresh != null) {
            if (this._directoryRefresh == null) {
                this._directoryRefresh = (DirectoryRefresh)DirectoryMsgFactory.createMsg();
                this._directoryRefresh.rdmMsgType(DirectoryMsgType.REFRESH);
            }
            directoryRefresh.copy(this._directoryRefresh);
        }
    }
}

