/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.Codec;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.ElementEntry;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.FilterEntry;
import com.refinitiv.eta.codec.FilterList;
import com.refinitiv.eta.codec.Int;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.rdm.ClassesOfService;
import com.refinitiv.eta.transport.Error;
import com.refinitiv.eta.transport.TransportFactory;
import com.refinitiv.eta.valueadd.reactor.CosAuthentication;
import com.refinitiv.eta.valueadd.reactor.CosCommon;
import com.refinitiv.eta.valueadd.reactor.CosDataIntegrity;
import com.refinitiv.eta.valueadd.reactor.CosFlowControl;
import com.refinitiv.eta.valueadd.reactor.CosGuarantee;
import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import java.nio.ByteBuffer;

public class ClassOfService {
    private CosCommon _commonProperties = new CosCommon();
    private CosAuthentication _authentication = new CosAuthentication();
    private CosFlowControl _flowControl = new CosFlowControl();
    private CosDataIntegrity _dataIntegrity = new CosDataIntegrity();
    private CosGuarantee _guarantee = new CosGuarantee();
    private ElementList _elemList = CodecFactory.createElementList();
    private ElementEntry _elemEntry = CodecFactory.createElementEntry();
    private FilterList _filterList = CodecFactory.createFilterList();
    private FilterEntry _filterEntry = CodecFactory.createFilterEntry();
    private UInt _tempUInt = CodecFactory.createUInt();
    private Int _tempInt = CodecFactory.createInt();
    private DecodeIterator _dIter = CodecFactory.createDecodeIterator();
    private EncodeIterator _eIter = CodecFactory.createEncodeIterator();
    private Buffer _tempBuffer = CodecFactory.createBuffer();
    private Error _error = TransportFactory.createError();
    private Buffer _encodedCOSBuffer;
    private boolean _allCOSDecoded;
    private boolean _isServer;

    public ClassOfService() {
        this._tempBuffer.data(ByteBuffer.allocate(512));
    }

    public CosCommon common() {
        return this._commonProperties;
    }

    public CosAuthentication authentication() {
        if (!this._allCOSDecoded && this._encodedCOSBuffer != null) {
            this.decodeRemainder(this._error);
        }
        return this._authentication;
    }

    public CosFlowControl flowControl() {
        if (!this._allCOSDecoded && this._encodedCOSBuffer != null) {
            this.decodeRemainder(this._error);
        }
        return this._flowControl;
    }

    public CosDataIntegrity dataIntegrity() {
        if (!this._allCOSDecoded && this._encodedCOSBuffer != null) {
            this.decodeRemainder(this._error);
        }
        return this._dataIntegrity;
    }

    public CosGuarantee guarantee() {
        if (!this._allCOSDecoded && this._encodedCOSBuffer != null) {
            this.decodeRemainder(this._error);
        }
        return this._guarantee;
    }

    public int filterFlags() {
        int flags = 1;
        if (this._authentication.type() != 0) {
            flags |= 2;
        }
        if (this._flowControl.type() != 0) {
            flags |= 4;
        }
        if (this._dataIntegrity.type() != 0) {
            flags |= 8;
        }
        if (this._guarantee.type() != 0) {
            flags |= 0x10;
        }
        return flags;
    }

    int decode(ReactorChannel reactorChannel, Buffer encodedBuffer, ReactorErrorInfo errorInfo) {
        if (encodedBuffer == null || encodedBuffer.data() == null) {
            errorInfo.error().text("encodedBuffer cannot be null");
            return -1;
        }
        this._dIter.clear();
        this._dIter.setBufferAndRWFVersion(encodedBuffer, reactorChannel.majorVersion(), reactorChannel.minorVersion());
        int ret = this._filterList.decode(this._dIter);
        if (ret >= 0) {
            while ((ret = this._filterEntry.decode(this._dIter)) != 14) {
                if (ret >= 0 && this._filterEntry.containerType() == 133) {
                    ret = this._elemList.decode(this._dIter, null);
                    if (ret >= 0) {
                        block8: while ((ret = this._elemEntry.decode(this._dIter)) != 14) {
                            if (ret >= 0) {
                                switch (this._filterEntry.id()) {
                                    case 1: {
                                        if (this._elemEntry.name().equals(ClassesOfService.ElementNames.MAX_MSG_SIZE)) {
                                            this._tempUInt.decode(this._dIter);
                                            this._commonProperties.maxMsgSize((int)this._tempUInt.toLong());
                                            continue block8;
                                        }
                                        if (this._elemEntry.name().equals(ClassesOfService.ElementNames.PROTOCOL_TYPE)) {
                                            this._tempUInt.decode(this._dIter);
                                            this._commonProperties.protocolType((int)this._tempUInt.toLong());
                                            continue block8;
                                        }
                                        if (this._elemEntry.name().equals(ClassesOfService.ElementNames.PROTOCOL_MAJOR_VERSION)) {
                                            this._tempUInt.decode(this._dIter);
                                            this._commonProperties.protocolMajorVersion((int)this._tempUInt.toLong());
                                            continue block8;
                                        }
                                        if (this._elemEntry.name().equals(ClassesOfService.ElementNames.PROTOCOL_MINOR_VERSION)) {
                                            this._tempUInt.decode(this._dIter);
                                            this._commonProperties.protocolMinorVersion((int)this._tempUInt.toLong());
                                            continue block8;
                                        }
                                        if (!this._elemEntry.name().equals(ClassesOfService.ElementNames.STREAM_VERSION)) continue block8;
                                        this._tempUInt.decode(this._dIter);
                                        this._commonProperties.streamVersion((int)this._tempUInt.toLong());
                                        continue block8;
                                    }
                                    case 2: {
                                        this._tempUInt.decode(this._dIter);
                                        this._authentication.type((int)this._tempUInt.toLong());
                                        continue block8;
                                    }
                                    case 3: {
                                        if (this._elemEntry.name().equals(ClassesOfService.ElementNames.TYPE)) {
                                            this._tempUInt.decode(this._dIter);
                                            this._flowControl.type((int)this._tempUInt.toLong());
                                            continue block8;
                                        }
                                        if (!this._elemEntry.name().equals(ClassesOfService.ElementNames.RECV_WINDOW_SIZE)) continue block8;
                                        this._tempInt.decode(this._dIter);
                                        this._flowControl.sendWindowSize((int)this._tempInt.toLong());
                                        continue block8;
                                    }
                                    case 4: {
                                        this._tempUInt.decode(this._dIter);
                                        this._dataIntegrity.type((int)this._tempUInt.toLong());
                                        continue block8;
                                    }
                                    case 5: {
                                        this._tempUInt.decode(this._dIter);
                                        this._guarantee.type((int)this._tempUInt.toLong());
                                        continue block8;
                                    }
                                }
                                continue;
                            }
                            errorInfo.error().text("ElementEntry decode failed with return code: " + ret);
                            return -1;
                        }
                        continue;
                    }
                    errorInfo.error().text("ElementList decode failed with return code: " + ret);
                    return -1;
                }
                errorInfo.error().text("FilterEntry decode failed with return code: " + ret);
                return -1;
            }
        } else {
            errorInfo.error().text("FilterList decode failed with return code: " + ret);
            return -1;
        }
        this._encodedCOSBuffer = encodedBuffer;
        this._allCOSDecoded = true;
        return 0;
    }

    int decodeCommonProperties(ReactorChannel reactorChannel, Buffer encodedBuffer, ReactorErrorInfo errorInfo) {
        int filterEntryRet;
        if (encodedBuffer == null || encodedBuffer.data() == null) {
            errorInfo.error().text("encodedBuffer cannot be null");
            return -1;
        }
        this._encodedCOSBuffer = encodedBuffer;
        this._dIter.clear();
        this._dIter.setBufferAndRWFVersion(encodedBuffer, reactorChannel.majorVersion(), reactorChannel.minorVersion());
        int ret = this._filterList.decode(this._dIter);
        if (ret >= 0) {
            while ((filterEntryRet = this._filterEntry.decode(this._dIter)) != 14) {
                if (filterEntryRet >= 0 && this._filterEntry.containerType() == 133) {
                    ret = this._elemList.decode(this._dIter, null);
                    if (ret >= 0) {
                        block8: while ((ret = this._elemEntry.decode(this._dIter)) != 14) {
                            if (ret >= 0) {
                                switch (this._filterEntry.id()) {
                                    case 1: {
                                        if (this._elemEntry.name().equals(ClassesOfService.ElementNames.MAX_MSG_SIZE)) {
                                            this._tempUInt.decode(this._dIter);
                                            this._commonProperties.maxMsgSize((int)this._tempUInt.toLong());
                                        }
                                        if (this._elemEntry.name().equals(ClassesOfService.ElementNames.MAX_FRAGMENT_SIZE)) {
                                            this._tempUInt.decode(this._dIter);
                                            this._commonProperties.maxMsgSize((int)this._tempUInt.toLong());
                                            continue block8;
                                        }
                                        if (this._elemEntry.name().equals(ClassesOfService.ElementNames.PROTOCOL_TYPE)) {
                                            this._tempUInt.decode(this._dIter);
                                            this._commonProperties.protocolType((int)this._tempUInt.toLong());
                                            continue block8;
                                        }
                                        if (this._elemEntry.name().equals(ClassesOfService.ElementNames.PROTOCOL_MAJOR_VERSION)) {
                                            this._tempUInt.decode(this._dIter);
                                            this._commonProperties.protocolMajorVersion((int)this._tempUInt.toLong());
                                            continue block8;
                                        }
                                        if (this._elemEntry.name().equals(ClassesOfService.ElementNames.PROTOCOL_MINOR_VERSION)) {
                                            this._tempUInt.decode(this._dIter);
                                            this._commonProperties.protocolMinorVersion((int)this._tempUInt.toLong());
                                            continue block8;
                                        }
                                        if (this._elemEntry.name().equals(ClassesOfService.ElementNames.STREAM_VERSION)) {
                                            this._tempUInt.decode(this._dIter);
                                            this._commonProperties.streamVersion((int)this._tempUInt.toLong());
                                            continue block8;
                                        }
                                        if (!this._elemEntry.name().equals(ClassesOfService.ElementNames.SUPPS_FRAGMENTATION)) continue block8;
                                        this._tempUInt.decode(this._dIter);
                                        this._commonProperties.supportFragmentation((int)this._tempUInt.toLong());
                                        continue block8;
                                    }
                                    case 2: {
                                        this._tempUInt.decode(this._dIter);
                                        this._authentication.type((int)this._tempUInt.toLong());
                                        continue block8;
                                    }
                                    case 3: {
                                        if (this._elemEntry.name().equals(ClassesOfService.ElementNames.TYPE)) {
                                            this._tempUInt.decode(this._dIter);
                                            this._flowControl.type((int)this._tempUInt.toLong());
                                            continue block8;
                                        }
                                        if (!this._elemEntry.name().equals(ClassesOfService.ElementNames.RECV_WINDOW_SIZE)) continue block8;
                                        this._tempInt.decode(this._dIter);
                                        this._flowControl.sendWindowSize((int)this._tempInt.toLong());
                                        continue block8;
                                    }
                                    case 4: {
                                        this._tempUInt.decode(this._dIter);
                                        this._dataIntegrity.type((int)this._tempUInt.toLong());
                                        continue block8;
                                    }
                                    case 5: {
                                        this._tempUInt.decode(this._dIter);
                                        this._guarantee.type((int)this._tempUInt.toLong());
                                        continue block8;
                                    }
                                }
                                continue;
                            }
                            errorInfo.error().text("ElementEntry decode failed with return code: " + ret);
                            return -1;
                        }
                        if (this._filterEntry.id() != 1) continue;
                        break;
                    }
                    errorInfo.error().text("ElementList decode failed with return code: " + ret);
                    return -1;
                }
                errorInfo.error().text("FilterEntry decode failed with return code: " + ret);
                return -1;
            }
        } else {
            errorInfo.error().text("FilterList decode failed with return code: " + ret);
            return -1;
        }
        if (filterEntryRet == 14) {
            this._allCOSDecoded = true;
        }
        return 0;
    }

    int decodeRemainder(Error error) {
        int ret;
        while ((ret = this._filterEntry.decode(this._dIter)) != 14) {
            if (ret >= 0 && this._filterEntry.containerType() == 133) {
                ret = this._elemList.decode(this._dIter, null);
                if (ret >= 0) {
                    block7: while ((ret = this._elemEntry.decode(this._dIter)) != 14) {
                        if (ret >= 0) {
                            switch (this._filterEntry.id()) {
                                case 2: {
                                    this._tempUInt.decode(this._dIter);
                                    this._authentication.type((int)this._tempUInt.toLong());
                                    continue block7;
                                }
                                case 3: {
                                    if (this._elemEntry.name().equals(ClassesOfService.ElementNames.TYPE)) {
                                        this._tempUInt.decode(this._dIter);
                                        this._flowControl.type((int)this._tempUInt.toLong());
                                        continue block7;
                                    }
                                    if (!this._elemEntry.name().equals(ClassesOfService.ElementNames.RECV_WINDOW_SIZE)) continue block7;
                                    this._tempInt.decode(this._dIter);
                                    this._flowControl.recvWindowSize((int)this._tempInt.toLong());
                                    continue block7;
                                }
                                case 4: {
                                    this._tempUInt.decode(this._dIter);
                                    this._dataIntegrity.type((int)this._tempUInt.toLong());
                                    continue block7;
                                }
                                case 5: {
                                    this._tempUInt.decode(this._dIter);
                                    this._guarantee.type((int)this._tempUInt.toLong());
                                    continue block7;
                                }
                            }
                            continue;
                        }
                        error.text("ElementEntry decode failed with return code: " + ret);
                        return -1;
                    }
                    continue;
                }
                error.text("ElementList decode failed with return code: " + ret);
                return -1;
            }
            error.text("FilterEntry decode failed with return code: " + ret);
            return -1;
        }
        this._allCOSDecoded = true;
        return 0;
    }

    Buffer encode(ReactorChannel reactorChannel) {
        this._eIter.clear();
        this._tempBuffer.data().clear();
        this._eIter.setBufferAndRWFVersion(this._tempBuffer, reactorChannel.majorVersion(), reactorChannel.minorVersion());
        if (this.encode(this._eIter) == 0) {
            return this._tempBuffer;
        }
        return null;
    }

    public int encode(EncodeIterator eIter) {
        int ret = 0;
        assert (null != eIter) : "Invalid parameters or parameters passed in as NULL";
        this._filterList.clear();
        this._filterList.containerType(133);
        ret = this._filterList.encodeInit(eIter);
        if (ret < 0) {
            return ret;
        }
        this._filterEntry.clear();
        this._filterEntry.action(2);
        this._filterEntry.applyHasContainerType();
        this._filterEntry.containerType(133);
        this._filterEntry.id(1);
        ret = this._filterEntry.encodeInit(eIter, 0);
        if (ret < 0) {
            return ret;
        }
        this._elemList.clear();
        this._elemList.applyHasStandardData();
        ret = this._elemList.encodeInit(eIter, null, 0);
        if (ret < 0) {
            return ret;
        }
        if (this._isServer) {
            this._elemEntry.clear();
            this._elemEntry.name(ClassesOfService.ElementNames.MAX_MSG_SIZE);
            this._elemEntry.dataType(4);
            if (this._commonProperties.streamVersion() > 1) {
                this._tempUInt.value(this._commonProperties.maxMsgSize());
            } else {
                this._tempUInt.value(this._commonProperties.maxFragmentSize());
            }
            ret = this._elemEntry.encode(eIter, this._tempUInt);
            if (ret < 0) {
                return ret;
            }
            if (this._commonProperties.streamVersion() > 1) {
                this._elemEntry.clear();
                this._elemEntry.name(ClassesOfService.ElementNames.MAX_FRAGMENT_SIZE);
                this._elemEntry.dataType(4);
                this._tempUInt.value(this._commonProperties.maxFragmentSize());
                ret = this._elemEntry.encode(eIter, this._tempUInt);
                if (ret < 0) {
                    return ret;
                }
                this._elemEntry.clear();
                this._elemEntry.name(ClassesOfService.ElementNames.SUPPS_FRAGMENTATION);
                this._elemEntry.dataType(4);
                this._tempUInt.value(this._commonProperties.supportFragmentation());
                ret = this._elemEntry.encode(eIter, this._tempUInt);
                if (ret < 0) {
                    return ret;
                }
            }
        }
        this._elemEntry.clear();
        this._elemEntry.name(ClassesOfService.ElementNames.PROTOCOL_TYPE);
        this._elemEntry.dataType(4);
        this._tempUInt.value(this._commonProperties.protocolType());
        ret = this._elemEntry.encode(eIter, this._tempUInt);
        if (ret < 0) {
            return ret;
        }
        this._elemEntry.clear();
        this._elemEntry.name(ClassesOfService.ElementNames.PROTOCOL_MAJOR_VERSION);
        this._elemEntry.dataType(4);
        this._tempUInt.value(this._commonProperties.protocolMajorVersion());
        ret = this._elemEntry.encode(eIter, this._tempUInt);
        if (ret < 0) {
            return ret;
        }
        this._elemEntry.clear();
        this._elemEntry.name(ClassesOfService.ElementNames.PROTOCOL_MINOR_VERSION);
        this._elemEntry.dataType(4);
        this._tempUInt.value(this._commonProperties.protocolMinorVersion());
        ret = this._elemEntry.encode(eIter, this._tempUInt);
        if (ret < 0) {
            return ret;
        }
        this._elemEntry.clear();
        this._elemEntry.name(ClassesOfService.ElementNames.STREAM_VERSION);
        this._elemEntry.dataType(4);
        this._tempUInt.value(this._commonProperties.streamVersion());
        ret = this._elemEntry.encode(eIter, this._tempUInt);
        if (ret < 0) {
            return ret;
        }
        ret = this._elemList.encodeComplete(eIter, true);
        if (ret < 0) {
            return ret;
        }
        ret = this._filterEntry.encodeComplete(eIter, true);
        if (ret < 0) {
            return ret;
        }
        if (this._authentication.type() != 0) {
            this._filterEntry.clear();
            this._filterEntry.action(2);
            this._filterEntry.applyHasContainerType();
            this._filterEntry.containerType(133);
            this._filterEntry.id(2);
            ret = this._filterEntry.encodeInit(eIter, 0);
            if (ret < 0) {
                return ret;
            }
            this._elemList.clear();
            this._elemList.applyHasStandardData();
            ret = this._elemList.encodeInit(eIter, null, 0);
            if (ret < 0) {
                return ret;
            }
            this._elemEntry.clear();
            this._elemEntry.name(ClassesOfService.ElementNames.TYPE);
            this._elemEntry.dataType(4);
            this._tempUInt.value(this._authentication.type());
            ret = this._elemEntry.encode(eIter, this._tempUInt);
            if (ret < 0) {
                return ret;
            }
            ret = this._elemList.encodeComplete(eIter, true);
            if (ret < 0) {
                return ret;
            }
            ret = this._filterEntry.encodeComplete(eIter, true);
            if (ret < 0) {
                return ret;
            }
        }
        if (this._flowControl.type() != 0) {
            this._filterEntry.clear();
            this._filterEntry.action(2);
            this._filterEntry.applyHasContainerType();
            this._filterEntry.containerType(133);
            this._filterEntry.id(3);
            ret = this._filterEntry.encodeInit(eIter, 0);
            if (ret < 0) {
                return ret;
            }
            this._elemList.clear();
            this._elemList.applyHasStandardData();
            ret = this._elemList.encodeInit(eIter, null, 0);
            if (ret < 0) {
                return ret;
            }
            this._elemEntry.clear();
            this._elemEntry.name(ClassesOfService.ElementNames.TYPE);
            this._elemEntry.dataType(4);
            this._tempUInt.value(this._flowControl.type());
            ret = this._elemEntry.encode(eIter, this._tempUInt);
            if (ret < 0) {
                return ret;
            }
            this._elemEntry.clear();
            this._elemEntry.name(ClassesOfService.ElementNames.RECV_WINDOW_SIZE);
            this._elemEntry.dataType(3);
            int recvWindowSize = this._flowControl.recvWindowSize();
            this._tempInt.value(recvWindowSize);
            ret = this._elemEntry.encode(eIter, this._tempInt);
            if (ret < 0) {
                return ret;
            }
            ret = this._elemList.encodeComplete(eIter, true);
            if (ret < 0) {
                return ret;
            }
            ret = this._filterEntry.encodeComplete(eIter, true);
            if (ret < 0) {
                return ret;
            }
        }
        if (this._dataIntegrity.type() != 0) {
            this._filterEntry.clear();
            this._filterEntry.action(2);
            this._filterEntry.applyHasContainerType();
            this._filterEntry.containerType(133);
            this._filterEntry.id(4);
            ret = this._filterEntry.encodeInit(eIter, 0);
            if (ret < 0) {
                return ret;
            }
            this._elemList.clear();
            this._elemList.applyHasStandardData();
            ret = this._elemList.encodeInit(eIter, null, 0);
            if (ret < 0) {
                return ret;
            }
            this._elemEntry.clear();
            this._elemEntry.name(ClassesOfService.ElementNames.TYPE);
            this._elemEntry.dataType(4);
            this._tempUInt.value(this._dataIntegrity.type());
            ret = this._elemEntry.encode(eIter, this._tempUInt);
            if (ret < 0) {
                return ret;
            }
            ret = this._elemList.encodeComplete(eIter, true);
            if (ret < 0) {
                return ret;
            }
            ret = this._filterEntry.encodeComplete(eIter, true);
            if (ret < 0) {
                return ret;
            }
        }
        if (this._guarantee.type() != 0) {
            this._filterEntry.clear();
            this._filterEntry.action(2);
            this._filterEntry.applyHasContainerType();
            this._filterEntry.containerType(133);
            this._filterEntry.id(5);
            ret = this._filterEntry.encodeInit(eIter, 0);
            if (ret < 0) {
                return ret;
            }
            this._elemList.clear();
            this._elemList.applyHasStandardData();
            ret = this._elemList.encodeInit(eIter, null, 0);
            if (ret < 0) {
                return ret;
            }
            this._elemEntry.clear();
            this._elemEntry.name(ClassesOfService.ElementNames.TYPE);
            this._elemEntry.dataType(4);
            this._tempUInt.value(this._guarantee.type());
            ret = this._elemEntry.encode(eIter, this._tempUInt);
            if (ret < 0) {
                return ret;
            }
            ret = this._elemList.encodeComplete(eIter, true);
            if (ret < 0) {
                return ret;
            }
            ret = this._filterEntry.encodeComplete(eIter, true);
            if (ret < 0) {
                return ret;
            }
        }
        if ((ret = this._filterList.encodeComplete(eIter, true)) < 0) {
            return ret;
        }
        return ret;
    }

    boolean isValid(boolean isServer, ReactorErrorInfo errorInfo) {
        this._isServer = isServer;
        if (this._dataIntegrity.type() != 1) {
            errorInfo.clear();
            errorInfo.code(-1).location("ClassOfService.isValid");
            errorInfo.error().errorId(-1);
            errorInfo.error().text("ClassOfService must minimally set reliability");
            return false;
        }
        if (!isServer && this._guarantee.type() == 1 && this._commonProperties.protocolType() != Codec.protocolType()) {
            errorInfo.clear();
            errorInfo.code(-1).location("ClassOfService.isValid");
            errorInfo.error().errorId(-1);
            errorInfo.error().text("Queue consumers must use RWF protocol type");
            return false;
        }
        if (this._commonProperties.protocolType() != Codec.protocolType() && this._authentication.type() == 1) {
            errorInfo.clear();
            errorInfo.code(-1).location("ClassOfService.isValid");
            errorInfo.error().errorId(-1);
            errorInfo.error().text("Must use RWF protocol type when using authentication type of OMM login");
            return false;
        }
        if (isServer && this._guarantee.type() == 1) {
            errorInfo.clear();
            errorInfo.code(-1).location("ClassOfService.isValid");
            errorInfo.error().errorId(-1);
            errorInfo.error().text("Only Queue Provider can support persistence");
            return false;
        }
        return true;
    }

    boolean decodedProperly() {
        return this._allCOSDecoded;
    }

    void isServer(boolean isServer) {
        this._isServer = isServer;
    }

    public void clear() {
        this._commonProperties.clear();
        this._authentication.clear();
        this._flowControl.clear();
        this._dataIntegrity.clear();
        this._guarantee.clear();
        this._encodedCOSBuffer = null;
        this._allCOSDecoded = false;
        this._isServer = false;
    }

    public int copy(ClassOfService destCos) {
        destCos.clear();
        destCos.common().maxMsgSize(this.common().maxMsgSize());
        destCos.common().protocolType(this.common().protocolType());
        destCos.common().protocolMajorVersion(this.common().protocolMajorVersion());
        destCos.common().protocolMinorVersion(this.common().protocolMinorVersion());
        destCos.common().streamVersion(this.common().streamVersion());
        destCos.authentication().type(this.authentication().type());
        destCos.flowControl().type(this.flowControl().type());
        destCos.flowControl().recvWindowSize(this.flowControl().recvWindowSize());
        destCos.flowControl().sendWindowSize(this.flowControl().sendWindowSize());
        destCos.dataIntegrity().type(this.dataIntegrity().type());
        destCos.guarantee().type(this.guarantee().type());
        destCos.guarantee().persistenceFilePath(this.guarantee().persistenceFilePath());
        destCos.guarantee().persistLocally(this.guarantee().persistLocally());
        return 0;
    }
}

