/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.login;

import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.ElementEntry;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.GenericMsg;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.rdm.ElementNames;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBaseImpl;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginRTT;

class LoginRTTImpl
extends MsgBaseImpl {
    private int flags;
    private long rtLatency;
    private long tcpRetrans;
    private long ticks;
    private ElementEntry elementEntry = CodecFactory.createElementEntry();
    private ElementList elementList = CodecFactory.createElementList();
    private UInt tmpUInt = CodecFactory.createUInt();
    private GenericMsg genericMsg = (GenericMsg)CodecFactory.createMsg();
    private static final String tab = "\t";

    LoginRTTImpl() {
        this.genericMsg.domainType(1);
        this.genericMsg.msgClass(7);
    }

    public void flags(int flags) {
        this.flags = flags;
    }

    public int flags() {
        return this.flags;
    }

    public void ticks(long t) {
        this.ticks = t;
    }

    public void tcpRetrans(long retrans) {
        assert (this.checkHasTCPRetrans());
        this.tcpRetrans = retrans;
    }

    public void rtLatency(long latency) {
        assert (this.checkHasRTLatency());
        this.rtLatency = latency;
    }

    public long ticks() {
        return this.ticks;
    }

    public long rtLatency() {
        return this.rtLatency;
    }

    public long tcpRetrans() {
        return this.tcpRetrans;
    }

    @Override
    public int domainType() {
        return 1;
    }

    @Override
    public int encode(EncodeIterator eIter) {
        int ret;
        this.genericMsg.clear();
        this.genericMsg.msgClass(7);
        this.genericMsg.domainType(1);
        this.genericMsg.streamId(this.streamId());
        this.genericMsg.containerType(133);
        if (this.checkProviderDriven()) {
            this.genericMsg.flags(16384);
        }
        if ((ret = this.genericMsg.encodeInit(eIter, 0)) != 13) {
            return -1;
        }
        this.elementEntry.clear();
        this.elementList.clear();
        this.elementList.flags(8);
        if (this.elementList.encodeInit(eIter, null, 0) < 0) {
            return -1;
        }
        this.elementEntry.dataType(4);
        this.elementEntry.name(ElementNames.TICKS);
        this.tmpUInt.value(this.ticks);
        ret = this.elementEntry.encode(eIter, this.tmpUInt);
        if (ret != 0) {
            return ret;
        }
        if (this.checkHasRTLatency()) {
            this.elementEntry.dataType(4);
            this.elementEntry.name(ElementNames.ROUND_TRIP_LATENCY);
            this.tmpUInt.value(this.rtLatency);
            ret = this.elementEntry.encode(eIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasTCPRetrans()) {
            this.elementEntry.dataType(4);
            this.elementEntry.name(ElementNames.TCP_RETRANS);
            this.tmpUInt.value(this.tcpRetrans);
            ret = this.elementEntry.encode(eIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
        }
        if ((ret = this.elementList.encodeComplete(eIter, true)) < 0) {
            return ret;
        }
        return 0;
    }

    @Override
    public int decode(DecodeIterator dIter, Msg msg) {
        if (msg.msgClass() != 7 || msg.domainType() != 1) {
            return -1;
        }
        if (msg.containerType() != 133) {
            return -1;
        }
        this.clear();
        this.streamId(msg.streamId());
        if ((msg.flags() & 0x4000) != 0) {
            this.applyProviderDriven();
        }
        this.elementList.clear();
        int ret = this.elementList.decode(dIter, null);
        if (ret != 0) {
            return ret;
        }
        this.elementEntry.clear();
        while ((ret = this.elementEntry.decode(dIter)) != 14) {
            if (ret != 0) {
                return ret;
            }
            if (this.elementEntry.name().equals(ElementNames.TICKS)) {
                if (this.elementEntry.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.ticks = this.tmpUInt.toLong();
                continue;
            }
            if (this.elementEntry.name().equals(ElementNames.ROUND_TRIP_LATENCY)) {
                if (this.elementEntry.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasRTLatency();
                this.rtLatency = this.tmpUInt.toLong();
                continue;
            }
            if (!this.elementEntry.name().equals(ElementNames.TCP_RETRANS)) continue;
            if (this.elementEntry.dataType() != 4) {
                return -1;
            }
            ret = this.tmpUInt.decode(dIter);
            if (ret != 0) {
                return ret;
            }
            this.applyHasTCPRetrans();
            this.tcpRetrans = this.tmpUInt.toLong();
        }
        return 0;
    }

    public boolean checkProviderDriven() {
        return (this.flags & 1) != 0;
    }

    public void applyProviderDriven() {
        this.flags |= 1;
    }

    public boolean checkHasTCPRetrans() {
        return (this.flags & 2) != 0;
    }

    public void applyHasTCPRetrans() {
        this.flags |= 2;
    }

    public boolean checkHasRTLatency() {
        return (this.flags & 4) != 0;
    }

    public void applyHasRTLatency() {
        this.flags |= 4;
    }

    @Override
    public void clear() {
        super.clear();
        this.flags = 0;
    }

    public int copy(LoginRTT destRTTMsg) {
        assert (destRTTMsg != null) : "destRTTMsg must not be null";
        destRTTMsg.streamId(this.streamId());
        destRTTMsg.ticks(this.ticks);
        if (this.checkHasTCPRetrans()) {
            destRTTMsg.applyHasTCPRetrans();
            destRTTMsg.tcpRetrans(this.tcpRetrans);
        }
        if (this.checkHasRTLatency()) {
            destRTTMsg.applyHasRTLatency();
            destRTTMsg.rtLatency(this.rtLatency);
        }
        if (this.checkProviderDriven()) {
            destRTTMsg.applyProviderDriven();
        }
        return 0;
    }

    public void initRTT(int streamId) {
        this.clear();
        this.streamId(streamId);
        this.applyProviderDriven();
        this.ticks = System.nanoTime();
    }

    public long calculateRTTLatency() {
        this.rtLatency = System.nanoTime() - this.ticks;
        return this.rtLatency;
    }

    @Override
    public String toString() {
        StringBuilder toStringBuilder = super.buildStringBuffer();
        toStringBuilder.insert(0, "LoginRTT: \n");
        toStringBuilder.append(tab);
        toStringBuilder.append("Ticks: ");
        toStringBuilder.append(this.ticks());
        if (this.checkHasRTLatency()) {
            toStringBuilder.append(tab);
            toStringBuilder.append("rtLatency: ");
            toStringBuilder.append(this.rtLatency());
        }
        if (this.checkHasTCPRetrans()) {
            toStringBuilder.append(tab);
            toStringBuilder.append("tcpRetrans: ");
            toStringBuilder.append(this.tcpRetrans());
        }
        toStringBuilder.append(tab);
        toStringBuilder.append("provider driven: ");
        toStringBuilder.append(this.checkProviderDriven());
        return toStringBuilder.toString();
    }
}

