/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.login;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.GenericMsg;
import com.refinitiv.eta.codec.Map;
import com.refinitiv.eta.codec.MapEntry;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.MsgKey;
import com.refinitiv.eta.rdm.ElementNames;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBaseImpl;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginConsumerConnectionStatus;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginWarmStandbyInfo;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginWarmStandbyInfoImpl;

class LoginConsumerConnectionStatusImpl
extends MsgBaseImpl {
    private LoginWarmStandbyInfo warmStandbyInfo = new LoginWarmStandbyInfoImpl();
    private int flags;
    private GenericMsg genericMsg = (GenericMsg)CodecFactory.createMsg();
    private Map map;
    private MapEntry mapEntry;
    private Buffer tempBuffer;
    private static final String tab = "\t";

    public LoginConsumerConnectionStatusImpl() {
        this.genericMsg.msgClass(7);
        this.genericMsg.domainType(1);
        this.map = CodecFactory.createMap();
        this.mapEntry = CodecFactory.createMapEntry();
        this.tempBuffer = CodecFactory.createBuffer();
    }

    public int copy(LoginConsumerConnectionStatus destConnStatusMsg) {
        assert (destConnStatusMsg != null) : "destConnStatusMsg must be non-null";
        destConnStatusMsg.streamId(this.streamId());
        if (this.checkHasWarmStandbyInfo()) {
            destConnStatusMsg.applyHasWarmStandbyInfo();
            destConnStatusMsg.warmStandbyInfo().warmStandbyMode(this.warmStandbyInfo().warmStandbyMode());
            destConnStatusMsg.warmStandbyInfo().action(this.warmStandbyInfo().action());
        }
        return 0;
    }

    public int flags() {
        return this.flags;
    }

    public void flags(int flags) {
        this.flags = flags;
    }

    @Override
    public void clear() {
        super.clear();
        this.warmStandbyInfo.clear();
        this.flags = 0;
    }

    @Override
    public int encode(EncodeIterator encodeIter) {
        this.genericMsg.clear();
        this.genericMsg.msgClass(7);
        this.genericMsg.domainType(1);
        this.genericMsg.streamId(this.streamId());
        this.genericMsg.containerType(137);
        this.genericMsg.flags(4);
        this.genericMsg.msgKey().flags(2);
        this.genericMsg.msgKey().name(ElementNames.CONS_CONN_STATUS);
        int ret = this.genericMsg.encodeInit(encodeIter, 0);
        if (ret != 13) {
            return -1;
        }
        this.map.clear();
        this.map.flags(0);
        this.map.keyPrimitiveType(17);
        this.map.containerType(133);
        ret = this.map.encodeInit(encodeIter, 0, 0);
        if (ret != 0) {
            return -1;
        }
        if (this.checkHasWarmStandbyInfo()) {
            this.mapEntry.clear();
            this.mapEntry.flags(0);
            this.mapEntry.action(this.warmStandbyInfo().action());
            if (this.mapEntry.action() != 3) {
                ret = this.mapEntry.encodeInit(encodeIter, ElementNames.WARMSTANDBY_INFO, 0);
                ret = this.warmStandbyInfo().encode(encodeIter);
                if (ret != 0) {
                    return -1;
                }
                ret = this.mapEntry.encodeComplete(encodeIter, true);
                if (ret != 0) {
                    return -1;
                }
            } else {
                ret = this.mapEntry.encode(encodeIter, ElementNames.WARMSTANDBY_INFO);
                if (ret != 0) {
                    return -1;
                }
            }
        }
        if ((ret = this.map.encodeComplete(encodeIter, true)) != 0) {
            return -1;
        }
        ret = this.genericMsg.encodeComplete(encodeIter, true);
        if (ret != 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public int decode(DecodeIterator dIter, Msg msg) {
        if (msg.msgClass() != 7 || msg.domainType() != 1) {
            return -1;
        }
        MsgKey key = msg.msgKey();
        if (key == null || !key.checkHasName()) {
            return -1;
        }
        if (!key.name().equals(ElementNames.CONS_CONN_STATUS)) {
            return -1;
        }
        if (msg.containerType() != 137) {
            return -1;
        }
        this.clear();
        this.streamId(msg.streamId());
        this.map.clear();
        int ret = this.map.decode(dIter);
        if (ret != 0) {
            return -1;
        }
        if (this.map.keyPrimitiveType() != 17 && this.map.keyPrimitiveType() != 16) {
            return -1;
        }
        if (this.map.containerType() != 133) {
            return -1;
        }
        this.mapEntry.clear();
        this.tempBuffer.clear();
        while ((ret = this.mapEntry.decode(dIter, (Object)this.tempBuffer)) != 14) {
            if (ret < 0) {
                return -1;
            }
            if (!this.tempBuffer.equals(ElementNames.WARMSTANDBY_INFO)) continue;
            this.flags(this.flags | 1);
            if (this.mapEntry.action() != 3 && (ret = this.warmStandbyInfo().decode(dIter, msg)) != 0) {
                return -1;
            }
            this.warmStandbyInfo().action(this.mapEntry.action());
        }
        return 0;
    }

    public LoginWarmStandbyInfo warmStandbyInfo() {
        return this.warmStandbyInfo;
    }

    public void warmStandbyInfo(LoginWarmStandbyInfo warmStandbyInfo) {
        ((LoginWarmStandbyInfoImpl)this.warmStandbyInfo()).copyReferences(warmStandbyInfo);
    }

    public boolean checkHasWarmStandbyInfo() {
        return (this.flags & 1) != 0;
    }

    public void applyHasWarmStandbyInfo() {
        this.flags |= 1;
    }

    @Override
    public String toString() {
        StringBuilder toStringBuilder = super.buildStringBuffer();
        toStringBuilder.insert(0, "LoginConsumerConnectionStatus: \n");
        if (this.checkHasWarmStandbyInfo()) {
            toStringBuilder.append(tab);
            toStringBuilder.append("warmStandbyInfo: ");
            toStringBuilder.append(this.warmStandbyInfo());
        }
        return toStringBuilder.toString();
    }

    @Override
    public int domainType() {
        return 1;
    }
}

