/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.login;

import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.ElementEntry;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Enum;
import com.refinitiv.eta.codec.LocalElementSetDefDb;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.codec.Vector;
import com.refinitiv.eta.codec.VectorEntry;
import com.refinitiv.eta.rdm.ElementNames;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginConnectionConfig;
import java.util.ArrayList;
import java.util.List;

class LoginConnectionConfigImpl
implements LoginConnectionConfig {
    private long numStandbyServers;
    private List<LoginConnectionConfig.ServerInfo> serverList;
    private static final String eol = System.getProperty("line.separator");
    private static final String tab = "\t";
    private StringBuilder stringBuf = new StringBuilder();
    private Vector vector = CodecFactory.createVector();
    private VectorEntry vectorEntry = CodecFactory.createVectorEntry();
    private ElementList elementList = CodecFactory.createElementList();
    private ElementEntry elementEntry = CodecFactory.createElementEntry();
    private ElementList serverElementList = CodecFactory.createElementList();
    private ElementEntry serverElementEntry = CodecFactory.createElementEntry();
    private Enum tmpEnum = CodecFactory.createEnum();
    private UInt tmpUInt = CodecFactory.createUInt();
    private LocalElementSetDefDb setDb = CodecFactory.createLocalElementSetDefDb();

    LoginConnectionConfigImpl() {
        this.serverList = new ArrayList<LoginConnectionConfig.ServerInfo>();
    }

    @Override
    public int copy(LoginConnectionConfig destConnectionConfig) {
        assert (destConnectionConfig != null) : "destConnectionConfig can not be null";
        destConnectionConfig.numStandbyServers(this.numStandbyServers());
        int ret = 0;
        for (LoginConnectionConfig.ServerInfo serverInfo : this.serverList()) {
            LoginConnectionConfig.ServerInfo destServerInfo;
            ret = serverInfo.copy(destServerInfo = new LoginConnectionConfig.ServerInfo());
            if (ret != 0) {
                return ret;
            }
            destConnectionConfig.serverList().add(destServerInfo);
        }
        return 0;
    }

    @Override
    public void clear() {
        this.numStandbyServers = 0L;
        this.serverList.clear();
    }

    public int encode(EncodeIterator encodeIter) {
        this.elementList.clear();
        this.elementList.flags(8);
        int ret = this.elementList.encodeInit(encodeIter, null, 0);
        if (ret != 0) {
            return ret;
        }
        this.elementEntry.clear();
        this.elementEntry.dataType(136);
        this.elementEntry.name(ElementNames.CONNECTION_CONFIG);
        ret = this.elementEntry.encodeInit(encodeIter, 0);
        if (ret != 0) {
            return ret;
        }
        this.vector.clear();
        this.vector.containerType(133);
        this.vector.flags(2);
        ret = this.vector.encodeInit(encodeIter, 0, 0);
        if (ret != 0) {
            return ret;
        }
        this.elementList.clear();
        this.elementList.flags(8);
        ret = this.elementList.encodeInit(encodeIter, null, 0);
        if (ret != 0) {
            return ret;
        }
        this.elementEntry.clear();
        this.elementEntry.dataType(4);
        this.elementEntry.name(ElementNames.NUM_STANDBY_SERVERS);
        this.tmpUInt.value(this.numStandbyServers());
        ret = this.elementEntry.encode(encodeIter, this.tmpUInt);
        if (ret != 0) {
            return ret;
        }
        ret = this.elementList.encodeComplete(encodeIter, true);
        if (ret != 0) {
            return ret;
        }
        ret = this.vector.encodeSummaryDataComplete(encodeIter, true);
        if (ret != 0) {
            return ret;
        }
        for (LoginConnectionConfig.ServerInfo serverInfo : this.serverList()) {
            this.vectorEntry.clear();
            this.vectorEntry.index(serverInfo.serverIndex());
            this.vectorEntry.action(2);
            ret = this.vectorEntry.encodeInit(encodeIter, 0);
            if (ret != 0) {
                return ret;
            }
            this.elementList.clear();
            this.elementList.flags(8);
            ret = this.elementList.encodeInit(encodeIter, null, 0);
            if (ret != 0) {
                return ret;
            }
            this.elementEntry.clear();
            this.elementEntry.dataType(17);
            this.elementEntry.name(ElementNames.HOSTNAME);
            ret = this.elementEntry.encode(encodeIter, serverInfo.hostName());
            if (ret != 0) {
                return ret;
            }
            this.elementEntry.dataType(4);
            this.elementEntry.name(ElementNames.PORT);
            this.tmpUInt.value(serverInfo.port());
            ret = this.elementEntry.encode(encodeIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
            if (serverInfo.checkHasLoadFactor()) {
                this.elementEntry.dataType(4);
                this.elementEntry.name(ElementNames.LOAD_FACT);
                this.tmpUInt.value(serverInfo.loadFactor());
                ret = this.elementEntry.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (serverInfo.checkHasType()) {
                this.elementEntry.dataType(14);
                this.elementEntry.name(ElementNames.SERVER_TYPE);
                this.tmpEnum.value(serverInfo.serverType());
                ret = this.elementEntry.encode(encodeIter, this.tmpEnum);
                if (ret != 0) {
                    return ret;
                }
            }
            if ((ret = this.elementList.encodeComplete(encodeIter, true)) != 0) {
                return ret;
            }
            ret = this.vectorEntry.encodeComplete(encodeIter, true);
            if (ret == 0) continue;
            return ret;
        }
        ret = this.vector.encodeComplete(encodeIter, true);
        if (ret != 0) {
            return ret;
        }
        ret = this.elementEntry.encodeComplete(encodeIter, true);
        if (ret != 0) {
            return ret;
        }
        return this.elementList.encodeComplete(encodeIter, true);
    }

    public int decode(DecodeIterator dIter) {
        this.clear();
        int ret = this.vector.decode(dIter);
        if (ret != 0) {
            return ret;
        }
        if (this.vector.containerType() != 133) {
            return -1;
        }
        if (this.vector.checkHasSetDefs()) {
            this.setDb.clear();
            ret = this.setDb.decode(dIter);
            if (ret != 0) {
                return ret;
            }
        }
        if (this.vector.checkHasSummaryData()) {
            ret = this.serverElementList.decode(dIter, null);
            if (ret != 0) {
                return ret;
            }
            boolean foundNumStandbyServers = false;
            while ((ret = this.serverElementEntry.decode(dIter)) != 14) {
                if (ret != 0) {
                    return ret;
                }
                if (!ElementNames.NUM_STANDBY_SERVERS.equals(this.serverElementEntry.name())) continue;
                if (this.serverElementEntry.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.numStandbyServers(this.tmpUInt.toLong());
                foundNumStandbyServers = true;
            }
            if (!foundNumStandbyServers) {
                return -1;
            }
        }
        this.vectorEntry.clear();
        boolean foundHostName = false;
        boolean foundServerPort = false;
        ret = this.vectorEntry.decode(dIter);
        if (ret != 14) {
            if (ret != 0) {
                return ret;
            }
            do {
                if ((ret = this.serverElementList.decode(dIter, this.setDb)) != 0) {
                    return ret;
                }
                LoginConnectionConfig.ServerInfo serverInfo = new LoginConnectionConfig.ServerInfo();
                this.serverList().add(serverInfo);
                serverInfo.serverIndex(this.vectorEntry.index());
                while ((ret = this.serverElementEntry.decode(dIter)) != 14) {
                    if (ret != 0) {
                        return ret;
                    }
                    if (this.serverElementEntry.name().equals(ElementNames.HOSTNAME)) {
                        foundHostName = true;
                        serverInfo.hostName(this.serverElementEntry.encodedData());
                    }
                    if (this.serverElementEntry.name().equals(ElementNames.PORT)) {
                        ret = this.tmpUInt.decode(dIter);
                        if (ret != 0) {
                            return ret;
                        }
                        foundServerPort = true;
                        serverInfo.port(this.tmpUInt.toLong());
                    }
                    if (this.serverElementEntry.name().equals(ElementNames.LOAD_FACT)) {
                        ret = this.tmpUInt.decode(dIter);
                        if (ret != 0) {
                            return ret;
                        }
                        serverInfo.applyHasLoadFactor();
                        serverInfo.loadFactor(this.tmpUInt.toLong());
                    }
                    if (!this.serverElementEntry.name().equals(ElementNames.SERVER_TYPE)) continue;
                    ret = this.tmpEnum.decode(dIter);
                    if (ret != 0) {
                        return ret;
                    }
                    serverInfo.applyHasType();
                    serverInfo.serverType(this.tmpEnum.toInt());
                }
                if (!foundServerPort) {
                    return -1;
                }
                if (foundHostName) continue;
                return -1;
            } while ((ret = this.vectorEntry.decode(dIter)) != 14);
        }
        return 0;
    }

    public String toString() {
        this.stringBuf.setLength(0);
        this.stringBuf.append(tab);
        this.stringBuf.append("numStandbyServers: ");
        this.stringBuf.append(this.numStandbyServers());
        this.stringBuf.append(eol);
        for (LoginConnectionConfig.ServerInfo serverInfo : this.serverList) {
            this.stringBuf.append(serverInfo.toString());
        }
        this.stringBuf.append(eol);
        return this.stringBuf.toString();
    }

    @Override
    public long numStandbyServers() {
        return this.numStandbyServers;
    }

    @Override
    public void numStandbyServers(long numStandbyServers) {
        this.numStandbyServers = numStandbyServers;
    }

    @Override
    public void serverList(List<LoginConnectionConfig.ServerInfo> serverList) {
        this.serverList().clear();
        for (LoginConnectionConfig.ServerInfo server : serverList) {
            this.serverList().add(server);
        }
    }

    @Override
    public List<LoginConnectionConfig.ServerInfo> serverList() {
        return this.serverList;
    }

    public void copyReferences(LoginConnectionConfig srcConnectionConfig) {
        assert (srcConnectionConfig != null) : "srcConnectionConfig can not be null";
        this.numStandbyServers(srcConnectionConfig.numStandbyServers());
        this.serverList(srcConnectionConfig.serverList());
    }
}

