/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.directory;

import com.refinitiv.eta.codec.Array;
import com.refinitiv.eta.codec.ArrayEntry;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DataTypes;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.ElementEntry;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.FilterEntryActions;
import com.refinitiv.eta.codec.LocalElementSetDefDb;
import com.refinitiv.eta.codec.Map;
import com.refinitiv.eta.codec.MapEntry;
import com.refinitiv.eta.codec.Qos;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.codec.Vector;
import com.refinitiv.eta.codec.VectorEntry;
import com.refinitiv.eta.rdm.ElementNames;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public interface Service {
    public void clear();

    public int action();

    public void action(int var1);

    public int flags();

    public void flags(int var1);

    public void applyHasInfo();

    public boolean checkHasInfo();

    public void applyHasData();

    public boolean checkHasData();

    public void applyHasLoad();

    public boolean checkHasLoad();

    public void applyHasLink();

    public boolean checkHasLink();

    public void applyHasState();

    public boolean checkHasState();

    public int encode(EncodeIterator var1);

    public int decode(DecodeIterator var1);

    public int serviceId();

    public void serviceId(int var1);

    public ServiceInfo info();

    public void info(ServiceInfo var1);

    public ServiceState state();

    public void state(ServiceState var1);

    public List<ServiceGroup> groupStateList();

    public void groupStateList(List<ServiceGroup> var1);

    public ServiceLoad load();

    public void load(ServiceLoad var1);

    public ServiceData data();

    public void data(ServiceData var1);

    public ServiceLinkInfo link();

    public void link(ServiceLinkInfo var1);

    public int copy(Service var1);

    public int applyUpdate(Service var1);

    public ServiceSeqMcastInfo seqMcastInfo();

    public static class ServiceStateFlags {
        public static final int NONE = 0;
        public static final int HAS_ACCEPTING_REQS = 1;
        public static final int HAS_STATUS = 2;

        private ServiceStateFlags() {
            throw new AssertionError();
        }
    }

    public static class ServiceState {
        private long serviceState;
        private long acceptingRequests;
        private State status;
        private int action;
        private int flags;
        private ElementList elementList = CodecFactory.createElementList();
        private ElementEntry element = CodecFactory.createElementEntry();
        private UInt tmpUInt = CodecFactory.createUInt();
        private State tmpStatus = CodecFactory.createState();
        private StringBuilder stringBuf = new StringBuilder();
        private static final String eol = "\n";
        private static final String tab = "\t";

        public ServiceState() {
            this.status = CodecFactory.createState();
            this.clear();
        }

        public void clear() {
            this.flags = 0;
            this.status.clear();
            this.status.streamState(1);
            this.status.code(0);
            this.status.dataState(1);
            this.action = 2;
            this.serviceState = 1L;
            this.acceptingRequests = 1L;
        }

        public int flags() {
            return this.flags;
        }

        public void flags(int flags) {
            this.flags = flags;
        }

        public int copy(ServiceState destServiceState) {
            assert (destServiceState != null) : "destServiceState can not be null";
            destServiceState.clear();
            destServiceState.flags(this.flags());
            destServiceState.action(this.action());
            destServiceState.serviceState(this.serviceState());
            if (this.checkHasAcceptingRequests()) {
                destServiceState.applyHasAcceptingRequests();
                destServiceState.acceptingRequests(this.acceptingRequests());
            }
            if (this.checkHasStatus()) {
                destServiceState.applyHasStatus();
                destServiceState.status().streamState(this.status().streamState());
                destServiceState.status().dataState(this.status().dataState());
                destServiceState.status().code(this.status().code());
                if (this.status().text().length() > 0) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(this.status().text().length());
                    this.status().text().copy(byteBuffer);
                    destServiceState.status().text().data(byteBuffer);
                }
            }
            return 0;
        }

        public int update(ServiceState destServiceState) {
            assert (destServiceState != null) : "destServiceState can not be null";
            destServiceState.flags(this.flags());
            destServiceState.action(this.action());
            destServiceState.serviceState(this.serviceState());
            if (this.checkHasAcceptingRequests()) {
                destServiceState.applyHasAcceptingRequests();
                destServiceState.acceptingRequests(this.acceptingRequests());
            }
            if (this.checkHasStatus()) {
                destServiceState.applyHasStatus();
                destServiceState.status().streamState(this.status().streamState());
                destServiceState.status().dataState(this.status().dataState());
                destServiceState.status().code(this.status().code());
                if (this.status().text().length() > 0) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(this.status().text().length());
                    this.status().text().copy(byteBuffer);
                    destServiceState.status().text().data(byteBuffer);
                }
            }
            return 0;
        }

        public String toString() {
            this.stringBuf.setLength(0);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("StateFilter:");
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("ServiceState: ");
            this.stringBuf.append(this.serviceState());
            this.stringBuf.append(eol);
            if (this.checkHasAcceptingRequests()) {
                this.stringBuf.append(tab);
                this.stringBuf.append(tab);
                this.stringBuf.append(tab);
                this.stringBuf.append("AcceptingRequests: ");
                this.stringBuf.append(this.acceptingRequests());
                this.stringBuf.append(eol);
            }
            if (this.checkHasStatus()) {
                this.stringBuf.append(tab);
                this.stringBuf.append(tab);
                this.stringBuf.append(tab);
                this.stringBuf.append(this.status());
                this.stringBuf.append(eol);
            }
            return this.stringBuf.toString();
        }

        public int action() {
            return this.action;
        }

        public void action(int action) {
            this.action = action;
        }

        public long serviceState() {
            return this.serviceState;
        }

        public void serviceState(long serviceState) {
            this.serviceState = serviceState;
        }

        public long acceptingRequests() {
            return this.acceptingRequests;
        }

        public void acceptingRequests(long acceptingRequests) {
            assert (this.checkHasAcceptingRequests());
            this.acceptingRequests = acceptingRequests;
        }

        public boolean checkHasAcceptingRequests() {
            return (this.flags & 1) != 0;
        }

        public void applyHasAcceptingRequests() {
            this.flags |= 1;
        }

        public State status() {
            return this.status;
        }

        public void status(State status) {
            this.status().streamState(status.streamState());
            this.status().dataState(status.dataState());
            this.status().code(status.code());
            this.status().text(status.text());
        }

        public boolean checkHasStatus() {
            return (this.flags & 2) != 0;
        }

        public void applyHasStatus() {
            this.flags |= 2;
        }

        public int filterId() {
            return 2;
        }

        public int encode(EncodeIterator encIter) {
            this.elementList.clear();
            this.elementList.applyHasStandardData();
            int ret = this.elementList.encodeInit(encIter, null, 0);
            if (ret != 0) {
                return ret;
            }
            this.element.clear();
            this.element.name(ElementNames.SVC_STATE);
            this.element.dataType(4);
            this.tmpUInt.value(this.serviceState());
            ret = this.element.encode(encIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
            if (this.checkHasAcceptingRequests()) {
                this.element.clear();
                this.element.name(ElementNames.ACCEPTING_REQS);
                this.element.dataType(4);
                this.tmpUInt.value(this.acceptingRequests());
                ret = this.element.encode(encIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.checkHasStatus()) {
                this.element.clear();
                this.element.name(ElementNames.STATUS);
                this.element.dataType(13);
                ret = this.element.encode(encIter, this.status());
                if (ret != 0) {
                    return ret;
                }
            }
            if ((ret = this.elementList.encodeComplete(encIter, true)) < 0) {
                return ret;
            }
            return 0;
        }

        public int decode(DecodeIterator dIter) {
            this.elementList.clear();
            this.element.clear();
            int ret = this.elementList.decode(dIter, null);
            if (ret < 0) {
                return ret;
            }
            boolean foundServiceState = false;
            while ((ret = this.element.decode(dIter)) != 14) {
                if (ret != 0) {
                    return ret;
                }
                if (this.element.name().equals(ElementNames.SVC_STATE)) {
                    ret = this.tmpUInt.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    this.serviceState(this.tmpUInt.toLong());
                    foundServiceState = true;
                    continue;
                }
                if (this.element.name().equals(ElementNames.ACCEPTING_REQS)) {
                    ret = this.tmpUInt.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    this.applyHasAcceptingRequests();
                    this.acceptingRequests(this.tmpUInt.toLong());
                    continue;
                }
                if (!this.element.name().equals(ElementNames.STATUS)) continue;
                ret = this.tmpStatus.decode(dIter);
                if (ret != 0 && ret != 15) {
                    return ret;
                }
                this.status().streamState(this.tmpStatus.streamState());
                this.status().dataState(this.tmpStatus.dataState());
                this.status().code(this.tmpStatus.code());
                if (this.tmpStatus.text().length() > 0) {
                    Buffer text = this.tmpStatus.text();
                    this.status().text().data(text.data(), text.position(), text.length());
                }
                this.applyHasStatus();
            }
            if (!foundServiceState) {
                return -1;
            }
            return 0;
        }
    }

    public static class ServiceLoadFlags {
        public static final int NONE = 0;
        public static final int HAS_OPEN_LIMIT = 1;
        public static final int HAS_OPEN_WINDOW = 2;
        public static final int HAS_LOAD_FACTOR = 4;

        private ServiceLoadFlags() {
            throw new AssertionError();
        }
    }

    public static class ServiceLoad {
        private long openLimit;
        private long openWindow;
        private long loadFactor;
        private int action;
        private int flags;
        private ElementList elementList = CodecFactory.createElementList();
        private ElementEntry element = CodecFactory.createElementEntry();
        private UInt tmpUInt = CodecFactory.createUInt();
        private StringBuilder stringBuf = new StringBuilder();
        private static final String eol = "\n";
        private static final String tab = "\t";

        public ServiceLoad() {
            this.clear();
        }

        public void clear() {
            this.flags = 0;
            this.action = 2;
            this.openLimit = 0xFFFFFFFFL;
            this.openWindow = 0xFFFFFFFFL;
            this.loadFactor = 65535L;
        }

        public String toString() {
            this.stringBuf.setLength(0);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("LoadFilter:");
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("OpenLimit: ");
            this.stringBuf.append(this.openLimit());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("OpenWindow: ");
            this.stringBuf.append(this.openWindow());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("LoadFactor: ");
            this.stringBuf.append(this.loadFactor());
            this.stringBuf.append(eol);
            return this.stringBuf.toString();
        }

        public int flags() {
            return this.flags;
        }

        public void flags(int flags) {
            this.flags = flags;
        }

        public int action() {
            return this.action;
        }

        public void action(int action) {
            this.action = action;
        }

        public long openLimit() {
            return this.openLimit;
        }

        public void openLimit(long openLimit) {
            assert (this.checkHasOpenLimit());
            this.openLimit = openLimit;
        }

        public boolean checkHasOpenLimit() {
            return (this.flags & 1) != 0;
        }

        public void applyHasOpenLimit() {
            this.flags |= 1;
        }

        public long openWindow() {
            return this.openWindow;
        }

        public void openWindow(long openWindow) {
            assert (this.checkHasOpenWindow());
            this.openWindow = openWindow;
        }

        public boolean checkHasOpenWindow() {
            return (this.flags & 2) != 0;
        }

        public void applyHasOpenWindow() {
            this.flags |= 2;
        }

        public long loadFactor() {
            return this.loadFactor;
        }

        public void loadFactor(long loadFactor) {
            assert (this.checkHasLoadFactor());
            this.loadFactor = loadFactor;
        }

        public boolean checkHasLoadFactor() {
            return (this.flags & 4) != 0;
        }

        public void applyHasLoadFactor() {
            this.flags |= 4;
        }

        public int copy(ServiceLoad destServiceLoad) {
            assert (destServiceLoad != null) : "destServiceLoad can not be null";
            destServiceLoad.clear();
            if (this.checkHasLoadFactor()) {
                destServiceLoad.applyHasLoadFactor();
                destServiceLoad.loadFactor(this.loadFactor());
            }
            if (this.checkHasOpenLimit()) {
                destServiceLoad.applyHasOpenLimit();
                destServiceLoad.openLimit(this.openLimit());
            }
            if (this.checkHasOpenWindow()) {
                destServiceLoad.applyHasOpenWindow();
                destServiceLoad.openWindow(this.openWindow());
            }
            destServiceLoad.action(this.action());
            return 0;
        }

        public int update(ServiceLoad destServiceLoad) {
            assert (destServiceLoad != null) : "destServiceLoad can not be null";
            if (this.checkHasLoadFactor()) {
                destServiceLoad.applyHasLoadFactor();
                destServiceLoad.loadFactor(this.loadFactor());
            }
            if (this.checkHasOpenLimit()) {
                destServiceLoad.applyHasOpenLimit();
                destServiceLoad.openLimit(this.openLimit());
            }
            if (this.checkHasOpenWindow()) {
                destServiceLoad.applyHasOpenWindow();
                destServiceLoad.openWindow(this.openWindow());
            }
            destServiceLoad.action(this.action());
            return 0;
        }

        public int filterId() {
            return 4;
        }

        public int encode(EncodeIterator encIter) {
            this.elementList.clear();
            this.elementList.applyHasStandardData();
            int ret = this.elementList.encodeInit(encIter, null, 0);
            if (ret != 0) {
                return ret;
            }
            if (this.checkHasOpenLimit()) {
                this.element.clear();
                this.element.name(ElementNames.OPEN_LIMIT);
                this.element.dataType(4);
                this.tmpUInt.value(this.openLimit());
                ret = this.element.encode(encIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.checkHasOpenWindow()) {
                this.element.clear();
                this.element.name(ElementNames.OPEN_WINDOW);
                this.element.dataType(4);
                this.tmpUInt.value(this.openWindow());
                ret = this.element.encode(encIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.checkHasLoadFactor()) {
                this.element.clear();
                this.element.name(ElementNames.LOAD_FACT);
                this.element.dataType(4);
                this.tmpUInt.value(this.loadFactor());
                ret = this.element.encode(encIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if ((ret = this.elementList.encodeComplete(encIter, true)) < 0) {
                return ret;
            }
            return 0;
        }

        public int decode(DecodeIterator dIter) {
            this.elementList.clear();
            this.element.clear();
            int ret = this.elementList.decode(dIter, null);
            if (ret < 0) {
                return ret;
            }
            while ((ret = this.element.decode(dIter)) != 14) {
                if (ret != 0) {
                    return ret;
                }
                if (this.element.name().equals(ElementNames.OPEN_LIMIT)) {
                    ret = this.tmpUInt.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    this.applyHasOpenLimit();
                    this.openLimit(this.tmpUInt.toLong());
                    continue;
                }
                if (this.element.name().equals(ElementNames.OPEN_WINDOW)) {
                    ret = this.tmpUInt.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    this.applyHasOpenWindow();
                    this.openWindow(this.tmpUInt.toLong());
                    continue;
                }
                if (!this.element.name().equals(ElementNames.LOAD_FACT)) continue;
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0 && ret != 15) {
                    return ret;
                }
                this.applyHasLoadFactor();
                this.loadFactor(this.tmpUInt.toLong());
            }
            return 0;
        }
    }

    public static class RDMMCAddressPortInfo {
        private List<Buffer> address = new ArrayList<Buffer>();
        private List<Long> port = new ArrayList<Long>();
        private List<Long> domain = new ArrayList<Long>();
        private int addressCount = 0;

        RDMMCAddressPortInfo() {
        }

        List<Buffer> addressList() {
            return this.address;
        }

        Buffer address(int location) {
            return this.address.get(location);
        }

        void address(Buffer setAddress, int location) {
            this.address.add(location, CodecFactory.createBuffer());
            this.address.get(location).data(ByteBuffer.allocate(setAddress.length()));
            setAddress.copy(this.address.get(location));
        }

        int addressCount() {
            return this.addressCount;
        }

        void addressCount(int setAddressCount) {
            this.addressCount = setAddressCount;
        }

        void incrementAddressCount() {
            ++this.addressCount;
        }

        List<Long> port() {
            return this.port;
        }

        Long port(int location) {
            return this.port.get(location);
        }

        void port(Long setPort, int location) {
            this.port.add(location, setPort);
        }

        List<Long> domain() {
            return this.domain;
        }

        Long domain(int location) {
            return this.domain.get(location);
        }

        void domain(Long setDomains, int location) {
            this.domain.add(location, setDomains);
        }

        void clear() {
            this.address.clear();
            this.port.clear();
            this.domain.clear();
            this.addressCount = 0;
        }
    }

    public static class RDMAddressPortInfo {
        private Buffer address = CodecFactory.createBuffer();
        private Long port = 0L;

        RDMAddressPortInfo() {
        }

        Buffer address() {
            return this.address;
        }

        void address(Buffer setAddress) {
            this.address.data(ByteBuffer.allocate(setAddress.length()));
            setAddress.copy(this.address);
        }

        Long port() {
            return this.port;
        }

        void port(Long setPort) {
            this.port = setPort;
        }

        void clear() {
            this.address = CodecFactory.createBuffer();
            this.port = 0L;
        }
    }

    public static class ServiceSeqMcastInfo {
        private static final int RDM_SVC_SMF_HAS_SNAPSHOT_SERV = 1;
        private static final int RDM_SVC_SMF_HAS_GAP_REC_SERV = 2;
        private static final int RDM_SVC_SMF_HAS_REF_DATA_SERV = 4;
        private static final int RDM_SVC_SMF_HAS_SMC_SERV = 8;
        private static final int RDM_SVC_SMF_HAS_GMC_SERV = 16;
        private List<ServiceLink> linkList;
        private int action;
        private static final String eol = "\n";
        private static final String tab = "\t";
        private StringBuilder stringBuf = new StringBuilder();
        private Buffer mapKey = CodecFactory.createBuffer();
        private Map linkMap = CodecFactory.createMap();
        private MapEntry linkMapEntry = CodecFactory.createMapEntry();
        private int flags;
        private FilterEntryActions actions;
        private RDMAddressPortInfo snapshotServer = new RDMAddressPortInfo();
        private RDMAddressPortInfo gapRecoveryServer = new RDMAddressPortInfo();
        private RDMAddressPortInfo refDataServer = new RDMAddressPortInfo();
        private int StreamingMCastChanServerCount;
        private RDMMCAddressPortInfo StreamingMcastChanServerList = new RDMMCAddressPortInfo();
        private int GapMCastChanServerCount;
        private RDMMCAddressPortInfo GapMCastChanServerList = new RDMMCAddressPortInfo();

        public ServiceSeqMcastInfo() {
            this.linkList = new ArrayList<ServiceLink>();
        }

        public List<ServiceLink> linkList() {
            return this.linkList;
        }

        public void linkList(List<ServiceLink> linkList) {
            assert (linkList != null) : "linkList can not be null";
            this.linkList().clear();
            for (ServiceLink serviceLink : linkList) {
                this.linkList().add(serviceLink);
            }
        }

        public void action(int action) {
            this.action = action;
        }

        public int action() {
            return this.action;
        }

        public int encode(EncodeIterator encIter) {
            this.linkMap.clear();
            this.linkMap.flags(0);
            this.linkMap.containerType(133);
            this.linkMap.keyPrimitiveType(17);
            int ret = this.linkMap.encodeInit(encIter, 0, 0);
            if (ret != 0) {
                return ret;
            }
            for (ServiceLink serviceLink : this.linkList()) {
                this.linkMapEntry.clear();
                this.linkMapEntry.flags(0);
                this.linkMapEntry.action(serviceLink.action());
                if (this.linkMapEntry.action() == 3) {
                    ret = this.linkMapEntry.encode(encIter, serviceLink.name());
                    if (ret == 0) continue;
                    return ret;
                }
                ret = this.linkMapEntry.encodeInit(encIter, serviceLink.name(), 0);
                if (ret != 0) {
                    return ret;
                }
                ret = serviceLink.encode(encIter);
                if (ret != 0) {
                    return ret;
                }
                ret = this.linkMapEntry.encodeComplete(encIter, true);
                if (ret == 0) continue;
                return ret;
            }
            return this.linkMap.encodeComplete(encIter, true);
        }

        public int decode(DecodeIterator dIter) {
            int ret;
            ServiceSeqMcast seqMcast = new ServiceSeqMcast();
            seqMcast.name().data(this.mapKey.data(), this.mapKey.position(), this.mapKey.length());
            seqMcast.action(this.linkMapEntry.action());
            if (seqMcast.action() != 3 && (ret = seqMcast.decode(dIter)) != 0) {
                return ret;
            }
            this.flags = seqMcast.seqMcastInfo().flags;
            this.actions = seqMcast.seqMcastInfo().actions;
            this.snapshotServer = seqMcast.seqMcastInfo().snapshotServer;
            this.gapRecoveryServer = seqMcast.seqMcastInfo().gapRecoveryServer;
            this.refDataServer = seqMcast.seqMcastInfo().refDataServer;
            this.StreamingMCastChanServerCount = seqMcast.seqMcastInfo().StreamingMCastChanServerCount;
            this.StreamingMcastChanServerList = seqMcast.seqMcastInfo().StreamingMcastChanServerList;
            this.GapMCastChanServerCount = seqMcast.seqMcastInfo().GapMCastChanServerCount;
            this.GapMCastChanServerList = seqMcast.seqMcastInfo().GapMCastChanServerList;
            return 0;
        }

        public void clear() {
            this.linkList.clear();
        }

        public String toString() {
            for (ServiceLink link : this.linkList) {
                this.stringBuf.append(tab);
                this.stringBuf.append(tab);
                this.stringBuf.append("LinkFilter: ");
                this.stringBuf.append(eol);
                this.stringBuf.append(link);
            }
            return this.stringBuf.toString();
        }

        public int copy(ServiceLinkInfo destServiceLinkInfo) {
            assert (destServiceLinkInfo != null) : "destServiceLinkInfo can not be null";
            destServiceLinkInfo.clear();
            destServiceLinkInfo.action(this.action());
            int ret = 0;
            for (ServiceLink serviceLink : this.linkList()) {
                ServiceLink serviceLink2;
                ret = serviceLink.copy(serviceLink2 = new ServiceLink());
                if (ret != 0) {
                    return ret;
                }
                destServiceLinkInfo.linkList().add(serviceLink2);
            }
            return ret;
        }

        public Buffer snapshotServerAddress() {
            return this.snapshotServer.address();
        }

        public Long snapshotServerPort() {
            return this.snapshotServer.port();
        }

        public Buffer refDataServerAddress() {
            return this.refDataServer.address();
        }

        public Long refDataServerPort() {
            return this.refDataServer.port();
        }

        public Buffer gapRecoveryServerAddress() {
            return this.gapRecoveryServer.address();
        }

        public Long gapRecoveryServerPort() {
            return this.gapRecoveryServer.port();
        }

        public List<Buffer> gapMCastChanServerList() {
            return this.GapMCastChanServerList.addressList();
        }

        public int gapMCastChanServerCount() {
            return this.GapMCastChanServerCount;
        }

        public List<Long> gapMCastChanPortList() {
            return this.GapMCastChanServerList.port();
        }

        public List<Long> gapMCastChanDomainList() {
            return this.GapMCastChanServerList.domain();
        }

        public List<Buffer> streamingMCastChanServerList() {
            return this.StreamingMcastChanServerList.addressList();
        }

        public List<Long> streamingMCastChanPortList() {
            return this.StreamingMcastChanServerList.port();
        }

        public int streamingMCastChanServerCount() {
            return this.StreamingMCastChanServerCount;
        }

        public List<Long> streamingMCastChanDomainList() {
            return this.StreamingMcastChanServerList.domain();
        }
    }

    public static class ServiceSeqMcastFlags {
        public static final int NONE = 0;
        public static final int HAS_TYPE = 1;
        public static final int HAS_CODE = 2;
        public static final int HAS_TEXT = 4;

        private ServiceSeqMcastFlags() {
            throw new AssertionError();
        }
    }

    public static class ServiceSeqMcast {
        private Buffer name;
        private long type;
        private long linkState;
        private long linkCode;
        private boolean foundSnapshotPort = false;
        private boolean foundSnapshotAddr = false;
        private boolean foundGapRecPort = false;
        private boolean foundGapRecAddr = false;
        private boolean foundRefDataPort = false;
        private boolean foundRefDataAddr = false;
        private Buffer text;
        private int flags;
        private int action;
        private static final String eol = "\n";
        private static final String tab = "\t";
        private StringBuilder stringBuf = new StringBuilder();
        private Vector vector = CodecFactory.createVector();
        private VectorEntry vectorEntry = CodecFactory.createVectorEntry();
        private ElementList vectorElementList = CodecFactory.createElementList();
        private ElementList elementList = CodecFactory.createElementList();
        private ElementEntry element = CodecFactory.createElementEntry();
        private UInt tmpUInt = CodecFactory.createUInt();
        private Buffer tmpBuffer = CodecFactory.createBuffer();
        private boolean foundPort = false;
        private boolean foundMCGroup = false;
        private boolean foundDomain = false;
        private LocalElementSetDefDb elementSetDefDb = CodecFactory.createLocalElementSetDefDb();
        public ServiceSeqMcastInfo seqMcastInfo = new ServiceSeqMcastInfo();

        public ServiceSeqMcast() {
            this.text = CodecFactory.createBuffer();
            this.name = CodecFactory.createBuffer();
            this.clear();
        }

        public ServiceSeqMcastInfo seqMcastInfo() {
            return this.seqMcastInfo;
        }

        public String toString() {
            this.stringBuf.setLength(0);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("Name: ");
            this.stringBuf.append(this.name());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("Snapshort Address:Port: ");
            this.stringBuf.append(this.seqMcastInfo.snapshotServer.address().data().array());
            this.stringBuf.append(":");
            this.stringBuf.append(this.seqMcastInfo.snapshotServer.port());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("Gap Receive Address:Port: ");
            this.stringBuf.append(this.seqMcastInfo.gapRecoveryServer.address().data().array());
            this.stringBuf.append(":");
            this.stringBuf.append(this.seqMcastInfo.gapRecoveryServer.port());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("Reference Data Address:Port: ");
            this.stringBuf.append(this.seqMcastInfo.refDataServer.address().data().array());
            this.stringBuf.append(":");
            this.stringBuf.append(this.seqMcastInfo.refDataServer.port());
            this.stringBuf.append(eol);
            return this.stringBuf.toString();
        }

        public void clear() {
            this.flags = 0;
            this.name.clear();
            this.type = 1L;
            this.linkState = 0L;
            this.linkCode = 0L;
            this.text.clear();
            this.action = 2;
        }

        public int copy(ServiceLink destServiceLink) {
            assert (destServiceLink != null) : "destServiceLink can not be null";
            if (this.checkHasCode()) {
                destServiceLink.applyHasCode();
                destServiceLink.linkCode(this.linkCode());
            }
            if (this.checkHasText()) {
                destServiceLink.applyHasText();
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.text().length());
                this.text().copy(byteBuffer);
                destServiceLink.text().data(byteBuffer);
            }
            if (this.checkHasType()) {
                destServiceLink.applyHasType();
                destServiceLink.type(this.type());
            }
            destServiceLink.linkState(this.linkState());
            return 0;
        }

        public Buffer name() {
            return this.name;
        }

        public void name(Buffer name) {
            assert (name != null) : "name can not be null";
            this.text().data(name.data(), name.position(), name.length());
        }

        public long type() {
            return this.type;
        }

        public void type(long type) {
            assert (this.checkHasType());
            this.type = type;
        }

        public long linkState() {
            return this.linkState;
        }

        public void linkState(long linkState) {
            this.linkState = linkState;
        }

        public long linkCode() {
            return this.linkCode;
        }

        public void linkCode(long linkCode) {
            assert (this.checkHasCode());
            this.linkCode = linkCode;
        }

        public Buffer text() {
            return this.text;
        }

        public void text(Buffer text) {
            assert (text != null) : "text can not be null";
            this.text().data(text.data(), text.position(), text.length());
        }

        public int flags() {
            return this.flags;
        }

        public void flags(int flags) {
            this.flags = flags;
        }

        public int filterId() {
            return 6;
        }

        public int encode(EncodeIterator encIter) {
            this.elementList.clear();
            this.elementList.applyHasStandardData();
            int ret = this.elementList.encodeInit(encIter, null, 0);
            if (ret != 0) {
                return ret;
            }
            if (this.checkHasCode()) {
                this.element.clear();
                this.element.name(ElementNames.LINK_CODE);
                this.element.dataType(4);
                this.tmpUInt.value(this.linkCode());
                ret = this.element.encode(encIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.checkHasText()) {
                this.element.clear();
                this.element.name(ElementNames.TEXT);
                this.element.dataType(17);
                ret = this.element.encode(encIter, this.text());
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.checkHasType()) {
                this.element.clear();
                this.element.name(ElementNames.TYPE);
                this.element.dataType(4);
                this.tmpUInt.value(this.type());
                ret = this.element.encode(encIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            this.element.clear();
            this.element.name(ElementNames.LINK_STATE);
            this.element.dataType(4);
            this.tmpUInt.value(this.linkState());
            ret = this.element.encode(encIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
            return this.elementList.encodeComplete(encIter, true);
        }

        public boolean checkHasText() {
            return (this.flags & 4) != 0;
        }

        public void applyHasText() {
            this.flags |= 4;
        }

        public boolean checkHasCode() {
            return (this.flags & 2) != 0;
        }

        public void applyHasCode() {
            this.flags |= 2;
        }

        public boolean checkHasType() {
            return (this.flags & 1) != 0;
        }

        public void applyHasType() {
            this.flags |= 1;
        }

        public int decode(DecodeIterator dIter) {
            this.elementList.clear();
            this.element.clear();
            int ret = this.elementList.decode(dIter, null);
            if (ret != 0) {
                return ret;
            }
            while ((ret = this.element.decode(dIter)) != 14) {
                if (ret != 0) {
                    return ret;
                }
                if (this.element.name().equals(ElementNames.SNAPSHOT_SERVER_HOST)) {
                    ret = this.tmpBuffer.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    this.seqMcastInfo.snapshotServer.address(this.tmpBuffer);
                    this.foundSnapshotAddr = true;
                } else if (this.element.name().equals(ElementNames.SNAPSHOT_SERVER_PORT)) {
                    ret = this.tmpUInt.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    this.seqMcastInfo.snapshotServer.port(this.tmpUInt.toLong());
                    this.foundSnapshotPort = true;
                } else if (this.element.name().equals(ElementNames.GAP_RECOVERY_SERVER_HOST)) {
                    ret = this.tmpBuffer.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    this.seqMcastInfo.gapRecoveryServer.address(this.tmpBuffer);
                    this.foundGapRecAddr = true;
                } else if (this.element.name().equals(ElementNames.GAP_RECOVERY_SERVER_PORT)) {
                    ret = this.tmpUInt.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    this.seqMcastInfo.gapRecoveryServer.port(this.tmpUInt.toLong());
                    this.foundGapRecPort = true;
                } else if (this.element.name().equals(ElementNames.REFERENCE_DATA_SERVER_HOST)) {
                    ret = this.tmpBuffer.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    this.tmpBuffer.copy(this.seqMcastInfo.refDataServer.address);
                    this.foundRefDataAddr = true;
                } else if (this.element.name().equals(ElementNames.REFERENCE_DATA_SERVER_PORT)) {
                    ret = this.tmpUInt.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    this.seqMcastInfo.refDataServer.port(this.tmpUInt.toLong());
                    this.foundRefDataPort = true;
                } else if (this.element.name().equals(ElementNames.STREAMING_MCAST_CHANNELS)) {
                    this.vector.clear();
                    ret = this.vector.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    if (this.vector.checkHasSetDefs()) {
                        this.elementSetDefDb.clear();
                        this.elementSetDefDb.decode(dIter);
                    }
                    this.vectorEntry.clear();
                    ret = this.vectorEntry.decode(dIter);
                    if (ret != 14) {
                        this.foundPort = false;
                        this.foundMCGroup = false;
                        this.foundDomain = false;
                        do {
                            this.vectorElementList.clear();
                            this.vectorElementList.decode(dIter, this.elementSetDefDb);
                            while ((ret = this.element.decode(dIter)) != 14) {
                                if (this.element.name().equals(ElementNames.MULTICAST_GROUP)) {
                                    ret = this.tmpBuffer.decode(dIter);
                                    if (ret != 0 && ret != 15) {
                                        return ret;
                                    }
                                    this.seqMcastInfo.StreamingMcastChanServerList.address(this.tmpBuffer, this.seqMcastInfo.streamingMCastChanServerCount());
                                    this.foundMCGroup = true;
                                    continue;
                                }
                                if (this.element.name().equals(ElementNames.PORT)) {
                                    ret = this.tmpUInt.decode(dIter);
                                    if (ret != 0 && ret != 15) {
                                        return ret;
                                    }
                                    this.seqMcastInfo.StreamingMcastChanServerList.port(this.tmpUInt.toLong(), this.seqMcastInfo.streamingMCastChanServerCount());
                                    this.foundPort = true;
                                    continue;
                                }
                                if (!this.element.name().equals(ElementNames.DOMAIN)) continue;
                                ret = this.tmpUInt.decode(dIter);
                                if (ret != 0 && ret != 15) {
                                    return ret;
                                }
                                this.seqMcastInfo.StreamingMcastChanServerList.domain(this.tmpUInt.toLong(), this.seqMcastInfo.streamingMCastChanServerCount());
                                this.foundDomain = true;
                            }
                            this.seqMcastInfo.StreamingMCastChanServerCount++;
                        } while ((ret = this.vectorEntry.decode(dIter)) != 14);
                        if (this.foundPort && this.foundMCGroup && this.foundDomain) {
                            this.seqMcastInfo.flags |= 8;
                        }
                    }
                } else if (this.element.name().equals(ElementNames.GAP_MCAST_CHANNELS)) {
                    this.vector.clear();
                    ret = this.vector.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    if (this.vector.checkHasSetDefs()) {
                        this.elementSetDefDb.clear();
                        this.elementSetDefDb.decode(dIter);
                    }
                    this.vectorEntry.clear();
                    ret = this.vectorEntry.decode(dIter);
                    if (ret != 14) {
                        this.foundPort = false;
                        this.foundMCGroup = false;
                        this.foundDomain = false;
                        do {
                            this.vectorElementList.clear();
                            this.vectorElementList.decode(dIter, this.elementSetDefDb);
                            while ((ret = this.element.decode(dIter)) != 14) {
                                if (this.element.name().equals(ElementNames.MULTICAST_GROUP)) {
                                    ret = this.tmpBuffer.decode(dIter);
                                    if (ret != 0 && ret != 15) {
                                        return ret;
                                    }
                                    this.seqMcastInfo.GapMCastChanServerList.address(this.tmpBuffer, this.seqMcastInfo.gapMCastChanServerCount());
                                    this.foundMCGroup = true;
                                    continue;
                                }
                                if (this.element.name().equals(ElementNames.PORT)) {
                                    ret = this.tmpUInt.decode(dIter);
                                    if (ret != 0 && ret != 15) {
                                        return ret;
                                    }
                                    this.seqMcastInfo.GapMCastChanServerList.port(this.tmpUInt.toLong(), this.seqMcastInfo.gapMCastChanServerCount());
                                    this.foundPort = true;
                                    continue;
                                }
                                if (!this.element.name().equals(ElementNames.DOMAIN)) continue;
                                ret = this.tmpUInt.decode(dIter);
                                if (ret != 0 && ret != 15) {
                                    return ret;
                                }
                                this.seqMcastInfo.GapMCastChanServerList.domain(this.tmpUInt.toLong(), this.seqMcastInfo.gapMCastChanServerCount());
                                this.foundDomain = true;
                            }
                            this.seqMcastInfo.GapMCastChanServerCount++;
                        } while ((ret = this.vectorEntry.decode(dIter)) != 14);
                        if (this.foundPort && this.foundMCGroup && this.foundDomain) {
                            this.seqMcastInfo.flags |= 16;
                        }
                    }
                }
                if (this.foundSnapshotPort && this.foundSnapshotAddr) {
                    this.seqMcastInfo.flags |= 1;
                }
                if (this.foundGapRecPort && this.foundGapRecAddr) {
                    this.seqMcastInfo.flags |= 2;
                }
                if (!this.foundRefDataPort || !this.foundRefDataAddr) continue;
                this.seqMcastInfo.flags |= 4;
            }
            return 0;
        }

        public int action() {
            return this.action;
        }

        public void action(int action) {
            this.action = action;
        }
    }

    public static class ServiceLinkInfo {
        private List<ServiceLink> linkList;
        private int action;
        private static final String eol = "\n";
        private static final String tab = "\t";
        private StringBuilder stringBuf = new StringBuilder();
        private Buffer mapKey = CodecFactory.createBuffer();
        private Map linkMap = CodecFactory.createMap();
        private MapEntry linkMapEntry = CodecFactory.createMapEntry();

        public ServiceLinkInfo() {
            this.linkList = new ArrayList<ServiceLink>();
        }

        public List<ServiceLink> linkList() {
            return this.linkList;
        }

        public void linkList(List<ServiceLink> linkList) {
            assert (linkList != null) : "linkList can not be null";
            this.linkList().clear();
            for (ServiceLink serviceLink : linkList) {
                this.linkList().add(serviceLink);
            }
        }

        public void action(int action) {
            this.action = action;
        }

        public int action() {
            return this.action;
        }

        public int encode(EncodeIterator encIter) {
            this.linkMap.clear();
            this.linkMap.flags(0);
            this.linkMap.containerType(133);
            this.linkMap.keyPrimitiveType(17);
            int ret = this.linkMap.encodeInit(encIter, 0, 0);
            if (ret != 0) {
                return ret;
            }
            for (ServiceLink serviceLink : this.linkList()) {
                this.linkMapEntry.clear();
                this.linkMapEntry.flags(0);
                this.linkMapEntry.action(serviceLink.action());
                if (this.linkMapEntry.action() == 3) {
                    ret = this.linkMapEntry.encode(encIter, serviceLink.name());
                    if (ret == 0) continue;
                    return ret;
                }
                ret = this.linkMapEntry.encodeInit(encIter, serviceLink.name(), 0);
                if (ret != 0) {
                    return ret;
                }
                ret = serviceLink.encode(encIter);
                if (ret != 0) {
                    return ret;
                }
                ret = this.linkMapEntry.encodeComplete(encIter, true);
                if (ret == 0) continue;
                return ret;
            }
            return this.linkMap.encodeComplete(encIter, true);
        }

        public int decode(DecodeIterator dIter) {
            this.clear();
            this.linkMap.clear();
            this.linkMapEntry.clear();
            this.mapKey.clear();
            int ret = this.linkMap.decode(dIter);
            if (ret != 0) {
                return ret;
            }
            if (this.linkMap.containerType() != 133 || this.linkMap.keyPrimitiveType() != 16 && this.linkMap.keyPrimitiveType() != 17) {
                return -1;
            }
            while ((ret = this.linkMapEntry.decode(dIter, (Object)this.mapKey)) != 14) {
                if (ret != 0 && ret != 15) {
                    return ret;
                }
                ServiceLink serviceLink = new ServiceLink();
                serviceLink.name().data(this.mapKey.data(), this.mapKey.position(), this.mapKey.length());
                serviceLink.action(this.linkMapEntry.action());
                if (serviceLink.action() == 3) continue;
                ret = serviceLink.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.linkList().add(serviceLink);
            }
            return 0;
        }

        public void clear() {
            this.linkList.clear();
        }

        public String toString() {
            for (ServiceLink link : this.linkList) {
                this.stringBuf.append(tab);
                this.stringBuf.append(tab);
                this.stringBuf.append("LinkFilter: ");
                this.stringBuf.append(eol);
                this.stringBuf.append(link);
            }
            return this.stringBuf.toString();
        }

        public int copy(ServiceLinkInfo destServiceLinkInfo) {
            assert (destServiceLinkInfo != null) : "destServiceLinkInfo can not be null";
            destServiceLinkInfo.clear();
            destServiceLinkInfo.action(this.action());
            int ret = 0;
            for (ServiceLink serviceLink : this.linkList()) {
                ServiceLink serviceLink2;
                ret = serviceLink.copy(serviceLink2 = new ServiceLink());
                if (ret != 0) {
                    return ret;
                }
                destServiceLinkInfo.linkList().add(serviceLink2);
            }
            return ret;
        }

        public int update(ServiceLinkInfo destServiceLinkInfo) {
            assert (destServiceLinkInfo != null) : "destServiceLinkInfo can not be null";
            int ret = 0;
            destServiceLinkInfo.action(this.action());
            block4: for (int i = 0; i < this.linkList().size(); ++i) {
                switch (this.linkList().get(i).action()) {
                    case 1: 
                    case 2: {
                        int j;
                        boolean foundService = false;
                        for (j = 0; j < destServiceLinkInfo.linkList().size(); ++j) {
                            if (!destServiceLinkInfo.linkList().get(j).name().equals(this.linkList().get(i).name())) continue;
                            ret = this.linkList().get(i).copy(destServiceLinkInfo.linkList().get(j));
                            foundService = true;
                            break;
                        }
                        if (ret != 0) {
                            return ret;
                        }
                        if (foundService) continue block4;
                        ServiceLink serviceLink = new ServiceLink();
                        destServiceLinkInfo.linkList().add(serviceLink);
                        ret = this.linkList().get(i).copy(serviceLink);
                        if (ret == 0) continue block4;
                        return ret;
                    }
                    case 3: {
                        int j;
                        for (j = 0; j < destServiceLinkInfo.linkList().size(); ++j) {
                            if (!destServiceLinkInfo.linkList().get(j).name().equals(this.linkList().get(i).name())) continue;
                            destServiceLinkInfo.linkList().remove(j);
                            continue block4;
                        }
                        continue block4;
                    }
                }
            }
            return ret;
        }
    }

    public static class ServiceLinkFlags {
        public static final int NONE = 0;
        public static final int HAS_TYPE = 1;
        public static final int HAS_CODE = 2;
        public static final int HAS_TEXT = 4;

        private ServiceLinkFlags() {
            throw new AssertionError();
        }
    }

    public static class ServiceLink {
        private Buffer name;
        private long type;
        private long linkState;
        private long linkCode;
        private Buffer text;
        private int flags;
        private int action;
        private static final String eol = "\n";
        private static final String tab = "\t";
        private StringBuilder stringBuf = new StringBuilder();
        private ElementList elementList = CodecFactory.createElementList();
        private ElementEntry element = CodecFactory.createElementEntry();
        private UInt tmpUInt = CodecFactory.createUInt();

        public ServiceLink() {
            this.text = CodecFactory.createBuffer();
            this.name = CodecFactory.createBuffer();
            this.clear();
        }

        public String toString() {
            this.stringBuf.setLength(0);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("Name: ");
            this.stringBuf.append(this.name());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("LinkType: ");
            this.stringBuf.append(this.type());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("LinkState: ");
            this.stringBuf.append(this.linkState());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("LinkCode: ");
            this.stringBuf.append(this.linkCode());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("LinkText: ");
            this.stringBuf.append(this.text());
            this.stringBuf.append(eol);
            return this.stringBuf.toString();
        }

        public void clear() {
            this.flags = 0;
            this.name.clear();
            this.type = 1L;
            this.linkState = 0L;
            this.linkCode = 0L;
            this.text.clear();
            this.action = 2;
        }

        public int copy(ServiceLink destServiceLink) {
            assert (destServiceLink != null) : "destServiceLink can not be null";
            if (this.checkHasCode()) {
                destServiceLink.applyHasCode();
                destServiceLink.linkCode(this.linkCode());
            }
            if (this.checkHasText()) {
                destServiceLink.applyHasText();
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.text().length());
                this.text().copy(byteBuffer);
                destServiceLink.text().data(byteBuffer);
            }
            if (this.checkHasType()) {
                destServiceLink.applyHasType();
                destServiceLink.type(this.type());
            }
            ByteBuffer nameBytebuffer = ByteBuffer.allocate(this.name().length());
            this.name().copy(nameBytebuffer);
            destServiceLink.name.data(nameBytebuffer);
            destServiceLink.linkState(this.linkState());
            return 0;
        }

        public Buffer name() {
            return this.name;
        }

        public void name(Buffer name) {
            assert (name != null) : "name can not be null";
            this.name().data(name.data(), name.position(), name.length());
        }

        public long type() {
            return this.type;
        }

        public void type(long type) {
            assert (this.checkHasType());
            this.type = type;
        }

        public long linkState() {
            return this.linkState;
        }

        public void linkState(long linkState) {
            this.linkState = linkState;
        }

        public long linkCode() {
            return this.linkCode;
        }

        public void linkCode(long linkCode) {
            assert (this.checkHasCode());
            this.linkCode = linkCode;
        }

        @Deprecated
        public Buffer linkText() {
            return this.text;
        }

        public Buffer text() {
            return this.text;
        }

        public void text(Buffer text) {
            assert (text != null) : "text can not be null";
            this.text().data(text.data(), text.position(), text.length());
        }

        public int flags() {
            return this.flags;
        }

        public void flags(int flags) {
            this.flags = flags;
        }

        public int filterId() {
            return 6;
        }

        public int encode(EncodeIterator encIter) {
            this.elementList.clear();
            this.elementList.applyHasStandardData();
            int ret = this.elementList.encodeInit(encIter, null, 0);
            if (ret != 0) {
                return ret;
            }
            if (this.checkHasCode()) {
                this.element.clear();
                this.element.name(ElementNames.LINK_CODE);
                this.element.dataType(4);
                this.tmpUInt.value(this.linkCode());
                ret = this.element.encode(encIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.checkHasText()) {
                this.element.clear();
                this.element.name(ElementNames.TEXT);
                this.element.dataType(17);
                ret = this.element.encode(encIter, this.text());
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.checkHasType()) {
                this.element.clear();
                this.element.name(ElementNames.TYPE);
                this.element.dataType(4);
                this.tmpUInt.value(this.type());
                ret = this.element.encode(encIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            this.element.clear();
            this.element.name(ElementNames.LINK_STATE);
            this.element.dataType(4);
            this.tmpUInt.value(this.linkState());
            ret = this.element.encode(encIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
            return this.elementList.encodeComplete(encIter, true);
        }

        public boolean checkHasText() {
            return (this.flags & 4) != 0;
        }

        public void applyHasText() {
            this.flags |= 4;
        }

        public boolean checkHasCode() {
            return (this.flags & 2) != 0;
        }

        public void applyHasCode() {
            this.flags |= 2;
        }

        public boolean checkHasType() {
            return (this.flags & 1) != 0;
        }

        public void applyHasType() {
            this.flags |= 1;
        }

        public int decode(DecodeIterator dIter) {
            this.elementList.clear();
            this.element.clear();
            int ret = this.elementList.decode(dIter, null);
            if (ret != 0) {
                return ret;
            }
            while ((ret = this.element.decode(dIter)) != 14) {
                if (ret != 0) {
                    return ret;
                }
                if (this.element.name().equals(ElementNames.TYPE)) {
                    ret = this.tmpUInt.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    this.applyHasType();
                    this.type(this.tmpUInt.toLong());
                    continue;
                }
                if (this.element.name().equals(ElementNames.LINK_STATE)) {
                    ret = this.tmpUInt.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    this.linkState(this.tmpUInt.toLong());
                    continue;
                }
                if (this.element.name().equals(ElementNames.LINK_CODE)) {
                    ret = this.tmpUInt.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    this.applyHasCode();
                    this.linkCode(this.tmpUInt.toLong());
                    continue;
                }
                if (!this.element.name().equals(ElementNames.TEXT)) continue;
                Buffer encodedData = this.element.encodedData();
                this.text().data(encodedData.data(), encodedData.position(), encodedData.length());
                this.applyHasText();
            }
            return 0;
        }

        public int action() {
            return this.action;
        }

        public void action(int action) {
            this.action = action;
        }
    }

    public static class ServiceInfoFlags {
        public static final int NONE = 0;
        public static final int HAS_VENDOR = 1;
        public static final int HAS_IS_SOURCE = 2;
        public static final int HAS_DICTS_PROVIDED = 4;
        public static final int HAS_DICTS_USED = 8;
        public static final int HAS_QOS = 16;
        public static final int HAS_SUPPORT_QOS_RANGE = 32;
        public static final int HAS_ITEM_LIST = 64;
        public static final int HAS_SUPPORT_OOB_SNAPSHOTS = 128;
        public static final int HAS_ACCEPTING_CONS_STATUS = 256;

        private ServiceInfoFlags() {
            throw new AssertionError();
        }
    }

    public static class ServiceInfo {
        private int flags;
        private int action;
        private Buffer serviceName;
        private Buffer vendor;
        private long isSource;
        private List<Long> capabilitiesList;
        private List<String> dictionariesProvidedList;
        private List<String> dictionariesUsedList;
        private List<Qos> qosList;
        private Buffer itemList;
        private long supportsQosRange;
        private long supportsOutOfBandSnapshots = 1L;
        private long acceptingConsumerStatus = 1L;
        private StringBuilder stringBuf = new StringBuilder();
        private static final String eol = "\n";
        private static final String tab = "\t";
        private ElementList elementList = CodecFactory.createElementList();
        private ElementEntry element = CodecFactory.createElementEntry();
        private UInt tmpUInt = CodecFactory.createUInt();
        private Array array = CodecFactory.createArray();
        private ArrayEntry arrayEntry = CodecFactory.createArrayEntry();
        private Buffer tmpBuffer = CodecFactory.createBuffer();
        private Qos bestQos;

        public ServiceInfo() {
            this.capabilitiesList = new ArrayList<Long>();
            this.dictionariesProvidedList = new ArrayList<String>();
            this.dictionariesUsedList = new ArrayList<String>();
            this.qosList = new ArrayList<Qos>();
            this.serviceName = CodecFactory.createBuffer();
            this.vendor = CodecFactory.createBuffer();
            this.itemList = CodecFactory.createBuffer();
            this.clear();
        }

        public void clear() {
            this.flags = 0;
            this.action = 2;
            this.isSource = 0L;
            this.capabilitiesList.clear();
            this.dictionariesProvidedList.clear();
            this.dictionariesUsedList.clear();
            this.qosList.clear();
            this.serviceName.clear();
            this.itemList.clear();
            this.vendor.clear();
            this.supportsOutOfBandSnapshots = 1L;
            this.acceptingConsumerStatus = 1L;
            this.supportsQosRange = 0L;
            this.bestQos = null;
        }

        public Buffer serviceName() {
            return this.serviceName;
        }

        public void serviceName(Buffer serviceName) {
            assert (serviceName != null) : "serviceName can not be null";
            this.serviceName().data(serviceName.data(), serviceName.position(), serviceName.length());
        }

        public Buffer vendor() {
            return this.vendor;
        }

        public void vendor(Buffer vendor) {
            assert (vendor != null) : "vendor can not be null";
            this.vendor().data(vendor.data(), vendor.position(), vendor.length());
        }

        public void applyHasVendor() {
            this.flags |= 1;
        }

        public boolean checkHasVendor() {
            return (this.flags & 1) != 0;
        }

        public long isSource() {
            return this.isSource;
        }

        public void isSource(long isSource) {
            assert (this.checkHasIsSource());
            this.isSource = isSource;
        }

        public void applyHasIsSource() {
            this.flags |= 2;
        }

        public boolean checkHasIsSource() {
            return (this.flags & 2) != 0;
        }

        public long supportsQosRange() {
            return this.supportsQosRange;
        }

        public void supportsQosRange(long supportsQosRange) {
            assert (this.checkHasSupportsQosRange());
            this.supportsQosRange = supportsQosRange;
        }

        public void applyHasSupportsQosRange() {
            this.flags |= 0x20;
        }

        public boolean checkHasSupportsQosRange() {
            return (this.flags & 0x20) != 0;
        }

        public long supportsOutOfBandSnapshots() {
            return this.supportsOutOfBandSnapshots;
        }

        public void supportsOutOfBandSnapshots(long supportsOutOfBandSnapshots) {
            assert (this.checkHasSupportsOutOfBandSnapshots());
            this.supportsOutOfBandSnapshots = supportsOutOfBandSnapshots;
        }

        public void applyHasSupportsOutOfBandSnapshots() {
            this.flags |= 0x80;
        }

        public boolean checkHasSupportsOutOfBandSnapshots() {
            return (this.flags & 0x80) != 0;
        }

        public long acceptingConsumerStatus() {
            return this.acceptingConsumerStatus;
        }

        public void acceptingConsumerStatus(long acceptingConsumerStatus) {
            assert (this.checkHasAcceptingConsumerStatus());
            this.acceptingConsumerStatus = acceptingConsumerStatus;
            this.flags |= 0x100;
        }

        public void applyHasAcceptingConsumerStatus() {
            this.flags |= 0x100;
        }

        public boolean checkHasAcceptingConsumerStatus() {
            return (this.flags & 0x100) != 0;
        }

        public Buffer itemList() {
            return this.itemList;
        }

        public void itemList(Buffer itemList) {
            assert (itemList != null) : "itemList can not be null";
            this.itemList().data(itemList.data(), itemList.position(), itemList.length());
        }

        public void applyHasItemList() {
            this.flags |= 0x40;
        }

        public boolean checkHasItemList() {
            return (this.flags & 0x40) != 0;
        }

        public List<Long> capabilitiesList() {
            return this.capabilitiesList;
        }

        public void capabilitiesList(List<Long> capabilitiesList) {
            assert (capabilitiesList != null) : "capabilitiesList can not be null";
            this.capabilitiesList().clear();
            for (Long capability : capabilitiesList) {
                this.capabilitiesList().add(capability);
            }
        }

        public List<String> dictionariesProvidedList() {
            return this.dictionariesProvidedList;
        }

        public void dictionariesProvidedList(List<String> dictionariesProvidedList) {
            assert (dictionariesProvidedList != null) : "dictionariesProvidedList can not be null";
            this.dictionariesProvidedList().clear();
            for (String dictionaryProvided : dictionariesProvidedList) {
                this.dictionariesProvidedList().add(dictionaryProvided);
            }
        }

        public void applyHasDictionariesProvided() {
            this.flags |= 4;
        }

        public boolean checkHasDictionariesProvided() {
            return (this.flags & 4) != 0;
        }

        public List<String> dictionariesUsedList() {
            return this.dictionariesUsedList;
        }

        public void dictionariesUsedList(List<String> dictionariesUsedList) {
            assert (dictionariesUsedList != null) : "dictionariesUsedList can not be null";
            this.dictionariesUsedList().clear();
            for (String dictionaryUsed : dictionariesUsedList) {
                this.dictionariesUsedList().add(dictionaryUsed);
            }
        }

        public void applyHasDictionariesUsed() {
            this.flags |= 8;
        }

        public boolean checkHasDictionariesUsed() {
            return (this.flags & 8) != 0;
        }

        public List<Qos> qosList() {
            return this.qosList;
        }

        public void qosList(List<Qos> qosList) {
            assert (qosList != null) : "qosList can not be null";
            this.qosList().clear();
            for (Qos qos : qosList) {
                this.qosList().add(qos);
            }
        }

        public Qos bestQos() {
            if (this.bestQos == null) {
                this.bestQos = CodecFactory.createQos();
                for (Qos qos : this.qosList) {
                    if (!qos.isBetter(this.bestQos)) continue;
                    this.bestQos = qos;
                }
            }
            return this.bestQos;
        }

        public void applyHasQos() {
            this.flags |= 0x10;
        }

        public boolean checkHasQos() {
            return (this.flags & 0x10) != 0;
        }

        public int action() {
            return this.action;
        }

        public void action(int action) {
            this.action = action;
        }

        public int flags() {
            return this.flags;
        }

        public void flags(int flags) {
            this.flags = flags;
        }

        public int filterId() {
            return 1;
        }

        public int encode(EncodeIterator encodeIter) {
            this.elementList.clear();
            this.elementList.applyHasStandardData();
            int ret = this.elementList.encodeInit(encodeIter, null, 0);
            if (ret != 0) {
                return ret;
            }
            this.element.clear();
            this.element.name(ElementNames.NAME);
            this.element.dataType(17);
            ret = this.element.encode(encodeIter, this.serviceName());
            if (ret != 0) {
                return ret;
            }
            if (this.checkHasVendor()) {
                this.element.name(ElementNames.VENDOR);
                this.element.dataType(17);
                ret = this.element.encode(encodeIter, this.vendor());
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.checkHasIsSource()) {
                this.element.name(ElementNames.IS_SOURCE);
                this.element.dataType(4);
                this.tmpUInt.value(this.isSource());
                ret = this.element.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            this.element.name(ElementNames.CAPABILITIES);
            this.element.dataType(15);
            ret = this.element.encodeInit(encodeIter, 0);
            if (ret != 0) {
                return ret;
            }
            this.array.clear();
            this.array.primitiveType(4);
            this.array.itemLength(0);
            ret = this.array.encodeInit(encodeIter);
            if (ret != 0) {
                return ret;
            }
            Iterator<Object> iterator = this.capabilitiesList().iterator();
            while (iterator.hasNext()) {
                long capability = iterator.next();
                this.tmpUInt.value(capability);
                ret = this.arrayEntry.encode(encodeIter, this.tmpUInt);
                if (ret == 0) continue;
                return ret;
            }
            ret = this.array.encodeComplete(encodeIter, true);
            if (ret != 0) {
                return ret;
            }
            ret = this.element.encodeComplete(encodeIter, true);
            if (ret != 0) {
                return ret;
            }
            if (this.checkHasDictionariesProvided()) {
                this.element.name(ElementNames.DICTIONARIES_PROVIDED);
                this.element.dataType(15);
                ret = this.element.encodeInit(encodeIter, 0);
                if (ret != 0) {
                    return ret;
                }
                this.array.clear();
                this.array.primitiveType(17);
                this.array.itemLength(0);
                ret = this.array.encodeInit(encodeIter);
                if (ret != 0) {
                    return ret;
                }
                for (String dictProvided : this.dictionariesProvidedList()) {
                    this.tmpBuffer.data(dictProvided);
                    ret = this.arrayEntry.encode(encodeIter, this.tmpBuffer);
                    if (ret == 0) continue;
                    return ret;
                }
                ret = this.array.encodeComplete(encodeIter, true);
                if (ret != 0) {
                    return ret;
                }
                ret = this.element.encodeComplete(encodeIter, true);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.checkHasDictionariesUsed()) {
                this.element.name(ElementNames.DICTIONARIES_USED);
                this.element.dataType(15);
                ret = this.element.encodeInit(encodeIter, 0);
                if (ret != 0) {
                    return ret;
                }
                this.array.clear();
                this.array.primitiveType(17);
                this.array.itemLength(0);
                ret = this.array.encodeInit(encodeIter);
                if (ret != 0) {
                    return ret;
                }
                for (String dictUsed : this.dictionariesUsedList()) {
                    this.tmpBuffer.data(dictUsed);
                    ret = this.arrayEntry.encode(encodeIter, this.tmpBuffer);
                    if (ret == 0) continue;
                    return ret;
                }
                ret = this.array.encodeComplete(encodeIter, true);
                if (ret != 0) {
                    return ret;
                }
                ret = this.element.encodeComplete(encodeIter, true);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.checkHasQos()) {
                this.element.name(ElementNames.QOS);
                this.element.dataType(15);
                ret = this.element.encodeInit(encodeIter, 0);
                if (ret != 0) {
                    return ret;
                }
                this.array.clear();
                this.array.primitiveType(12);
                this.array.itemLength(0);
                ret = this.array.encodeInit(encodeIter);
                if (ret != 0) {
                    return ret;
                }
                for (Qos qos : this.qosList()) {
                    ret = this.arrayEntry.encode(encodeIter, qos);
                    if (ret == 0) continue;
                    return ret;
                }
                ret = this.array.encodeComplete(encodeIter, true);
                if (ret != 0) {
                    return ret;
                }
                ret = this.element.encodeComplete(encodeIter, true);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.checkHasSupportsQosRange()) {
                this.element.name(ElementNames.SUPPS_QOS_RANGE);
                this.element.dataType(4);
                this.tmpUInt.value(this.supportsQosRange());
                ret = this.element.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.checkHasItemList()) {
                this.element.name(ElementNames.ITEM_LIST);
                this.element.dataType(17);
                ret = this.element.encode(encodeIter, this.itemList());
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.checkHasSupportsOutOfBandSnapshots()) {
                this.element.name(ElementNames.SUPPS_OOB_SNAPSHOTS);
                this.element.dataType(4);
                this.tmpUInt.value(this.supportsOutOfBandSnapshots());
                ret = this.element.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.checkHasAcceptingConsumerStatus()) {
                this.element.name(ElementNames.ACCEPTING_CONS_STATUS);
                this.element.dataType(4);
                this.tmpUInt.value(this.acceptingConsumerStatus());
                ret = this.element.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            return this.elementList.encodeComplete(encodeIter, true);
        }

        public int decode(DecodeIterator dIter) {
            this.clear();
            this.elementList.clear();
            this.element.clear();
            this.array.clear();
            int ret = this.elementList.decode(dIter, null);
            if (ret < 0) {
                return ret;
            }
            Buffer tmpBuffer = null;
            while ((ret = this.element.decode(dIter)) != 14) {
                if (ret != 0) {
                    return ret;
                }
                if (this.element.name().equals(ElementNames.NAME)) {
                    tmpBuffer = this.element.encodedData();
                    this.serviceName().data(tmpBuffer.data(), tmpBuffer.position(), tmpBuffer.length());
                    continue;
                }
                if (this.element.name().equals(ElementNames.VENDOR)) {
                    this.applyHasVendor();
                    tmpBuffer = this.element.encodedData();
                    this.vendor().data(tmpBuffer.data(), tmpBuffer.position(), tmpBuffer.length());
                    continue;
                }
                if (this.element.name().equals(ElementNames.IS_SOURCE)) {
                    ret = this.tmpUInt.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    this.applyHasIsSource();
                    this.isSource(this.tmpUInt.toLong());
                    continue;
                }
                if (this.element.name().equals(ElementNames.CAPABILITIES)) {
                    ret = this.array.decode(dIter);
                    if (ret < 0) {
                        return ret;
                    }
                    while ((ret = this.arrayEntry.decode(dIter)) != 14) {
                        if (ret == 0) {
                            ret = this.tmpUInt.decode(dIter);
                            this.capabilitiesList().add(this.tmpUInt.toLong());
                            if (ret == 0 || ret == 15) continue;
                            return ret;
                        }
                        if (ret == 15) continue;
                        return ret;
                    }
                    continue;
                }
                if (this.element.name().equals(ElementNames.DICTIONARIES_PROVIDED)) {
                    ret = this.array.decode(dIter);
                    if (ret < 0) {
                        return ret;
                    }
                    this.applyHasDictionariesProvided();
                    while ((ret = this.arrayEntry.decode(dIter)) != 14) {
                        if (ret == 0) {
                            this.dictionariesProvidedList().add(this.arrayEntry.encodedData().toString());
                            continue;
                        }
                        if (ret == 15) continue;
                        return ret;
                    }
                    continue;
                }
                if (this.element.name().equals(ElementNames.DICTIONARIES_USED)) {
                    ret = this.array.decode(dIter);
                    if (ret < 0) {
                        return ret;
                    }
                    this.applyHasDictionariesUsed();
                    while ((ret = this.arrayEntry.decode(dIter)) != 14) {
                        if (ret == 0) {
                            this.dictionariesUsedList().add(this.arrayEntry.encodedData().toString());
                            continue;
                        }
                        if (ret == 15) continue;
                        return ret;
                    }
                    continue;
                }
                if (this.element.name().equals(ElementNames.QOS)) {
                    ret = this.array.decode(dIter);
                    if (ret < 0) {
                        return ret;
                    }
                    this.applyHasQos();
                    while ((ret = this.arrayEntry.decode(dIter)) != 14) {
                        if (ret == 0) {
                            Qos qos = CodecFactory.createQos();
                            ret = qos.decode(dIter);
                            this.qosList().add(qos);
                            if (ret == 0 || ret == 15) continue;
                            return ret;
                        }
                        if (ret == 15) continue;
                        return ret;
                    }
                    continue;
                }
                if (this.element.name().equals(ElementNames.SUPPS_QOS_RANGE)) {
                    ret = this.tmpUInt.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    this.applyHasSupportsQosRange();
                    this.supportsQosRange(this.tmpUInt.toLong());
                    continue;
                }
                if (this.element.name().equals(ElementNames.ITEM_LIST)) {
                    this.applyHasItemList();
                    tmpBuffer = this.element.encodedData();
                    this.itemList().data(tmpBuffer.data(), tmpBuffer.position(), tmpBuffer.length());
                    continue;
                }
                if (this.element.name().equals(ElementNames.SUPPS_OOB_SNAPSHOTS)) {
                    ret = this.tmpUInt.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    this.applyHasSupportsOutOfBandSnapshots();
                    this.supportsOutOfBandSnapshots(this.tmpUInt.toLong());
                    continue;
                }
                if (!this.element.name().equals(ElementNames.ACCEPTING_CONS_STATUS)) continue;
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0 && ret != 15) {
                    return ret;
                }
                this.applyHasAcceptingConsumerStatus();
                this.acceptingConsumerStatus(this.tmpUInt.toLong());
            }
            return 0;
        }

        public int copy(ServiceInfo destServiceInfo) {
            assert (destServiceInfo != null) : "destServiceInfo can not be null";
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.serviceName().length());
            this.serviceName().copy(byteBuffer);
            destServiceInfo.clear();
            destServiceInfo.serviceName().data(byteBuffer);
            destServiceInfo.action(this.action());
            destServiceInfo.capabilitiesList().addAll(this.capabilitiesList());
            if (this.checkHasAcceptingConsumerStatus()) {
                destServiceInfo.applyHasAcceptingConsumerStatus();
                destServiceInfo.acceptingConsumerStatus(this.acceptingConsumerStatus());
            }
            if (this.checkHasDictionariesProvided()) {
                destServiceInfo.applyHasDictionariesProvided();
                for (String dictProvided : this.dictionariesProvidedList()) {
                    destServiceInfo.dictionariesProvidedList().add(dictProvided);
                }
            }
            if (this.checkHasDictionariesUsed()) {
                destServiceInfo.applyHasDictionariesUsed();
                for (String dictUsed : this.dictionariesUsedList()) {
                    destServiceInfo.dictionariesUsedList().add(dictUsed);
                }
            }
            if (this.checkHasIsSource()) {
                destServiceInfo.applyHasIsSource();
                destServiceInfo.isSource(this.isSource());
            }
            if (this.checkHasItemList()) {
                destServiceInfo.applyHasItemList();
                byteBuffer = ByteBuffer.allocate(this.itemList().length());
                this.itemList().copy(byteBuffer);
                destServiceInfo.itemList().data(byteBuffer);
            }
            if (this.checkHasQos()) {
                destServiceInfo.applyHasQos();
                for (Qos qos : this.qosList()) {
                    Qos copyqos = CodecFactory.createQos();
                    copyqos.dynamic(qos.isDynamic());
                    copyqos.rate(qos.rate());
                    copyqos.rateInfo(qos.rateInfo());
                    copyqos.timeInfo(qos.timeInfo());
                    copyqos.timeliness(qos.timeliness());
                    destServiceInfo.qosList().add(copyqos);
                }
            }
            if (this.checkHasSupportsOutOfBandSnapshots()) {
                destServiceInfo.applyHasSupportsOutOfBandSnapshots();
                destServiceInfo.supportsOutOfBandSnapshots(this.supportsOutOfBandSnapshots());
            }
            if (this.checkHasSupportsQosRange()) {
                destServiceInfo.applyHasSupportsQosRange();
                destServiceInfo.supportsQosRange(this.supportsQosRange());
            }
            if (this.checkHasVendor()) {
                destServiceInfo.applyHasVendor();
                byteBuffer = ByteBuffer.allocate(this.vendor().length());
                this.vendor().copy(byteBuffer);
                destServiceInfo.vendor().data(byteBuffer);
            }
            return 0;
        }

        public int update(ServiceInfo destServiceInfo) {
            assert (destServiceInfo != null) : "destServiceInfo can not be null";
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.serviceName().length());
            this.serviceName().copy(byteBuffer);
            destServiceInfo.serviceName().data(byteBuffer);
            destServiceInfo.action(this.action());
            destServiceInfo.capabilitiesList().clear();
            destServiceInfo.capabilitiesList().addAll(this.capabilitiesList());
            if (this.checkHasAcceptingConsumerStatus()) {
                destServiceInfo.applyHasAcceptingConsumerStatus();
                destServiceInfo.acceptingConsumerStatus(this.acceptingConsumerStatus());
            }
            if (this.checkHasDictionariesProvided()) {
                destServiceInfo.applyHasDictionariesProvided();
                this.dictionariesProvidedList().clear();
                for (String dictProvided : this.dictionariesProvidedList()) {
                    destServiceInfo.dictionariesProvidedList().add(dictProvided);
                }
            }
            if (this.checkHasDictionariesUsed()) {
                destServiceInfo.applyHasDictionariesUsed();
                this.dictionariesUsedList().clear();
                for (String dictUsed : this.dictionariesUsedList()) {
                    destServiceInfo.dictionariesUsedList().add(dictUsed);
                }
            }
            if (this.checkHasIsSource()) {
                destServiceInfo.applyHasIsSource();
                destServiceInfo.isSource(this.isSource());
            }
            if (this.checkHasItemList()) {
                destServiceInfo.applyHasItemList();
                byteBuffer = ByteBuffer.allocate(this.itemList().length());
                this.itemList().copy(byteBuffer);
                destServiceInfo.itemList().data(byteBuffer);
            }
            if (this.checkHasQos()) {
                destServiceInfo.applyHasQos();
                destServiceInfo.qosList().clear();
                for (Qos qos : this.qosList()) {
                    Qos copyqos = CodecFactory.createQos();
                    copyqos.dynamic(qos.isDynamic());
                    copyqos.rate(qos.rate());
                    copyqos.rateInfo(qos.rateInfo());
                    copyqos.timeInfo(qos.timeInfo());
                    copyqos.timeliness(qos.timeliness());
                    destServiceInfo.qosList().add(copyqos);
                }
            }
            if (this.checkHasSupportsOutOfBandSnapshots()) {
                destServiceInfo.applyHasSupportsOutOfBandSnapshots();
                destServiceInfo.supportsOutOfBandSnapshots(this.supportsOutOfBandSnapshots());
            }
            if (this.checkHasSupportsQosRange()) {
                destServiceInfo.applyHasSupportsQosRange();
                destServiceInfo.supportsQosRange(this.supportsQosRange());
            }
            if (this.checkHasVendor()) {
                destServiceInfo.applyHasVendor();
                byteBuffer = ByteBuffer.allocate(this.vendor().length());
                this.vendor().copy(byteBuffer);
                destServiceInfo.vendor().data(byteBuffer);
            }
            return 0;
        }

        public String toString() {
            this.stringBuf.setLength(0);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("InfoFilter:");
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("serviceName: ");
            this.stringBuf.append(this.serviceName());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("vendor: ");
            this.stringBuf.append(this.vendor());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("isSource: ");
            this.stringBuf.append(this.isSource());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("supportsQosRange: ");
            this.stringBuf.append(this.supportsQosRange());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("supportsOutOfBandSnapshots: ");
            this.stringBuf.append(this.supportsOutOfBandSnapshots());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("acceptingConsumerStatus: ");
            this.stringBuf.append(this.acceptingConsumerStatus());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("capabilities: ");
            this.stringBuf.append(this.capabilitiesList());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("dictionariesProvided: ");
            this.stringBuf.append(this.dictionariesProvidedList());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("dictionariesUsed: ");
            this.stringBuf.append(this.dictionariesUsedList());
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("qos: ");
            this.stringBuf.append(this.qosList());
            this.stringBuf.append(eol);
            return this.stringBuf.toString();
        }
    }

    public static class ServiceGroupFlags {
        public static final int NONE = 0;
        public static final int HAS_MERGED_TO_GROUP = 1;
        public static final int HAS_STATUS = 2;

        private ServiceGroupFlags() {
            throw new AssertionError();
        }
    }

    public static class ServiceGroup {
        private int flags;
        private Buffer group;
        private Buffer mergedToGroup;
        private State status;
        private int action;
        private static final String eol = "\n";
        private static final String tab = "\t";
        private StringBuilder stringBuf = new StringBuilder();
        private ElementList elementList = CodecFactory.createElementList();
        private ElementEntry element = CodecFactory.createElementEntry();
        private State tmpStatus = CodecFactory.createState();

        public ServiceGroup() {
            this.status = CodecFactory.createState();
            this.group = CodecFactory.createBuffer();
            this.mergedToGroup = CodecFactory.createBuffer();
            this.clear();
        }

        public void clear() {
            this.flags = 0;
            this.group.clear();
            this.mergedToGroup.clear();
            this.status.clear();
            this.status.streamState(1);
            this.status.code(0);
            this.status.dataState(1);
            this.action = 2;
        }

        public void applyHasStatus() {
            this.flags |= 2;
        }

        public boolean checkHasStatus() {
            return (this.flags & 2) != 0;
        }

        public void applyHasMergedToGroup() {
            this.flags |= 1;
        }

        public boolean checkHasMergedToGroup() {
            return (this.flags & 1) != 0;
        }

        public String toString() {
            this.stringBuf.setLength(0);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("GroupFilter:");
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("group: ");
            this.stringBuf.append(this.group().toHexString());
            this.stringBuf.append(eol);
            if (this.checkHasMergedToGroup()) {
                this.stringBuf.append(tab);
                this.stringBuf.append(tab);
                this.stringBuf.append(tab);
                this.stringBuf.append("mergedToGroup: ");
                this.stringBuf.append(this.mergedToGroup().toHexString());
                this.stringBuf.append(eol);
            }
            if (this.checkHasStatus()) {
                this.stringBuf.append(tab);
                this.stringBuf.append(tab);
                this.stringBuf.append(tab);
                this.stringBuf.append("status: ");
                this.stringBuf.append(this.status());
                this.stringBuf.append(eol);
            }
            return this.stringBuf.toString();
        }

        public int flags() {
            return this.flags;
        }

        public void flags(int flags) {
            this.flags = flags;
        }

        public int action() {
            return this.action;
        }

        public void action(int action) {
            this.action = action;
        }

        public Buffer group() {
            return this.group;
        }

        public void group(Buffer group) {
            this.group.data(group.data(), group.position(), group.length());
        }

        public Buffer mergedToGroup() {
            return this.mergedToGroup;
        }

        public void mergedToGroup(Buffer mergedToGroup) {
            this.mergedToGroup.data(mergedToGroup.data(), mergedToGroup.position(), mergedToGroup.length());
        }

        public State status() {
            return this.status;
        }

        public void status(State status) {
            this.status().streamState(status.streamState());
            this.status().dataState(status.dataState());
            this.status().code(status.code());
            this.status().text(status.text());
        }

        public int filterId() {
            return 3;
        }

        public int encode(EncodeIterator encIter) {
            this.elementList.clear();
            this.elementList.applyHasStandardData();
            int ret = this.elementList.encodeInit(encIter, null, 0);
            if (ret != 0) {
                return ret;
            }
            this.element.clear();
            if (this.checkHasMergedToGroup()) {
                this.element.clear();
                this.element.name(ElementNames.MERG_TO_GRP);
                this.element.dataType(16);
                ret = this.element.encode(encIter, this.mergedToGroup());
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.checkHasStatus()) {
                this.element.clear();
                this.element.name(ElementNames.STATUS);
                this.element.dataType(13);
                ret = this.element.encode(encIter, this.status());
                if (ret != 0) {
                    return ret;
                }
            }
            this.element.clear();
            this.element.name(ElementNames.GROUP);
            this.element.dataType(16);
            ret = this.element.encode(encIter, this.group());
            if (ret != 0) {
                return ret;
            }
            ret = this.elementList.encodeComplete(encIter, true);
            if (ret < 0) {
                return ret;
            }
            return 0;
        }

        public int decode(DecodeIterator dIter) {
            this.clear();
            this.elementList.clear();
            this.element.clear();
            int ret = this.elementList.decode(dIter, null);
            if (ret != 0) {
                return ret;
            }
            Buffer tmpBuf = null;
            while ((ret = this.element.decode(dIter)) != 14) {
                if (ret != 0) {
                    return ret;
                }
                if (this.element.name().equals(ElementNames.GROUP)) {
                    tmpBuf = this.element.encodedData();
                    this.group.data(tmpBuf.data(), tmpBuf.position(), tmpBuf.length());
                    continue;
                }
                if (this.element.name().equals(ElementNames.MERG_TO_GRP)) {
                    tmpBuf = this.element.encodedData();
                    this.mergedToGroup.data(tmpBuf.data(), tmpBuf.position(), tmpBuf.length());
                    this.applyHasMergedToGroup();
                    continue;
                }
                if (!this.element.name().equals(ElementNames.STATUS)) continue;
                ret = this.tmpStatus.decode(dIter);
                if (ret != 0 && ret != 15) {
                    return ret;
                }
                this.status().streamState(this.tmpStatus.streamState());
                this.status().dataState(this.tmpStatus.dataState());
                this.status().code(this.tmpStatus.code());
                if (this.tmpStatus.text().length() > 0) {
                    Buffer text = this.tmpStatus.text();
                    this.status().text().data(text.data(), text.position(), text.length());
                }
                this.applyHasStatus();
            }
            return 0;
        }

        public int copy(ServiceGroup destServiceGroup) {
            ByteBuffer byteBuffer;
            assert (destServiceGroup != null) : "destServiceGroup can not be null";
            destServiceGroup.clear();
            destServiceGroup.flags(this.flags());
            destServiceGroup.action(this.action());
            if (this.checkHasMergedToGroup()) {
                byteBuffer = ByteBuffer.allocate(this.mergedToGroup().length());
                this.mergedToGroup().copy(byteBuffer);
                destServiceGroup.mergedToGroup().data(byteBuffer);
                destServiceGroup.applyHasMergedToGroup();
            }
            if (this.checkHasStatus()) {
                destServiceGroup.status().streamState(this.status().streamState());
                destServiceGroup.status().dataState(this.status().dataState());
                destServiceGroup.status().code(this.status().code());
                if (this.status().text().length() > 0) {
                    byteBuffer = ByteBuffer.allocate(this.status().text().length());
                    this.status().text().copy(byteBuffer);
                    destServiceGroup.status().text().data(byteBuffer);
                }
                destServiceGroup.applyHasStatus();
            }
            byteBuffer = ByteBuffer.allocate(this.group().length());
            this.group().copy(byteBuffer);
            destServiceGroup.group().data(byteBuffer);
            return 0;
        }
    }

    public static class ServiceFlags {
        public static final int NONE = 0;
        public static final int HAS_INFO = 1;
        public static final int HAS_STATE = 2;
        public static final int HAS_LOAD = 4;
        public static final int HAS_DATA = 8;
        public static final int HAS_LINK = 16;

        private ServiceFlags() {
            throw new AssertionError();
        }
    }

    public static class ServiceDataFlags {
        public static final int NONE = 0;
        public static final int HAS_DATA = 1;

        private ServiceDataFlags() {
            throw new AssertionError();
        }
    }

    public static class ServiceData {
        private int flags;
        private int dataType;
        private Buffer data;
        private long type;
        private int action;
        private static final String eol = "\n";
        private static final String tab = "\t";
        private StringBuilder stringBuf = new StringBuilder();
        private UInt tmpUInt = CodecFactory.createUInt();
        private ElementList elementList = CodecFactory.createElementList();
        private ElementEntry element = CodecFactory.createElementEntry();

        public ServiceData() {
            this.data = CodecFactory.createBuffer();
            this.clear();
        }

        public void clear() {
            this.flags = 0;
            this.dataType = 128;
            this.data.clear();
            this.action = 2;
            this.type = 0L;
        }

        public void applyHasData() {
            this.flags |= 1;
        }

        public boolean checkHasData() {
            return (this.flags & 1) != 0;
        }

        public int encode(EncodeIterator encIter) {
            this.elementList.clear();
            this.elementList.applyHasStandardData();
            int ret = this.elementList.encodeInit(encIter, null, 0);
            if (ret != 0) {
                return ret;
            }
            if (this.checkHasData()) {
                this.element.clear();
                this.element.name(ElementNames.TYPE);
                this.element.dataType(4);
                this.tmpUInt.value(this.type());
                ret = this.element.encode(encIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
                this.element.clear();
                this.element.name(ElementNames.DATA);
                this.element.dataType(this.dataType());
                ret = this.element.encode(encIter, this.data());
                if (ret != 0) {
                    return ret;
                }
            }
            return this.elementList.encodeComplete(encIter, true);
        }

        public int decode(DecodeIterator dIter) {
            this.clear();
            this.elementList.clear();
            this.element.clear();
            int ret = this.elementList.decode(dIter, null);
            if (ret != 0) {
                return ret;
            }
            boolean foundType = false;
            boolean foundData = false;
            while ((ret = this.element.decode(dIter)) != 14) {
                if (ret != 0) {
                    return ret;
                }
                if (this.element.name().equals(ElementNames.TYPE)) {
                    this.tmpUInt.clear();
                    ret = this.tmpUInt.decode(dIter);
                    if (ret != 0 && ret != 15) {
                        return ret;
                    }
                    foundType = true;
                    this.type(this.tmpUInt.toLong());
                    continue;
                }
                if (!this.element.name().equals(ElementNames.DATA)) continue;
                Buffer tmpBuf = this.element.encodedData();
                this.data().data(tmpBuf.data(), tmpBuf.position(), tmpBuf.length());
                this.dataType(this.element.dataType());
                this.applyHasData();
                foundData = true;
            }
            if (foundData && !foundType || foundType && !foundData) {
                return -1;
            }
            return 0;
        }

        public int copy(ServiceData destServiceData) {
            assert (destServiceData != null) : "destServiceData can not be null";
            destServiceData.clear();
            destServiceData.action(this.action());
            destServiceData.type(this.type());
            destServiceData.flags(this.flags());
            if (this.checkHasData()) {
                destServiceData.applyHasData();
                destServiceData.dataType(this.dataType());
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.data().length());
                this.data().copy(byteBuffer);
                destServiceData.data().data(byteBuffer);
            }
            return 0;
        }

        public int update(ServiceData destServiceData) {
            assert (destServiceData != null) : "destServiceData can not be null";
            destServiceData.action(this.action());
            destServiceData.type(this.type());
            destServiceData.flags(this.flags());
            if (this.checkHasData()) {
                destServiceData.applyHasData();
                destServiceData.dataType(this.dataType());
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.data().length());
                this.data().copy(byteBuffer);
                destServiceData.data().data(byteBuffer);
            }
            return 0;
        }

        public void flags(int flags) {
            this.flags = flags;
        }

        public int flags() {
            return this.flags;
        }

        public void action(int action) {
            this.action = action;
        }

        public int action() {
            return this.action;
        }

        public int dataType() {
            return this.dataType;
        }

        public void dataType(int dataType) {
            this.dataType = dataType;
        }

        public long type() {
            return this.type;
        }

        public void type(long type) {
            this.type = type;
        }

        public Buffer data() {
            return this.data;
        }

        public void data(Buffer data) {
            this.data.data(data.data(), data.position(), data.length());
        }

        public int filterId() {
            return 5;
        }

        public String toString() {
            this.stringBuf.setLength(0);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("DataFilter:");
            this.stringBuf.append(eol);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append(tab);
            this.stringBuf.append("Type: ");
            this.stringBuf.append(this.type());
            this.stringBuf.append(eol);
            if (this.checkHasData()) {
                this.stringBuf.append(tab);
                this.stringBuf.append(tab);
                this.stringBuf.append(tab);
                this.stringBuf.append("Data: ");
                this.stringBuf.append(this.data());
                this.stringBuf.append(eol);
                this.stringBuf.append(tab);
                this.stringBuf.append(tab);
                this.stringBuf.append(tab);
                this.stringBuf.append("DataType: ");
                this.stringBuf.append(DataTypes.toString((int)this.dataType()));
                this.stringBuf.append(eol);
            }
            return this.stringBuf.toString();
        }
    }
}

