/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.dictionary;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DataDictionary;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.ElementEntry;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Int;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.MsgKey;
import com.refinitiv.eta.codec.RefreshMsg;
import com.refinitiv.eta.codec.Series;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.rdm.ElementNames;
import com.refinitiv.eta.transport.Error;
import com.refinitiv.eta.transport.TransportFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBaseImpl;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryRefresh;
import java.nio.ByteBuffer;

class DictionaryRefreshImpl
extends MsgBaseImpl {
    private int flags;
    private Buffer dictionaryName;
    private Buffer dataBody;
    private State state;
    private int dictionaryType;
    private int serviceId;
    private int verbosity;
    private long sequenceNumber;
    private int startFid;
    private int startEnumTableCount;
    private Int tmpInt = CodecFactory.createInt();
    private DataDictionary dictionary = null;
    private Error error = TransportFactory.createError();
    private Series series = CodecFactory.createSeries();
    private ElementList elementList = CodecFactory.createElementList();
    private ElementEntry elementEntry = CodecFactory.createElementEntry();
    private DecodeIterator seriesDecodeIter = CodecFactory.createDecodeIterator();
    private UInt tmpUInt = CodecFactory.createUInt();
    private RefreshMsg refreshMsg = (RefreshMsg)CodecFactory.createMsg();
    private Buffer version = CodecFactory.createBuffer();
    private static final String eol = "\n";
    private static final String tab = "\t";
    private boolean userSetDictionary = false;

    public int flags() {
        return this.flags;
    }

    public void flags(int flags) {
        this.flags = flags;
    }

    public boolean checkHasSequenceNumber() {
        return (this.flags & 8) != 0;
    }

    public void applyHasSequenceNumber() {
        this.flags |= 8;
    }

    public boolean checkHasInfo() {
        return (this.flags & 1) != 0;
    }

    public void applyHasInfo() {
        this.flags |= 1;
    }

    DictionaryRefreshImpl() {
        this.dictionaryName = CodecFactory.createBuffer();
        this.state = CodecFactory.createState();
        this.dataBody = CodecFactory.createBuffer();
    }

    public int copy(DictionaryRefresh destRefreshMsg) {
        assert (destRefreshMsg != null) : "destRefreshMsg must be non-null";
        destRefreshMsg.streamId(this.streamId());
        destRefreshMsg.serviceId(this.serviceId());
        destRefreshMsg.verbosity(this.verbosity());
        destRefreshMsg.streamId(this.streamId());
        destRefreshMsg.serviceId(this.serviceId());
        destRefreshMsg.dictionaryType(this.dictionaryType());
        destRefreshMsg.startFid(this.startFid());
        destRefreshMsg.startEnumTableCount(this.startEnumTableCount());
        destRefreshMsg.flags(this.flags);
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.dictionaryName.length());
        this.dictionaryName.copy(byteBuffer);
        destRefreshMsg.dictionaryName().data(byteBuffer);
        if (this.dataBody != null && this.dataBody.length() > 0) {
            byteBuffer = ByteBuffer.allocate(this.dataBody.length());
            this.dataBody.copy(byteBuffer);
            destRefreshMsg.dataBody().data(byteBuffer);
        }
        destRefreshMsg.state().streamState(this.state.streamState());
        destRefreshMsg.state().dataState(this.state.dataState());
        destRefreshMsg.state().code(this.state.code());
        if (this.state.text().length() > 0) {
            byteBuffer = ByteBuffer.allocate(this.state.text().length());
            this.state.text().copy(byteBuffer);
            destRefreshMsg.state().text().data(byteBuffer);
        }
        return 0;
    }

    @Override
    public void clear() {
        this.state.clear();
        this.state.streamState(1);
        this.state.code(0);
        this.state.dataState(1);
        this.dictionaryName.clear();
        this.flags = 0;
        this.serviceId = 0;
        this.verbosity = 7;
        this.dictionaryType = 0;
        this.sequenceNumber = 0L;
        this.startFid = Short.MIN_VALUE;
        this.startEnumTableCount = 0;
        this.dataBody.clear();
        this.version.clear();
        if (this.dictionary != null && !this.userSetDictionary) {
            this.dictionary.clear();
        }
        this.userSetDictionary = false;
    }

    @Override
    public int encode(EncodeIterator encodeIter) {
        this.refreshMsg.clear();
        this.refreshMsg.msgClass(2);
        this.refreshMsg.streamId(this.streamId());
        this.refreshMsg.domainType(5);
        this.refreshMsg.containerType(138);
        this.refreshMsg.applyHasMsgKey();
        if (this.checkSolicited()) {
            this.refreshMsg.applySolicited();
        }
        if (this.checkClearCache()) {
            this.refreshMsg.applyClearCache();
        }
        if (this.checkHasSequenceNumber()) {
            this.refreshMsg.applyHasSeqNum();
            this.refreshMsg.seqNum(this.sequenceNumber());
        }
        this.refreshMsg.state().dataState(this.state().dataState());
        this.refreshMsg.state().streamState(this.state().streamState());
        this.refreshMsg.state().code(this.state().code());
        this.refreshMsg.state().text(this.state().text());
        this.refreshMsg.msgKey().applyHasName();
        this.refreshMsg.msgKey().applyHasFilter();
        this.refreshMsg.msgKey().applyHasServiceId();
        this.refreshMsg.msgKey().name(this.dictionaryName());
        this.refreshMsg.msgKey().filter((long)this.verbosity());
        this.refreshMsg.msgKey().serviceId(this.serviceId());
        int ret = this.refreshMsg.encodeInit(encodeIter, 0);
        if (ret < 0) {
            return ret;
        }
        switch (this.dictionaryType) {
            case 1: {
                int dictEncodeRet;
                this.tmpInt.value(this.startFid);
                if (this.dictionary == null) {
                    this.dictionary = CodecFactory.createDataDictionary();
                }
                if ((dictEncodeRet = this.dictionary.encodeFieldDictionary(encodeIter, this.tmpInt, this.verbosity, this.error)) != 0) {
                    if (dictEncodeRet != 10) {
                        return dictEncodeRet;
                    }
                } else {
                    ret = encodeIter.setRefreshCompleteFlag();
                    if (ret != 0) {
                        this.error.text("Unable to set refresh complete flag to dictionary refresh msg");
                        return ret;
                    }
                }
                if ((ret = this.refreshMsg.encodeComplete(encodeIter, true)) < 0) {
                    return ret;
                }
                this.startFid = (int)this.tmpInt.toLong();
                return dictEncodeRet;
            }
            case 2: {
                this.tmpInt.value(this.startEnumTableCount);
                int dictEncodeRet = this.dictionary.encodeEnumTypeDictionaryAsMultiPart(encodeIter, this.tmpInt, this.verbosity(), this.error);
                if (dictEncodeRet != 0) {
                    if (dictEncodeRet != 10) {
                        return dictEncodeRet;
                    }
                } else {
                    ret = encodeIter.setRefreshCompleteFlag();
                    if (ret != 0) {
                        this.error.text("Unable to set refresh complete flag to dictionary refresh msg");
                        return ret;
                    }
                }
                if ((ret = this.refreshMsg.encodeComplete(encodeIter, true)) < 0) {
                    return ret;
                }
                this.startEnumTableCount = (int)this.tmpInt.toLong();
                return dictEncodeRet;
            }
        }
        this.error.text("Invalid Dictionary Type: " + this.dictionaryType);
        return -1;
    }

    public boolean checkSolicited() {
        return (this.flags & 4) != 0;
    }

    public boolean checkClearCache() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public int decode(DecodeIterator dIter, Msg msg) {
        if (msg.msgClass() != 2) {
            return -1;
        }
        this.clear();
        this.streamId(msg.streamId());
        MsgKey key = msg.msgKey();
        if (!(key != null && key.checkHasFilter() && key.checkHasName() && key.checkHasServiceId())) {
            return -1;
        }
        RefreshMsg refreshMsg = (RefreshMsg)msg;
        Buffer name = key.name();
        this.dictionaryName().data(name.data(), name.position(), name.length());
        if (key.checkHasServiceId()) {
            this.serviceId(key.serviceId());
        }
        if (refreshMsg.checkHasSeqNum()) {
            this.applyHasSequenceNumber();
            this.sequenceNumber(refreshMsg.seqNum());
        }
        this.verbosity((int)key.filter());
        if (refreshMsg.checkRefreshComplete()) {
            this.applyRefreshComplete();
        }
        if (refreshMsg.checkSolicited()) {
            this.applySolicited();
        }
        if (refreshMsg.checkClearCache()) {
            this.applyClearCache();
        }
        this.state().code(refreshMsg.state().code());
        this.state().streamState(refreshMsg.state().streamState());
        this.state().dataState(refreshMsg.state().dataState());
        if (refreshMsg.state().text().length() > 0) {
            Buffer buf = refreshMsg.state().text();
            this.state().text().data(buf.data(), buf.position(), buf.length());
        }
        this.seriesDecodeIter.clear();
        this.series.clear();
        if (msg.encodedDataBody().length() > 0) {
            Buffer encodedDataBody = msg.encodedDataBody();
            this.dataBody().data(encodedDataBody.data(), encodedDataBody.position(), encodedDataBody.length());
            this.seriesDecodeIter.setBufferAndRWFVersion(encodedDataBody, dIter.majorVersion(), dIter.minorVersion());
            int ret = this.series.decode(this.seriesDecodeIter);
            if (ret != 0) {
                return ret;
            }
            if (this.series.checkHasSummaryData()) {
                this.applyHasInfo();
                return this.decodeDictionaryInfo();
            }
        }
        return 0;
    }

    public void applyClearCache() {
        this.flags |= 0x10;
    }

    public void applySolicited() {
        this.flags |= 4;
    }

    public void applyRefreshComplete() {
        this.flags |= 2;
    }

    public boolean checkRefreshComplete() {
        return (this.flags & 2) != 0;
    }

    private int decodeDictionaryInfo() {
        this.elementList.clear();
        int ret = this.elementList.decode(this.seriesDecodeIter, null);
        if (ret != 0) {
            return ret;
        }
        if (!this.elementList.checkHasStandardData() && !this.elementList.checkHasSetData()) {
            return -1;
        }
        this.elementEntry.clear();
        boolean foundVersion = false;
        boolean foundType = false;
        while ((ret = this.elementEntry.decode(this.seriesDecodeIter)) != 14) {
            if (ret != 0) {
                return ret;
            }
            if (this.elementEntry.name().equals(ElementNames.DICT_VERSION)) {
                foundVersion = true;
                Buffer versionString = this.elementEntry.encodedData();
                this.version.data(versionString.data(), versionString.position(), versionString.length());
            }
            if (this.elementEntry.name().equals(ElementNames.DICT_TYPE)) {
                ret = this.tmpUInt.decode(this.seriesDecodeIter);
                if (ret != 0) {
                    return ret;
                }
                this.dictionaryType((int)this.tmpUInt.toLong());
                foundType = true;
            }
            if (foundVersion || foundType) continue;
            return -1;
        }
        return 0;
    }

    public int verbosity() {
        return this.verbosity;
    }

    public void verbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    public void sequenceNumber(long sequenceNumber) {
        assert (this.checkHasSequenceNumber());
        this.sequenceNumber = sequenceNumber;
    }

    public int serviceId() {
        return this.serviceId;
    }

    public void serviceId(int serviceId) {
        this.serviceId = serviceId;
    }

    public State state() {
        return this.state;
    }

    public void state(State state) {
        this.state().streamState(state.streamState());
        this.state().dataState(state.dataState());
        this.state().code(state.code());
        this.state().text(state.text());
    }

    public int dictionaryType() {
        return this.dictionaryType;
    }

    public void dictionaryType(int dictionaryType) {
        this.dictionaryType = dictionaryType;
    }

    public Buffer dictionaryName() {
        return this.dictionaryName;
    }

    public void dictionaryName(Buffer dictionaryName) {
        this.dictionaryName.data(dictionaryName.data(), dictionaryName.position(), dictionaryName.length());
    }

    public Buffer version() {
        return this.version;
    }

    public Buffer dataBody() {
        return this.dataBody;
    }

    public int startFid() {
        return this.startFid;
    }

    public int startEnumTableCount() {
        return this.startEnumTableCount;
    }

    public void startFid(int startFid) {
        this.startFid = startFid;
    }

    public void startEnumTableCount(int startEnumTableCount) {
        this.startEnumTableCount = startEnumTableCount;
    }

    public DataDictionary dictionary() {
        if (this.userSetDictionary) {
            return this.dictionary;
        }
        if (this.dictionary == null) {
            this.dictionary = CodecFactory.createDataDictionary();
        }
        return this.dictionary;
    }

    public void dictionary(DataDictionary dictionary) {
        this.dictionary = dictionary;
        this.userSetDictionary = true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuf = super.buildStringBuffer();
        stringBuf.insert(0, "DictionaryRefresh: \n");
        stringBuf.append(tab);
        stringBuf.append("dictionaryName: ");
        stringBuf.append(this.dictionaryName());
        stringBuf.append(eol);
        stringBuf.append(tab);
        stringBuf.append(this.state());
        stringBuf.append(eol);
        stringBuf.append(tab);
        stringBuf.append("IsRefreshComplete: " + this.checkRefreshComplete());
        stringBuf.append(eol);
        stringBuf.append(tab);
        stringBuf.append("IsClearCache: " + this.checkClearCache());
        stringBuf.append(eol);
        stringBuf.append(tab);
        stringBuf.append("isSolicited: " + this.checkSolicited());
        stringBuf.append(eol);
        stringBuf.append(tab);
        stringBuf.append("verbosity: ");
        boolean addOr = false;
        long verbosity = this.verbosity();
        if ((verbosity & 0L) != 0L) {
            stringBuf.append("INFO");
            addOr = true;
        }
        if ((verbosity & 3L) != 0L) {
            if (addOr) {
                stringBuf.append(" | ");
            }
            stringBuf.append("MINIMAL");
            addOr = true;
        }
        if ((verbosity & 7L) != 0L) {
            if (addOr) {
                stringBuf.append(" | ");
            }
            stringBuf.append("NORMAL");
            addOr = true;
        }
        if ((verbosity & 0xFL) != 0L) {
            if (addOr) {
                stringBuf.append(" | ");
            }
            stringBuf.append("VERBOSE");
            addOr = true;
        }
        stringBuf.append(eol);
        return stringBuf.toString();
    }

    @Override
    public int domainType() {
        return 5;
    }
}

