/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.util;

import com.refinitiv.eta.json.util.UtilQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class UtilQueueConcurrent<T>
extends UtilQueue<T> {
    private Lock lock = new ReentrantLock();

    public UtilQueueConcurrent(int initialSize, Supplier<T> supplier) {
        super(initialSize, supplier);
    }

    @Override
    public T get() {
        this.lock.lock();
        try {
            Object t = super.get();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void add(T element) {
        this.lock.lock();
        try {
            super.add(element);
        }
        finally {
            this.lock.unlock();
        }
    }
}

