/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.util;

import com.refinitiv.eta.json.util.UtilQueue;
import com.refinitiv.eta.json.util.UtilQueueConcurrent;
import java.util.function.Supplier;

public class ObjectPool<T> {
    final UtilQueue<T> pool;
    static final int DEFAULT_INITIAL_SIZE = 16;

    public ObjectPool(boolean isConcurrent, Supplier<T> supplier) {
        this(isConcurrent, 16, supplier);
    }

    public ObjectPool(boolean isConcurrent, int initialSize, Supplier<T> supplier) {
        this.pool = isConcurrent ? new UtilQueueConcurrent<T>(initialSize, supplier) : new UtilQueue<T>(initialSize, supplier);
    }

    public T get() {
        return this.pool.get();
    }

    public void release(T obj) {
        this.pool.add(obj);
    }

    public void growPool(int numOfObjects) {
        this.pool.growPool(numOfObjects);
    }
}

