/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.util;

import com.refinitiv.eta.codec.Array;
import com.refinitiv.eta.codec.ArrayEntry;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.Date;
import com.refinitiv.eta.codec.DateTime;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.Double;
import com.refinitiv.eta.codec.ElementEntry;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Enum;
import com.refinitiv.eta.codec.FieldEntry;
import com.refinitiv.eta.codec.FieldList;
import com.refinitiv.eta.codec.FilterEntry;
import com.refinitiv.eta.codec.FilterList;
import com.refinitiv.eta.codec.Float;
import com.refinitiv.eta.codec.Int;
import com.refinitiv.eta.codec.LocalElementSetDefDb;
import com.refinitiv.eta.codec.LocalFieldSetDefDb;
import com.refinitiv.eta.codec.Map;
import com.refinitiv.eta.codec.MapEntry;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.Qos;
import com.refinitiv.eta.codec.Real;
import com.refinitiv.eta.codec.Series;
import com.refinitiv.eta.codec.SeriesEntry;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.codec.Time;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.codec.Vector;
import com.refinitiv.eta.codec.VectorEntry;
import com.refinitiv.eta.json.util.ByteArrayPool;
import com.refinitiv.eta.json.util.ObjectPool;
import java.nio.ByteBuffer;

public class JsonFactory {
    private static ObjectPool<Int> intPool = new ObjectPool<Int>(true, CodecFactory::createInt);
    private static ObjectPool<UInt> uintPool = new ObjectPool<UInt>(true, CodecFactory::createUInt);
    private static ObjectPool<ElementList> elementListPool = new ObjectPool<ElementList>(true, CodecFactory::createElementList);
    private static ObjectPool<ElementEntry> elementEntryPool = new ObjectPool<ElementEntry>(true, CodecFactory::createElementEntry);
    private static ObjectPool<Buffer> bufferPool = new ObjectPool<Buffer>(true, CodecFactory::createBuffer);
    private static ObjectPool<FieldList> fieldListPool = new ObjectPool<FieldList>(true, CodecFactory::createFieldList);
    private static ObjectPool<FieldEntry> fieldEntryPool = new ObjectPool<FieldEntry>(true, CodecFactory::createFieldEntry);
    private static ObjectPool<Vector> vectorPool = new ObjectPool<Vector>(true, CodecFactory::createVector);
    private static ObjectPool<VectorEntry> vectorEntryPool = new ObjectPool<VectorEntry>(true, CodecFactory::createVectorEntry);
    private static ObjectPool<Series> seriesPool = new ObjectPool<Series>(true, CodecFactory::createSeries);
    private static ObjectPool<SeriesEntry> seriesEntryPool = new ObjectPool<SeriesEntry>(true, CodecFactory::createSeriesEntry);
    private static ObjectPool<FilterList> filterListPool = new ObjectPool<FilterList>(true, CodecFactory::createFilterList);
    private static ObjectPool<FilterEntry> filterEntryPool = new ObjectPool<FilterEntry>(true, CodecFactory::createFilterEntry);
    private static ObjectPool<Real> realPool = new ObjectPool<Real>(true, CodecFactory::createReal);
    private static ObjectPool<Double> doublePool = new ObjectPool<Double>(true, CodecFactory::createDouble);
    private static ObjectPool<Float> floatPool = new ObjectPool<Float>(true, CodecFactory::createFloat);
    private static ObjectPool<State> statePool = new ObjectPool<State>(true, CodecFactory::createState);
    private static ObjectPool<Qos> qosPool = new ObjectPool<Qos>(true, CodecFactory::createQos);
    private static ObjectPool<Map> mapPool = new ObjectPool<Map>(true, CodecFactory::createMap);
    private static ObjectPool<MapEntry> mapEntryPool = new ObjectPool<MapEntry>(true, CodecFactory::createMapEntry);
    private static ObjectPool<Enum> enumPool = new ObjectPool<Enum>(true, CodecFactory::createEnum);
    private static ObjectPool<Time> timePool = new ObjectPool<Time>(true, CodecFactory::createTime);
    private static ObjectPool<Date> datePool = new ObjectPool<Date>(true, CodecFactory::createDate);
    private static ObjectPool<DateTime> dateTimePool = new ObjectPool<DateTime>(true, CodecFactory::createDateTime);
    private static ObjectPool<Array> arrayPool = new ObjectPool<Array>(true, CodecFactory::createArray);
    private static ObjectPool<ArrayEntry> arrayEntryPool = new ObjectPool<ArrayEntry>(true, CodecFactory::createArrayEntry);
    private static ObjectPool<Msg> msgPool = new ObjectPool<Msg>(true, CodecFactory::createMsg);
    private static ObjectPool<LocalFieldSetDefDb> fieldSetDefDbPool = new ObjectPool<LocalFieldSetDefDb>(true, CodecFactory::createLocalFieldSetDefDb);
    private static ObjectPool<LocalElementSetDefDb> elementSetDefDbPool = new ObjectPool<LocalElementSetDefDb>(true, CodecFactory::createLocalElementSetDefDb);
    private static ObjectPool<DecodeIterator> decodeIterPool = new ObjectPool<DecodeIterator>(true, CodecFactory::createDecodeIterator);
    private static ObjectPool<EncodeIterator> encodeIteratorPool = new ObjectPool<EncodeIterator>(true, CodecFactory::createEncodeIterator);
    public static final int DEFAULT_BYTEBUFFER_SIZE = 4096;
    private static ObjectPool<ByteBuffer> byteBufferPool = new ObjectPool<ByteBuffer>(true, () -> ByteBuffer.allocate(4096));
    private static ByteArrayPool byteArrayPool = new ByteArrayPool();
    private static boolean isInitialized = false;
    public static final int JSON_CONVERTER_DEFAULT_POOLS_SIZE = 10;

    private JsonFactory() {
        throw new AssertionError();
    }

    public static Int createInt() {
        return intPool.get();
    }

    public static void releaseInt(Int objInt) {
        intPool.release(objInt);
    }

    public static UInt createUInt() {
        return uintPool.get();
    }

    public static void releaseUInt(UInt objUInt) {
        uintPool.release(objUInt);
    }

    public static ElementList createElementList() {
        return elementListPool.get();
    }

    public static void releaseElementList(ElementList objElementList) {
        elementListPool.release(objElementList);
    }

    public static ElementEntry createElementEntry() {
        return elementEntryPool.get();
    }

    public static void releaseElementEntry(ElementEntry objElementEntry) {
        elementEntryPool.release(objElementEntry);
    }

    public static Buffer createBuffer() {
        return bufferPool.get();
    }

    public static void releaseBuffer(Buffer objBuffer) {
        bufferPool.release(objBuffer);
    }

    public static FieldList createFieldList() {
        return fieldListPool.get();
    }

    public static void releaseFieldList(FieldList objBuffer) {
        fieldListPool.release(objBuffer);
    }

    public static FieldEntry createFieldEntry() {
        return fieldEntryPool.get();
    }

    public static void releaseFieldEntry(FieldEntry objBuffer) {
        fieldEntryPool.release(objBuffer);
    }

    public static Vector createVector() {
        return vectorPool.get();
    }

    public static void releaseVector(Vector objBuffer) {
        vectorPool.release(objBuffer);
    }

    public static VectorEntry createVectorEntry() {
        return vectorEntryPool.get();
    }

    public static void releaseVectorEntry(VectorEntry objBuffer) {
        vectorEntryPool.release(objBuffer);
    }

    public static Series createSeries() {
        return seriesPool.get();
    }

    public static void releaseSeries(Series objBuffer) {
        seriesPool.release(objBuffer);
    }

    public static SeriesEntry createSeriesEntry() {
        return seriesEntryPool.get();
    }

    public static void releaseSeriesEntry(SeriesEntry objBuffer) {
        seriesEntryPool.release(objBuffer);
    }

    public static FilterList createFilterList() {
        return filterListPool.get();
    }

    public static void releaseFilterList(FilterList objBuffer) {
        filterListPool.release(objBuffer);
    }

    public static FilterEntry createFilterEntry() {
        return filterEntryPool.get();
    }

    public static void releaseFilterEntry(FilterEntry objBuffer) {
        filterEntryPool.release(objBuffer);
    }

    public static MapEntry createMapEntry() {
        return mapEntryPool.get();
    }

    public static void releaseMapEntry(MapEntry objBuffer) {
        mapEntryPool.release(objBuffer);
    }

    public static Map createMap() {
        return mapPool.get();
    }

    public static void releaseMap(Map objMap) {
        mapPool.release(objMap);
    }

    public static Real createReal() {
        return realPool.get();
    }

    public static void releaseReal(Real objReal) {
        realPool.release(objReal);
    }

    public static Time createTime() {
        return timePool.get();
    }

    public static void releaseTime(Time objTime) {
        timePool.release(objTime);
    }

    public static State createState() {
        return statePool.get();
    }

    public static void releaseState(State objState) {
        statePool.release(objState);
    }

    public static Date createDate() {
        return datePool.get();
    }

    public static void releaseDate(Date objDate) {
        datePool.release(objDate);
    }

    public static DateTime createDateTime() {
        return dateTimePool.get();
    }

    public static void releaseDateTime(DateTime objDateTime) {
        dateTimePool.release(objDateTime);
    }

    public static Qos createQos() {
        return qosPool.get();
    }

    public static void releaseQos(Qos objQos) {
        qosPool.release(objQos);
    }

    public static Float createFloat() {
        return floatPool.get();
    }

    public static void releaseFloat(Float objFloat) {
        floatPool.release(objFloat);
    }

    public static Double createDouble() {
        return doublePool.get();
    }

    public static void releaseDouble(Double objDouble) {
        doublePool.release(objDouble);
    }

    public static Enum createEnum() {
        return enumPool.get();
    }

    public static void releaseEnum(Enum objEnum) {
        enumPool.release(objEnum);
    }

    public static void releaseFieldSetDefDb(LocalFieldSetDefDb objBuffer) {
        fieldSetDefDbPool.release(objBuffer);
    }

    public static void releaseElementSetDefDb(LocalElementSetDefDb objBuffer) {
        elementSetDefDbPool.release(objBuffer);
    }

    public static LocalElementSetDefDb createLocalElementSetDefDb() {
        return elementSetDefDbPool.get();
    }

    public static LocalFieldSetDefDb createLocalFieldSetDefDb() {
        return fieldSetDefDbPool.get();
    }

    public static DecodeIterator createDecodeIterator() {
        return decodeIterPool.get();
    }

    public static void releaseDecodeIterator(DecodeIterator objBuffer) {
        decodeIterPool.release(objBuffer);
    }

    public static Array createArray() {
        return arrayPool.get();
    }

    public static void releaseArray(Array objArray) {
        arrayPool.release(objArray);
    }

    public static ArrayEntry createArrayEntry() {
        return arrayEntryPool.get();
    }

    public static void releaseArrayEntry(ArrayEntry objArrayEntry) {
        arrayEntryPool.release(objArrayEntry);
    }

    public static Msg createMsg() {
        return msgPool.get();
    }

    public static void releaseMsg(Msg objMsg) {
        msgPool.release(objMsg);
    }

    public static EncodeIterator createEncodeIterator() {
        return encodeIteratorPool.get();
    }

    public static void releaseEncodeIterator(EncodeIterator objEncodeIterator) {
        encodeIteratorPool.release(objEncodeIterator);
    }

    public static ByteBuffer createByteBuffer() {
        return byteBufferPool.get();
    }

    public static void releaseByteBuffer(ByteBuffer objByteBuffer) {
        byteBufferPool.release(objByteBuffer);
    }

    public static Object getPrimitiveType(int dataType) {
        switch (dataType) {
            case 15: {
                return JsonFactory.createArray();
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return JsonFactory.createBuffer();
            }
            case 9: 
            case 76: {
                return JsonFactory.createDate();
            }
            case 10: 
            case 77: 
            case 78: 
            case 83: 
            case 84: {
                return JsonFactory.createTime();
            }
            case 8: 
            case 74: 
            case 75: {
                return JsonFactory.createReal();
            }
            case 3: 
            case 64: 
            case 66: 
            case 68: 
            case 70: {
                return JsonFactory.createInt();
            }
            case 4: 
            case 65: 
            case 67: 
            case 69: 
            case 71: {
                return JsonFactory.createUInt();
            }
            case 11: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                return JsonFactory.createDateTime();
            }
            case 12: {
                return JsonFactory.createQos();
            }
            case 13: {
                return JsonFactory.createState();
            }
            case 6: 
            case 73: {
                return JsonFactory.createDouble();
            }
            case 5: 
            case 72: {
                return JsonFactory.createFloat();
            }
            case 14: {
                return JsonFactory.createEnum();
            }
        }
        return null;
    }

    public static void releasePrimitiveType(int dataType, Object primitive) {
        switch (dataType) {
            case 15: {
                JsonFactory.releaseArray((Array)primitive);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                JsonFactory.releaseBuffer((Buffer)primitive);
                break;
            }
            case 9: 
            case 76: {
                JsonFactory.releaseDate((Date)primitive);
                break;
            }
            case 10: 
            case 77: 
            case 78: 
            case 83: 
            case 84: {
                JsonFactory.releaseTime((Time)primitive);
                break;
            }
            case 8: 
            case 74: 
            case 75: {
                JsonFactory.releaseReal((Real)primitive);
                break;
            }
            case 3: 
            case 64: 
            case 66: 
            case 68: 
            case 70: {
                JsonFactory.releaseInt((Int)primitive);
                break;
            }
            case 4: 
            case 65: 
            case 67: 
            case 69: 
            case 71: {
                JsonFactory.releaseUInt((UInt)primitive);
                break;
            }
            case 11: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                JsonFactory.releaseDateTime((DateTime)primitive);
                break;
            }
            case 12: {
                JsonFactory.releaseQos((Qos)primitive);
                break;
            }
            case 13: {
                JsonFactory.releaseState((State)primitive);
                break;
            }
            case 6: 
            case 73: {
                JsonFactory.releaseDouble((Double)primitive);
                break;
            }
            case 5: 
            case 72: {
                JsonFactory.releaseFloat((Float)primitive);
                break;
            }
            case 14: {
                JsonFactory.releaseEnum((Enum)primitive);
                break;
            }
        }
    }

    public static byte[] createByteArray(int length) {
        return byteArrayPool.poll(length);
    }

    public static void releaseByteArray(byte[] array) {
        byteArrayPool.putBack(array);
    }

    public static void initPools(int numOfObjects) {
        if (!isInitialized && numOfObjects > 0) {
            intPool.growPool(numOfObjects);
            uintPool.growPool(numOfObjects);
            elementListPool.growPool(numOfObjects);
            elementEntryPool.growPool(numOfObjects);
            bufferPool.growPool(numOfObjects);
            fieldListPool.growPool(numOfObjects);
            fieldEntryPool.growPool(numOfObjects);
            vectorPool.growPool(numOfObjects);
            vectorEntryPool.growPool(numOfObjects);
            seriesPool.growPool(numOfObjects);
            seriesEntryPool.growPool(numOfObjects);
            filterListPool.growPool(numOfObjects);
            filterEntryPool.growPool(numOfObjects);
            realPool.growPool(numOfObjects);
            doublePool.growPool(numOfObjects);
            floatPool.growPool(numOfObjects);
            statePool.growPool(numOfObjects);
            qosPool.growPool(numOfObjects);
            mapPool.growPool(numOfObjects);
            mapEntryPool.growPool(numOfObjects);
            enumPool.growPool(numOfObjects);
            timePool.growPool(numOfObjects);
            datePool.growPool(numOfObjects);
            dateTimePool.growPool(numOfObjects);
            arrayPool.growPool(numOfObjects);
            arrayEntryPool.growPool(numOfObjects);
            msgPool.growPool(numOfObjects);
            fieldSetDefDbPool.growPool(numOfObjects);
            elementSetDefDbPool.growPool(numOfObjects);
            decodeIterPool.growPool(numOfObjects);
            encodeIteratorPool.growPool(numOfObjects);
            byteBufferPool.growPool(numOfObjects);
            isInitialized = true;
        }
    }
}

