/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.util;

import com.refinitiv.eta.json.util.ObjectPool;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ByteArrayPool {
    private Map<Integer, ObjectPool<byte[]>> arrayPools = new HashMap<Integer, ObjectPool<byte[]>>();
    private List<Integer> lengths;
    private int DEFAULT_ARRAY_SIZE = 4096;
    private int DEFAULT_NUM_OF_POOLS = 8;

    public ByteArrayPool() {
        this.arrayPools.put(0, new ObjectPool<byte[]>(true, () -> new byte[0]));
        this.lengths = new LinkedList<Integer>();
        this.lengths.add(0);
        int currLen = this.DEFAULT_ARRAY_SIZE;
        for (int i = 0; i < this.DEFAULT_NUM_OF_POOLS; ++i) {
            int len = currLen;
            this.arrayPools.put(currLen, new ObjectPool<byte[]>(true, () -> new byte[len]));
            this.lengths.add(len);
            currLen += this.DEFAULT_ARRAY_SIZE;
        }
    }

    public byte[] poll(int length) {
        int n = length / this.DEFAULT_ARRAY_SIZE + 1;
        int newLen = this.DEFAULT_ARRAY_SIZE * n;
        ObjectPool<byte[]> pool = this.arrayPools.get(newLen);
        if (pool == null) {
            pool = new ObjectPool<byte[]>(true, () -> new byte[newLen]);
            this.arrayPools.put(newLen, pool);
        }
        return pool.get();
    }

    public void putBack(byte[] arr) {
        ObjectPool<byte[]> pool;
        if (arr != null && (pool = this.arrayPools.get(arr.length)) != null) {
            pool.release(arr);
        }
    }
}

