/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

class JsonUtf8Converter
extends AbstractPrimitiveTypeConverter {
    JsonUtf8Converter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{18};
    }

    @Override
    Object getPrimitiveType() {
        return JsonFactory.createBuffer();
    }

    @Override
    void releasePrimitiveType(Object type) {
        JsonFactory.releaseBuffer((Buffer)type);
    }

    @Override
    int decode(DecodeIterator decIter, Object type) {
        Buffer buffer = (Buffer)type;
        return buffer.decode(decIter);
    }

    @Override
    boolean writeToJson(JsonBuffer outBuffer, Object type, JsonConverterError error) {
        return BasicPrimitiveConverter.writeUTF8String((Buffer)type, outBuffer, error);
    }

    @Override
    public void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        Buffer buffer = (Buffer)msg;
        if (node.isNull()) {
            buffer.clear();
            return;
        }
        buffer.data(ByteBuffer.wrap(node.textValue().getBytes(StandardCharsets.UTF_8)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encodeRWF(JsonNode dataNode, String key, EncodeIterator iter, JsonConverterError error) {
        Buffer encBufferValue = JsonFactory.createBuffer();
        try {
            int result;
            this.decodeJson(dataNode, encBufferValue, error);
            if (error.isSuccessful() && (result = encBufferValue.encode(iter)) != 0) {
                error.setEncodeError(result, key);
            }
        }
        finally {
            JsonFactory.releaseBuffer(encBufferValue);
        }
    }
}

