/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.UpdateMsg;
import com.refinitiv.eta.json.converter.AbstractRsslMessageTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.converter.RsslMsgChunkType;
import com.refinitiv.eta.json.util.JsonFactory;
import java.util.HashMap;
import java.util.Objects;

class JsonUpdateMsgConverter
extends AbstractRsslMessageTypeConverter {
    private static HashMap<Integer, String> updateEventTypeMap = new HashMap();

    JsonUpdateMsgConverter(JsonAbstractConverter converter) {
        super(converter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        block51: {
            block49: {
                block50: {
                    ((Msg)msg).msgClass(4);
                    updateMsg = (UpdateMsg)msg;
                    updateMsg.domainType(6);
                    hasId = false;
                    extendedHeaderBuffer = null;
                    permDataBuffer = null;
                    try {
                        it = node.fieldNames();
                        while (it.hasNext()) {
                            key = (String)it.next();
                            currentNode = node.path(key);
                            var11_11 = key;
                            var12_12 = -1;
                            switch (var11_11.hashCode()) {
                                case 2331: {
                                    if (!var11_11.equals("ID")) break;
                                    var12_12 = 0;
                                    break;
                                }
                                case 2622298: {
                                    if (!var11_11.equals("Type")) break;
                                    var12_12 = 1;
                                    break;
                                }
                                case 2052636900: {
                                    if (!var11_11.equals("Domain")) break;
                                    var12_12 = 2;
                                    break;
                                }
                                case 56304919: {
                                    if (!var11_11.equals("Elements")) break;
                                    var12_12 = 3;
                                    break;
                                }
                                case 2104126169: {
                                    if (!var11_11.equals("Fields")) break;
                                    var12_12 = 4;
                                    break;
                                }
                                case 440160342: {
                                    if (!var11_11.equals("FilterList")) break;
                                    var12_12 = 5;
                                    break;
                                }
                                case 77116: {
                                    if (!var11_11.equals("Map")) break;
                                    var12_12 = 6;
                                    break;
                                }
                                case -1675388953: {
                                    if (!var11_11.equals("Message")) break;
                                    var12_12 = 7;
                                    break;
                                }
                                case -1736520349: {
                                    if (!var11_11.equals("Vector")) break;
                                    var12_12 = 8;
                                    break;
                                }
                                case 2318600: {
                                    if (!var11_11.equals("Json")) break;
                                    var12_12 = 9;
                                    break;
                                }
                                case 88055: {
                                    if (!var11_11.equals("Xml")) break;
                                    var12_12 = 10;
                                    break;
                                }
                                case -1926827967: {
                                    if (!var11_11.equals("Opaque")) break;
                                    var12_12 = 11;
                                    break;
                                }
                                case -1821971817: {
                                    if (!var11_11.equals("Series")) break;
                                    var12_12 = 12;
                                    break;
                                }
                                case 75327: {
                                    if (!var11_11.equals("Key")) break;
                                    var12_12 = 13;
                                    break;
                                }
                                case 2089762101: {
                                    if (!var11_11.equals("ExtHdr")) break;
                                    var12_12 = 14;
                                    break;
                                }
                                case -694118407: {
                                    if (!var11_11.equals("PostUserInfo")) break;
                                    var12_12 = 15;
                                    break;
                                }
                                case 500974298: {
                                    if (!var11_11.equals("PermData")) break;
                                    var12_12 = 16;
                                    break;
                                }
                                case -211509144: {
                                    if (!var11_11.equals("SeqNumber")) break;
                                    var12_12 = 17;
                                    break;
                                }
                                case -297064293: {
                                    if (!var11_11.equals("ConflationInfo")) break;
                                    var12_12 = 18;
                                    break;
                                }
                                case -1922207174: {
                                    if (!var11_11.equals("DoNotCache")) break;
                                    var12_12 = 19;
                                    break;
                                }
                                case 178565650: {
                                    if (!var11_11.equals("DoNotConflate")) break;
                                    var12_12 = 20;
                                    break;
                                }
                                case 978340472: {
                                    if (!var11_11.equals("DoNotRipple")) break;
                                    var12_12 = 21;
                                    break;
                                }
                                case 1697549251: {
                                    if (!var11_11.equals("UpdateType")) break;
                                    var12_12 = 22;
                                    break;
                                }
                            }
                            switch (var12_12) {
                                case 0: {
                                    updateMsg.streamId(this.getInt(currentNode, key, error));
                                    hasId = true;
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    this.checkStringOrInt(currentNode, key, error);
                                    if (error.isFailed()) break;
                                    if (currentNode.isTextual()) {
                                        updateMsg.domainType(ConstCharArrays.JsonDomain.ofValue(this.getText(currentNode, key, error), error));
                                        break;
                                    }
                                    updateMsg.domainType(this.getInt(currentNode, key, error));
                                    break;
                                }
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: {
                                    updateMsg.containerType(this.converter.getContainerDataType(key, currentNode, error));
                                    break;
                                }
                                case 13: {
                                    updateMsg.applyHasMsgKey();
                                    this.converter.decodeChunk(RsslMsgChunkType.MSG_KEY_CHUNK, currentNode, (Object)updateMsg, error);
                                    break;
                                }
                                case 14: {
                                    updateMsg.applyHasExtendedHdr();
                                    extendedHeaderBuffer = JsonFactory.createBuffer();
                                    BufferConverter.decodeFromBase64(this.getText(currentNode, key, error), extendedHeaderBuffer, error);
                                    if (error.isFailed()) break;
                                    updateMsg.extendedHeader(extendedHeaderBuffer);
                                    break;
                                }
                                case 15: {
                                    updateMsg.applyHasPostUserInfo();
                                    this.converter.decodeChunk(RsslMsgChunkType.POST_USER_INFO_CHUNK, currentNode, (Object)updateMsg.postUserInfo(), error);
                                    break;
                                }
                                case 16: {
                                    updateMsg.applyHasPermData();
                                    permDataBuffer = JsonFactory.createBuffer();
                                    BufferConverter.decodeFromBase64(this.getText(currentNode, key, error), permDataBuffer, error);
                                    if (error.isFailed()) break;
                                    updateMsg.permData(permDataBuffer);
                                    break;
                                }
                                case 17: {
                                    updateMsg.applyHasSeqNum();
                                    updateMsg.seqNum(this.getLong(currentNode, key, error));
                                    break;
                                }
                                case 18: {
                                    updateMsg.applyHasConfInfo();
                                    this.converter.decodeChunk(RsslMsgChunkType.CONFINFO_CHUNK, currentNode, (Object)updateMsg, error);
                                    break;
                                }
                                case 19: {
                                    if (!this.getBoolean(currentNode, key, error)) break;
                                    updateMsg.applyDoNotCache();
                                    break;
                                }
                                case 20: {
                                    if (!this.getBoolean(currentNode, key, error)) break;
                                    updateMsg.applyDoNotConflate();
                                    break;
                                }
                                case 21: {
                                    if (!this.getBoolean(currentNode, key, error)) break;
                                    updateMsg.applyDoNotRipple();
                                    break;
                                }
                                case 22: {
                                    this.checkStringOrInt(currentNode, key, error);
                                    if (error.isFailed()) break;
                                    if (currentNode.isTextual()) {
                                        updateMsg.updateType(ConstCharArrays.JsonUpdateType.ofValue(this.getText(currentNode, key, error), error));
                                        break;
                                    }
                                    updateMsg.updateType(this.getInt(currentNode, key, error));
                                    break;
                                }
                                default: {
                                    this.processUnexpectedKey(key, error);
                                }
                            }
                            if (!error.isFailed()) continue;
                            if (extendedHeaderBuffer == null) break block49;
                            break block50;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var13_13) {
                        if (extendedHeaderBuffer != null) {
                            JsonFactory.releaseBuffer(extendedHeaderBuffer);
                        }
                        if (permDataBuffer == null) throw var13_13;
                        JsonFactory.releaseBuffer(permDataBuffer);
                        throw var13_13;
                    }
                }
                JsonFactory.releaseBuffer(extendedHeaderBuffer);
            }
            if (permDataBuffer == null) return;
            JsonFactory.releaseBuffer(permDataBuffer);
            return;
lbl-1000:
            // 1 sources

            {
                if (!hasId) {
                    error.setError(12, "ID");
                }
                if (extendedHeaderBuffer == null) break block51;
            }
            JsonFactory.releaseBuffer(extendedHeaderBuffer);
        }
        if (permDataBuffer == null) return;
        JsonFactory.releaseBuffer(permDataBuffer);
    }

    @Override
    boolean encodeJson(DecodeIterator decIter, Object msg, JsonBuffer outBuffer, JsonConverterError error) {
        UpdateMsg upd = (UpdateMsg)msg;
        BufferHelper.writeArrayAndColon("UpdateType", outBuffer, true, error);
        String updateType = this.getUpdateEventType(upd.updateType());
        if (updateType != null) {
            BufferHelper.writeArray(updateType, outBuffer, true, error);
        } else {
            BasicPrimitiveConverter.writeLong(upd.updateType(), outBuffer, error);
        }
        if (upd.checkDoNotConflate()) {
            BufferHelper.writeArrayAndColon("DoNotConflate", outBuffer, true, error);
            BufferHelper.writeArray("true", outBuffer, false, error);
        }
        if (upd.checkDoNotRipple()) {
            BufferHelper.writeArrayAndColon("DoNotRipple", outBuffer, true, error);
            BufferHelper.writeArray("true", outBuffer, false, error);
        }
        if (upd.checkDiscardable()) {
            BufferHelper.writeArrayAndColon("Discardable", outBuffer, true, error);
            BufferHelper.writeArray("true", outBuffer, false, error);
        }
        if (upd.checkDoNotCache()) {
            BufferHelper.writeArrayAndColon("DoNotCache", outBuffer, true, error);
            BufferHelper.writeArray("true", outBuffer, false, error);
        }
        if (upd.checkHasMsgKey()) {
            BufferHelper.writeArrayAndColon("Key", outBuffer, true, error);
            if (!this.converter.processMsgKey(decIter, upd.msgKey(), outBuffer, upd.domainType(), true, error)) {
                return false;
            }
        }
        if (upd.checkHasPostUserInfo()) {
            BufferHelper.writeArrayAndColon("PostUserInfo", outBuffer, true, error);
            if (!this.converter.processPostUserInfo(upd.postUserInfo(), outBuffer, error)) {
                return false;
            }
        }
        if (upd.checkHasPermData()) {
            if (Objects.nonNull(upd.permData()) && Objects.nonNull(upd.permData().data())) {
                BufferHelper.writeArrayAndColon("PermData", outBuffer, true, error);
                if (!this.converter.getPrimitiveHandler(16).encodeJson(upd.permData(), outBuffer, error)) {
                    return false;
                }
            } else {
                error.setError(4, "Empty permission data found");
                return false;
            }
        }
        if (upd.checkHasSeqNum()) {
            BufferHelper.writeArrayAndColon("SeqNumber", outBuffer, true, error);
            BasicPrimitiveConverter.writeLong(upd.seqNum(), outBuffer, error);
        }
        if (upd.checkHasConfInfo()) {
            BufferHelper.writeArrayAndColon("ConflationInfo", outBuffer, true, error);
            BufferHelper.beginObject(outBuffer, error);
            BufferHelper.writeArrayAndColon("Count", outBuffer, false, error);
            BasicPrimitiveConverter.writeLong(upd.conflationCount(), outBuffer, error);
            BufferHelper.writeArrayAndColon("Time", outBuffer, true, error);
            BasicPrimitiveConverter.writeLong(upd.conflationTime(), outBuffer, error);
            BufferHelper.endObject(outBuffer, error);
        }
        if (upd.checkHasExtendedHdr()) {
            if (Objects.nonNull(upd.extendedHeader()) && Objects.nonNull(upd.extendedHeader().data())) {
                BufferHelper.writeArrayAndColon("ExtHdr", outBuffer, true, error);
                if (!this.converter.getPrimitiveHandler(16).encodeJson(upd.extendedHeader(), outBuffer, error)) {
                    return false;
                }
            } else {
                error.setError(4, "Empty extended header found");
                return false;
            }
        }
        if (upd.containerType() != 128) {
            BufferHelper.comma(outBuffer, error);
            this.converter.getContainerHandler(upd.containerType()).encodeJson(decIter, outBuffer, true, null, error);
        }
        return error.isSuccessful();
    }

    private String getUpdateEventType(int type) {
        return updateEventTypeMap.get(type);
    }

    static {
        updateEventTypeMap.put(0, "Unspecified");
        updateEventTypeMap.put(1, "Quote");
        updateEventTypeMap.put(2, "Trade");
        updateEventTypeMap.put(3, "NewsAlert");
        updateEventTypeMap.put(4, "VolumeAlert");
        updateEventTypeMap.put(5, "OrderIndication");
        updateEventTypeMap.put(6, "ClosingRun");
        updateEventTypeMap.put(7, "Correction");
        updateEventTypeMap.put(8, "MarketDigest");
        updateEventTypeMap.put(9, "QuotesTrade");
        updateEventTypeMap.put(10, "Multiple");
        updateEventTypeMap.put(11, "Verify");
    }
}

