/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;

public class JsonUnknownTypeConverter
extends AbstractPrimitiveTypeConverter {
    JsonUnknownTypeConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{0};
    }

    @Override
    int decode(DecodeIterator decIter, Object type) {
        return 0;
    }

    @Override
    boolean writeToJson(JsonBuffer outBuffer, Object type, JsonConverterError error) {
        return false;
    }

    @Override
    boolean encodeJson(DecodeIterator decIter, JsonBuffer outBuffer, JsonConverterError error) {
        error.setError(5, "Unknown type is not supported.");
        return false;
    }

    @Override
    void encodeRWF(JsonNode dataNode, String key, EncodeIterator iter, JsonConverterError error) {
        this.converter.getPrimitiveHandler(16).encodeRWF(dataNode, key, iter, error);
    }

    @Override
    public void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        error.setError(5, "Unknown type not supported");
    }
}

