/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.StatusMsg;
import com.refinitiv.eta.json.converter.AbstractRsslMessageTypeConverter;
import com.refinitiv.eta.json.converter.BufferConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.converter.JsonStateConverter;
import com.refinitiv.eta.json.converter.RsslMsgChunkType;
import com.refinitiv.eta.json.util.JsonFactory;
import java.util.Objects;

class JsonStatusMsgConverter
extends AbstractRsslMessageTypeConverter {
    JsonStatusMsgConverter(JsonAbstractConverter converter) {
        super(converter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        block48: {
            block46: {
                block47: {
                    ((Msg)msg).msgClass(3);
                    statusMsg = (StatusMsg)msg;
                    statusMsg.domainType(6);
                    hasId = false;
                    extendedHeaderBuffer = null;
                    permDataBuffer = null;
                    try {
                        it = node.fieldNames();
                        while (it.hasNext()) {
                            key = (String)it.next();
                            currentNode = node.path(key);
                            var11_11 = key;
                            var12_12 = -1;
                            switch (var11_11.hashCode()) {
                                case 2331: {
                                    if (!var11_11.equals("ID")) break;
                                    var12_12 = 0;
                                    break;
                                }
                                case 2622298: {
                                    if (!var11_11.equals("Type")) break;
                                    var12_12 = 1;
                                    break;
                                }
                                case 2052636900: {
                                    if (!var11_11.equals("Domain")) break;
                                    var12_12 = 2;
                                    break;
                                }
                                case 56304919: {
                                    if (!var11_11.equals("Elements")) break;
                                    var12_12 = 3;
                                    break;
                                }
                                case 2104126169: {
                                    if (!var11_11.equals("Fields")) break;
                                    var12_12 = 4;
                                    break;
                                }
                                case 440160342: {
                                    if (!var11_11.equals("FilterList")) break;
                                    var12_12 = 5;
                                    break;
                                }
                                case 77116: {
                                    if (!var11_11.equals("Map")) break;
                                    var12_12 = 6;
                                    break;
                                }
                                case -1675388953: {
                                    if (!var11_11.equals("Message")) break;
                                    var12_12 = 7;
                                    break;
                                }
                                case -1736520349: {
                                    if (!var11_11.equals("Vector")) break;
                                    var12_12 = 8;
                                    break;
                                }
                                case 2318600: {
                                    if (!var11_11.equals("Json")) break;
                                    var12_12 = 9;
                                    break;
                                }
                                case 88055: {
                                    if (!var11_11.equals("Xml")) break;
                                    var12_12 = 10;
                                    break;
                                }
                                case -1926827967: {
                                    if (!var11_11.equals("Opaque")) break;
                                    var12_12 = 11;
                                    break;
                                }
                                case -1821971817: {
                                    if (!var11_11.equals("Series")) break;
                                    var12_12 = 12;
                                    break;
                                }
                                case 75327: {
                                    if (!var11_11.equals("Key")) break;
                                    var12_12 = 13;
                                    break;
                                }
                                case -1850659583: {
                                    if (!var11_11.equals("ReqKey")) break;
                                    var12_12 = 14;
                                    break;
                                }
                                case 2089762101: {
                                    if (!var11_11.equals("ExtHdr")) break;
                                    var12_12 = 15;
                                    break;
                                }
                                case -694118407: {
                                    if (!var11_11.equals("PostUserInfo")) break;
                                    var12_12 = 16;
                                    break;
                                }
                                case 500974298: {
                                    if (!var11_11.equals("PermData")) break;
                                    var12_12 = 17;
                                    break;
                                }
                                case 1350155619: {
                                    if (!var11_11.equals("Private")) break;
                                    var12_12 = 18;
                                    break;
                                }
                                case 80204913: {
                                    if (!var11_11.equals("State")) break;
                                    var12_12 = 19;
                                    break;
                                }
                                case 1234226517: {
                                    if (!var11_11.equals("ClearCache")) break;
                                    var12_12 = 20;
                                    break;
                                }
                                case 756027516: {
                                    if (!var11_11.equals("Qualified")) break;
                                    var12_12 = 21;
                                    break;
                                }
                            }
                            switch (var12_12) {
                                case 0: {
                                    statusMsg.streamId(this.getInt(currentNode, key, error));
                                    hasId = true;
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    this.checkStringOrInt(currentNode, key, error);
                                    if (error.isFailed()) break;
                                    if (currentNode.isTextual()) {
                                        statusMsg.domainType(ConstCharArrays.JsonDomain.ofValue(this.getText(currentNode, key, error), error));
                                        break;
                                    }
                                    statusMsg.domainType(this.getInt(currentNode, key, error));
                                    break;
                                }
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: {
                                    statusMsg.containerType(this.converter.getContainerDataType(key, currentNode, error));
                                    break;
                                }
                                case 13: {
                                    statusMsg.applyHasMsgKey();
                                    this.converter.decodeChunk(RsslMsgChunkType.MSG_KEY_CHUNK, currentNode, (Object)statusMsg, error);
                                    break;
                                }
                                case 14: {
                                    break;
                                }
                                case 15: {
                                    statusMsg.applyHasExtendedHdr();
                                    extendedHeaderBuffer = JsonFactory.createBuffer();
                                    BufferConverter.decodeFromBase64(this.getText(currentNode, key, error), extendedHeaderBuffer, error);
                                    if (error.isFailed()) break;
                                    statusMsg.extendedHeader(extendedHeaderBuffer);
                                    break;
                                }
                                case 16: {
                                    statusMsg.applyHasPostUserInfo();
                                    this.converter.decodeChunk(RsslMsgChunkType.POST_USER_INFO_CHUNK, currentNode, (Object)statusMsg.postUserInfo(), error);
                                    break;
                                }
                                case 17: {
                                    statusMsg.applyHasPermData();
                                    permDataBuffer = JsonFactory.createBuffer();
                                    BufferConverter.decodeFromBase64(this.getText(currentNode, key, error), permDataBuffer, error);
                                    if (error.isFailed()) break;
                                    statusMsg.permData(permDataBuffer);
                                    break;
                                }
                                case 18: {
                                    if (!this.getBoolean(currentNode, key, error)) break;
                                    statusMsg.applyPrivateStream();
                                    break;
                                }
                                case 19: {
                                    statusMsg.applyHasState();
                                    this.converter.decodeChunk(13, currentNode, (Object)statusMsg.state(), error);
                                    break;
                                }
                                case 20: {
                                    if (!this.getBoolean(currentNode, key, error)) break;
                                    statusMsg.applyClearCache();
                                    break;
                                }
                                case 21: {
                                    if (!this.getBoolean(currentNode, key, error)) break;
                                    statusMsg.applyQualifiedStream();
                                    break;
                                }
                                default: {
                                    this.processUnexpectedKey(key, error);
                                }
                            }
                            if (!error.isFailed()) continue;
                            if (extendedHeaderBuffer == null) break block46;
                            break block47;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var13_13) {
                        if (extendedHeaderBuffer != null) {
                            JsonFactory.releaseBuffer(extendedHeaderBuffer);
                        }
                        if (permDataBuffer == null) throw var13_13;
                        JsonFactory.releaseBuffer(permDataBuffer);
                        throw var13_13;
                    }
                }
                JsonFactory.releaseBuffer(extendedHeaderBuffer);
            }
            if (permDataBuffer == null) return;
            JsonFactory.releaseBuffer(permDataBuffer);
            return;
lbl-1000:
            // 1 sources

            {
                if (!hasId) {
                    error.setError(12, "ID");
                }
                if (extendedHeaderBuffer == null) break block48;
            }
            JsonFactory.releaseBuffer(extendedHeaderBuffer);
        }
        if (permDataBuffer == null) return;
        JsonFactory.releaseBuffer(permDataBuffer);
    }

    @Override
    boolean encodeJson(DecodeIterator decIter, Object msg, JsonBuffer outBuffer, JsonConverterError error) {
        StatusMsg statusMsg = (StatusMsg)msg;
        if (statusMsg.flags() != 0) {
            if (statusMsg.checkHasMsgKey()) {
                BufferHelper.writeArrayAndColon("Key", outBuffer, true, error);
                this.converter.processMsgKey(decIter, statusMsg.msgKey(), outBuffer, statusMsg.domainType(), true, error);
            }
            if (statusMsg.checkHasState()) {
                BufferHelper.writeArrayAndColon("State", outBuffer, true, error);
                if (!((JsonStateConverter)this.converter.getPrimitiveHandler(13)).writeToJson(statusMsg.state(), outBuffer, error)) {
                    return false;
                }
            }
            if (statusMsg.checkClearCache()) {
                BufferHelper.writeArrayAndColon("ClearCache", outBuffer, true, error);
                BufferHelper.writeArray("true", outBuffer, false, error);
            }
            if (statusMsg.checkPrivateStream()) {
                BufferHelper.writeArrayAndColon("Private", outBuffer, true, error);
                BufferHelper.writeArray("true", outBuffer, false, error);
            }
            if (statusMsg.checkQualifiedStream()) {
                BufferHelper.writeArrayAndColon("Qualified", outBuffer, true, error);
                BufferHelper.writeArray("true", outBuffer, false, error);
            }
            if (statusMsg.checkHasPostUserInfo()) {
                BufferHelper.writeArrayAndColon("PostUserInfo", outBuffer, true, error);
                if (!this.converter.processPostUserInfo(statusMsg.postUserInfo(), outBuffer, error)) {
                    return false;
                }
            }
            if (statusMsg.checkHasExtendedHdr()) {
                if (Objects.nonNull(statusMsg.extendedHeader()) && Objects.nonNull(statusMsg.extendedHeader().data())) {
                    BufferHelper.writeArrayAndColon("ExtHdr", outBuffer, true, error);
                    if (!this.converter.getPrimitiveHandler(16).encodeJson(statusMsg.extendedHeader(), outBuffer, error)) {
                        return false;
                    }
                } else {
                    error.setError(4, "Empty extended header found");
                    return false;
                }
            }
            if (statusMsg.checkHasPermData()) {
                if (Objects.nonNull(statusMsg.permData()) && Objects.nonNull(statusMsg.permData().data())) {
                    BufferHelper.writeArrayAndColon("PermData", outBuffer, true, error);
                    if (!this.converter.getPrimitiveHandler(16).encodeJson(statusMsg.permData(), outBuffer, error)) {
                        return false;
                    }
                } else {
                    error.setError(4, "Empty permission data found");
                    return false;
                }
            }
        }
        if (statusMsg.containerType() != 128) {
            BufferHelper.comma(outBuffer, error);
            if (!this.converter.getContainerHandler(statusMsg.containerType()).encodeJson(decIter, outBuffer, true, null, error)) {
                return false;
            }
        }
        return error.isSuccessful();
    }
}

