/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Qos;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import java.util.Iterator;

class JsonQosConverter
extends AbstractPrimitiveTypeConverter {
    JsonQosConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{12};
    }

    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        Qos qos = (Qos)msg;
        if (node.isNull()) {
            qos.clear();
            return;
        }
        this.checkObject(node, "Qos", error);
        if (error.isFailed()) {
            return;
        }
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            JsonNode currentNode = node.path(key);
            int result = 0;
            switch (key) {
                case "Timeliness": {
                    result = this.decodeTimeliness(currentNode, key, qos, error);
                    break;
                }
                case "Rate": {
                    result = this.decodeRate(currentNode, key, qos, error);
                    break;
                }
                case "TimeInfo": {
                    qos.timeInfo(this.getInt(currentNode, key, error));
                    break;
                }
                case "RateInfo": {
                    qos.rateInfo(this.getInt(currentNode, key, error));
                    break;
                }
                default: {
                    this.processUnexpectedKey(key, error);
                }
            }
            if (error.isFailed()) {
                return;
            }
            if (result == 0) continue;
            error.setError(4, key + "=" + currentNode.asText());
        }
    }

    private int decodeRate(JsonNode currentNode, String key, Qos qos, JsonConverterError error) {
        this.checkStringOrInt(currentNode, key, error);
        if (error.isFailed()) {
            return -1;
        }
        if (currentNode.isTextual()) {
            return qos.rate(ConstCharArrays.JsonQosRate.ofValue(this.getText(currentNode, key, error), error));
        }
        return qos.rate(this.getInt(currentNode, key, error));
    }

    private int decodeTimeliness(JsonNode currentNode, String key, Qos qos, JsonConverterError error) {
        this.checkStringOrInt(currentNode, key, error);
        if (error.isFailed()) {
            return -1;
        }
        if (currentNode.isTextual()) {
            return qos.timeliness(ConstCharArrays.JsonQosTimeliness.ofValue(this.getText(currentNode, key, error), error));
        }
        return qos.timeliness(this.getInt(currentNode, key, error));
    }

    @Override
    Object getPrimitiveType() {
        return JsonFactory.createQos();
    }

    @Override
    void releasePrimitiveType(Object type) {
        JsonFactory.releaseQos((Qos)type);
    }

    @Override
    int decode(DecodeIterator decIter, Object type) {
        Qos qos = (Qos)type;
        qos.clear();
        return qos.decode(decIter);
    }

    @Override
    boolean writeToJson(JsonBuffer outBuffer, Object type, JsonConverterError error) {
        return this.writeToJson((Qos)type, outBuffer, error);
    }

    boolean writeToJson(Qos qos, JsonBuffer outBuffer, JsonConverterError error) {
        BufferHelper.beginObject(outBuffer, error);
        BufferHelper.writeArrayAndColon("Timeliness", outBuffer, false, error);
        BufferHelper.writeArray(JsonQosConverter.getQosTimeliness(qos.timeliness()), outBuffer, true, error);
        BufferHelper.writeArrayAndColon("Rate", outBuffer, true, error);
        BufferHelper.writeArray(JsonQosConverter.getQosRate(qos.rate()), outBuffer, true, error);
        if (qos.isDynamic()) {
            BufferHelper.writeArrayAndColon("Dynamic", outBuffer, true, error);
            BufferHelper.writeArray("true", outBuffer, false, error);
        }
        if (qos.timeliness() == 3) {
            BufferHelper.writeArrayAndColon("TimeInfo", outBuffer, true, error);
            BasicPrimitiveConverter.writeLong(qos.timeInfo(), outBuffer, error);
        }
        if (qos.rate() == 3) {
            BufferHelper.writeArrayAndColon("RateInfo", outBuffer, true, error);
            BasicPrimitiveConverter.writeLong(qos.rateInfo(), outBuffer, error);
        }
        return BufferHelper.endObject(outBuffer, error);
    }

    private static String getQosTimeliness(int time) {
        if (0 <= time && time <= 3) {
            return ConstCharArrays.qosTimelinessStrings[time];
        }
        return null;
    }

    private static String getQosRate(int rate) {
        if (0 <= rate && rate <= 3) {
            return ConstCharArrays.qosRateStrings[rate];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encodeRWF(JsonNode dataNode, String key, EncodeIterator iter, JsonConverterError error) {
        if (dataNode.isNull()) {
            return;
        }
        Qos encQosValue = JsonFactory.createQos();
        try {
            int result;
            if (!dataNode.path("Timeliness").isMissingNode()) {
                this.decodeTimeliness(dataNode.path("Timeliness"), "Timeliness", encQosValue, error);
            }
            if (!dataNode.path("Rate").isMissingNode()) {
                this.decodeRate(dataNode.path("Rate"), "Rate", encQosValue, error);
            }
            if (!dataNode.path("TimeInfo").isMissingNode()) {
                encQosValue.timeInfo(this.getInt(dataNode.path("TimeInfo"), key, error));
            }
            if (!dataNode.path("RateInfo").isMissingNode()) {
                encQosValue.rateInfo(this.getInt(dataNode.path("RateInfo"), key, error));
            }
            if ((result = encQosValue.encode(iter)) != 0) {
                error.setEncodeError(result, key);
                return;
            }
        }
        finally {
            JsonFactory.releaseQos(encQosValue);
        }
    }
}

