/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum JsonMsgTypes {
    PING("Ping", 1),
    PONG("Pong", 2),
    ERROR("Error", 3);

    private static final Map<String, JsonMsgTypes> MSG_TYPES_MAP;
    private String typeName;
    private int readCode;

    private JsonMsgTypes(String typeName, int readCode) {
        this.typeName = typeName;
        this.readCode = readCode;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getReadCode() {
        return this.readCode;
    }

    public static JsonMsgTypes getJsonMsgByType(String type) {
        return MSG_TYPES_MAP.get(type);
    }

    public static JsonMsgTypes getJsonMsgByCode(int readCode) {
        if (readCode > ERROR.getReadCode() || readCode < PING.getReadCode()) {
            return null;
        }
        return JsonMsgTypes.values()[readCode];
    }

    static {
        MSG_TYPES_MAP = new HashMap<String, JsonMsgTypes>();
        Arrays.stream(JsonMsgTypes.values()).forEach(value -> MSG_TYPES_MAP.put(value.typeName, (JsonMsgTypes)((Object)value)));
    }
}

