/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.Codec;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.MsgKey;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.json.converter.AbstractRsslMessageChunkTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import java.util.Iterator;

class JsonMsgKeyConverter
extends AbstractRsslMessageChunkTypeConverter {
    JsonMsgKeyConverter(JsonAbstractConverter converter) {
        super(converter);
    }

    @Override
    protected void decodeJson(JsonNode node, Object msgObj, JsonConverterError error) {
        RequestMsg msg = (RequestMsg)msgObj;
        MsgKey msgKey = msg.msgKey();
        msgKey.nameType(1);
        msgKey.applyHasNameType();
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            JsonNode currentNode = node.path(key);
            switch (key) {
                case "Name": {
                    if (currentNode.isTextual()) {
                        msgKey.applyHasName();
                        msgKey.name().data(this.getText(currentNode, key, error));
                        break;
                    }
                    if (currentNode.isArray() && msg instanceof RequestMsg) {
                        msg.applyHasBatch();
                        msg.containerType(133);
                        break;
                    }
                    error.setError(3, key + " TEXT or ARRAY type was expected", "Name");
                    break;
                }
                case "NameType": {
                    this.checkStringOrInt(currentNode, key, error);
                    if (error.isFailed()) break;
                    msgKey.applyHasNameType();
                    if (currentNode.isTextual()) {
                        msgKey.nameType(ConstCharArrays.JsonNameType.ofValue(this.getText(currentNode, key, error), error));
                        break;
                    }
                    msgKey.nameType(this.getInt(currentNode, key, error));
                    break;
                }
                case "Elements": {
                    msgKey.applyHasAttrib();
                    msgKey.attribContainerType(133);
                    break;
                }
                case "Filter": {
                    msgKey.applyHasFilter();
                    if (currentNode.isInt()) {
                        msgKey.filter((long)currentNode.asInt());
                        break;
                    }
                    if (currentNode.isLong()) {
                        msgKey.filter(currentNode.asLong());
                        break;
                    }
                    error.setError(4, "expected Long type for Filter, found " + currentNode.getNodeType().toString(), "Filter");
                    break;
                }
                case "Identifier": {
                    msgKey.applyHasIdentifier();
                    msgKey.identifier(this.getInt(currentNode, key, error));
                    break;
                }
                case "Service": {
                    this.checkStringOrInt(currentNode, key, error);
                    if (error.isFailed()) break;
                    int serviceId = -1;
                    if (currentNode.isTextual()) {
                        serviceId = this.converter.serviceNameToId(this.getText(currentNode, key, error), error);
                        if (serviceId == -1) {
                            if (!error.isFailed()) {
                                error.setError(4, "token: " + key + " , failed to find appropriate service ID");
                            }
                            return;
                        }
                    } else {
                        serviceId = this.getInt(currentNode, key, error);
                    }
                    if (serviceId < 0) {
                        error.setError(4, "token: " + key + " , invalid service ID " + serviceId);
                        return;
                    }
                    msgKey.serviceId(serviceId);
                    msgKey.applyHasServiceId();
                    break;
                }
                default: {
                    this.processUnexpectedKey(key, error);
                }
            }
            if (!error.isFailed()) continue;
            return;
        }
        if (!(msgKey.nameType() != 4 && msgKey.nameType() != 5 || msgKey.checkHasName())) {
            msgKey.applyHasName();
            msgKey.name().data(ConstCharArrays.blankStringConst);
        }
        if (!msgKey.checkHasServiceId() && this.converter.hasDefaultServiceId() && msg.domainType() != 4 && msg.domainType() != 1) {
            msgKey.applyHasServiceId();
            msgKey.serviceId(this.converter.getDefaultServiceId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean encodeJson(DecodeIterator decIter, Object msgKey, JsonBuffer outBuffer, int domain, boolean wantServiceName, JsonConverterError error) {
        boolean comma = false;
        MsgKey key = (MsgKey)msgKey;
        if (key.flags() == 0) {
            return BufferHelper.beginObject(outBuffer, error) && BufferHelper.endObject(outBuffer, error);
        }
        BufferHelper.beginObject(outBuffer, error);
        if (key.checkHasServiceId()) {
            BufferHelper.writeArrayAndColon("Service", outBuffer, false, error);
            if (wantServiceName) {
                String serviceName = this.converter.getServiceNameIdConverter().serviceIdToName(key.serviceId(), error);
                if (serviceName != null) {
                    BufferHelper.writeArray(serviceName, outBuffer, true, error);
                } else {
                    BasicPrimitiveConverter.writeLong(key.serviceId(), outBuffer, error);
                }
            } else {
                BasicPrimitiveConverter.writeLong(key.serviceId(), outBuffer, error);
            }
            comma = true;
        }
        if (key.checkHasNameType() && key.nameType() != 1) {
            BufferHelper.writeArrayAndColon("NameType", outBuffer, comma, error);
            String nameType = domain == 1 ? JsonMsgKeyConverter.getLoginUserIdType(key.nameType()) : JsonMsgKeyConverter.getInstrumentNameType(key.nameType());
            if (nameType != null) {
                BufferHelper.writeArray(nameType, outBuffer, true, error);
            } else {
                BasicPrimitiveConverter.writeLong(key.nameType(), outBuffer, error);
            }
            comma = true;
        }
        if (key.checkHasName() && key.nameType() != 4 && key.nameType() != 5) {
            BufferHelper.writeArrayAndColon("Name", outBuffer, comma, error);
            if (key.name().length() == 0 || key.name().length() == 1 && (key.name().data() == null || key.name().equals(ConstCharArrays.emptyBuffer))) {
                BufferHelper.writeArray("null", outBuffer, false, error);
            } else {
                BasicPrimitiveConverter.writeAsciiString(key.name(), outBuffer, error);
            }
            comma = true;
        }
        if (key.checkHasFilter()) {
            BufferHelper.writeArrayAndColon("Filter", outBuffer, comma, error);
            BasicPrimitiveConverter.writeLong(key.filter(), outBuffer, error);
            comma = true;
        }
        if (key.checkHasIdentifier()) {
            BufferHelper.writeArrayAndColon("Identifier", outBuffer, comma, error);
            BasicPrimitiveConverter.writeLong(key.identifier(), outBuffer, error);
            comma = true;
        }
        if (key.checkHasAttrib()) {
            DecodeIterator iter = JsonFactory.createDecodeIterator();
            try {
                iter.clear();
                iter.setBufferAndRWFVersion(key.encodedAttrib(), Codec.majorVersion(), Codec.minorVersion());
                if (comma) {
                    BufferHelper.comma(outBuffer, error);
                }
                if (!this.converter.getContainerHandler(key.attribContainerType()).encodeJson(iter, outBuffer, true, null, error)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                JsonFactory.releaseDecodeIterator(iter);
            }
        }
        BufferHelper.endObject(outBuffer, error);
        return error.isSuccessful();
    }

    private static String getLoginUserIdType(int nameType) {
        switch (nameType) {
            case 1: {
                return "Name";
            }
            case 2: {
                return "EmailAddress";
            }
            case 3: {
                return "Token";
            }
            case 4: {
                return "Cookie";
            }
            case 5: {
                return "AuthnToken";
            }
        }
        return null;
    }

    private static String getInstrumentNameType(int nameType) {
        switch (nameType) {
            case 1: {
                return "Ric";
            }
            case 2: {
                return "Contributor";
            }
            case 0: {
                return "Unspecified";
            }
        }
        return null;
    }
}

