/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.json.converter.AbstractContainerTypeConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;

class JsonMsgConverter
extends AbstractContainerTypeConverter {
    JsonMsgConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{141};
    }

    @Override
    protected int decodeEntry(DecodeIterator decIter, Object entryObj) {
        return -1;
    }

    @Override
    protected boolean writeContent(DecodeIterator decIter, JsonBuffer outBuffer, JsonConverterError error, Object container) {
        return false;
    }

    @Override
    protected int decodeContainer(DecodeIterator decIter, Object setDb, Object container) {
        return -1;
    }

    @Override
    protected boolean writeEntry(DecodeIterator decIterator, JsonBuffer outBuffer, Object localSetDb, JsonConverterError error, Object entryObj, Object container) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean encodeJson(DecodeIterator decIter, JsonBuffer outBuffer, boolean writeTag, Object setDb, JsonConverterError error) {
        Msg message = JsonFactory.createMsg();
        try {
            int ret;
            message.clear();
            if (writeTag) {
                BufferHelper.writeArrayAndColon("Message", outBuffer, false, error);
            }
            if ((ret = message.decode(decIter)) < 0) {
                error.setError(15, "Failed decoding Message, code = " + ret);
                boolean bl = false;
                return bl;
            }
            boolean bl = this.converter.processMsg(decIter, message, outBuffer, error, false);
            return bl;
        }
        finally {
            JsonFactory.releaseMsg(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encodeRWF(JsonNode dataNode, String key, EncodeIterator iter, JsonConverterError error) {
        int msgType = 1;
        JsonNode msgTypeNode = dataNode.path("Type");
        if (msgTypeNode != null && !msgTypeNode.isMissingNode()) {
            msgType = this.converter.getRwfMsgTypeFromJson(msgTypeNode, error);
            if (error.isFailed()) {
                return;
            }
        }
        Msg msg = null;
        try {
            msg = JsonFactory.createMsg();
            this.converter.decodeRsslMessage(msgType, dataNode, msg, error, iter);
        }
        finally {
            if (msg != null) {
                JsonFactory.releaseMsg(msg);
            }
        }
    }
}

