/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.Date;
import com.refinitiv.eta.codec.DateTime;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.Double;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Enum;
import com.refinitiv.eta.codec.Float;
import com.refinitiv.eta.codec.Int;
import com.refinitiv.eta.codec.Map;
import com.refinitiv.eta.codec.MapEntry;
import com.refinitiv.eta.codec.Qos;
import com.refinitiv.eta.codec.Real;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.codec.Time;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.json.converter.AbstractContainerTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Objects;

class JsonMapConverter
extends AbstractContainerTypeConverter {
    JsonMapConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{137};
    }

    @Override
    Object getContainerObject() {
        return JsonFactory.createMap();
    }

    @Override
    Object getEntryObject() {
        return JsonFactory.createMapEntry();
    }

    @Override
    void releaseContainer(Object container) {
        JsonFactory.releaseMap((Map)container);
    }

    @Override
    void releaseEntry(Object entry) {
        JsonFactory.releaseMapEntry((MapEntry)entry);
    }

    @Override
    boolean hasEntries(Object container) {
        return ((Map)container).encodedEntries().data() != null && ((Map)container).encodedEntries() != null && ((Map)container).encodedEntries().length() != 0;
    }

    @Override
    protected int decodeEntry(DecodeIterator decIter, Object entryObj) {
        MapEntry mapEntry = (MapEntry)entryObj;
        mapEntry.clear();
        return mapEntry.decode(decIter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean writeContent(DecodeIterator decIter, JsonBuffer outBuffer, JsonConverterError error, Object container) {
        boolean bl;
        block15: {
            boolean res;
            Map map;
            Object localSetDb;
            block13: {
                boolean bl2;
                block14: {
                    block11: {
                        boolean bl3;
                        block12: {
                            block9: {
                                boolean bl4;
                                block10: {
                                    localSetDb = null;
                                    map = (Map)container;
                                    try {
                                        if (map.checkHasSetDefs()) {
                                            localSetDb = this.getLocalSetDb(decIter, map.containerType(), error);
                                        }
                                        res = true;
                                        BufferHelper.beginObject(outBuffer, error);
                                        BufferHelper.writeArrayAndColon("KeyType", outBuffer, false, error);
                                        BufferHelper.writeArray(this.converter.getDataType(map.keyPrimitiveType()), outBuffer, true, error);
                                        if (!map.checkHasSummaryData() || map.containerType() <= 128) break block9;
                                        BufferHelper.comma(outBuffer, error);
                                        if (this.writeSummaryData(decIter, map.containerType(), outBuffer, localSetDb, error)) break block9;
                                        bl4 = false;
                                        if (localSetDb == null) break block10;
                                    }
                                    catch (Throwable throwable) {
                                        if (localSetDb != null) {
                                            this.returnLocalSetDb(map.containerType(), localSetDb);
                                        }
                                        throw throwable;
                                    }
                                    this.returnLocalSetDb(map.containerType(), localSetDb);
                                }
                                return bl4;
                            }
                            if (map.checkHasTotalCountHint()) {
                                BufferHelper.writeArrayAndColon("CountHint", outBuffer, true, error);
                                BasicPrimitiveConverter.writeLong(map.totalCountHint(), outBuffer, error);
                            }
                            if (map.checkHasKeyFieldId()) {
                                BufferHelper.writeArrayAndColon("KeyFieldID", outBuffer, true, error);
                                BasicPrimitiveConverter.writeLong(map.keyFieldId(), outBuffer, error);
                            }
                            if (map.encodedEntries().length() != 0) break block11;
                            bl3 = BufferHelper.endObject(outBuffer, error);
                            if (localSetDb == null) break block12;
                            this.returnLocalSetDb(map.containerType(), localSetDb);
                        }
                        return bl3;
                    }
                    if (this.writeEntries(decIter, outBuffer, true, localSetDb, error, true, container)) break block13;
                    bl2 = false;
                    if (localSetDb == null) break block14;
                    this.returnLocalSetDb(map.containerType(), localSetDb);
                }
                return bl2;
            }
            BufferHelper.endObject(outBuffer, error);
            bl = res;
            if (localSetDb == null) break block15;
            this.returnLocalSetDb(map.containerType(), localSetDb);
        }
        return bl;
    }

    @Override
    protected int decodeContainer(DecodeIterator decIter, Object setDb, Object container) {
        Map map = (Map)container;
        map.clear();
        return map.decode(decIter);
    }

    @Override
    protected boolean writeEntry(DecodeIterator decIter, JsonBuffer outBuffer, Object localSetDb, JsonConverterError error, Object entryObj, Object container) {
        Map map = (Map)container;
        MapEntry mapEntry = (MapEntry)entryObj;
        boolean res = BufferHelper.beginObject(outBuffer, error);
        String action = this.getMapEntryAction(mapEntry.action());
        if (action == null) {
            return false;
        }
        BufferHelper.writeArrayAndColon("Action", outBuffer, false, error);
        BufferHelper.writeArray(action, outBuffer, true, error);
        BufferHelper.writeArrayAndColon("Key", outBuffer, true, error);
        if (!this.converter.getPrimitiveHandler(map.keyPrimitiveType()).encodeJson(mapEntry.encodedKey(), outBuffer, error)) {
            return false;
        }
        if (mapEntry.checkHasPermData()) {
            BufferHelper.writeArrayAndColon("PermData", outBuffer, true, error);
            if (!this.converter.getPrimitiveHandler(16).encodeJson(mapEntry.permData(), outBuffer, error)) {
                return false;
            }
        }
        if (mapEntry.encodedData().length() == 0) {
            return res && BufferHelper.endObject(outBuffer, error);
        }
        int type = ((Map)container).containerType();
        BufferHelper.comma(outBuffer, error);
        if (!this.converter.getContainerHandler(type).encodeJson(decIter, outBuffer, true, localSetDb, error)) {
            return false;
        }
        BufferHelper.endObject(outBuffer, error);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encodeRWF(JsonNode node, String keyString, EncodeIterator iter, JsonConverterError error) {
        Map map = JsonFactory.createMap();
        map.clear();
        MapEntry mapEntry = JsonFactory.createMapEntry();
        Buffer buf = JsonFactory.createBuffer();
        buf.data(ByteBuffer.allocate(0));
        int ret = 0;
        try {
            JsonNode summary = null;
            JsonNode entries = null;
            JsonNode entryData = null;
            int summaryType = 0;
            int entryContainerType = 128;
            Object encKey = null;
            boolean hasKeyType = false;
            map.clear();
            if (!node.isObject()) {
                error.setError(4, "Expected object type, found " + node.getNodeType().toString(), keyString);
                return;
            }
            Iterator it = node.fieldNames();
            block60: while (it.hasNext()) {
                String key = (String)it.next();
                JsonNode currentNode = node.path(key);
                switch (key) {
                    case "Summary": {
                        if (!currentNode.isObject()) {
                            error.setError(4, "Expected object type for Summary, found " + currentNode.getNodeType().toString(), "Summary");
                            return;
                        }
                        if (currentNode.size() != 1) {
                            error.setError(14, "Unexpected keys present", "Summary");
                            return;
                        }
                        Iterator curr = currentNode.fieldNames();
                        String containerName = (String)curr.next();
                        summaryType = this.converter.getContainerType(containerName);
                        if (summaryType == 128) {
                            if (!this.converter.catchUnexpectedKeys()) continue block60;
                            error.setError(14, "Unexpected key: " + containerName, "Summary");
                            return;
                        }
                        summary = currentNode.get(containerName);
                        break;
                    }
                    case "CountHint": {
                        if (!currentNode.isInt()) {
                            error.setError(4, "Expected integer type, found " + currentNode.getNodeType().toString(), "CountHint");
                            return;
                        }
                        map.applyHasTotalCountHint();
                        map.totalCountHint(currentNode.asInt());
                        break;
                    }
                    case "KeyType": {
                        int type = this.converter.getDataType(currentNode);
                        if (type == -1) {
                            error.setError(11, "Unexpected type: " + type, "KeyType");
                            return;
                        }
                        if (type >= 127) {
                            error.setError(5, "Unexpected primitive type: " + type, "KeyType");
                            return;
                        }
                        hasKeyType = true;
                        map.keyPrimitiveType(type);
                        break;
                    }
                    case "KeyFieldID": {
                        if (!currentNode.isInt()) {
                            error.setError(4, "Expected integer value, found " + currentNode.getNodeType().toString(), "KeyFieldID");
                            return;
                        }
                        map.applyHasKeyFieldId();
                        map.keyFieldId(currentNode.asInt());
                        break;
                    }
                    case "Entries": {
                        if (!currentNode.isArray()) {
                            error.setError(4, "Expected array type, found type " + currentNode.getNodeType().toString(), "Entries");
                            return;
                        }
                        entries = currentNode;
                        entryContainerType = this.converter.getPayloadType(currentNode);
                        break;
                    }
                    default: {
                        if (!this.converter.catchUnexpectedKeys()) break;
                        error.setError(14, "Unexpected key: " + key, keyString);
                        return;
                    }
                }
            }
            if (!hasKeyType) {
                error.setError(12, "Missing key type", keyString);
                return;
            }
            if (summaryType != 0) {
                map.applyHasSummaryData();
                map.containerType(summaryType);
            } else if (entryContainerType != 0) {
                map.containerType(entryContainerType);
            } else {
                map.containerType(128);
            }
            ret = map.encodeInit(iter, 0, 0);
            if (ret < 0) {
                error.setError(8, "Failed encoding Map, code: " + ret);
                return;
            }
            if (Objects.nonNull(summary)) {
                this.converter.getContainerHandler(summaryType).encodeRWF(summary, null, iter, error);
                if (error.isFailed()) {
                    return;
                }
                ret = map.encodeSummaryDataComplete(iter, true);
                if (ret < 0) {
                    error.setError(8, "Failed encoding Map, code: " + ret);
                    return;
                }
            }
            if (entries != null) {
                for (int i = 0; i < entries.size(); ++i) {
                    mapEntry.clear();
                    entryData = null;
                    encKey = null;
                    JsonNode curr = entries.get(i);
                    boolean hasEntriesKey = false;
                    boolean hasEntriesAction = false;
                    if (!curr.isObject()) {
                        error.setError(4, "Expected object type for Map entry[" + i + "], found " + curr.getNodeType().toString());
                        return;
                    }
                    Iterator it2 = curr.fieldNames();
                    while (it2.hasNext()) {
                        String name = (String)it2.next();
                        boolean foundValidToken = false;
                        JsonNode child = curr.get(name);
                        switch (name) {
                            case "Action": {
                                foundValidToken = true;
                                hasEntriesAction = true;
                                if (!child.isTextual()) {
                                    error.setError(4, "Expected string type for Map entry[" + i + "] action, found " + child.getNodeType().toString());
                                    return;
                                }
                                this.setMapEntryAction(child, mapEntry, error, i);
                                if (!error.isFailed()) break;
                                return;
                            }
                            case "Key": {
                                hasEntriesKey = true;
                                foundValidToken = true;
                                encKey = this.converter.getPrimitiveHandler(map.keyPrimitiveType()).getPrimitiveType();
                                this.converter.getPrimitiveHandler(map.keyPrimitiveType()).decodeJson(child, encKey, error);
                                if (error.isFailed()) {
                                    return;
                                }
                                if (encKey != null) break;
                                encKey = buf;
                                break;
                            }
                            case "PermData": {
                                foundValidToken = true;
                                if (!child.isTextual()) {
                                    error.setError(4, "Expected string type for Permission Data in Map entry[" + i + "], found: " + child.getNodeType().toString());
                                    return;
                                }
                                this.converter.getPrimitiveHandler(16).decodeJson(child, mapEntry.permData(), error);
                                if (error.isFailed()) {
                                    return;
                                }
                                mapEntry.applyHasPermData();
                                break;
                            }
                        }
                        if (foundValidToken) continue;
                        entryContainerType = this.converter.getContainerType(name);
                        if (entryContainerType == 128) {
                            if (!this.converter.catchUnexpectedKeys()) continue;
                            error.setError(14, "Unexpected key in Map entry[" + i + "]: " + name);
                            return;
                        }
                        entryData = child;
                    }
                    if (summary != null) {
                        if (entryContainerType != 128 && entryContainerType != summaryType) {
                            error.setError(8, "Failed to encode Map: container types mismatch, found summary container type = " + summaryType + ", entry container type = " + entryContainerType);
                            return;
                        }
                    } else if (map.containerType() != entryContainerType) {
                        error.setError(8, "Failed encoding MapEntry: entry[" + i + "] container type mismatch with Map container type, found " + map.containerType() + " and " + entryContainerType + " types.");
                        return;
                    }
                    if (!hasEntriesKey) {
                        error.setError(12, "Missing entry key", "Map entry[" + i + "]");
                        return;
                    }
                    if (!hasEntriesAction) {
                        error.setError(12, "Missing entry action", "Map entry[" + i + "]");
                        return;
                    }
                    if (encKey == null) {
                        error.setError(12, "Missing entry key", "Map entry[" + i + "]");
                        return;
                    }
                    if (entryData != null && mapEntry.action() != 3) {
                        ret = JsonMapConverter.encodeMapEntryInit(mapEntry, iter, encKey);
                        if (ret < 0) {
                            error.setError(8, "Failed encoding MapEntry, code: " + ret, "Map entry[" + i + "]");
                            return;
                        }
                        this.converter.getContainerHandler(map.containerType()).encodeRWF(entryData, "Map entry[" + i + "]", iter, error);
                        if (error.isFailed()) {
                            return;
                        }
                        ret = mapEntry.encodeComplete(iter, true);
                        if (ret < 0) {
                            error.setError(8, "Failed encoding MapEntry, code: " + ret, "Map entry[" + i + "]");
                            return;
                        }
                    } else {
                        ret = JsonMapConverter.encodeMapEntry(mapEntry, iter, encKey);
                        if (ret < 0) {
                            error.setError(8, "Failed encoding MapEntry, code: " + ret, "Map entry[" + i + "]");
                            return;
                        }
                    }
                    if (encKey == null) continue;
                    this.converter.getPrimitiveHandler(map.keyPrimitiveType()).releasePrimitiveType(encKey);
                }
            }
            if (summary == null && map.containerType() == 0) {
                map.containerType(128);
                ret = map.encodeInit(iter, 0, 0);
                if (ret < 0) {
                    error.setError(8, "Failed encoding Map, code: " + ret, keyString);
                    return;
                }
            }
            if ((ret = map.encodeComplete(iter, true)) < 0) {
                error.setError(8, "Failed encoding Map, code: " + ret, keyString);
                return;
            }
            return;
        }
        catch (Exception ex) {
            error.setError(8, "Failed encoding Map, exception: " + ex.getMessage(), "Map");
            return;
        }
        finally {
            JsonFactory.releaseMap(map);
            JsonFactory.releaseMapEntry(mapEntry);
            JsonFactory.releaseBuffer(buf);
        }
    }

    private String getMapEntryAction(int action) {
        if (action >= 1 && action <= 3) {
            return ConstCharArrays.mapEntryActionStrings[action - 1];
        }
        return null;
    }

    private void setMapEntryAction(JsonNode child, MapEntry mapEntry, JsonConverterError error, int position) {
        switch (child.asText()) {
            case "Add": {
                mapEntry.action(2);
                break;
            }
            case "Update": {
                mapEntry.action(1);
                break;
            }
            case "Delete": {
                mapEntry.action(3);
                break;
            }
            default: {
                error.setError(4, "Unexpected value for Map Entry action: " + child.asText(), "entry[" + position + "]");
                return;
            }
        }
    }

    private static int encodeMapEntryInit(MapEntry mapEntry, EncodeIterator encIter, Object key) {
        if (key instanceof Int) {
            return mapEntry.encodeInit(encIter, (Int)key, 0);
        }
        if (key instanceof UInt) {
            return mapEntry.encodeInit(encIter, (UInt)key, 0);
        }
        if (key instanceof Real) {
            return mapEntry.encodeInit(encIter, (Real)key, 0);
        }
        if (key instanceof Float) {
            return mapEntry.encodeInit(encIter, (Float)key, 0);
        }
        if (key instanceof Double) {
            return mapEntry.encodeInit(encIter, (Double)key, 0);
        }
        if (key instanceof Buffer) {
            return mapEntry.encodeInit(encIter, (Buffer)key, 0);
        }
        if (key instanceof Enum) {
            return mapEntry.encodeInit(encIter, (Enum)key, 0);
        }
        if (key instanceof Date) {
            return mapEntry.encodeInit(encIter, (Date)key, 0);
        }
        if (key instanceof DateTime) {
            return mapEntry.encodeInit(encIter, (DateTime)key, 0);
        }
        if (key instanceof Time) {
            return mapEntry.encodeInit(encIter, (Time)key, 0);
        }
        if (key instanceof Qos) {
            return mapEntry.encodeInit(encIter, (Qos)key, 0);
        }
        if (key instanceof State) {
            return mapEntry.encodeInit(encIter, (State)key, 0);
        }
        return -1;
    }

    private static int encodeMapEntry(MapEntry mapEntry, EncodeIterator encIter, Object key) {
        if (key instanceof Int) {
            return mapEntry.encode(encIter, (Int)key);
        }
        if (key instanceof UInt) {
            return mapEntry.encode(encIter, (UInt)key);
        }
        if (key instanceof Real) {
            return mapEntry.encode(encIter, (Real)key);
        }
        if (key instanceof Float) {
            return mapEntry.encode(encIter, (Float)key);
        }
        if (key instanceof Double) {
            return mapEntry.encode(encIter, (Double)key);
        }
        if (key instanceof Buffer) {
            return mapEntry.encode(encIter, (Buffer)key);
        }
        if (key instanceof Enum) {
            return mapEntry.encode(encIter, (Enum)key);
        }
        if (key instanceof Date) {
            return mapEntry.encode(encIter, (Date)key);
        }
        if (key instanceof DateTime) {
            return mapEntry.encode(encIter, (DateTime)key);
        }
        if (key instanceof Time) {
            return mapEntry.encode(encIter, (Time)key);
        }
        if (key instanceof Qos) {
            return mapEntry.encode(encIter, (Qos)key);
        }
        if (key instanceof State) {
            return mapEntry.encode(encIter, (State)key);
        }
        return -1;
    }
}

