/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import java.math.BigInteger;

class JsonLongConverter
extends AbstractPrimitiveTypeConverter {
    public static final BigInteger MAX_BIG_INTEGER_VALUE = new BigInteger("18446744073709551615");

    JsonLongConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{4, 65, 67, 69, 71};
    }

    @Override
    Object getPrimitiveType() {
        return JsonFactory.createUInt();
    }

    @Override
    void releasePrimitiveType(Object type) {
        JsonFactory.releaseUInt((UInt)type);
    }

    @Override
    int decode(DecodeIterator decIter, Object type) {
        UInt uInt = (UInt)type;
        uInt.clear();
        return uInt.decode(decIter);
    }

    @Override
    boolean writeToJson(JsonBuffer outBuffer, Object type, JsonConverterError error) {
        long longValue = ((UInt)type).toLong();
        if (longValue < 0L) {
            return BasicPrimitiveConverter.writeBigInteger(((UInt)type).toBigInteger(), outBuffer, error);
        }
        return BasicPrimitiveConverter.writeLong(longValue, outBuffer, error);
    }

    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        UInt iv = (UInt)msg;
        iv.clear();
        if (node.isNull()) {
            return;
        }
        if (node.isInt()) {
            iv.value(node.asInt());
        } else if (node.isLong()) {
            iv.value(node.asLong());
        } else if (node.isBigInteger()) {
            iv.value(node.bigIntegerValue());
        } else {
            error.setError(4, "expected type UInt, found " + node.getNodeType().toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encodeRWF(JsonNode dataNode, String key, EncodeIterator iter, JsonConverterError error) {
        if (dataNode.isNull()) {
            return;
        }
        UInt encUIntValue = JsonFactory.createUInt();
        try {
            encUIntValue.clear();
            if (dataNode.isInt()) {
                encUIntValue.value(dataNode.asInt());
            } else if (dataNode.isLong()) {
                encUIntValue.value(dataNode.asLong());
            } else if (dataNode.isBigInteger()) {
                encUIntValue.value(dataNode.bigIntegerValue());
            } else {
                error.setError(4, "expected type UInt, found " + dataNode.getNodeType().toString());
                return;
            }
            int result = encUIntValue.encode(iter);
            if (result != 0) {
                error.setEncodeError(result, key);
                return;
            }
        }
        finally {
            JsonFactory.releaseUInt(encUIntValue);
        }
    }

    @Override
    boolean isInRange(int dataType, JsonNode dataNode) {
        if (dataNode.isDouble() || dataNode.isFloat()) {
            return false;
        }
        if (dataNode.isBigInteger()) {
            if (dataType == 4 || dataType == 71) {
                BigInteger bigValue = dataNode.bigIntegerValue();
                return bigValue.compareTo(MAX_BIG_INTEGER_VALUE) <= 0;
            }
            return false;
        }
        long value = dataNode.asLong();
        switch (dataType) {
            case 4: 
            case 71: {
                if (value < 0L || value > Long.MAX_VALUE) break;
                return true;
            }
            case 65: {
                if (value < 0L || value > 255L) break;
                return true;
            }
            case 67: {
                if (value < 0L || value > 65535L) break;
                return true;
            }
            case 69: {
                if (value < 0L || value > 0xFFFFFFFFL) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }
}

