/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;

class JsonFloatConverter
extends AbstractPrimitiveTypeConverter {
    JsonFloatConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{5, 72};
    }

    @Override
    Object getPrimitiveType() {
        return JsonFactory.createFloat();
    }

    @Override
    void releasePrimitiveType(Object type) {
        JsonFactory.releaseFloat((com.refinitiv.eta.codec.Float)type);
    }

    @Override
    int decode(DecodeIterator decIter, Object type) {
        com.refinitiv.eta.codec.Float fv = (com.refinitiv.eta.codec.Float)type;
        fv.clear();
        return fv.decode(decIter);
    }

    @Override
    boolean writeToJson(JsonBuffer outBuffer, Object type, JsonConverterError error) {
        return BasicPrimitiveConverter.writeFloat((com.refinitiv.eta.codec.Float)type, outBuffer, false, error);
    }

    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        com.refinitiv.eta.codec.Float fv = (com.refinitiv.eta.codec.Float)msg;
        fv.clear();
        if (node.isNull()) {
            fv.blank();
            return;
        }
        if (node.isFloat() || node.isDouble()) {
            fv.value((float)node.asDouble());
        } else if (node.isTextual()) {
            switch (node.textValue()) {
                case "Inf": {
                    fv.value(Float.POSITIVE_INFINITY);
                    break;
                }
                case "-Inf": {
                    fv.value(Float.NEGATIVE_INFINITY);
                    break;
                }
                case "NaN": {
                    fv.value(Float.NaN);
                    break;
                }
                default: {
                    error.setError(2, "Invalid text '" + node.textValue() + "' expected Float");
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encodeRWF(JsonNode dataNode, String key, EncodeIterator iter, JsonConverterError error) {
        if (dataNode.isNull()) {
            return;
        }
        com.refinitiv.eta.codec.Float encFloatValue = JsonFactory.createFloat();
        try {
            this.decodeJson(dataNode, encFloatValue, error);
            int result = encFloatValue.encode(iter);
            if (result != 0) {
                error.setEncodeError(result, key);
                return;
            }
        }
        finally {
            JsonFactory.releaseFloat(encFloatValue);
        }
    }
}

