/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.FilterEntry;
import com.refinitiv.eta.codec.FilterList;
import com.refinitiv.eta.json.converter.AbstractContainerTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import java.util.Iterator;

class JsonFilterListConverter
extends AbstractContainerTypeConverter {
    JsonFilterListConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{135};
    }

    @Override
    Object getContainerObject() {
        return JsonFactory.createFilterList();
    }

    @Override
    Object getEntryObject() {
        return JsonFactory.createFilterEntry();
    }

    @Override
    void releaseContainer(Object container) {
        JsonFactory.releaseFilterList((FilterList)container);
    }

    @Override
    void releaseEntry(Object entry) {
        JsonFactory.releaseFilterEntry((FilterEntry)entry);
    }

    @Override
    boolean hasEntries(Object container) {
        return ((FilterList)container).encodedEntries() != null && ((FilterList)container).encodedEntries().data() != null && ((FilterList)container).encodedEntries().length() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encodeRWF(JsonNode node, String stringKey, EncodeIterator iter, JsonConverterError error) {
        JsonNode entries = null;
        JsonNode entry = null;
        JsonNode entryData = null;
        boolean foundValidToken = false;
        int entryType = 0;
        String key = null;
        int ret = 0;
        if (!node.isObject()) {
            error.setError(4, "Expected object type, found " + node.getNodeType().toString(), stringKey);
            return;
        }
        FilterList filterList = JsonFactory.createFilterList();
        FilterEntry filterEntry = JsonFactory.createFilterEntry();
        try {
            filterList.clear();
            filterList.containerType(133);
            Iterator iterator = node.fieldNames();
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                JsonNode curr = node.get(next);
                switch (next) {
                    case "Entries": {
                        if (!curr.isArray()) {
                            error.setError(4, "Expected array type, found type " + curr.getNodeType().toString(), next);
                            return;
                        }
                        entries = curr;
                        break;
                    }
                    case "CountHint": {
                        if (!curr.isInt()) {
                            error.setError(4, "Expected integer type, found type " + curr.getNodeType().toString(), next);
                            return;
                        }
                        filterList.applyHasTotalCountHint();
                        filterList.totalCountHint(curr.asInt());
                        break;
                    }
                    default: {
                        if (!this.converter.catchUnexpectedKeys()) break;
                        error.setError(14, "Unexpected key: " + next);
                        return;
                    }
                }
            }
            ret = filterList.encodeInit(iter);
            if (ret < 0) {
                error.setError(8, "Failed encoding FilterEntry code: " + ret, stringKey);
                return;
            }
            if (entries != null) {
                for (int i = 0; i < entries.size(); ++i) {
                    entry = entries.get(i);
                    if (!entry.isObject()) {
                        error.setError(4, "Expected object type, found " + entry.getNodeType().toString(), "Entries");
                        return;
                    }
                    filterEntry.clear();
                    entryData = null;
                    filterEntry.applyHasContainerType();
                    filterEntry.containerType(filterList.containerType());
                    Iterator entryIter = entry.fieldNames();
                    boolean hasAction = false;
                    boolean hasId = false;
                    while (entryIter.hasNext()) {
                        key = (String)entryIter.next();
                        JsonNode entryToken = entry.get(key);
                        foundValidToken = false;
                        switch (key) {
                            case "ID": {
                                foundValidToken = true;
                                hasId = true;
                                if (!entryToken.isInt()) {
                                    error.setError(4, "Expected integer type, found type " + entryToken.getNodeType().toString(), "entry[" + i + "]." + key);
                                    return;
                                }
                                filterEntry.id(entryToken.asInt());
                                break;
                            }
                            case "Action": {
                                foundValidToken = true;
                                hasAction = true;
                                if (!entryToken.isInt() && !entryToken.isTextual()) {
                                    error.setError(4, "Unexpected Action type: " + entryToken.getNodeType().toString(), "entry[" + i + "]." + key);
                                    return;
                                }
                                if (entryToken.isTextual()) {
                                    int action = this.getAction(entryToken.asText());
                                    if (action == 0) {
                                        error.setError(4, "Unknown FilterEntry action: " + entryToken.asText(), "entry[" + i + "]." + key);
                                        return;
                                    }
                                    filterEntry.action(action);
                                    break;
                                }
                                if (entryToken.isInt() && entryToken.asInt() >= 1 && entryToken.asInt() <= 3) {
                                    filterEntry.action(entryToken.asInt());
                                    break;
                                }
                                error.setError(4, "Unknown FilterList entry action: " + entryToken.asText(), "entry[" + i + "]." + key);
                                return;
                            }
                            case "PermData": {
                                foundValidToken = true;
                                if (!entryToken.isTextual()) {
                                    error.setError(4, "Expected string value for Permission Data, found " + entryToken.getNodeType().toString(), "entry[" + i + "]." + key);
                                    return;
                                }
                                filterEntry.applyHasPermData();
                                this.converter.getPrimitiveHandler(16).decodeJson(entryToken, filterEntry.permData(), error);
                                if (!error.isFailed()) break;
                                return;
                            }
                        }
                        if (foundValidToken) continue;
                        entryType = this.converter.getContainerType(key);
                        if (entryType == 128) {
                            if (!this.converter.catchUnexpectedKeys()) continue;
                            error.setError(14, "Unexpected key: " + key, "entry[" + i + "]");
                            return;
                        }
                        filterEntry.applyHasContainerType();
                        filterEntry.containerType(entryType);
                        entryData = entryToken;
                    }
                    if (!hasAction) {
                        error.setError(12, "Missing entry Action", "entry[" + i + "]");
                        return;
                    }
                    if (!hasId) {
                        error.setError(12, "Missing entry Id", "entry[" + i + "]");
                        return;
                    }
                    if (entryData != null && filterEntry.action() != 3) {
                        ret = filterEntry.encodeInit(iter, 0);
                        if (ret < 0) {
                            error.setError(8, "Failed encoding FilterList entry, code: " + ret, "entry[" + i + "]");
                            return;
                        }
                        this.converter.getContainerHandler(entryType).encodeRWF(entryData, key, iter, error);
                        if (error.isFailed()) {
                            return;
                        }
                        ret = filterEntry.encodeComplete(iter, true);
                        if (ret >= 0) continue;
                        error.setError(8, "Failed encoding FilterList entry, code: " + ret, "entry[" + i + "]");
                        return;
                    }
                    ret = filterEntry.encode(iter);
                    if (ret >= 0) continue;
                    error.setError(8, "Failed encoding FilterList entry, code: " + ret, "entry[" + i + "]");
                    return;
                }
            }
            if ((ret = filterList.encodeComplete(iter, true)) < 0) {
                error.setError(17, "Encoding failed, code = " + ret, stringKey);
                return;
            }
            return;
        }
        finally {
            JsonFactory.releaseFilterEntry(filterEntry);
            JsonFactory.releaseFilterList(filterList);
        }
    }

    @Override
    protected int decodeEntry(DecodeIterator decIter, Object entryObj) {
        FilterEntry entry = (FilterEntry)entryObj;
        entry.clear();
        return entry.decode(decIter);
    }

    @Override
    protected boolean writeContent(DecodeIterator decIter, JsonBuffer outBuffer, JsonConverterError error, Object container) {
        boolean comma = false;
        BufferHelper.beginObject(outBuffer, error);
        FilterList filterList = (FilterList)container;
        if (filterList.checkHasTotalCountHint()) {
            BufferHelper.writeArrayAndColon("CountHint", outBuffer, false, error);
            BasicPrimitiveConverter.writeLong(filterList.totalCountHint(), outBuffer, error);
            comma = true;
        }
        if (filterList.encodedEntries().length() == 0) {
            return BufferHelper.endObject(outBuffer, error);
        }
        return this.writeEntries(decIter, outBuffer, true, null, error, comma, container) && BufferHelper.endObject(outBuffer, error);
    }

    @Override
    protected int decodeContainer(DecodeIterator decIter, Object setDb, Object container) {
        FilterList list = (FilterList)container;
        list.clear();
        return list.decode(decIter);
    }

    @Override
    protected boolean writeEntry(DecodeIterator decIter, JsonBuffer outBuffer, Object localSetDb, JsonConverterError error, Object entryObj, Object container) {
        int containerType;
        FilterList filterList = (FilterList)container;
        FilterEntry filterEntry = (FilterEntry)entryObj;
        int n = containerType = filterEntry.checkHasContainerType() ? filterEntry.containerType() : filterList.containerType();
        if (filterEntry.action() == 0) {
            error.setError(17, "FilterList Entry action is 0");
            return false;
        }
        BufferHelper.beginObject(outBuffer, error);
        BufferHelper.writeArrayAndColon("ID", outBuffer, false, error);
        BasicPrimitiveConverter.writeLong(filterEntry.id(), outBuffer, error);
        BufferHelper.writeArrayAndColon("Action", outBuffer, true, error);
        BufferHelper.writeArray(this.getAction(filterEntry.action()), outBuffer, true, error);
        if (filterEntry.checkHasPermData()) {
            BufferHelper.writeArrayAndColon("PermData", outBuffer, true, error);
            this.converter.getPrimitiveHandler(16).encodeJson(filterEntry.permData(), outBuffer, error);
        }
        if (filterEntry.encodedData().length() > 0 && containerType > 128) {
            BufferHelper.comma(outBuffer, error);
            this.converter.getContainerHandler(containerType).encodeJson(decIter, outBuffer, true, localSetDb, error);
        }
        return BufferHelper.endObject(outBuffer, error);
    }

    private String getAction(int action) {
        if (action >= 1 && action <= 3) {
            return ConstCharArrays.entryActionStrings[action - 1];
        }
        return null;
    }

    private int getAction(String key) {
        switch (key) {
            case "Update": {
                return 1;
            }
            case "Set": {
                return 2;
            }
            case "Clear": {
                return 3;
            }
        }
        return 0;
    }
}

