/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.DictionaryEntry;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Enum;
import com.refinitiv.eta.codec.EnumType;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.EnumTableDefinition;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;

class JsonEnumerationConverter
extends AbstractPrimitiveTypeConverter {
    JsonEnumerationConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{14};
    }

    @Override
    Object getPrimitiveType() {
        return JsonFactory.createEnum();
    }

    @Override
    void releasePrimitiveType(Object type) {
        JsonFactory.releaseEnum((Enum)type);
    }

    @Override
    int decode(DecodeIterator decIter, Object type) {
        Enum enumeration = (Enum)type;
        enumeration.clear();
        return enumeration.decode(decIter);
    }

    @Override
    boolean writeToJson(JsonBuffer outBuffer, Object type, JsonConverterError error) {
        return BasicPrimitiveConverter.writeLong(((Enum)type).toInt(), outBuffer, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean encodeJson(DecodeIterator decIter, DictionaryEntry entry, JsonBuffer outBuffer, JsonConverterError error) {
        Enum enumer = JsonFactory.createEnum();
        try {
            boolean res;
            enumer.clear();
            int ret = enumer.decode(decIter);
            if (ret < 0) {
                error.setError(15, null);
                boolean bl = false;
                return bl;
            }
            if (ret == 15) {
                res = BufferHelper.writeArray(ConstCharArrays.nullBytes, outBuffer, false, error);
            } else {
                EnumType enumType = entry.enumTypeTable() != null && enumer.toInt() <= entry.enumTypeTable().maxValue() ? entry.enumTypeTable().enumTypes()[enumer.toInt()] : null;
                res = enumType != null && enumType.display().data() != null ? BasicPrimitiveConverter.writeRMTESString(enumType.display(), outBuffer, error) : BasicPrimitiveConverter.writeLong(enumer.toInt(), outBuffer, error);
            }
            if (!res) {
                error.setError(16, null);
            }
            boolean bl = res;
            return bl;
        }
        catch (Exception e) {
            error.setError(17, e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            JsonFactory.releaseEnum(enumer);
        }
    }

    private int convertDisplayToEnum(JsonNode dataNode, JsonConverterError error) {
        DictionaryEntry dictEntry = this.converter.dictionaryEntry();
        EnumTableDefinition enumTableDefinition = this.converter.getEnumTableDefinition(dictEntry.enumTypeTable());
        int enumValue = -1;
        enumValue = enumTableDefinition.findEnumDefinition(dataNode.textValue());
        if (enumValue == -1) {
            enumValue = enumTableDefinition.addEnumDefinition(dictEntry.enumTypeTable(), dataNode.textValue(), error);
        }
        return enumValue;
    }

    @Override
    protected void decodeJson(JsonNode dataNode, Object msg, JsonConverterError error) {
        Enum enumer = (Enum)msg;
        if (dataNode.isTextual() && this.converter.allowEnumDisplayStrings()) {
            int enumValue = this.convertDisplayToEnum(dataNode, error);
            if (enumValue != -1) {
                enumer.value(enumValue);
            } else {
                enumer.value("");
            }
        } else if (dataNode.isInt()) {
            enumer.value(dataNode.intValue());
        } else {
            enumer.value("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void encodeRWF(int enumValue, String key, EncodeIterator iter, JsonConverterError error) {
        Enum encIntValue = JsonFactory.createEnum();
        try {
            encIntValue.clear();
            int result = encIntValue.value(enumValue);
            if (result != 0) {
                error.setError(4, "Received '" + enumValue + "'");
                return;
            }
            result = encIntValue.encode(iter);
            if (result != 0) {
                error.setEncodeError(result, key);
                return;
            }
        }
        finally {
            JsonFactory.releaseEnum(encIntValue);
        }
    }

    @Override
    protected void encodeRWF(JsonNode dataNode, String key, EncodeIterator iter, JsonConverterError error) {
        if (dataNode.isTextual() && this.converter.allowEnumDisplayStrings()) {
            int enumValue = this.convertDisplayToEnum(dataNode, error);
            if (enumValue != -1) {
                this.encodeRWF(enumValue, key, iter, error);
            }
        } else if (dataNode.isNumber()) {
            this.encodeRWF(dataNode.intValue(), key, iter, error);
        }
    }
}

