/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;

class JsonDoubleConverter
extends AbstractPrimitiveTypeConverter {
    JsonDoubleConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{6, 73};
    }

    @Override
    Object getPrimitiveType() {
        return JsonFactory.createDouble();
    }

    @Override
    void releasePrimitiveType(Object type) {
        JsonFactory.releaseDouble((com.refinitiv.eta.codec.Double)type);
    }

    @Override
    int decode(DecodeIterator decIter, Object type) {
        com.refinitiv.eta.codec.Double dv = (com.refinitiv.eta.codec.Double)type;
        dv.clear();
        return dv.decode(decIter);
    }

    @Override
    boolean writeToJson(JsonBuffer outBuffer, Object type, JsonConverterError error) {
        return BasicPrimitiveConverter.writeDouble((com.refinitiv.eta.codec.Double)type, outBuffer, false, error);
    }

    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        com.refinitiv.eta.codec.Double dv = (com.refinitiv.eta.codec.Double)msg;
        dv.clear();
        if (node.isNull()) {
            dv.blank();
        } else if (node.isDouble()) {
            dv.value(node.doubleValue());
        } else if (node.isTextual()) {
            switch (node.textValue()) {
                case "Inf": {
                    dv.value(Double.POSITIVE_INFINITY);
                    break;
                }
                case "-Inf": {
                    dv.value(Double.NEGATIVE_INFINITY);
                    break;
                }
                case "NaN": {
                    dv.value(Double.NaN);
                    break;
                }
                default: {
                    error.setError(2, "Invalid text '" + node.textValue() + "' expected Double");
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encodeRWF(JsonNode dataNode, String key, EncodeIterator iter, JsonConverterError error) {
        if (dataNode.isNull()) {
            return;
        }
        com.refinitiv.eta.codec.Double dv = JsonFactory.createDouble();
        try {
            this.decodeJson(dataNode, dv, error);
            int result = dv.encode(iter);
            if (result != 0) {
                error.setEncodeError(result, key);
                return;
            }
        }
        finally {
            JsonFactory.releaseDouble(dv);
        }
    }
}

