/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.refinitiv.eta.json.converter.JsonConverterError;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class JsonConverterErrorImpl
implements JsonConverterError {
    private int errorId;
    private String text;
    private String caller;
    private String key;
    String declaringClass;
    int line = -1;

    JsonConverterErrorImpl() {
    }

    private String callerToString() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        this.declaringClass = stackTraceElements[4].getClassName();
        this.line = stackTraceElements[4].getLineNumber();
        return stackTraceElements[3] + "\n\n" + IntStream.range(0, stackTraceElements.length).mapToObj(i -> Integer.toString(i) + " " + stackTraceElements[i]).collect(Collectors.joining("\n"));
    }

    @Override
    public int setEncodeError(int encodeErrorId, String key) {
        return this.setError(8, "code=" + encodeErrorId + ", '" + key + "' encoding failure");
    }

    @Override
    public int setError(int errorId, String text) {
        this.errorId = errorId;
        switch (errorId) {
            case 2: {
                this.text = "JSON Converter parse error: " + text;
                break;
            }
            case 20: {
                this.text = "JSON Converter init error. Unsupported protocol: [" + text + "]. At the moment supported version is JSON Simple (2)";
                break;
            }
            case 21: {
                this.text = "JSON Converter init error. Invalid property: " + text;
                break;
            }
            case 3: {
                this.text = "JSON Converter Token Type error: " + text;
                break;
            }
            case 14: {
                this.text = "JSON Converter unexpected key. Received " + text;
                break;
            }
            case 50: {
                this.text = "JSON Converter parsing is not supported: " + text;
                break;
            }
            case 4: {
                this.text = "JSON Converter unexpected value: " + text;
                break;
            }
            case 8: {
                this.text = "JSON Converter encode error: " + text;
                break;
            }
            case 12: {
                this.text = "JSON Converter missing key: " + text;
                break;
            }
            case 100: {
                this.text = "Operation not supported for class: " + text;
                break;
            }
            default: {
                this.text = "JSON Converter error: " + text;
            }
        }
        this.caller = this.callerToString();
        if (errorId != 0) {
            return -1;
        }
        return errorId;
    }

    @Override
    public int getCode() {
        return this.errorId;
    }

    @Override
    public boolean isSuccessful() {
        return this.errorId == 0;
    }

    @Override
    public boolean isFailed() {
        return this.errorId != 0;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getFile() {
        return this.declaringClass;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public String toString() {
        return "JsonConverterError{errorId=" + this.errorId + ", text='" + this.text + '\'' + ", caller=" + this.caller + '}';
    }

    @Override
    public int setError(int errorId, String text, String key) {
        this.key = key;
        this.errorId = errorId;
        switch (errorId) {
            case 2: {
                this.text = "Key: " + key + ", JSON Converter parse error: " + text;
                break;
            }
            case 20: {
                this.text = "Key: " + key + ", JSON Converter init error. Unsupported protocol: [" + text + "]. At the moment supported version is JSON Simple (2)";
                break;
            }
            case 21: {
                this.text = "Key: " + key + ", JSON Converter init error. Invalid property: " + text;
                break;
            }
            case 3: {
                this.text = "Key: " + key + ", JSON Converter Token Type error: " + text;
                break;
            }
            case 14: {
                this.text = "Key: " + key + ", JSON Converter unexpected key. Received " + text;
                break;
            }
            case 50: {
                this.text = "Key: " + key + ", JSON Converter parsing is not supported: " + text;
                break;
            }
            case 4: {
                this.text = "Key: " + key + ", JSON Converter unexpected value: " + text;
                break;
            }
            case 8: {
                this.text = "Key: " + key + ", JSON Converter encode error: " + text;
                break;
            }
            case 12: {
                this.text = "Key: " + key + ", JSON Converter missing key: " + text;
                break;
            }
            case 100: {
                this.text = "Key: " + key + ", Operation not supported for class: " + text;
                break;
            }
            default: {
                this.text = "Key: " + key + ", JSON Converter error: " + text;
            }
        }
        this.caller = this.callerToString();
        if (errorId != 0) {
            return -1;
        }
        return errorId;
    }

    @Override
    public void clear() {
        this.errorId = 0;
        this.text = null;
        this.caller = null;
        this.key = null;
        this.line = -1;
    }
}

