/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;

class JsonAsciiConverter
extends AbstractPrimitiveTypeConverter {
    JsonAsciiConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{17};
    }

    @Override
    Object getPrimitiveType() {
        return JsonFactory.createBuffer();
    }

    @Override
    void releasePrimitiveType(Object type) {
        JsonFactory.releaseBuffer((Buffer)type);
    }

    @Override
    int decode(DecodeIterator decIter, Object type) {
        Buffer buf = (Buffer)type;
        buf.clear();
        return buf.decode(decIter);
    }

    @Override
    boolean writeToJson(JsonBuffer outBuffer, Object type, JsonConverterError error) {
        return BasicPrimitiveConverter.writeAsciiString((Buffer)type, outBuffer, error);
    }

    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        Buffer buff = (Buffer)msg;
        if (node.isNull()) {
            buff.clear();
            return;
        }
        if (!node.isTextual()) {
            error.setError(4, "Expected string value");
            return;
        }
        buff.clear();
        buff.data(node.asText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encodeRWF(JsonNode dataNode, String key, EncodeIterator iter, JsonConverterError error) {
        Buffer encBufferValue = JsonFactory.createBuffer();
        try {
            int result;
            this.decodeJson(dataNode, encBufferValue, error);
            if (error.isSuccessful() && (result = encBufferValue.encode(iter)) != 0) {
                error.setEncodeError(result, key);
            }
        }
        finally {
            JsonFactory.releaseBuffer(encBufferValue);
        }
    }
}

