/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.Array;
import com.refinitiv.eta.codec.ArrayEntry;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;

class JsonArrayConverter
extends AbstractPrimitiveTypeConverter {
    JsonArrayConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{15};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean encodeJson(DecodeIterator decIter, JsonBuffer outBuffer, JsonConverterError error) {
        Array array = JsonFactory.createArray();
        ArrayEntry arrayEntry = JsonFactory.createArrayEntry();
        try {
            AbstractPrimitiveTypeConverter conv = null;
            array.clear();
            arrayEntry.clear();
            int ret = array.decode(decIter);
            if (ret < 0) {
                error.setError(15, null);
                boolean bl = false;
                return bl;
            }
            if (ret == 15) {
                boolean bl = BufferHelper.writeArray("null", outBuffer, false, error);
                return bl;
            }
            BufferHelper.beginObject(outBuffer, error);
            BufferHelper.writeArrayAndColon("Type", outBuffer, false, error);
            BufferHelper.writeArray(this.getDataType(array.primitiveType()), outBuffer, true, error);
            BufferHelper.writeArrayAndColon("Data", outBuffer, true, error);
            BufferHelper.beginArray(outBuffer, error);
            boolean writeComma = false;
            conv = this.converter.getPrimitiveHandler(array.primitiveType());
            if (conv != null) {
                while (arrayEntry.decode(decIter) != 14) {
                    if (!writeComma) {
                        writeComma = true;
                    } else {
                        BufferHelper.comma(outBuffer, error);
                    }
                    if (conv.encodeJson(decIter, outBuffer, error)) continue;
                    boolean bl = false;
                    return bl;
                }
            } else {
                error.setError(17, "Unknown primitive type: " + array.primitiveType());
                boolean bl = false;
                return bl;
            }
            BufferHelper.endArray(outBuffer, error);
            BufferHelper.endObject(outBuffer, error);
            boolean bl = error.isSuccessful();
            return bl;
        }
        catch (Exception e) {
            error.setError(17, e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            JsonFactory.releaseArray(array);
            JsonFactory.releaseArrayEntry(arrayEntry);
        }
    }

    @Override
    int decode(DecodeIterator decIter, Object type) {
        return 0;
    }

    @Override
    boolean writeToJson(JsonBuffer outBuffer, Object type, JsonConverterError error) {
        return false;
    }

    @Override
    boolean encodeJson(Buffer buffer, JsonBuffer outBuffer, JsonConverterError error) {
        return false;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void encodeRWF(JsonNode currentNode, String key, EncodeIterator iter, JsonConverterError error) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 18[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getDataType(int dataType) {
        if (dataType >= 0 && dataType <= 19) {
            return ConstCharArrays.dataTypeStrings[dataType];
        }
        if (dataType >= 64 && dataType <= 84) {
            return ConstCharArrays.dataTypeStrings[dataType - 44];
        }
        if (dataType >= 130 && dataType <= 142) {
            return ConstCharArrays.dataTypeStrings[dataType - 88];
        }
        if (dataType == 128) {
            return ConstCharArrays.dataTypeStrings[41];
        }
        return null;
    }
}

