/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.AckMsg;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.json.converter.AbstractRsslMessageTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import java.util.Objects;

class JsonAckMsgConverter
extends AbstractRsslMessageTypeConverter {
    JsonAckMsgConverter(JsonAbstractConverter converter) {
        super(converter);
    }

    @Override
    boolean encodeJson(DecodeIterator decIter, Object msg, JsonBuffer outBuffer, JsonConverterError error) {
        AckMsg ackMsg = (AckMsg)msg;
        BufferHelper.writeArrayAndColon("AckID", outBuffer, true, error);
        BasicPrimitiveConverter.writeLong(ackMsg.ackId(), outBuffer, error);
        if (ackMsg.flags() != 0) {
            if (ackMsg.checkHasNakCode()) {
                BufferHelper.writeArrayAndColon("NakCode", outBuffer, true, error);
                String code = this.getNakCodeString(ackMsg.nakCode());
                if (code != null) {
                    BufferHelper.writeArray(code, outBuffer, true, error);
                } else {
                    BasicPrimitiveConverter.writeLong(ackMsg.nakCode(), outBuffer, error);
                }
            }
            if (ackMsg.checkHasText()) {
                BufferHelper.writeArrayAndColon("Text", outBuffer, true, error);
                BasicPrimitiveConverter.writeSafeString(ackMsg.text(), outBuffer, error);
            }
            if (ackMsg.checkPrivateStream()) {
                BufferHelper.writeArrayAndColon("Private", outBuffer, true, error);
                BufferHelper.writeArray("true", outBuffer, false, error);
            }
            if (ackMsg.checkHasSeqNum()) {
                BufferHelper.writeArrayAndColon("SeqNumber", outBuffer, true, error);
                BasicPrimitiveConverter.writeLong(ackMsg.seqNum(), outBuffer, error);
            }
            if (ackMsg.checkHasMsgKey()) {
                BufferHelper.writeArrayAndColon("Key", outBuffer, true, error);
                if (!this.converter.processMsgKey(decIter, ackMsg.msgKey(), outBuffer, ackMsg.domainType(), true, error)) {
                    return false;
                }
            }
            if (ackMsg.checkHasExtendedHdr()) {
                if (Objects.nonNull(ackMsg.extendedHeader()) && Objects.nonNull(ackMsg.extendedHeader().data())) {
                    BufferHelper.writeArrayAndColon("ExtHdr", outBuffer, true, error);
                    if (!this.converter.getPrimitiveHandler(16).encodeJson(ackMsg.extendedHeader(), outBuffer, error)) {
                        return false;
                    }
                } else {
                    error.setError(4, "Found empty extended header");
                    return false;
                }
            }
            if (ackMsg.checkQualifiedStream()) {
                BufferHelper.writeArrayAndColon("Qualified", outBuffer, true, error);
                BufferHelper.writeArray("true", outBuffer, false, error);
            }
        }
        if (ackMsg.containerType() != 128) {
            BufferHelper.comma(outBuffer, error);
            if (!this.converter.getContainerHandler(ackMsg.containerType()).encodeJson(decIter, outBuffer, true, null, error)) {
                return false;
            }
        }
        return error.isSuccessful();
    }

    private String getNakCodeString(int code) {
        switch (code) {
            case 0: {
                return "None";
            }
            case 1: {
                return "AccessDenied";
            }
            case 2: {
                return "DeniedBySrc";
            }
            case 3: {
                return "SourceDown";
            }
            case 4: {
                return "SourceUnknown";
            }
            case 5: {
                return "NoResources";
            }
            case 6: {
                return "NoResponse";
            }
            case 7: {
                return "GatewayDown";
            }
            case 10: {
                return "SymbolUnknown";
            }
            case 11: {
                return "NotOpen";
            }
            case 12: {
                return "InvalidContent";
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

