/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.DataDictionary;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.DictionaryEntry;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.EnumTypeTable;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.PostUserInfo;
import com.refinitiv.eta.json.converter.AbstractContainerTypeConverter;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.AbstractRsslMessageChunkTypeConverter;
import com.refinitiv.eta.json.converter.AbstractRsslMessageTypeConverter;
import com.refinitiv.eta.json.converter.AbstractTypeConverter;
import com.refinitiv.eta.json.converter.ConversionResults;
import com.refinitiv.eta.json.converter.DecodeJsonMsgOptions;
import com.refinitiv.eta.json.converter.EnumTableDefinition;
import com.refinitiv.eta.json.converter.GetJsonErrorParams;
import com.refinitiv.eta.json.converter.GetJsonMsgOptions;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverter;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.converter.JsonMsg;
import com.refinitiv.eta.json.converter.ParseJsonOptions;
import com.refinitiv.eta.json.converter.RWFToJsonOptions;
import com.refinitiv.eta.json.converter.RsslMsgChunkType;
import com.refinitiv.eta.json.converter.ServiceNameIdConverter;
import com.refinitiv.eta.transport.TransportBuffer;

public abstract class JsonAbstractConverter
implements JsonConverter {
    protected ServiceNameIdConverter serviceNameIdConverter;

    @Override
    public abstract int parseJsonBuffer(Buffer var1, ParseJsonOptions var2, JsonConverterError var3);

    @Override
    public abstract int parseJsonBuffer(TransportBuffer var1, ParseJsonOptions var2, JsonConverterError var3);

    @Override
    public abstract int decodeJsonMsg(JsonMsg var1, DecodeJsonMsgOptions var2, JsonConverterError var3);

    @Override
    public abstract int convertRWFToJson(Msg var1, RWFToJsonOptions var2, ConversionResults var3, JsonConverterError var4);

    @Override
    public abstract int convertRWFToJson(Msg var1, RWFToJsonOptions var2, JsonConverterError var3);

    @Override
    public abstract int getJsonBuffer(Buffer var1, GetJsonMsgOptions var2, JsonConverterError var3);

    @Override
    public abstract int getJsonBuffer(TransportBuffer var1, GetJsonMsgOptions var2, JsonConverterError var3);

    @Override
    public abstract int getErrorMessage(Buffer var1, GetJsonErrorParams var2, JsonConverterError var3);

    abstract AbstractPrimitiveTypeConverter getPrimitiveHandler(int var1);

    abstract AbstractContainerTypeConverter getContainerHandler(int var1);

    abstract AbstractRsslMessageChunkTypeConverter getMsgChunkHandler(RsslMsgChunkType var1);

    abstract AbstractRsslMessageTypeConverter getRsslMessageHandler(int var1);

    abstract AbstractTypeConverter getHandler(int var1, JsonConverterError var2);

    abstract AbstractTypeConverter getHandler(RsslMsgChunkType var1, JsonConverterError var2);

    abstract int getContainerDataType(String var1, JsonNode var2, JsonConverterError var3);

    abstract DataDictionary getDictionary();

    abstract ObjectMapper getMapper();

    abstract DictionaryEntry dictionaryEntry();

    abstract void dictionaryEntry(DictionaryEntry var1);

    abstract ServiceNameIdConverter getServiceNameIdConverter();

    public abstract int getRwfMsgTypeFromJson(JsonNode var1, JsonConverterError var2);

    public abstract int getJsonMsgType(JsonMsg var1, JsonNode var2, JsonConverterError var3);

    abstract boolean catchUnexpectedKeys();

    abstract boolean catchUnexpectedFids();

    abstract boolean allowEnumDisplayStrings();

    abstract boolean useDefaultDynamicQoS();

    abstract boolean expandEnumFields();

    abstract int getDefaultServiceId();

    abstract boolean hasDefaultServiceId();

    abstract void setHasDefaultServiceId(boolean var1);

    abstract String getDataType(int var1);

    abstract int getDataType(JsonNode var1);

    abstract int getContainerType(String var1);

    abstract int getPayloadType(JsonNode var1);

    abstract boolean processMsg(DecodeIterator var1, Msg var2, JsonBuffer var3, JsonConverterError var4, boolean var5);

    abstract boolean processMsgKey(DecodeIterator var1, Object var2, JsonBuffer var3, int var4, boolean var5, JsonConverterError var6);

    abstract boolean processPostUserInfo(PostUserInfo var1, JsonBuffer var2, JsonConverterError var3);

    abstract EnumTableDefinition getEnumTableDefinition(EnumTypeTable var1);

    void setServiceNameIdConverter(ServiceNameIdConverter serviceNameIdConverter) {
        this.serviceNameIdConverter = serviceNameIdConverter;
    }

    protected abstract void decodeRsslMessage(int var1, JsonNode var2, Object var3, JsonConverterError var4, EncodeIterator var5);

    protected abstract void decodeChunk(int var1, JsonNode var2, Object var3, JsonConverterError var4);

    protected abstract void decodeChunk(RsslMsgChunkType var1, JsonNode var2, Object var3, JsonConverterError var4);

    protected abstract void decodeChunk(int var1, JsonNode var2, String var3, EncodeIterator var4, JsonConverterError var5);

    int serviceNameToId(String serviceName, JsonConverterError error) {
        if (this.serviceNameIdConverter == null) {
            error.setError(4, "ServiceNameToId callback was not configured, cannot get id for service '" + serviceName + "'");
            return -1;
        }
        return this.serviceNameIdConverter.serviceNameToId(serviceName, error);
    }
}

