/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.refinitiv.eta.codec.EnumType;
import com.refinitiv.eta.codec.EnumTypeTable;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

class EnumTableDefinition {
    private Map<String, Integer> enumByDispalyValueHash;
    private JsonBuffer outputBuffer;
    private ByteBuffer byteBuffer;
    private ReentrantLock accessLock = new ReentrantLock();

    EnumTableDefinition(int maxEnumValue) {
        this.enumByDispalyValueHash = new HashMap<String, Integer>(maxEnumValue);
        this.byteBuffer = ByteBuffer.allocate(256);
        this.outputBuffer = new JsonBuffer();
        this.outputBuffer.position = 0;
        this.outputBuffer.data = this.byteBuffer.array();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findEnumDefinition(String displayValue) {
        this.accessLock.lock();
        try {
            Integer enumValue = this.enumByDispalyValueHash.get(displayValue);
            if (Objects.nonNull(enumValue)) {
                int n = enumValue;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.accessLock.unlock();
        }
    }

    static boolean compareDisplayValue(byte[] displayByteArray, byte[] outputByteArray) {
        for (int index = 0; index < displayByteArray.length; ++index) {
            if (displayByteArray[index] == outputByteArray[index + 1]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addEnumDefinition(EnumTypeTable enumTypeTable, String displayValue, JsonConverterError error) {
        int enumValue = -1;
        boolean success = true;
        this.accessLock.lock();
        try {
            byte[] displayByteArray;
            try {
                displayByteArray = displayValue.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                int n = -1;
                this.accessLock.unlock();
                return n;
            }
            for (int index = 0; index <= enumTypeTable.maxValue(); ++index) {
                EnumType enumType = enumTypeTable.enumTypes()[index];
                if (Objects.isNull(enumType)) continue;
                this.outputBuffer.position = 0;
                success = BasicPrimitiveConverter.writeRMTESString(enumType.display(), this.outputBuffer, error);
                if (!success) {
                    error.setError(16, null);
                    int n = -1;
                    return n;
                }
                if (displayByteArray.length + 2 != this.outputBuffer.position || !EnumTableDefinition.compareDisplayValue(displayByteArray, this.outputBuffer.data)) continue;
                enumValue = enumType.value();
                this.enumByDispalyValueHash.put(displayValue, enumValue);
                int n = enumValue;
                return n;
            }
            int n = enumValue;
            return n;
        }
        finally {
            this.accessLock.unlock();
        }
    }
}

