/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import java.nio.ByteBuffer;
import java.util.Base64;

class BufferConverter {
    private static Buffer buffer = CodecFactory.createBuffer();

    BufferConverter() {
    }

    static boolean writeToJson(DecodeIterator iter, JsonBuffer outBuffer, JsonConverterError error) {
        buffer.clear();
        int ret = buffer.decode(iter);
        if (ret < 0) {
            return false;
        }
        if (ret == 15) {
            return BufferHelper.writeArray(ConstCharArrays.nullBytes, outBuffer, false, error);
        }
        return BufferConverter.writeToJson(buffer, outBuffer, error);
    }

    static boolean writeToJson(Buffer buffer, JsonBuffer outBuffer, JsonConverterError error) {
        return BufferConverter.encodeInBase64(buffer, outBuffer, error);
    }

    static boolean decodeFromBase64(String base64Str, Buffer outBuffer, JsonConverterError error) {
        try {
            byte[] bytes = Base64.getDecoder().decode(base64Str);
            outBuffer.data(ByteBuffer.wrap(bytes));
        }
        catch (IllegalArgumentException e) {
            error.setError(15, "Error during base64 decoding: " + e.getMessage());
            return false;
        }
        return true;
    }

    static boolean encodeInBase64(Buffer buffer, JsonBuffer outBuffer, JsonConverterError error) {
        if (BufferHelper.checkAndResize(outBuffer, buffer.length() / 3 * 4 + 4 + 2, error)) {
            outBuffer.data[outBuffer.position++] = 34;
            int orgPosition = buffer.data().position();
            int orgLimit = buffer.data().limit();
            buffer.data().position(buffer.position());
            buffer.data().limit(buffer.position() + buffer.length());
            ByteBuffer result = Base64.getEncoder().encode(buffer.data());
            buffer.data().limit(orgLimit);
            buffer.data().position(orgPosition);
            for (int pos = 0; pos < result.limit(); ++pos) {
                outBuffer.data[outBuffer.position++] = result.get(pos);
            }
            outBuffer.data[outBuffer.position++] = 34;
            return true;
        }
        return false;
    }
}

