/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.Date;
import com.refinitiv.eta.codec.DateTime;
import com.refinitiv.eta.codec.Float;
import com.refinitiv.eta.codec.Real;
import com.refinitiv.eta.codec.RmtesBuffer;
import com.refinitiv.eta.codec.RmtesCacheBuffer;
import com.refinitiv.eta.codec.RmtesDecoder;
import com.refinitiv.eta.codec.Time;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import java.math.BigInteger;
import java.nio.ByteBuffer;

class BasicPrimitiveConverter {
    private static final int[] intLengths = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final long[] longLengths = new long[]{9L, 99L, 999L, 9999L, 99999L, 999999L, 9999999L, 99999999L, 999999999L, 9999999999L, 99999999999L, 999999999999L, 9999999999999L, 99999999999999L, 999999999999999L, 9999999999999999L, 99999999999999999L, 999999999999999999L, Long.MAX_VALUE};
    private static final double log10_5 = Math.log10(5.0);
    private static final double log10_2 = Math.log10(2.0);
    private static final long double_exp_mask = 0x7FF0000000000000L;
    private static final long double_mantissa_mask = 0xFFFFFFFFFFFFFL;
    private static final long double_sign_mask = Long.MIN_VALUE;
    private static final int float_sign_mask = Integer.MIN_VALUE;
    private static final int float_exp_mask = 2139095040;
    private static final int float_mantissa_mask = 0x7FFFFF;
    private static final int[] numerator_mask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    private static final long DIV_MAGIC_MULT1 = 0xCCCCCCCDL;
    private static final int SHIFT1 = 35;
    private static final long DIV_MAGIC_MULT4 = 3518437209L;
    private static final int SHIFT4 = 45;
    private static final int CHUNK_LENGTH = 4;
    private static final int INT_MAX_STORED = (int)Math.pow(10.0, 4.0) - 1;
    private static final int INT_DIVISOR = (int)Math.pow(10.0, 4.0);
    private static final char[][] charInts;
    private static final StringBuilder sb;
    private static final RmtesDecoder decoder;
    private static RmtesCacheBuffer cacheBuffer;
    private static RmtesBuffer rmtesBuffer;

    BasicPrimitiveConverter() {
    }

    private static char[] getCharRepresentation(int val) {
        char[] res = new char[BasicPrimitiveConverter.getIntLengthCompare(val)];
        for (int i = res.length - 1; i >= 0; --i) {
            int q = BasicPrimitiveConverter.divide1(val);
            res[i] = ConstCharArrays.digits[val - q * 10];
            val = q;
        }
        return res;
    }

    private static int divide1(int val) {
        assert (val >= 0);
        return (int)((long)val * 0xCCCCCCCDL >>> 35);
    }

    private static int divide4(int val) {
        assert (val >= 0);
        return (int)((long)val * 3518437209L >>> 45);
    }

    static int getLongLengthCompare(long value) {
        if (value == Long.MIN_VALUE) {
            return 20;
        }
        if (value < 0L) {
            return BasicPrimitiveConverter.getPositiveLongLengthCompare(-value) + 1;
        }
        return BasicPrimitiveConverter.getPositiveLongLengthCompare(value);
    }

    static int getPositiveLongLengthCompare(long value) {
        assert (value >= 0L);
        int iter = 1;
        while (longLengths[iter - 1] < value) {
            ++iter;
        }
        return iter;
    }

    static int getIntLengthDivide(int value) {
        if (value == Integer.MIN_VALUE) {
            return 11;
        }
        int length = 0;
        if (value < 0) {
            ++length;
            value *= -1;
        }
        do {
            ++length;
        } while ((value /= 10) > 0);
        return length;
    }

    static int getIntLengthDivide1(int value) {
        if (value == Integer.MIN_VALUE) {
            return 11;
        }
        int length = 0;
        if (value < 0) {
            ++length;
            value *= -1;
        }
        do {
            ++length;
        } while ((value = BasicPrimitiveConverter.divide1(value)) > 0);
        return length;
    }

    static int getIntLengthCompare(int value) {
        if (value == Integer.MIN_VALUE) {
            return 11;
        }
        int res = 1;
        if (value < 0) {
            ++res;
            value *= -1;
        }
        int iter = 0;
        while (intLengths[iter] < value) {
            ++iter;
        }
        return res += iter;
    }

    static void writeInt(int value, int posLength, byte[] buffer, int start) {
        if (value == Integer.MIN_VALUE) {
            BufferHelper.copyToByteArray(ConstCharArrays.minInt, start, buffer);
        } else {
            if (value < 0) {
                buffer[start++] = 45;
                value *= -1;
            }
            int end = start + posLength - 1;
            while (true) {
                if (value <= INT_MAX_STORED) {
                    BufferHelper.copyToByteArray(charInts[value], start, buffer);
                    break;
                }
                int q = BasicPrimitiveConverter.divide4(value);
                int r = value - q * INT_DIVISOR;
                BufferHelper.fillZeroes(4 - charInts[r].length, buffer, end - 4 + 1);
                BufferHelper.copyToByteArray(charInts[r], end - charInts[r].length + 1, buffer);
                end -= 4;
                value = q;
            }
        }
    }

    static void writeLong(long value, int posLength, int start, byte[] buffer) {
        if (value == Long.MIN_VALUE) {
            BufferHelper.copyToByteArray(ConstCharArrays.minLong, start, buffer);
        } else {
            if (value < 0L) {
                buffer[start++] = 45;
                value *= -1L;
                --posLength;
            }
            int end = start + posLength - 1;
            while (true) {
                if (value <= Integer.MAX_VALUE) {
                    BasicPrimitiveConverter.writeInt((int)value, BasicPrimitiveConverter.getIntLengthCompare((int)value), buffer, start);
                    break;
                }
                long q = value / (long)INT_DIVISOR;
                int r = (int)(value - q * (long)INT_DIVISOR);
                BufferHelper.fillZeroes(4 - charInts[r].length, buffer, end - 4 + 1);
                BufferHelper.copyToByteArray(charInts[r], end - charInts[r].length + 1, buffer);
                end -= 4;
                value = q;
            }
        }
    }

    static boolean writeLong(long value, JsonBuffer buffer, JsonConverterError error) {
        int length = BasicPrimitiveConverter.getLongLengthCompare(value);
        if (BufferHelper.checkAndResize(buffer, length, error)) {
            BasicPrimitiveConverter.writeLong(value, length, buffer.position, buffer.data);
            buffer.position += length;
            return true;
        }
        return false;
    }

    static boolean writeBigInteger(BigInteger value, JsonBuffer buffer, JsonConverterError error) {
        char[] bigIntegerCharArr = value.toString().toCharArray();
        int length = bigIntegerCharArr.length;
        if (BufferHelper.checkAndResize(buffer, length, error)) {
            BufferHelper.copyToByteArray(bigIntegerCharArr, buffer.position, buffer.data);
            buffer.position += length;
            return true;
        }
        return false;
    }

    static boolean writeReal(Real value, JsonBuffer buffer, boolean asString, JsonConverterError error) {
        int length = BasicPrimitiveConverter.getRealLength(value, asString);
        if (BufferHelper.checkAndResize(buffer, length, error)) {
            BasicPrimitiveConverter.writeReal(value, buffer.data, buffer.position, asString);
            buffer.position += length;
            return true;
        }
        return false;
    }

    static int getRealLength(Real real, boolean asString) {
        if (real.isBlank()) {
            return "null".length();
        }
        if (real.hint() > 30) {
            switch (real.hint()) {
                case 33: {
                    return ConstCharArrays.inf.length + (asString ? 2 : 0);
                }
                case 34: {
                    return ConstCharArrays.infNeg.length + (asString ? 2 : 0);
                }
                case 35: {
                    return ConstCharArrays.nan.length + (asString ? 2 : 0);
                }
            }
        } else {
            int length = 0;
            long value = real.toLong();
            if (value == 0L) {
                return 1 + (asString ? 2 : 0);
            }
            if (value < 0L && value != Long.MIN_VALUE) {
                value *= -1L;
                ++length;
            }
            if (real.hint() - 22 >= 0) {
                if (real.hint() - 22 > 0) {
                    long whole = value >> real.hint() - 22;
                    int remainder = (int)(value & (long)numerator_mask[real.hint() - 22]);
                    if (remainder == 0) {
                        return length + BasicPrimitiveConverter.getLongLengthCompare(whole) + (asString ? 2 : 0);
                    }
                    return length + BasicPrimitiveConverter.getLongLengthCompare(whole) + 1 + (real.hint() - 22 - Long.numberOfTrailingZeros(remainder)) + (asString ? 2 : 0);
                }
                return length + BasicPrimitiveConverter.getLongLengthCompare(value) + (asString ? 2 : 0);
            }
            int exponent = real.hint() - 14;
            int longLength = BasicPrimitiveConverter.getLongLengthCompare(value);
            if (exponent >= 0) {
                return (asString ? 2 : 0) + (value != 0L ? length + longLength + exponent : 1);
            }
            if (exponent == 0) {
                return length + longLength + (asString ? 2 : 0);
            }
            if (longLength + exponent > 0) {
                return length + longLength + 1 + (asString ? 2 : 0);
            }
            return length + 1 + 1 - exponent + (asString ? 2 : 0);
        }
        return -1;
    }

    static void writeReal(Real real, byte[] buffer, int start, boolean asString) {
        long value = real.toLong();
        boolean maxNegativeLong = false;
        if (real.isBlank()) {
            BufferHelper.copyToByteArray(ConstCharArrays.nullBytes, start, buffer);
            return;
        }
        if (asString) {
            buffer[start++] = 34;
        }
        switch (real.hint()) {
            case 33: {
                BufferHelper.copyToByteArray(ConstCharArrays.inf, start, buffer);
                return;
            }
            case 34: {
                BufferHelper.copyToByteArray(ConstCharArrays.infNeg, start, buffer);
                return;
            }
            case 35: {
                BufferHelper.copyToByteArray(ConstCharArrays.nan, start, buffer);
                return;
            }
        }
        if (value == 0L) {
            buffer[start++] = 48;
        } else {
            if (value < 0L && (real.hint() < 14 || real.hint() > 22)) {
                value *= -1L;
                if (real.toLong() == Long.MIN_VALUE) {
                    maxNegativeLong = true;
                    if (real.hint() < 22) {
                        value = Long.MAX_VALUE;
                        buffer[start++] = 45;
                    }
                } else {
                    buffer[start++] = 45;
                }
            }
            if (real.hint() - 22 >= 0) {
                if (real.hint() - 22 > 0) {
                    long whole = value >> real.hint() - 22;
                    int remainder = (int)(value & (long)numerator_mask[real.hint() - 22]);
                    if (whole == 0L) {
                        buffer[start++] = 48;
                    } else {
                        int l = BasicPrimitiveConverter.getLongLengthCompare(whole);
                        BasicPrimitiveConverter.writeLong(whole, l, start, buffer);
                        start += l;
                    }
                    if (remainder > 0) {
                        int f = real.hint() - 22;
                        buffer[start++] = 46;
                        int p2 = Long.numberOfTrailingZeros(remainder);
                        int dec = (remainder >> p2) * (int)Math.pow(5.0, f - p2);
                        int l = f - p2 - BasicPrimitiveConverter.getIntLengthCompare(dec);
                        BufferHelper.fillZeroes(f - p2 - BasicPrimitiveConverter.getIntLengthCompare(dec), buffer, start);
                        BasicPrimitiveConverter.writeInt(dec, BasicPrimitiveConverter.getIntLengthCompare(dec), buffer, start + l);
                    }
                } else {
                    BasicPrimitiveConverter.writeLong(value, BasicPrimitiveConverter.getLongLengthCompare(value), start, buffer);
                }
            } else {
                int exponent = real.hint() - 14;
                int longLength = BasicPrimitiveConverter.getLongLengthCompare(value);
                if (exponent >= 0) {
                    BasicPrimitiveConverter.writeLong(value, longLength, start, buffer);
                    BufferHelper.fillZeroes(exponent, buffer, start + longLength);
                } else if (exponent == 0) {
                    BasicPrimitiveConverter.writeLong(value, longLength, start, buffer);
                } else if (longLength + exponent > 0) {
                    int end = start + longLength;
                    long nv = value;
                    while (exponent++ < 0) {
                        nv = value / 10L;
                        if (!maxNegativeLong) {
                            buffer[end--] = (byte)(ConstCharArrays.digits[(int)(value - nv * 10L)] & 0xFF);
                        } else {
                            buffer[end--] = (byte)(ConstCharArrays.digits[(int)(value - nv * 10L + 1L)] & 0xFF);
                            maxNegativeLong = false;
                        }
                        value = nv;
                    }
                    buffer[end] = 46;
                    BasicPrimitiveConverter.writeLong(nv, end - start, start, buffer);
                } else {
                    buffer[start++] = 48;
                    buffer[start++] = 46;
                    int x = Math.abs(longLength + exponent);
                    BufferHelper.fillZeroes(x, buffer, start);
                    BasicPrimitiveConverter.writeLong(value, longLength, start + x, buffer);
                }
            }
        }
        if (asString) {
            buffer[start++] = 34;
        }
    }

    static boolean writeFloat(Float value, JsonBuffer buffer, boolean asString, JsonConverterError error) {
        if (value.isBlank()) {
            if (BufferHelper.checkAndResize(buffer, ConstCharArrays.nullBytes.length, error)) {
                BufferHelper.copyToByteArray(ConstCharArrays.nullBytes, buffer);
                return true;
            }
            return false;
        }
        float val = value.toFloat();
        if (java.lang.Float.isNaN(val)) {
            return BufferHelper.writeArray(ConstCharArrays.nan, buffer, asString, error);
        }
        if (val == java.lang.Float.POSITIVE_INFINITY) {
            return BufferHelper.writeArray(ConstCharArrays.inf, buffer, asString, error);
        }
        if (val == java.lang.Float.NEGATIVE_INFINITY) {
            return BufferHelper.writeArray(ConstCharArrays.infNeg, buffer, asString, error);
        }
        sb.delete(0, sb.length());
        sb.append(val);
        if (BufferHelper.checkAndResize(buffer, asString ? sb.length() + 2 : sb.length(), error)) {
            if (asString) {
                buffer.data[buffer.position++] = 34;
            }
            for (int i = 0; i < sb.length(); ++i) {
                buffer.data[buffer.position++] = (byte)sb.charAt(i);
            }
            if (asString) {
                buffer.data[buffer.position++] = 34;
            }
            return true;
        }
        return false;
    }

    static boolean writeDouble(com.refinitiv.eta.codec.Double value, JsonBuffer buffer, boolean asString, JsonConverterError error) {
        if (value.isBlank()) {
            if (BufferHelper.checkAndResize(buffer, ConstCharArrays.nullBytes.length, error)) {
                BufferHelper.copyToByteArray(ConstCharArrays.nullBytes, buffer);
                return true;
            }
            return false;
        }
        double val = value.toDouble();
        if (Double.isNaN(val)) {
            return BufferHelper.writeArray(ConstCharArrays.nan, buffer, asString, error);
        }
        if (val == Double.POSITIVE_INFINITY) {
            return BufferHelper.writeArray(ConstCharArrays.inf, buffer, asString, error);
        }
        if (val == Double.NEGATIVE_INFINITY) {
            return BufferHelper.writeArray(ConstCharArrays.infNeg, buffer, asString, error);
        }
        sb.delete(0, sb.length());
        sb.append(val);
        if (BufferHelper.checkAndResize(buffer, asString ? sb.length() + 2 : sb.length(), error)) {
            if (asString) {
                buffer.data[buffer.position++] = 34;
            }
            for (int i = 0; i < sb.length(); ++i) {
                buffer.data[buffer.position++] = (byte)sb.charAt(i);
            }
            if (asString) {
                buffer.data[buffer.position++] = 34;
            }
            return true;
        }
        return false;
    }

    static int writeDouble0(double value, int start, byte[] buffer) {
        long whole;
        int pow10;
        int exp2;
        long bits = Double.doubleToRawLongBits(value);
        boolean positive = (bits & Long.MIN_VALUE) == 0L;
        long exp = (bits & 0x7FF0000000000000L) >> 52;
        long f = bits & 0xFFFFFFFFFFFFFL;
        if (exp == 2047L) {
            if (f == 0L) {
                if (positive) {
                    BufferHelper.copyToByteArray(ConstCharArrays.inf, start, buffer);
                    return start + ConstCharArrays.inf.length;
                }
                BufferHelper.copyToByteArray(ConstCharArrays.infNeg, start, buffer);
                return start + ConstCharArrays.infNeg.length;
            }
            BufferHelper.copyToByteArray(ConstCharArrays.nan, start, buffer);
            return start + ConstCharArrays.nan.length;
        }
        if (exp == 0L && f == 0L) {
            buffer[start++] = 48;
            return start;
        }
        if (!positive) {
            buffer[start++] = 45;
        }
        if ((exp2 = (int)(exp - 1023L)) >= 0 && exp2 < 53) {
            int shift = 52 - exp2;
            long whole2 = (1L << exp2) + (f >> shift);
            int whole_length = BasicPrimitiveConverter.getLongLengthCompare(whole2);
            BasicPrimitiveConverter.writeLong(whole2, whole_length, start, buffer);
            return BasicPrimitiveConverter.writeFraction(f, shift, exp2, buffer, start + whole_length);
        }
        if (exp2 < 0 && exp2 != -1023) {
            pow10 = -exp2 - (int)(log10_5 * (double)(-exp2));
            double nd = Math.abs(value) * Math.pow(10.0, pow10);
            whole = (long)nd;
            if (BasicPrimitiveConverter.getLongLengthCompare(whole) > 1) {
                --pow10;
                nd /= 10.0;
            } else if (whole == 0L) {
                nd *= 10.0;
                ++pow10;
            }
            bits = Double.doubleToRawLongBits(nd);
            exp = (bits & 0x7FF0000000000000L) >> 52;
            f = bits & 0xFFFFFFFFFFFFFL;
            exp2 = (int)(exp - 1023L);
            if (exp2 >= 0 && exp2 < 53) {
                int shift = 52 - exp2;
                whole = (1L << exp2) + (f >> shift);
                int whole_length = BasicPrimitiveConverter.getLongLengthCompare(whole);
                assert (whole_length == 1);
                BasicPrimitiveConverter.writeLong(whole, whole_length, start, buffer);
                start = BasicPrimitiveConverter.writeFraction(f, shift, exp2, buffer, start + whole_length);
                buffer[start++] = 101;
                buffer[start++] = 45;
                BasicPrimitiveConverter.writeInt(pow10, BasicPrimitiveConverter.getIntLengthCompare(pow10), buffer, start);
                return start + BasicPrimitiveConverter.getIntLengthCompare(pow10);
            }
        }
        if (exp2 == -1023 && f != 0L) {
            int nlz = Long.numberOfLeadingZeros(f) - 12;
            int pow102 = nlz + 1 + 1022 - (int)(log10_5 * (double)(nlz + 1 + 1022)) - 1;
            double nd = Math.abs(value) * Math.pow(10.0, pow102 - 50) * 1.0E50;
            long whole3 = (long)nd;
            if (BasicPrimitiveConverter.getLongLengthCompare(whole3) > 1) {
                --pow102;
                nd /= 10.0;
            } else if (whole3 == 0L) {
                nd *= 10.0;
                ++pow102;
            }
            bits = Double.doubleToRawLongBits(nd);
            exp = (bits & 0x7FF0000000000000L) >> 52;
            f = bits & 0xFFFFFFFFFFFFFL;
            exp2 = (int)(exp - 1023L);
            if (exp2 >= 0 && exp2 < 53) {
                int shift = 52 - exp2;
                whole3 = (1L << exp2) + (f >> shift);
                int whole_length = BasicPrimitiveConverter.getLongLengthCompare(whole3);
                assert (whole_length == 1);
                BasicPrimitiveConverter.writeLong(whole3, whole_length, start, buffer);
                start = BasicPrimitiveConverter.writeFraction(f, shift, exp2, buffer, start + whole_length);
                buffer[start++] = 101;
                buffer[start++] = 45;
                BasicPrimitiveConverter.writeInt(pow102, BasicPrimitiveConverter.getIntLengthCompare(pow102), buffer, start);
                return start + BasicPrimitiveConverter.getIntLengthCompare(pow102);
            }
        }
        if (exp2 > 52) {
            pow10 = (int)((double)exp2 * log10_2);
            double nd = Math.abs(value) / Math.pow(10.0, pow10);
            whole = (long)nd;
            if (BasicPrimitiveConverter.getLongLengthCompare(whole) > 1) {
                ++pow10;
                nd /= 10.0;
            } else if (whole == 0L) {
                nd *= 10.0;
                --pow10;
            }
            bits = Double.doubleToRawLongBits(nd);
            exp = (bits & 0x7FF0000000000000L) >> 52;
            f = bits & 0xFFFFFFFFFFFFFL;
            exp2 = (int)(exp - 1023L);
            if (exp2 >= 0 && exp2 < 53) {
                int shift = 52 - exp2;
                whole = (1L << exp2) + (f >> shift);
                int whole_length = BasicPrimitiveConverter.getLongLengthCompare(whole);
                assert (whole_length == 1);
                BasicPrimitiveConverter.writeLong(whole, whole_length, start, buffer);
                start = BasicPrimitiveConverter.writeFraction(f, shift, exp2, buffer, start + whole_length);
                buffer[start++] = 101;
                BasicPrimitiveConverter.writeInt(pow10, BasicPrimitiveConverter.getIntLengthCompare(pow10), buffer, start);
                return start + BasicPrimitiveConverter.getIntLengthCompare(pow10);
            }
        }
        return 0;
    }

    static int writeFloat0(float value, int start, byte[] buffer) {
        long whole;
        int pow10;
        int exp2;
        int bits = java.lang.Float.floatToRawIntBits(value);
        boolean positive = (bits & Integer.MIN_VALUE) == 0;
        int exp = (bits & 0x7F800000) >> 23;
        int f = bits & 0x7FFFFF;
        if (exp == 255) {
            if (f == 0) {
                if (positive) {
                    BufferHelper.copyToByteArray(ConstCharArrays.inf, start, buffer);
                    return start + ConstCharArrays.inf.length;
                }
                BufferHelper.copyToByteArray(ConstCharArrays.infNeg, start, buffer);
                return start + ConstCharArrays.infNeg.length;
            }
            BufferHelper.copyToByteArray(ConstCharArrays.nan, start, buffer);
            return start + ConstCharArrays.nan.length;
        }
        if (exp == 0 && f == 0) {
            buffer[start++] = 48;
            return start;
        }
        if (!positive) {
            buffer[start++] = 45;
        }
        if ((exp2 = exp - 127) >= 0 && exp2 < 23) {
            int shift = 23 - exp2;
            long whole2 = (1L << exp2) + (long)(f >> shift);
            int whole_length = BasicPrimitiveConverter.getLongLengthCompare(whole2);
            BasicPrimitiveConverter.writeLong(whole2, whole_length, start, buffer);
            return BasicPrimitiveConverter.writeFraction(f, shift, exp2, buffer, start + whole_length);
        }
        if (exp2 < 0 && exp2 != -127) {
            pow10 = -exp2 - (int)(log10_5 * (double)(-exp2));
            float nd = (float)((double)Math.abs(value) * Math.pow(10.0, pow10));
            whole = (long)nd;
            if (BasicPrimitiveConverter.getLongLengthCompare(whole) > 1) {
                --pow10;
                nd /= 10.0f;
            } else if (whole == 0L) {
                nd *= 10.0f;
                ++pow10;
            }
            bits = java.lang.Float.floatToRawIntBits(nd);
            exp = (bits & 0x7F800000) >> 23;
            f = bits & 0x7FFFFF;
            exp2 = exp - 127;
            if (exp2 >= 0 && exp2 < 23) {
                int shift = 23 - exp2;
                whole = (1L << exp2) + (long)(f >> shift);
                int whole_length = BasicPrimitiveConverter.getLongLengthCompare(whole);
                assert (whole_length == 1);
                BasicPrimitiveConverter.writeLong(whole, whole_length, start, buffer);
                start = BasicPrimitiveConverter.writeFraction(f, shift, exp2, buffer, start + whole_length);
                buffer[start++] = 101;
                buffer[start++] = 45;
                BasicPrimitiveConverter.writeInt(pow10, BasicPrimitiveConverter.getIntLengthCompare(pow10), buffer, start);
                return start + BasicPrimitiveConverter.getIntLengthCompare(pow10);
            }
        }
        if (exp2 == -127 && f != 0) {
            int nlz = Integer.numberOfLeadingZeros(f) - 9;
            int pow102 = nlz + 1 + 126 - (int)(log10_5 * (double)(nlz + 1 + 126)) - 1;
            float nd = (float)((double)Math.abs(value) * Math.pow(10.0, pow102));
            long whole3 = (long)nd;
            if (BasicPrimitiveConverter.getLongLengthCompare(whole3) > 1) {
                --pow102;
                nd /= 10.0f;
            } else if (whole3 == 0L) {
                nd *= 10.0f;
                ++pow102;
            }
            bits = java.lang.Float.floatToRawIntBits(nd);
            exp = (bits & 0x7F800000) >> 23;
            f = bits & 0x7FFFFF;
            exp2 = exp - 127;
            if (exp2 >= 0 && exp2 < 23) {
                int shift = 23 - exp2;
                whole3 = (1L << exp2) + (long)(f >> shift);
                int whole_length = BasicPrimitiveConverter.getLongLengthCompare(whole3);
                assert (whole_length == 1);
                BasicPrimitiveConverter.writeLong(whole3, whole_length, start, buffer);
                start = BasicPrimitiveConverter.writeFraction(f, shift, exp2, buffer, start + whole_length);
                buffer[start++] = 101;
                buffer[start++] = 45;
                BasicPrimitiveConverter.writeInt(pow102, BasicPrimitiveConverter.getIntLengthCompare(pow102), buffer, start);
                return start + BasicPrimitiveConverter.getIntLengthCompare(pow102);
            }
        }
        if (exp2 >= 23) {
            pow10 = (int)((double)exp2 * log10_2);
            float nd = (float)((double)Math.abs(value) / Math.pow(10.0, pow10));
            whole = (long)nd;
            if (BasicPrimitiveConverter.getLongLengthCompare(whole) > 1) {
                ++pow10;
                nd /= 10.0f;
            } else if (whole == 0L) {
                nd *= 10.0f;
                --pow10;
            }
            bits = java.lang.Float.floatToRawIntBits(nd);
            exp = (bits & 0x7F800000) >> 23;
            f = bits & 0x7FFFFF;
            exp2 = exp - 127;
            if (exp2 >= 0 && exp2 < 23) {
                int shift = 23 - exp2;
                whole = (1L << exp2) + (long)(f >> shift);
                int whole_length = BasicPrimitiveConverter.getLongLengthCompare(whole);
                assert (whole_length == 1);
                BasicPrimitiveConverter.writeLong(whole, whole_length, start, buffer);
                start = BasicPrimitiveConverter.writeFraction(f, shift, exp2, buffer, start + whole_length);
                buffer[start++] = 101;
                BasicPrimitiveConverter.writeInt(pow10, BasicPrimitiveConverter.getIntLengthCompare(pow10), buffer, start);
                return start + BasicPrimitiveConverter.getIntLengthCompare(pow10);
            }
        }
        return 0;
    }

    private static int writeFraction(long f, long shift, int exp2, byte[] buffer, int start) {
        long u = f - (f >> (int)shift << (int)shift) << 1;
        if (u > 0L) {
            buffer[start++] = 46;
            int k = 0;
            long e = 1L;
            long one = 1L << (int)(++shift);
            while (u >= e && u < one - e) {
                long sum = (u << 3) + (u << 1);
                long digit = sum >> (int)shift;
                buffer[start + ++k - 1] = (byte)(ConstCharArrays.digits[(int)digit] & 0xFF);
                u = sum - (digit << (int)shift);
                e = (e << 3) + (e << 1);
            }
            if ((u << 3) + (u << 1) > (long)(1 << (int)(shift - 1L))) {
                buffer[start + k - 1] = (byte)(buffer[start + k - 1] + 1);
            }
            return start + k;
        }
        return start;
    }

    static int getDateLength(Date date) {
        if (date.isBlank()) {
            return 4;
        }
        int res = 2;
        if (date.year() > 0) {
            res += 4;
            if (date.month() > 0) {
                res += 3;
                if (date.day() > 0) {
                    res += 3;
                }
            } else if (date.day() > 0) {
                res += 4;
            }
        } else if (date.month() > 0) {
            res += 4;
            if (date.day() > 0) {
                res += 3;
            }
        } else if (date.day() > 0) {
            res += 6;
        }
        return res;
    }

    static int getTimeMaxLength(Time time) {
        if (time.isBlank()) {
            return 4;
        }
        return 20;
    }

    static int getDateTimeMaxLength(DateTime dateTime) {
        if (dateTime.isBlank()) {
            return 4;
        }
        if (dateTime.date().isBlank()) {
            return 21;
        }
        if (dateTime.time().isBlank()) {
            return BasicPrimitiveConverter.getDateLength(dateTime.date());
        }
        return 2 + BasicPrimitiveConverter.getDateLength(dateTime.date()) + 1 + BasicPrimitiveConverter.getTimeMaxLength(dateTime.time());
    }

    private static void writeNum(int number, int maxLength, JsonBuffer buffer) {
        int l = BasicPrimitiveConverter.getIntLengthCompare(number);
        assert (l <= maxLength);
        for (int i = 0; i < maxLength - l; ++i) {
            buffer.data[buffer.position++] = 48;
        }
        BasicPrimitiveConverter.writeInt(number, l, buffer.data, buffer.position);
        buffer.position += l;
    }

    private static void writeNonemptyDate(Date date, JsonBuffer buffer) {
        if (date.year() > 0) {
            BasicPrimitiveConverter.writeNum(date.year(), 4, buffer);
            if (date.month() > 0) {
                buffer.data[buffer.position++] = 45;
                BasicPrimitiveConverter.writeNum(date.month(), 2, buffer);
                if (date.day() > 0) {
                    buffer.data[buffer.position++] = 45;
                    BasicPrimitiveConverter.writeNum(date.day(), 2, buffer);
                }
            } else if (date.day() > 0) {
                buffer.data[buffer.position++] = 45;
                buffer.data[buffer.position++] = 45;
                BasicPrimitiveConverter.writeNum(date.day(), 2, buffer);
            }
        } else if (date.month() > 0) {
            buffer.data[buffer.position++] = 45;
            buffer.data[buffer.position++] = 45;
            BasicPrimitiveConverter.writeNum(date.month(), 2, buffer);
            if (date.day() > 0) {
                buffer.data[buffer.position++] = 45;
                BasicPrimitiveConverter.writeNum(date.day(), 2, buffer);
            }
        } else if (date.day() > 0) {
            buffer.data[buffer.position++] = 45;
            buffer.data[buffer.position++] = 45;
            buffer.data[buffer.position++] = 45;
            buffer.data[buffer.position++] = 45;
            BasicPrimitiveConverter.writeNum(date.day(), 2, buffer);
        }
    }

    private static void writeNonemptyTime(Time time, JsonBuffer buffer) {
        BasicPrimitiveConverter.writeNum(time.hour(), 2, buffer);
        if (time.minute() != 255) {
            buffer.data[buffer.position++] = 58;
            BasicPrimitiveConverter.writeNum(time.minute(), 2, buffer);
            if (time.second() != 255) {
                buffer.data[buffer.position++] = 58;
                BasicPrimitiveConverter.writeNum(time.second(), 2, buffer);
                if (time.millisecond() != 65535) {
                    buffer.data[buffer.position++] = 46;
                    BasicPrimitiveConverter.writeNum(time.millisecond(), 3, buffer);
                    if (time.microsecond() != 2074) {
                        BasicPrimitiveConverter.writeNum(time.microsecond(), 3, buffer);
                        if (time.nanosecond() != 2047) {
                            BasicPrimitiveConverter.writeNum(time.nanosecond(), 3, buffer);
                        }
                    }
                    while (buffer.data[buffer.position - 1] == 48) {
                        buffer.data[buffer.position - 1] = 0;
                        --buffer.position;
                    }
                    if (buffer.data[buffer.position - 1] == 46) {
                        buffer.data[buffer.position - 1] = 0;
                        --buffer.position;
                    }
                }
            }
        }
    }

    static boolean writeDate(Date date, JsonBuffer buffer, JsonConverterError error) {
        if (date.isValid() && BufferHelper.checkAndResize(buffer, BasicPrimitiveConverter.getDateLength(date), error)) {
            if (date.isBlank()) {
                BufferHelper.copyToByteArray(ConstCharArrays.nullBytes, buffer);
            } else {
                buffer.data[buffer.position++] = 34;
                BasicPrimitiveConverter.writeNonemptyDate(date, buffer);
                buffer.data[buffer.position++] = 34;
            }
            return true;
        }
        return false;
    }

    static boolean writeTime(Time time, JsonBuffer buffer, JsonConverterError error) {
        if (time.isValid() && BufferHelper.checkAndResize(buffer, BasicPrimitiveConverter.getTimeMaxLength(time), error)) {
            if (time.isBlank()) {
                BufferHelper.copyToByteArray(ConstCharArrays.nullBytes, buffer);
            } else {
                buffer.data[buffer.position++] = 34;
                BasicPrimitiveConverter.writeNonemptyTime(time, buffer);
                buffer.data[buffer.position++] = 34;
            }
            return true;
        }
        return false;
    }

    static boolean writeDateTime(DateTime dateTime, JsonBuffer buffer, JsonConverterError error) {
        if (dateTime.isValid() && BufferHelper.checkAndResize(buffer, BasicPrimitiveConverter.getDateTimeMaxLength(dateTime), error)) {
            if (dateTime.isBlank()) {
                BufferHelper.copyToByteArray(ConstCharArrays.nullBytes, buffer);
            } else {
                buffer.data[buffer.position++] = 34;
                if (!dateTime.date().isBlank()) {
                    BasicPrimitiveConverter.writeNonemptyDate(dateTime.date(), buffer);
                }
                if (!dateTime.time().isBlank()) {
                    buffer.data[buffer.position++] = 84;
                    BasicPrimitiveConverter.writeNonemptyTime(dateTime.time(), buffer);
                }
                buffer.data[buffer.position++] = 34;
            }
            return true;
        }
        return false;
    }

    static int getSafeStringMaxLength(int inLength) {
        return Math.max(inLength * 6 + 2, 4);
    }

    static boolean writeSafeString(Buffer inBuffer, JsonBuffer outBuffer, JsonConverterError error) {
        if (BufferHelper.checkAndResize(outBuffer, BasicPrimitiveConverter.getSafeStringMaxLength(inBuffer.length()), error)) {
            outBuffer.data[outBuffer.position++] = 34;
            ByteBuffer data = inBuffer.data();
            int dataLength = inBuffer.length();
            int position = inBuffer.position();
            block11: for (int i = 0; i < dataLength; ++i) {
                if ((data.get(i + position) & 0xFF) > 31 && (data.get(i + position) & 0xFF) != 127) {
                    switch (data.get(i + position)) {
                        case 92: {
                            outBuffer.data[outBuffer.position++] = 92;
                            if (i == dataLength) {
                                outBuffer.data[outBuffer.position++] = 92;
                                break;
                            }
                            if (data.get(i + position + 1) == 34) {
                                outBuffer.data[outBuffer.position++] = 34;
                                ++i;
                                break;
                            }
                            if (data.get(i + position + 1) == 92) {
                                outBuffer.data[outBuffer.position++] = 92;
                                ++i;
                                break;
                            }
                            outBuffer.data[outBuffer.position++] = 92;
                            break;
                        }
                        case 34: {
                            outBuffer.data[outBuffer.position++] = 92;
                            outBuffer.data[outBuffer.position++] = 34;
                            break;
                        }
                        default: {
                            outBuffer.data[outBuffer.position++] = data.get(i + position);
                            break;
                        }
                    }
                    continue;
                }
                if ((data.get(i + position) & 0x80) != 0) {
                    outBuffer.data[outBuffer.position++] = data.get(i + position);
                    continue;
                }
                switch (data.get(i + position)) {
                    case 8: {
                        outBuffer.data[outBuffer.position++] = 92;
                        outBuffer.data[outBuffer.position++] = 98;
                        continue block11;
                    }
                    case 12: {
                        outBuffer.data[outBuffer.position++] = 92;
                        outBuffer.data[outBuffer.position++] = 102;
                        continue block11;
                    }
                    case 10: {
                        outBuffer.data[outBuffer.position++] = 92;
                        outBuffer.data[outBuffer.position++] = 110;
                        continue block11;
                    }
                    case 13: {
                        outBuffer.data[outBuffer.position++] = 92;
                        outBuffer.data[outBuffer.position++] = 114;
                        continue block11;
                    }
                    case 9: {
                        outBuffer.data[outBuffer.position++] = 92;
                        outBuffer.data[outBuffer.position++] = 116;
                        continue block11;
                    }
                    default: {
                        BufferHelper.writeCharAsHex(data.get(i + position), outBuffer);
                    }
                }
            }
            outBuffer.data[outBuffer.position++] = 34;
            return true;
        }
        return false;
    }

    static int charsToEscapeCount(byte[] array) {
        if (array == null) {
            return 0;
        }
        int count = 0;
        block3: for (int i = 0; i < array.length; ++i) {
            switch (array[i]) {
                case 9: 
                case 10: 
                case 34: 
                case 92: {
                    ++count;
                    continue block3;
                }
                default: {
                    if (array[i] >= 32 && array[i] != 127) continue block3;
                    count += 5;
                }
            }
        }
        return count;
    }

    static boolean writeSafeString(byte[] array, JsonBuffer outBuffer, JsonConverterError error) {
        if (BufferHelper.checkAndResize(outBuffer, BasicPrimitiveConverter.charsToEscapeCount(array) + array.length + 2, error)) {
            outBuffer.data[outBuffer.position++] = 34;
            block11: for (int i = 0; i < array.length; ++i) {
                if ((array[i] & 0xFF) > 31 && (array[i] & 0xFF) != 127) {
                    switch (array[i]) {
                        case 92: {
                            outBuffer.data[outBuffer.position++] = 92;
                            if (i == array.length) {
                                outBuffer.data[outBuffer.position++] = 92;
                                break;
                            }
                            if (array[i + 1] == 34) {
                                outBuffer.data[outBuffer.position++] = 34;
                                ++i;
                                break;
                            }
                            if (array[i + 1] == 92) {
                                outBuffer.data[outBuffer.position++] = 92;
                                ++i;
                                break;
                            }
                            outBuffer.data[outBuffer.position++] = 92;
                            break;
                        }
                        case 34: {
                            outBuffer.data[outBuffer.position++] = 92;
                            outBuffer.data[outBuffer.position++] = 34;
                            break;
                        }
                        default: {
                            outBuffer.data[outBuffer.position++] = array[i];
                            break;
                        }
                    }
                    continue;
                }
                if ((array[i] & 0x80) != 0) {
                    outBuffer.data[outBuffer.position++] = array[i];
                    continue;
                }
                switch (array[i]) {
                    case 8: {
                        outBuffer.data[outBuffer.position++] = 92;
                        outBuffer.data[outBuffer.position++] = 98;
                        continue block11;
                    }
                    case 12: {
                        outBuffer.data[outBuffer.position++] = 92;
                        outBuffer.data[outBuffer.position++] = 102;
                        continue block11;
                    }
                    case 10: {
                        outBuffer.data[outBuffer.position++] = 92;
                        outBuffer.data[outBuffer.position++] = 110;
                        continue block11;
                    }
                    case 13: {
                        outBuffer.data[outBuffer.position++] = 92;
                        outBuffer.data[outBuffer.position++] = 114;
                        continue block11;
                    }
                    case 9: {
                        outBuffer.data[outBuffer.position++] = 92;
                        outBuffer.data[outBuffer.position++] = 116;
                        continue block11;
                    }
                    default: {
                        BufferHelper.writeCharAsHex(array[i], outBuffer);
                    }
                }
            }
            outBuffer.data[outBuffer.position++] = 34;
            return true;
        }
        return false;
    }

    static boolean writeAsciiString(Buffer ascii, JsonBuffer buffer, JsonConverterError error) {
        if (BufferHelper.checkAndResize(buffer, BasicPrimitiveConverter.getSafeStringMaxLength(ascii.length()), error)) {
            if (ascii.isBlank() || ascii.length() == 0) {
                if (BufferHelper.checkAndResize(buffer, ConstCharArrays.nullBytes.length, error)) {
                    BufferHelper.copyToByteArray(ConstCharArrays.nullBytes, buffer);
                    return true;
                }
                return false;
            }
            return BasicPrimitiveConverter.writeSafeString(ascii, buffer, error);
        }
        return false;
    }

    static boolean writeUTF8String(Buffer utf8, JsonBuffer buffer, JsonConverterError error) {
        if (BufferHelper.checkAndResize(buffer, BasicPrimitiveConverter.getSafeStringMaxLength(utf8.length()), error)) {
            if (utf8.isBlank() || utf8.length() == 0) {
                BufferHelper.copyToByteArray(ConstCharArrays.nullBytes, buffer);
                return true;
            }
            return BasicPrimitiveConverter.writeSafeString(utf8, buffer, error);
        }
        return false;
    }

    static boolean writeRMTESString(Buffer rmtes, JsonBuffer buffer, JsonConverterError error) {
        rmtesBuffer.clear();
        cacheBuffer.clear();
        if (rmtes.isBlank() || rmtes.length() == 0) {
            if (BufferHelper.checkAndResize(buffer, ConstCharArrays.nullBytes.length, error)) {
                BufferHelper.copyToByteArray(ConstCharArrays.nullBytes, buffer);
                return true;
            }
            return false;
        }
        if (cacheBuffer.allocatedLength() < rmtes.length() * 3) {
            cacheBuffer = CodecFactory.createRmtesCacheBuffer((int)(rmtes.length() * 3));
        }
        if (decoder.hasPartialRMTESUpdate(rmtes)) {
            for (int i = rmtes.position(); i < rmtes.length() + rmtes.position(); ++i) {
                cacheBuffer.byteData().put(rmtes.data().get(i));
            }
            cacheBuffer.length(rmtes.length());
        } else {
            decoder.RMTESApplyToCache(rmtes, cacheBuffer);
        }
        int length = rmtes.length() * 9;
        if (length > rmtesBuffer.allocatedLength()) {
            BasicPrimitiveConverter.reallocateRMTESBuffer(length);
        }
        int ret = decoder.RMTESToUTF8(rmtesBuffer, cacheBuffer);
        while (ret == -21) {
            BasicPrimitiveConverter.reallocateRMTESBuffer(rmtesBuffer.allocatedLength() * 2);
            ret = decoder.RMTESToUTF8(rmtesBuffer, cacheBuffer);
        }
        if (ret == 0 && rmtesBuffer.length() != 0) {
            if (BufferHelper.checkAndResize(buffer, rmtesBuffer.length() * 6 + 2, error)) {
                buffer.data[buffer.position++] = 34;
                for (int i = 0; i < rmtesBuffer.length(); ++i) {
                    BasicPrimitiveConverter.writeByteChar(rmtesBuffer.byteData().get(i), buffer);
                }
                buffer.data[buffer.position++] = 34;
                return true;
            }
        } else if (BufferHelper.checkAndResize(buffer, ConstCharArrays.nullBytes.length, error)) {
            BufferHelper.copyToByteArray(ConstCharArrays.nullBytes, buffer.position, buffer.data);
            return true;
        }
        return false;
    }

    static void writeByteChar(byte ch, JsonBuffer buffer) {
        if ((ch & 0xFF & 0x80) != 1) {
            switch (ch) {
                case 34: {
                    buffer.data[buffer.position++] = 92;
                    buffer.data[buffer.position++] = 34;
                    break;
                }
                case 92: {
                    buffer.data[buffer.position++] = 92;
                    buffer.data[buffer.position++] = 92;
                    break;
                }
                default: {
                    if ((ch & 0xFF) < 32 || (ch & 0xFF) == 127) {
                        BufferHelper.writeCharAsHex(ch, buffer);
                        break;
                    }
                    buffer.data[buffer.position++] = ch;
                }
            }
        }
    }

    private static boolean reallocateRMTESBuffer(int newLength) {
        try {
            JsonFactory.releaseByteArray(rmtesBuffer.byteData().array());
            byte[] newArray = JsonFactory.createByteArray(newLength);
            ByteBuffer bb = ByteBuffer.wrap(newArray);
            rmtesBuffer.clear();
            rmtesBuffer.data(bb);
            rmtesBuffer.allocatedLength(newArray.length);
            return true;
        }
        catch (OutOfMemoryError e) {
            return false;
        }
    }

    static {
        sb = new StringBuilder();
        decoder = CodecFactory.createRmtesDecoder();
        cacheBuffer = CodecFactory.createRmtesCacheBuffer((int)2000);
        rmtesBuffer = CodecFactory.createRmtesBuffer((int)2000);
        charInts = new char[INT_MAX_STORED + 1][];
        for (int i = 0; i <= INT_MAX_STORED; ++i) {
            BasicPrimitiveConverter.charInts[i] = BasicPrimitiveConverter.getCharRepresentation(i);
        }
    }
}

