/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.Codec;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.json.converter.AbstractTypeConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import java.util.Objects;

abstract class AbstractPrimitiveTypeConverter
extends AbstractTypeConverter {
    AbstractPrimitiveTypeConverter(JsonAbstractConverter converter) {
        super(converter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean encodeJson(Buffer buffer, JsonBuffer outBuffer, JsonConverterError error) {
        if (Objects.isNull(buffer) || Objects.isNull(buffer.data())) {
            return false;
        }
        DecodeIterator decIter = JsonFactory.createDecodeIterator();
        try {
            decIter.clear();
            decIter.setBufferAndRWFVersion(buffer, Codec.majorVersion(), Codec.minorVersion());
            boolean bl = this.encodeJson(decIter, outBuffer, error);
            return bl;
        }
        finally {
            JsonFactory.releaseDecodeIterator(decIter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean encodeJson(DecodeIterator decIter, JsonBuffer outBuffer, JsonConverterError error) {
        Object type = this.getPrimitiveType();
        try {
            int ret = this.decode(decIter, type);
            if (ret < 0) {
                error.setError(15, null);
                boolean bl = false;
                return bl;
            }
            boolean res = ret == 15 ? BufferHelper.writeArray("null", outBuffer, false, error) : this.writeToJson(outBuffer, type, error);
            if (!res) {
                error.setError(16, null);
            }
            boolean bl = res;
            return bl;
        }
        catch (Exception e) {
            error.setError(17, e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.releasePrimitiveType(type);
        }
    }

    Object getPrimitiveType() {
        return null;
    }

    void releasePrimitiveType(Object type) {
    }

    boolean isInRange(int dataType, JsonNode dataNode) {
        return true;
    }

    abstract int decode(DecodeIterator var1, Object var2);

    abstract boolean writeToJson(JsonBuffer var1, Object var2, JsonConverterError var3);
}

