/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.LocalElementSetDefDb;
import com.refinitiv.eta.codec.LocalFieldSetDefDb;
import com.refinitiv.eta.json.converter.AbstractTypeConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import java.util.HashMap;

abstract class AbstractContainerTypeConverter
extends AbstractTypeConverter {
    private HashMap<Integer, String> containerNameMap = new HashMap();

    AbstractContainerTypeConverter(JsonAbstractConverter converter) {
        super(converter);
        this.containerNameMap.put(136, "Vector");
        this.containerNameMap.put(137, "Map");
        this.containerNameMap.put(138, "Series");
        this.containerNameMap.put(133, "Elements");
        this.containerNameMap.put(135, "FilterList");
        this.containerNameMap.put(132, "Fields");
        this.containerNameMap.put(130, "Opaque");
        this.containerNameMap.put(131, "Xml");
        this.containerNameMap.put(142, "Json");
        this.containerNameMap.put(134, "AnsiPage");
    }

    Object getContainerObject() {
        return null;
    }

    Object getEntryObject() {
        return null;
    }

    void releaseContainer(Object contianer) {
    }

    void releaseEntry(Object entry) {
    }

    boolean hasEntries(Object container) {
        return false;
    }

    protected abstract int decodeEntry(DecodeIterator var1, Object var2);

    protected abstract boolean writeContent(DecodeIterator var1, JsonBuffer var2, JsonConverterError var3, Object var4);

    protected abstract int decodeContainer(DecodeIterator var1, Object var2, Object var3);

    protected abstract boolean writeEntry(DecodeIterator var1, JsonBuffer var2, Object var3, JsonConverterError var4, Object var5, Object var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeEntries(DecodeIterator decIter, JsonBuffer outBuffer, boolean writeTag, Object localSetDb, JsonConverterError error, boolean commaBefore, Object container) {
        boolean res = (!commaBefore || BufferHelper.comma(outBuffer, error)) && (!writeTag || BufferHelper.writeArrayAndColon("Entries", outBuffer, false, error) && BufferHelper.beginArray(outBuffer, error));
        boolean comma = false;
        Object entry = this.getEntryObject();
        try {
            int ret = this.decodeEntry(decIter, entry);
            while (res && ret != 14) {
                if (ret < 0) {
                    error.setError(15, null);
                    boolean bl = false;
                    return bl;
                }
                if (comma) {
                    res = res && BufferHelper.comma(outBuffer, error);
                } else {
                    comma = true;
                }
                res = res && this.writeEntry(decIter, outBuffer, localSetDb, error, entry, container);
                ret = this.decodeEntry(decIter, entry);
            }
            boolean bl = res = res && (!writeTag || BufferHelper.endArray(outBuffer, error));
            return bl;
        }
        finally {
            this.releaseEntry(entry);
        }
    }

    protected Object getLocalSetDb(DecodeIterator decIter, int containerType, JsonConverterError error) {
        switch (containerType) {
            case 132: {
                LocalFieldSetDefDb fieldSetDb = JsonFactory.createLocalFieldSetDefDb();
                if (fieldSetDb.decode(decIter) < 0) {
                    error.setError(15, "Failed decoding vector.");
                    return null;
                }
                return fieldSetDb;
            }
            case 133: {
                LocalElementSetDefDb elemSetDb = JsonFactory.createLocalElementSetDefDb();
                if (elemSetDb.decode(decIter) < 0) {
                    error.setError(15, "Failed decoding vector.");
                    return null;
                }
                return elemSetDb;
            }
        }
        return null;
    }

    protected boolean returnLocalSetDb(int containerType, Object localSetDefDb) {
        switch (containerType) {
            case 133: {
                JsonFactory.releaseElementSetDefDb((LocalElementSetDefDb)localSetDefDb);
                break;
            }
            case 132: {
                JsonFactory.releaseFieldSetDefDb((LocalFieldSetDefDb)localSetDefDb);
                break;
            }
        }
        return true;
    }

    protected boolean writeSummaryData(DecodeIterator decIter, int containerType, JsonBuffer outBuffer, Object localSetDb, JsonConverterError error) {
        BufferHelper.writeArrayAndColon("Summary", outBuffer, false, error);
        BufferHelper.beginObject(outBuffer, error);
        this.converter.getContainerHandler(containerType).encodeJson(decIter, outBuffer, true, localSetDb, error);
        BufferHelper.endObject(outBuffer, error);
        return error.isSuccessful();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean encodeJson(DecodeIterator decIter, JsonBuffer outBuffer, boolean writeTag, Object setDb, JsonConverterError error) {
        Object container = this.getContainerObject();
        try {
            boolean res;
            int ret = this.decodeContainer(decIter, setDb, container);
            if (ret < 0) {
                error.setError(15, "Failed decoding container " + this.getContainerName(this.dataTypes[0]) + ", code = " + ret);
                boolean bl = false;
                return bl;
            }
            boolean bl = res = !writeTag || BufferHelper.writeArrayAndColon(this.getContainerName(this.dataTypes[0]), outBuffer, false, error);
            if (ret == 15 || ret == 16) {
                boolean bl2 = res && BufferHelper.writeEmptyObject(outBuffer, error);
                return bl2;
            }
            boolean bl3 = res = res && this.writeContent(decIter, outBuffer, error, container);
            if (!res && error.isSuccessful()) {
                error.setError(16, "Out of memory");
            }
            boolean bl4 = res;
            return bl4;
        }
        finally {
            this.releaseContainer(container);
        }
    }

    protected String getContainerName(int containerType) {
        return this.containerNameMap.get(containerType);
    }
}

