/*
 * Decompiled with CFR 0.152.
 */
package io.redisearch.aggregation;

import io.redisearch.FieldName;
import io.redisearch.aggregation.Group;
import io.redisearch.aggregation.Limit;
import io.redisearch.aggregation.SortedField;
import io.redisearch.aggregation.reducers.Reducer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import redis.clients.jedis.util.SafeEncoder;

@Deprecated
public class AggregationRequest {
    private String query;
    private final List<FieldName> load = new ArrayList<FieldName>();
    private final List<Group> groups = new ArrayList<Group>();
    private final List<SortedField> sortby = new ArrayList<SortedField>();
    private final Map<String, String> projections = new HashMap<String, String>();
    private final Map<String, String> queryProjections = new HashMap<String, String>();
    private String filterQuery;
    private Limit limit = Limit.NO_LIMIT;
    private int sortbyMax = 0;
    private int cursorCount = 0;
    private long cursorMaxIdle = Long.MAX_VALUE;

    public AggregationRequest(String query) {
        this.query = query;
    }

    public AggregationRequest() {
        this("*");
    }

    public AggregationRequest load(String ... fields) {
        return this.load(FieldName.convert(fields));
    }

    public AggregationRequest load(FieldName ... fields) {
        this.load.addAll(Arrays.asList(fields));
        return this;
    }

    public AggregationRequest limit(int offset, int count) {
        if (this.groups.isEmpty()) {
            this.limit = new Limit(offset, count);
        } else {
            this.groups.get(this.groups.size() - 1).limit(new Limit(offset, count));
        }
        return this;
    }

    public AggregationRequest limit(int count) {
        return this.limit(0, count);
    }

    public AggregationRequest sortBy(SortedField ... fields) {
        this.sortby.addAll(Arrays.asList(fields));
        return this;
    }

    public AggregationRequest sortBy(Collection<SortedField> fields, int max) {
        this.sortby.addAll(fields);
        this.sortbyMax = max;
        return this;
    }

    public AggregationRequest sortBy(SortedField field, int max) {
        this.sortBy(field);
        this.sortbyMax = max;
        return this;
    }

    public AggregationRequest sortByAsc(String field) {
        return this.sortBy(SortedField.asc(field));
    }

    public AggregationRequest sortByDesc(String field) {
        return this.sortBy(SortedField.desc(field));
    }

    @Deprecated
    public AggregationRequest apply(String projection, String alias) {
        this.groupApply(projection, alias);
        return this;
    }

    public AggregationRequest groupApply(String projection, String alias) {
        this.projections.put(alias, projection);
        return this;
    }

    public AggregationRequest queryApply(String projection, String alias) {
        this.queryProjections.put(alias, projection);
        return this;
    }

    public AggregationRequest groupBy(Collection<String> fields, Collection<Reducer> reducers) {
        String[] fieldsArr = new String[fields.size()];
        Group g = new Group(fields.toArray(fieldsArr));
        for (Reducer r : reducers) {
            g.reduce(r);
        }
        this.groups.add(g);
        return this;
    }

    public AggregationRequest groupBy(String field, Reducer ... reducers) {
        return this.groupBy(Collections.singletonList(field), Arrays.asList(reducers));
    }

    public AggregationRequest groupBy(Group group) {
        this.groups.add(group);
        return this;
    }

    public AggregationRequest filter(String expression) {
        this.filterQuery = expression;
        return this;
    }

    public AggregationRequest cursor(int count, long maxIdle) {
        this.cursorCount = count;
        this.cursorMaxIdle = maxIdle;
        return this;
    }

    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.query);
        if (!this.load.isEmpty()) {
            args.add("LOAD");
            int loadCountIndex = args.size();
            args.add(null);
            int loadCount = 0;
            for (FieldName fn : this.load) {
                loadCount += fn.addCommandEncodedArguments(args);
            }
            args.set(loadCountIndex, Integer.toString(loadCount));
        }
        if (!this.queryProjections.isEmpty()) {
            for (Map.Entry<String, String> e : this.queryProjections.entrySet()) {
                args.add("APPLY");
                args.add(e.getValue());
                args.add("AS");
                args.add(e.getKey());
            }
        }
        if (!this.groups.isEmpty()) {
            for (Group group : this.groups) {
                args.add("GROUPBY");
                group.addArgs(args);
            }
        }
        if (!this.projections.isEmpty()) {
            for (Map.Entry<String, String> e : this.projections.entrySet()) {
                args.add("APPLY");
                args.add(e.getValue());
                args.add("AS");
                args.add(e.getKey());
            }
        }
        if (this.filterQuery != null) {
            args.add("FILTER");
            args.add(this.filterQuery);
        }
        if (!this.sortby.isEmpty()) {
            args.add("SORTBY");
            args.add(Integer.toString(this.sortby.size() * 2));
            for (SortedField field : this.sortby) {
                args.add(field.getField());
                args.add(field.getOrder());
            }
            if (this.sortbyMax > 0) {
                args.add("MAX");
                args.add(Integer.toString(this.sortbyMax));
            }
        }
        this.limit.addArgs(args);
        if (this.cursorCount > 0) {
            args.add("WITHCURSOR");
            args.add("COUNT");
            args.add(Integer.toString(this.cursorCount));
            if (this.cursorMaxIdle < Long.MAX_VALUE && this.cursorMaxIdle >= 0L) {
                args.add("MAXIDLE");
                args.add(Long.toString(this.cursorMaxIdle));
            }
        }
        return args;
    }

    public void serializeRedisArgs(List<byte[]> redisArgs) {
        for (String s : this.getArgs()) {
            redisArgs.add(SafeEncoder.encode((String)s));
        }
    }

    public String getArgsString() {
        StringJoiner sj = new StringJoiner(" ");
        for (String s : this.getArgs()) {
            sj.add(s);
        }
        return sj.toString();
    }

    public boolean isWithCursor() {
        return this.cursorCount > 0;
    }
}

