/*
 * Decompiled with CFR 0.152.
 */
package io.redisearch;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.util.SafeEncoder;

public class Document
implements Serializable {
    private static final long serialVersionUID = 4884173545291367373L;
    private static final Gson gson = new Gson();
    private String id;
    private double score;
    private byte[] payload;
    private Map<String, Object> properties;

    @Deprecated
    public Document(String id, Double score) {
        this(id, new HashMap<String, Object>(), score);
    }

    public Document(String id, double score) {
        this(id, new HashMap<String, Object>(), score);
    }

    public Document(String id) {
        this(id, 1.0);
    }

    public Document(String id, Map<String, Object> fields) {
        this(id, fields, 1.0);
    }

    public Document(String id, Map<String, Object> fields, double score) {
        this(id, fields, score, null);
    }

    public Document(String id, Map<String, Object> fields, double score, byte[] payload) {
        this.id = id;
        this.properties = new HashMap<String, Object>(fields);
        this.score = score;
        this.payload = payload;
    }

    public Iterable<Map.Entry<String, Object>> getProperties() {
        return this.properties.entrySet();
    }

    @Deprecated
    public static Document load(String id, Double score, byte[] payload, List<byte[]> fields) {
        return Document.load(id, (double)score, payload, fields);
    }

    public static Document load(String id, double score, byte[] payload, List<byte[]> fields) {
        return Document.load(id, score, payload, fields, true);
    }

    @Deprecated
    public static Document load(String id, Double score, byte[] payload, List<byte[]> fields, boolean decode) {
        return Document.load(id, (double)score, payload, fields, decode);
    }

    public static Document load(String id, double score, byte[] payload, List<byte[]> fields, boolean decode) {
        Document ret = new Document(id, score);
        ret.payload = payload;
        if (fields != null) {
            for (int i = 0; i < fields.size(); i += 2) {
                ret.set(SafeEncoder.encode((byte[])fields.get(i)), decode ? (Object)SafeEncoder.encode((byte[])fields.get(i + 1)) : fields.get(i + 1));
            }
        }
        return ret;
    }

    public Document set(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public Object get(String key) {
        return this.properties.get(key);
    }

    public String getString(String key) {
        Object value = this.properties.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return value instanceof byte[] ? SafeEncoder.encode((byte[])((byte[])value)) : value.toString();
    }

    public double getScore() {
        return this.score;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public Document setScore(float score) {
        this.score = score;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return gson.toJson((Object)this);
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }
}

